/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.seasar.framework.util.ModifierUtil;
import org.seasar.framework.util.StringUtil;

public class ConstantAnnotationUtil {
    protected ConstantAnnotationUtil() {
    }

    public static Map convertExpressionToMap(String expression) {
        if (StringUtil.isEmpty(expression)) {
            return null;
        }
        Tokenizer tokenizer = new Tokenizer(expression);
        HashMap<String, String> ret = new HashMap<String, String>();
        int token = tokenizer.nextToken();
        while (token != -1) {
            String s = tokenizer.getStringValue();
            token = tokenizer.nextToken();
            if (token == 61) {
                token = tokenizer.nextToken();
                String s2 = tokenizer.getStringValue();
                ret.put(s, s2);
                tokenizer.nextToken();
            } else if (token == 44) {
                ret.put(null, s);
            } else if (token == -1) {
                ret.put(null, s);
                break;
            }
            token = tokenizer.nextToken();
        }
        return ret;
    }

    public static boolean isConstantAnnotation(Field field) {
        return ModifierUtil.isPublicStaticFinalField(field) && field.getType().equals(String.class);
    }

    public static class Tokenizer {
        public static final int TT_EOF = -1;
        public static final int TT_QUOTE = 39;
        public static final int TT_EQUAL = 61;
        public static final int TT_COMMA = 44;
        public static final int TT_WORD = -3;
        private static final int TT_NOTHING = -4;
        private static final int NEED_CHAR = Integer.MAX_VALUE;
        private static final int QUOTE = 39;
        private static final byte CT_WHITESPACE = 1;
        private static final byte CT_ALPHA = 4;
        private static byte[] ctype = new byte[256];
        private String str_;
        private int colno_ = 0;
        private int ttype_ = -4;
        private String sval_;
        private char[] buf_ = new char[20];
        private int peekc_ = Integer.MAX_VALUE;
        private byte peekct_ = 0;

        public Tokenizer(String str) {
            this.str_ = str;
        }

        private static void setup() {
            Tokenizer.wordChars(97, 122);
            Tokenizer.wordChars(65, 90);
            Tokenizer.wordChars(48, 57);
            Tokenizer.wordChars(64, 64);
            Tokenizer.wordChars(124, 124);
            Tokenizer.wordChars(95, 95);
            Tokenizer.wordChars(63, 63);
            Tokenizer.wordChars(62, 62);
            Tokenizer.wordChars(61, 61);
            Tokenizer.wordChars(33, 33);
            Tokenizer.wordChars(60, 60);
            Tokenizer.wordChars(34, 34);
            Tokenizer.wordChars(126, 126);
            Tokenizer.wordChars(42, 42);
            Tokenizer.wordChars(46, 46);
            Tokenizer.ordinaryChar(61);
            Tokenizer.ordinaryChar(44);
            Tokenizer.whitespaceChars(0, 32);
        }

        private static void wordChars(int low, int hi) {
            if (low < 0) {
                low = 0;
            }
            if (hi >= ctype.length) {
                hi = ctype.length - 1;
            }
            while (low <= hi) {
                int n = low++;
                ctype[n] = (byte)(ctype[n] | 4);
            }
        }

        private static void whitespaceChars(int low, int hi) {
            if (low < 0) {
                low = 0;
            }
            if (hi >= ctype.length) {
                hi = ctype.length - 1;
            }
            while (low <= hi) {
                Tokenizer.ctype[low++] = 1;
            }
        }

        private static void ordinaryChar(int ch) {
            if (ch >= 0 && ch < ctype.length) {
                Tokenizer.ctype[ch] = 0;
            }
        }

        public final int getTokenType() {
            return this.ttype_;
        }

        public final String getStringValue() {
            return this.sval_;
        }

        public int nextToken() {
            this.initVal();
            if (this.processEOF()) {
                return this.ttype_;
            }
            if (this.processWhitespace()) {
                return this.ttype_;
            }
            if (this.processWord()) {
                return this.ttype_;
            }
            if (this.processQuote()) {
                return this.ttype_;
            }
            if (this.processOrdinary()) {
                return this.ttype_;
            }
            this.ttype_ = this.peekc_;
            return this.ttype_;
        }

        public final String getReadString() {
            return this.str_.substring(0, this.colno_ - 1);
        }

        private int read() {
            if (this.colno_ >= this.str_.length()) {
                return -1;
            }
            return this.str_.charAt(this.colno_++);
        }

        private void initVal() {
            this.sval_ = null;
        }

        private boolean processEOF() {
            if (this.peekc_ < 0) {
                this.ttype_ = -1;
                return true;
            }
            if (this.peekc_ == Integer.MAX_VALUE) {
                this.peekc_ = this.read();
                if (this.peekc_ < 0) {
                    this.ttype_ = -1;
                    return true;
                }
            }
            return false;
        }

        private boolean processWhitespace() {
            this.peekct_ = (byte)(this.peekc_ < 256 ? ctype[this.peekc_] : 4);
            while ((this.peekct_ & 1) != 0) {
                if (this.peekc_ == 13) {
                    this.peekc_ = this.read();
                    if (this.peekc_ == 10) {
                        this.peekc_ = this.read();
                    }
                } else {
                    this.peekc_ = this.read();
                }
                if (this.peekc_ < 0) {
                    this.ttype_ = -1;
                    return true;
                }
                this.peekct_ = (byte)(this.peekc_ < 256 ? ctype[this.peekc_] : 4);
            }
            return false;
        }

        private boolean processWord() {
            if ((this.peekct_ & 4) != 0) {
                int i = 0;
                do {
                    if (i >= this.buf_.length) {
                        char[] nb = new char[this.buf_.length * 2];
                        System.arraycopy(this.buf_, 0, nb, 0, this.buf_.length);
                        this.buf_ = nb;
                    }
                    this.buf_[i++] = (char)this.peekc_;
                    this.peekc_ = this.read();
                    int n = this.peekc_ < 0 ? 1 : (this.peekct_ = this.peekc_ < 256 ? ctype[this.peekc_] : 4);
                } while ((this.peekct_ & 4) != 0);
                this.sval_ = String.copyValueOf(this.buf_, 0, i);
                this.ttype_ = -3;
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean processQuote() {
            int d;
            if (this.peekc_ != 39) {
                return false;
            }
            this.ttype_ = 39;
            int i = 0;
            int c = d = this.read();
            while (d >= 0) {
                block6: {
                    if (d == 39) {
                        int d2 = this.read();
                        if (d2 == 39) {
                            c = 39;
                            break block6;
                        } else {
                            d = d2;
                            break;
                        }
                    }
                    c = d;
                }
                if (i >= this.buf_.length) {
                    char[] nb = new char[this.buf_.length * 2];
                    System.arraycopy(this.buf_, 0, nb, 0, this.buf_.length);
                    this.buf_ = nb;
                }
                this.buf_[i++] = (char)c;
                d = this.read();
            }
            this.peekc_ = d;
            this.sval_ = String.copyValueOf(this.buf_, 0, i);
            return true;
        }

        private boolean processOrdinary() {
            if (this.peekct_ == 0) {
                this.ttype_ = this.peekc_;
                this.peekc_ = this.read();
                this.peekct_ = this.peekc_ < 0 ? 1 : (this.peekc_ < 256 ? ctype[this.peekc_] : 4);
                return true;
            }
            return false;
        }

        static {
            Tokenizer.setup();
        }
    }
}

