/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.external.servlet;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.seasar.framework.container.external.AbstractUnmodifiableExternalContextMap;

public class ServletRequestHeaderValuesMap
extends AbstractUnmodifiableExternalContextMap {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final HttpServletRequest request;
    private final Set headerNames = new HashSet();

    public ServletRequestHeaderValuesMap(HttpServletRequest request) {
        this.request = request;
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            this.headerNames.add(names.nextElement());
        }
    }

    protected Object getAttribute(String key) {
        if (this.headerNames.contains(key)) {
            return this.toStringArray(this.request.getHeaders(key));
        }
        return null;
    }

    protected Iterator getAttributeNames() {
        return this.headerNames.iterator();
    }

    private String[] toStringArray(Enumeration e) {
        if (e == null) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList list = new ArrayList();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }
}

