/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.cooldeploy;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.ClassLoaderUtil;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public class CoolComponentAutoRegister
implements ClassTraversal.ClassHandler {
    public static final String INIT_METHOD = "registerAll";
    public static final String container_BINDING = "bindingType=must";
    private S2Container container;
    private Map strategies = new HashMap();
    private ComponentCreator[] creators;
    private NamingConvention namingConvention;

    public CoolComponentAutoRegister() {
        this.addStrategy("file", new FileSystemStrategy());
        this.addStrategy("jar", new JarFileStrategy());
        this.addStrategy("zip", new ZipFileStrategy());
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public Map getStrategies() {
        return this.strategies;
    }

    protected Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(URLUtil.toCanonicalProtocol(protocol));
    }

    protected void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public ComponentCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(ComponentCreator[] creators) {
        this.creators = creators;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public void setNamingConvention(NamingConvention namingConvention) {
        this.namingConvention = namingConvention;
    }

    public void registerAll() {
        String[] rootPackageNames = this.namingConvention.getRootPackageNames();
        if (rootPackageNames != null) {
            for (int i = 0; i < rootPackageNames.length; ++i) {
                String rootDir = rootPackageNames[i].replace('.', '/');
                Iterator it = ClassLoaderUtil.getResources(rootDir);
                while (it.hasNext()) {
                    URL url = (URL)it.next();
                    Strategy strategy = this.getStrategy(url.getProtocol());
                    strategy.registerAll(rootDir, url);
                }
            }
        }
    }

    public void processClass(String packageName, String shortClassName) {
        String className = ClassUtil.concatName(packageName, shortClassName);
        if (!this.namingConvention.isTargetClassName(className)) {
            return;
        }
        Class clazz = ClassUtil.forName(className);
        if (this.container.getRoot().hasComponentDef(clazz)) {
            return;
        }
        ComponentDef cd = this.createComponentDef(clazz);
        if (cd != null) {
            this.container.getRoot().register(cd);
        }
    }

    protected ComponentDef createComponentDef(Class componentClass) {
        for (int i = 0; i < this.creators.length; ++i) {
            ComponentCreator creator = this.creators[i];
            ComponentDef cd = creator.createComponentDef(componentClass);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            String urlString = ResourceUtil.toExternalForm(url);
            int pos = urlString.lastIndexOf(33);
            String jarFileName = urlString.substring("zip:".length(), pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public void registerAll(String path, URL url) {
            JarFile jarFile = this.createJarFile(url);
            ClassTraversal.forEach(jarFile, (ClassTraversal.ClassHandler)CoolComponentAutoRegister.this);
        }

        protected JarFile createJarFile(URL url) {
            return JarFileUtil.toJarFile(url);
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public void registerAll(String path, URL url) {
            File rootDir = this.getRootDir(path, url);
            String[] rootPackageNames = CoolComponentAutoRegister.this.namingConvention.getRootPackageNames();
            for (int i = 0; i < rootPackageNames.length; ++i) {
                ClassTraversal.forEach(rootDir, rootPackageNames[i], CoolComponentAutoRegister.this);
            }
        }

        protected File getRootDir(String path, URL url) {
            File file = URLUtil.toFile(url);
            String[] names = StringUtil.split(path, "/");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public void registerAll(String var1, URL var2);
    }
}

