/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap {
    private final Map hash = new HashMap();
    private final int HARD_SIZE;
    private final LinkedList hardCache = new LinkedList();
    private final ReferenceQueue queue = new ReferenceQueue();

    public WeakValueHashMap() {
        this(100);
    }

    public WeakValueHashMap(int hardSize) {
        this.HARD_SIZE = hardSize;
    }

    public Object get(Object key) {
        Object result = null;
        WeakValue soft_ref = (WeakValue)this.hash.get(key);
        if (soft_ref != null) {
            result = soft_ref.get();
            if (result == null) {
                this.hash.remove(key);
            } else {
                this.hardCache.addFirst(result);
                if (this.hardCache.size() > this.HARD_SIZE) {
                    this.hardCache.removeLast();
                }
            }
        }
        return result;
    }

    private void processQueue() {
        WeakValue wv;
        while ((wv = (WeakValue)this.queue.poll()) != null) {
            this.hash.remove(wv.key);
        }
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        return this.hash.put(key, new WeakValue(value, key, this.queue));
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.hash.remove(key);
    }

    public void clear() {
        this.hardCache.clear();
        this.processQueue();
        this.hash.clear();
    }

    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class WeakValue
    extends WeakReference {
        final Object key;

        protected WeakValue(Object k, Object key, ReferenceQueue q) {
            super(k, q);
            this.key = key;
        }
    }
}

