/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.source.SourceDescriptor;

public class CompositeSourceDescriptor
extends ParameterAwareImpl
implements SourceDescriptor {
    private static final long serialVersionUID = 7557914925525488748L;
    private List _descriptors = new ArrayList();
    private SourceDescriptor _foundLast;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceDescriptor(SourceDescriptor source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        List list = this._descriptors;
        synchronized (list) {
            this._descriptors.add(source);
        }
    }

    private SourceDescriptor findDescriptor() {
        if (this._foundLast != null && this._foundLast.exists()) {
            return this._foundLast;
        }
        this._foundLast = null;
        for (int i = 0; i < this._descriptors.size(); ++i) {
            SourceDescriptor descriptor = (SourceDescriptor)this._descriptors.get(i);
            if (!descriptor.exists()) continue;
            this._foundLast = descriptor;
            return descriptor;
        }
        return null;
    }

    public void setSystemID(String systemID) {
        this._foundLast = null;
        this._descriptors.clear();
        super.setSystemID(systemID);
    }

    public boolean exists() {
        return this.findDescriptor() != null;
    }

    public InputStream getInputStream() {
        SourceDescriptor descriptor = this.findDescriptor();
        if (descriptor != null) {
            return descriptor.getInputStream();
        }
        return null;
    }

    public Date getTimestamp() {
        SourceDescriptor descriptor = this.findDescriptor();
        if (descriptor != null) {
            return descriptor.getTimestamp();
        }
        return new Date(0L);
    }
}

