/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.source;

import java.io.InputStream;
import java.util.Date;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.source.ForbiddenPathException;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class ClassLoaderSourceDescriptor
extends ParameterAwareImpl
implements SourceDescriptor {
    private static final long serialVersionUID = -4924522601395047024L;
    public static final String META_INF = "/META-INF";
    private String _root = "";
    private Class _neighbor;
    private transient InputStream _inputStream;
    private transient Date _timestamp;

    public void setNeighborClass(Class neighbor) {
        this._neighbor = neighbor;
    }

    public Class getNeighborClass() {
        return this._neighbor;
    }

    public void setRoot(String root) {
        this._root = StringUtil.preparePath(root);
    }

    public String getRoot() {
        return this._root;
    }

    public void setSystemID(String systemID) {
        if (systemID != null && systemID.indexOf(META_INF) != -1) {
            throw new ForbiddenPathException(systemID);
        }
        super.setSystemID(StringUtil.preparePath(systemID));
    }

    public boolean exists() {
        String path = (this._root + this.getSystemID()).substring(1);
        if (this._neighbor != null) {
            this._inputStream = this._neighbor.getResourceAsStream(path);
        }
        if (this._inputStream == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            this._inputStream = loader.getResourceAsStream(path);
        }
        return this._inputStream != null;
    }

    public InputStream getInputStream() {
        if (this.exists()) {
            return this._inputStream;
        }
        return null;
    }

    public void setTimestamp(Date timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException();
        }
        this._timestamp = timestamp;
    }

    public Date getTimestamp() {
        if (this._timestamp != null) {
            return this._timestamp;
        }
        this._timestamp = new Date();
        return this._timestamp;
    }
}

