/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification.serialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.engine.specification.serialize.ProcessorReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.ProcessorResolveListener;

public class ProcessorSerializeController
implements ProcessorReferenceResolver {
    private List _processorListeners = new ArrayList();
    private Map _processors = new HashMap();

    public void init() {
        this._processorListeners = new ArrayList();
        this._processors = new HashMap(20);
    }

    public void release() {
        this.doNotify();
        Iterator it = this._processorListeners.iterator();
        while (it.hasNext()) {
            ProcessorListener listener = (ProcessorListener)it.next();
            listener.release();
        }
        this._processorListeners.clear();
        this._processors.clear();
    }

    public void processorLoaded(String uniqueID, ProcessorTreeWalker item) {
        this._processors.put(uniqueID, item);
    }

    public ProcessorTreeWalker getProcessor(String uniqueID) {
        return (ProcessorTreeWalker)this._processors.get(uniqueID);
    }

    public void registResolveProcessorListener(String uniqueID, ProcessorResolveListener listener) {
        this._processorListeners.add(new ProcessorListener(uniqueID, listener));
    }

    public void doNotify() {
        Iterator it = this._processorListeners.iterator();
        while (it.hasNext()) {
            ProcessorListener listener = (ProcessorListener)it.next();
            listener._listener.notify(listener._id, this.getProcessor(listener._id));
        }
    }

    public class ProcessorListener {
        String _id;
        ProcessorResolveListener _listener;

        public ProcessorListener(String id, ProcessorResolveListener listener) {
            this._id = id;
            this._listener = listener;
        }

        public void release() {
            this._listener.release();
            this._listener = null;
        }
    }
}

