/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.builder.SpecificationBuilder;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.serialize.NodeReferenceResolver;
import org.seasar.mayaa.engine.specification.serialize.NodeResolveListener;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.EngineUtil;
import org.seasar.mayaa.impl.engine.specification.NodeTreeWalkerImpl;
import org.seasar.mayaa.impl.engine.specification.serialize.NodeSerializeController;
import org.seasar.mayaa.impl.engine.specification.serialize.SerializeThreadManager;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.source.NullSourceDescriptor;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.source.SourceDescriptor;

public class SpecificationImpl
extends ParameterAwareImpl
implements Specification,
NodeReferenceResolver,
CONST_IMPL {
    private static final long serialVersionUID = 174451168836001746L;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl = SpecificationImpl.class$("org.seasar.mayaa.impl.engine.specification.SpecificationImpl")) : class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl));
    private Date _buildTimestamp;
    private Date _builtSourceTime;
    private SourceDescriptor _source;
    private NodeTreeWalkerImpl _delegateNodeTreeWalker;
    private boolean _hasSource;
    private boolean _deprecated;
    private int _lastSequenceID;
    private transient boolean _specificationSerialize;
    private static final String SERIALIZE_CONTROLLER_KEY = (class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl == null ? (class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl = SpecificationImpl.class$("org.seasar.mayaa.impl.engine.specification.SpecificationImpl")) : class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl).getName() + "#serializeController";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$specification$SpecificationImpl;

    protected boolean needCheckTimestamp() {
        return EngineUtil.getEngineSettingBoolean("checkTimestamp", true);
    }

    protected boolean isSourceExists() {
        return this.getSource().exists();
    }

    public boolean isSpecificationSerialize() {
        return this._specificationSerialize;
    }

    public void setSpecificationSerialize(boolean specificationSerialize) {
        this._specificationSerialize = specificationSerialize;
    }

    protected SpecificationBuilder getBuilder() {
        return ProviderUtil.getSpecificationBuilder();
    }

    protected void setTimestamp(Date buildTimestamp) {
        this._buildTimestamp = buildTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeTreeWalker getNodeTreeWalker() {
        if (this._delegateNodeTreeWalker == null) {
            SpecificationImpl specificationImpl = this;
            synchronized (specificationImpl) {
                this._delegateNodeTreeWalker = new NodeTreeWalkerImpl();
                this._delegateNodeTreeWalker.setOwner(this);
            }
        }
        return this._delegateNodeTreeWalker;
    }

    protected void finalize() throws Throwable {
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)(this.toString() + " unloaded."));
        }
    }

    public String toString() {
        String className = ObjectUtil.getSimpleClassName(this.getClass());
        return this.getSystemID() + "(" + className + "@" + Integer.toHexString(this.hashCode()) + ")";
    }

    public boolean isDeprecated() {
        if (!this._deprecated) {
            boolean bl = this._deprecated = this._hasSource != this.isSourceExists();
            if (!this._deprecated) {
                if (!this._hasSource) {
                    return false;
                }
                boolean bl2 = this._deprecated = this.getTimestamp() == null;
                if (!this._deprecated) {
                    if (!this.needCheckTimestamp()) {
                        return false;
                    }
                    Date sourceTime = this.getSource().getTimestamp();
                    this._deprecated = !sourceTime.equals(this._builtSourceTime);
                }
            }
        }
        return this._deprecated;
    }

    public void build() {
        if (this.isDeprecated()) {
            this._hasSource = this.isSourceExists();
            if (this._hasSource) {
                LOG.debug((Object)(this.getSystemID() + " build start."));
                Date sourceTime = this.getSource().getTimestamp();
                this._lastSequenceID = 0;
                this.getBuilder().build(this);
                this.setTimestamp(new Date());
                this._builtSourceTime = sourceTime;
                this._deprecated = false;
                if (this.isSpecificationSerialize()) {
                    SerializeThreadManager.serializeReserve(this, CycleUtil.getServiceCycle().getApplicationScope().getUnderlyingContext());
                }
                return;
            }
            this.setTimestamp(new Date(0L));
            this._builtSourceTime = new Date(0L);
            this._deprecated = false;
        }
    }

    public Date getTimestamp() {
        return this._buildTimestamp;
    }

    public void setSource(SourceDescriptor source) {
        this._source = source;
    }

    public SourceDescriptor getSource() {
        if (this._source == null) {
            this._source = new NullSourceDescriptor();
        }
        return this._source;
    }

    public void resetSequenceID(int sequenceID) {
        this._lastSequenceID = sequenceID;
    }

    public int nextSequenceID() {
        return this._lastSequenceID++;
    }

    public void kill() {
        this._deprecated = true;
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.kill();
            this._delegateNodeTreeWalker = null;
        }
        this.setTimestamp(null);
    }

    public void clearChildNodes() {
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.clearChildNodes();
        }
    }

    public void setParentNode(NodeTreeWalker parentNode) {
        throw new IllegalStateException();
    }

    public NodeTreeWalker getParentNode() {
        return null;
    }

    public void addChildNode(NodeTreeWalker childNode) {
        this.getNodeTreeWalker().addChildNode(childNode);
    }

    public void insertChildNode(int index, NodeTreeWalker childNode) {
        this.getNodeTreeWalker().insertChildNode(index, childNode);
    }

    public Iterator iterateChildNode() {
        return this.getNodeTreeWalker().iterateChildNode();
    }

    public boolean removeChildNode(NodeTreeWalker node) {
        return this.getNodeTreeWalker().removeChildNode(node);
    }

    public NodeTreeWalker getChildNode(int index) {
        return this.getNodeTreeWalker().getChildNode(index);
    }

    public int getChildNodeSize() {
        return this.getNodeTreeWalker().getChildNodeSize();
    }

    public NodeReferenceResolver findNodeResolver() {
        return this.getNodeTreeWalker().findNodeResolver();
    }

    public String getSystemID() {
        if (this.getSource() == null) {
            return null;
        }
        return this.getSource().getSystemID();
    }

    public int getLineNumber() {
        return 0;
    }

    public boolean isOnTemplate() {
        return false;
    }

    protected static File getSerializedFile(String systemID) {
        ApplicationScope scope = CycleUtil.getServiceCycle().getApplicationScope();
        String cachePath = scope.getRealPath("WEB-INF/.mayaaSpecCache");
        File cacheDir = new File(cachePath);
        cacheDir.mkdirs();
        return new File(cacheDir, systemID.substring("/".length()).replace('/', '.') + ".ser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize() {
        SpecificationImpl specificationImpl = this;
        synchronized (specificationImpl) {
            try {
                File outputFile = SpecificationImpl.getSerializedFile(this.getSystemID());
                ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(outputFile));
                try {
                    SpecificationImpl.nodeSerializer().init();
                    try {
                        stream.writeObject(this);
                    }
                    finally {
                        SpecificationImpl.nodeSerializer().release();
                    }
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"page serialize failed.", (Throwable)e);
            }
        }
    }

    protected void afterDeserialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Specification deserialize(String systemID) {
        SpecificationImpl specificationImpl = this;
        synchronized (specificationImpl) {
            File cacheFile = SpecificationImpl.getSerializedFile(systemID);
            if (!cacheFile.exists()) {
                return null;
            }
            try {
                Specification result;
                ObjectInputStream stream = new ObjectInputStream(new FileInputStream(cacheFile));
                try {
                    SpecificationImpl.nodeSerializer().init();
                    try {
                        result = (Specification)stream.readObject();
                        if (result instanceof SpecificationImpl) {
                            ((SpecificationImpl)result).afterDeserialize();
                        }
                    }
                    finally {
                        SpecificationImpl.nodeSerializer().release();
                    }
                }
                finally {
                    stream.close();
                }
                return result;
            }
            catch (Throwable e) {
                String message = this.getSystemID() + " specification deserialize failed.";
                if (e.getMessage() != null) {
                    message = message + " " + e.getMessage();
                }
                LOG.info((Object)message);
                cacheFile.delete();
                return null;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this._delegateNodeTreeWalker != null) {
            this._delegateNodeTreeWalker.setOwner(this);
        }
        Iterator it = this.iterateChildNode();
        while (it.hasNext()) {
            NodeTreeWalker child = (NodeTreeWalker)it.next();
            child.setParentNode(this);
        }
        SpecificationImpl.nodeSerializer().specLoaded(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public static NodeSerializeController nodeSerializer() {
        return (NodeSerializeController)CycleUtil.getGlobalVariable(SERIALIZE_CONTROLLER_KEY, null);
    }

    public void registResolveNodeListener(String uniqueID, NodeResolveListener listener) {
        SpecificationImpl.nodeSerializer().registResolveNodeListener(uniqueID, listener);
    }

    public void nodeLoaded(SpecificationNode item) {
        SpecificationImpl.nodeSerializer().nodeLoaded(item);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CycleUtil.registVariableFactory(SERIALIZE_CONTROLLER_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object[] params) {
                return new NodeSerializeController();
            }

            public void destroy(Object instance) {
                if (instance instanceof NodeSerializeController) {
                    ((NodeSerializeController)instance).release();
                }
            }
        });
    }
}

