/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.specification;

import java.util.Iterator;
import org.seasar.mayaa.engine.specification.Namespace;
import org.seasar.mayaa.engine.specification.NodeAttribute;
import org.seasar.mayaa.engine.specification.PrefixMapping;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.engine.specification.SpecificationNode;
import org.seasar.mayaa.engine.specification.URI;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class NodeAttributeImpl
implements NodeAttribute {
    private static final long serialVersionUID = -1384526104972846069L;
    private transient SpecificationNode _node;
    private QName _qName;
    private String _value;
    private String _prefix;

    public NodeAttributeImpl(QName qName, String value) {
        this(qName, value, null);
    }

    public NodeAttributeImpl(QName qName, String value, String prefix) {
        if (qName == null || value == null) {
            throw new IllegalArgumentException();
        }
        this._qName = qName;
        this._value = value;
        this._prefix = prefix;
    }

    public void setNode(SpecificationNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this._node = node;
    }

    public SpecificationNode getNode() {
        return this._node;
    }

    public String getValue() {
        return this._value;
    }

    public String toString() {
        return this.getQName().toString() + "=\"" + this.getValue() + "\"";
    }

    public QName getQName() {
        return this._qName;
    }

    public String getPrefix() {
        if (this._prefix == null) {
            URI namespaceURI = this.getQName().getNamespaceURI();
            PrefixMapping mapping = this.getMappingFromURI(namespaceURI, true);
            if (mapping != null && !StringUtil.equals(namespaceURI, mapping.getNamespaceURI())) {
                return mapping.getPrefix();
            }
            return "";
        }
        return this._prefix;
    }

    public void setParentSpace(Namespace parent) {
        throw new UnsupportedOperationException();
    }

    public Namespace getParentSpace() {
        if (this.getNode() != null) {
            return this.getNode().getParentSpace();
        }
        return null;
    }

    public void addPrefixMapping(String prefix, String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    public PrefixMapping getMappingFromPrefix(String prefix, boolean all) {
        if (this.getNode() != null) {
            return this.getNode().getMappingFromPrefix(prefix, all);
        }
        return null;
    }

    public PrefixMapping getMappingFromURI(URI namespaceURI, boolean all) {
        if (this.getNode() != null) {
            return this.getNode().getMappingFromURI(namespaceURI, all);
        }
        return null;
    }

    public Iterator iteratePrefixMapping(boolean all) {
        if (this.getNode() != null) {
            return this.getNode().iteratePrefixMapping(all);
        }
        return NullIterator.getInstance();
    }

    public boolean addedMapping() {
        return false;
    }

    public URI getDefaultNamespaceURI() {
        if (this.getNode() != null) {
            return this.getNode().getDefaultNamespaceURI();
        }
        return null;
    }

    public void setDefaultNamespaceURI(URI namespaceURI) {
        if (this.getNode() != null) {
            this.getNode().setDefaultNamespaceURI(namespaceURI);
        }
    }
}

