/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.io.Serializable;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.impl.cycle.script.ScriptUtil;

public class ProcessorPropertyImpl
implements ProcessorProperty,
Serializable {
    private static final long serialVersionUID = 1794156997857284538L;
    private PrefixAwareName _name;
    private CompiledScript _compiled;

    public ProcessorPropertyImpl(PrefixAwareName name, String value, Class expectedClass) {
        if (name == null || expectedClass == null) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._compiled = ScriptUtil.compile(value, expectedClass);
    }

    public PrefixAwareName getName() {
        return this._name;
    }

    public CompiledScript getValue() {
        return this._compiled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessorProperty) {
            PrefixAwareName otherName = ((ProcessorProperty)obj).getName();
            return this._name.getQName().equals(otherName.getQName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._name.toString() + "=\"" + this._compiled.toString() + "\"";
    }
}

