/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.StringUtil;

public class DOCTYPEProcessor
extends TemplateProcessorSupport
implements CONST_IMPL {
    private static final long serialVersionUID = 8518993579074245108L;
    private static final int DEFAULT_BUFFER_SIZE = 128;
    private String _name;
    private String _publicID;
    private String _systemID;

    public void setName(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setPublicID(String publicID) {
        this._publicID = publicID;
    }

    public String getPublicID() {
        return this._publicID;
    }

    public void setSystemID(String systemID) {
        this._systemID = systemID;
    }

    public String getSystemID() {
        return this._systemID;
    }

    private void writeData(StringBuffer docTypeDecl) {
        docTypeDecl.append("<!DOCTYPE ").append(this._name);
        if (StringUtil.hasValue(this._publicID)) {
            docTypeDecl.append(" PUBLIC \"").append(this._publicID).append("\"");
        }
        if (StringUtil.hasValue(this._systemID)) {
            docTypeDecl.append(" \"").append(this._systemID).append("\"");
        }
        docTypeDecl.append(">");
    }

    public ProcessStatus doStartProcess(Page topLevelPage) {
        StringBuffer docTypeDecl = new StringBuffer(128);
        this.writeData(docTypeDecl);
        ServiceCycle cycle = CycleUtil.getServiceCycle();
        cycle.getResponse().write(docTypeDecl.toString());
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        if (!this.getOriginalNode().getQName().equals(CONST_IMPL.QM_DOCTYPE)) {
            return new ProcessorTreeWalker[]{this};
        }
        StringBuffer sb = new StringBuffer();
        this.writeData(sb);
        LiteralCharactersProcessor literal = new LiteralCharactersProcessor(sb.toString());
        BuilderUtil.characterProcessorCopy(this, literal, sequenceIDGenerator);
        this.getParentProcessor().removeProcessor(this);
        return new ProcessorTreeWalker[]{literal};
    }
}

