/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import org.mozilla.javascript.Undefined;
import org.seasar.mayaa.builder.SequenceIDGenerator;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.processor.ProcessorTreeWalker;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.builder.BuilderUtil;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.engine.processor.LiteralCharactersProcessor;
import org.seasar.mayaa.impl.engine.processor.ProcessorPropertyImpl;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.engine.specification.SpecificationUtil;

public class CharactersProcessor
extends TemplateProcessorSupport
implements CONST_IMPL {
    private static final long serialVersionUID = 2054159396651833214L;
    private ProcessorProperty _text;

    public CharactersProcessor() {
    }

    public CharactersProcessor(CharactersProcessor share, String text) {
        this(share.getText(), text);
    }

    public CharactersProcessor(ProcessorProperty prop, String text) {
        ProcessorPropertyImpl propCopy = new ProcessorPropertyImpl(prop.getName(), text, prop.getValue().getExpectedClass());
        this.setText(propCopy);
    }

    public void setText(ProcessorProperty text) {
        this._text = text;
    }

    public ProcessorProperty getText() {
        return this._text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessStatus doStartProcess(Page topLevelPage) {
        Object value = null;
        SpecificationUtil.endScope();
        try {
            value = this.getText().getValue().execute(null);
        }
        finally {
            SpecificationUtil.startScope(this.getVariables());
        }
        if (value != null && !(value instanceof Undefined)) {
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            cycle.getResponse().write(value.toString());
        }
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessorTreeWalker[] divide(SequenceIDGenerator sequenceIDGenerator) {
        if (!this.getOriginalNode().getQName().equals(CONST_IMPL.QM_CHARACTERS)) {
            return new ProcessorTreeWalker[]{this};
        }
        CompiledScript script = this.getText().getValue();
        if (script.isLiteral()) {
            LiteralCharactersProcessor literal = new LiteralCharactersProcessor(script.getScriptText());
            BuilderUtil.characterProcessorCopy(this, literal, sequenceIDGenerator);
            return new ProcessorTreeWalker[]{literal};
        }
        return super.divide(sequenceIDGenerator);
    }

    public void kill() {
        this._text = null;
        super.kill();
    }
}

