/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.engine.processor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.mayaa.cycle.CycleWriter;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.processor.ChildEvaluationProcessor;
import org.seasar.mayaa.engine.processor.InformalPropertyAcceptable;
import org.seasar.mayaa.engine.processor.ProcessStatus;
import org.seasar.mayaa.engine.processor.ProcessorProperty;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.DefaultCycleLocalInstantiator;
import org.seasar.mayaa.impl.engine.processor.TemplateProcessorSupport;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public abstract class AbstractAttributableProcessor
extends TemplateProcessorSupport
implements ChildEvaluationProcessor,
InformalPropertyAcceptable {
    private boolean _childEvaluation;
    private List _attributes;
    private static final String PROCESS_TIME_INFO_KEY = (class$org$seasar$mayaa$impl$engine$processor$AbstractAttributableProcessor == null ? (class$org$seasar$mayaa$impl$engine$processor$AbstractAttributableProcessor = AbstractAttributableProcessor.class$("org.seasar.mayaa.impl.engine.processor.AbstractAttributableProcessor")) : class$org$seasar$mayaa$impl$engine$processor$AbstractAttributableProcessor).getName() + "#processtimeInfo";
    static /* synthetic */ Class class$org$seasar$mayaa$impl$engine$processor$AbstractAttributableProcessor;
    static /* synthetic */ Class class$org$seasar$mayaa$engine$processor$ProcessorProperty;
    static /* synthetic */ Class class$java$lang$Object;

    protected void clearProcesstimeInfo() {
        CycleUtil.clearLocalVariable(PROCESS_TIME_INFO_KEY, this);
    }

    protected ProcesstimeInfo getProcesstimeInfo() {
        return (ProcesstimeInfo)CycleUtil.getLocalVariable(PROCESS_TIME_INFO_KEY, this, null);
    }

    public void setChildEvaluation(boolean childEvaluation) {
        this._childEvaluation = childEvaluation;
    }

    public void addInformalProperty(PrefixAwareName name, Serializable attr) {
        if (this._attributes == null) {
            this._attributes = new ArrayList();
        }
        this._attributes.add(attr);
    }

    public Class getPropertyClass() {
        return class$org$seasar$mayaa$engine$processor$ProcessorProperty == null ? (class$org$seasar$mayaa$engine$processor$ProcessorProperty = AbstractAttributableProcessor.class$("org.seasar.mayaa.engine.processor.ProcessorProperty")) : class$org$seasar$mayaa$engine$processor$ProcessorProperty;
    }

    public Class getExpectedClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = AbstractAttributableProcessor.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Iterator iterateInformalProperties() {
        if (this._attributes == null) {
            return NullIterator.getInstance();
        }
        return this._attributes.iterator();
    }

    public void addProcesstimeProperty(ProcessorProperty prop) {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        info.addProcesstimeProperty(prop);
    }

    public boolean hasProcesstimeProperty(ProcessorProperty prop) {
        if (prop == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        return info.hasProcesstimeProperty(prop);
    }

    public Iterator iterateProcesstimeProperties() {
        ProcesstimeInfo info = this.getProcesstimeInfo();
        return info.iterateProcesstimeProperties();
    }

    protected abstract ProcessStatus writeStartElement();

    protected abstract void writeBody(String var1);

    protected abstract void writeEndElement();

    public ProcessStatus doStartProcess(Page topLevelPage) {
        this.clearProcesstimeInfo();
        if (this._childEvaluation) {
            return ProcessStatus.EVAL_BODY_BUFFERED;
        }
        return this.writeStartElement();
    }

    public boolean isChildEvaluation() {
        return this._childEvaluation;
    }

    public void setBodyContent(CycleWriter body) {
        if (body == null) {
            throw new IllegalArgumentException();
        }
        ProcesstimeInfo info = this.getProcesstimeInfo();
        info.setBody(body);
    }

    public void doInitChildProcess() {
    }

    public boolean isIteration() {
        return false;
    }

    public ProcessStatus doAfterChildProcess() {
        return ProcessStatus.SKIP_BODY;
    }

    public ProcessStatus doEndProcess() {
        ProcesstimeInfo info = this.getProcesstimeInfo();
        if (this._childEvaluation) {
            this.writeStartElement();
            CycleWriter body = info.getBody();
            if (body != null) {
                this.writeBody(body.getString());
            }
        }
        this.writeEndElement();
        return ProcessStatus.EVAL_PAGE;
    }

    public void kill() {
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this.clearProcesstimeInfo();
        super.kill();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.clearProcesstimeInfo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CycleUtil.registVariableFactory(PROCESS_TIME_INFO_KEY, new DefaultCycleLocalInstantiator(){

            public Object create(Object owner, Object[] params) {
                return new ProcesstimeInfo();
            }
        });
    }

    protected static class ProcesstimeInfo {
        private CycleWriter _body;
        private List _processtimeProperties;

        protected ProcesstimeInfo() {
        }

        public void setBody(CycleWriter body) {
            if (body == null) {
                throw new IllegalArgumentException();
            }
            this._body = body;
        }

        public CycleWriter getBody() {
            return this._body;
        }

        public boolean hasProcesstimeProperty(ProcessorProperty property) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            if (this._processtimeProperties == null) {
                return false;
            }
            return this._processtimeProperties.contains(property);
        }

        public void addProcesstimeProperty(ProcessorProperty property) {
            if (property == null) {
                throw new IllegalArgumentException();
            }
            if (this._processtimeProperties == null) {
                this._processtimeProperties = new ArrayList();
            }
            if (!this._processtimeProperties.contains(property)) {
                this._processtimeProperties.add(property);
            }
        }

        public Iterator iterateProcesstimeProperties() {
            if (this._processtimeProperties == null) {
                return NullIterator.getInstance();
            }
            return this._processtimeProperties.iterator();
        }
    }
}

