/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.web;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.seasar.mayaa.impl.cycle.scope.AbstractReadOnlyAttributeScope;
import org.seasar.mayaa.impl.util.collection.EnumerationIterator;

public class HeaderValuesScope
extends AbstractReadOnlyAttributeScope {
    private static final long serialVersionUID = -7755074034945921281L;
    private transient HttpServletRequest _request;

    public HeaderValuesScope(HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException();
        }
        this._request = request;
    }

    public String getScopeName() {
        return "headerValues";
    }

    public Iterator iterateAttributeNames() {
        return EnumerationIterator.getInstance(this._request.getHeaderNames());
    }

    public boolean hasAttribute(String name) {
        Iterator it = this.iterateAttributeNames();
        while (it.hasNext()) {
            String headerName = (String)it.next();
            if (!headerName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Object getAttribute(String name) {
        if (this.hasAttribute(name)) {
            Enumeration headers = this._request.getHeaders(name);
            ArrayList headerList = new ArrayList();
            while (headers.hasMoreElements()) {
                headerList.add(headers.nextElement());
            }
            return headerList.toArray(new String[headerList.size()]);
        }
        return null;
    }
}

