/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script.rhino;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.seasar.mayaa.PositionAware;
import org.seasar.mayaa.cycle.scope.AttributeScope;
import org.seasar.mayaa.engine.specification.PrefixAwareName;
import org.seasar.mayaa.engine.specification.QName;
import org.seasar.mayaa.impl.CONST_IMPL;
import org.seasar.mayaa.impl.cycle.script.AbstractTextCompiledScript;
import org.seasar.mayaa.impl.cycle.script.ReadOnlyScriptBlockException;
import org.seasar.mayaa.impl.cycle.script.rhino.OffsetLineRhinoException;
import org.seasar.mayaa.impl.cycle.script.rhino.RhinoUtil;
import org.seasar.mayaa.impl.engine.RenderingBrake;
import org.seasar.mayaa.impl.engine.specification.PrefixAwareNameImpl;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class TextCompiledScriptImpl
extends AbstractTextCompiledScript {
    private static final long serialVersionUID = 4793923040332838492L;
    private final String _sourceName;
    private final int _lineNumber;
    private final int _offsetLine;
    private transient Script _rhinoScript;
    private transient Script _elRhinoScript;
    private String _elScriptText;
    private String _elStyleName;
    private boolean _elStyle;

    public TextCompiledScriptImpl(String text, PositionAware position, int offsetLine) {
        super(text);
        String sourceName = position.getSystemID();
        if (position instanceof PrefixAwareName) {
            PrefixAwareName prefixAwareName = (PrefixAwareName)((Object)position);
            QName qName = prefixAwareName.getQName();
            sourceName = CONST_IMPL.URI_MAYAA == qName.getNamespaceURI() ? sourceName + "#" + qName.getLocalName() : sourceName + "#" + PrefixAwareNameImpl.forPrefixAwareNameString(qName, prefixAwareName.getPrefix());
        }
        this._sourceName = sourceName;
        this._lineNumber = position.getLineNumber();
        this._offsetLine = offsetLine;
        this.processText(text);
    }

    protected boolean maybeELStyle(String text) {
        boolean start = true;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (start) {
                if (Character.isJavaIdentifierStart(c)) {
                    start = false;
                    continue;
                }
            } else if (Character.isJavaIdentifierPart(c)) continue;
            if (c == '.') {
                start = true;
                continue;
            }
            return false;
        }
        return true;
    }

    protected void processText(String text) {
        int pos;
        if (text == null) {
            throw new IllegalArgumentException();
        }
        String script = text = text.trim();
        String name = null;
        if (this.maybeELStyle(text) && (pos = text.lastIndexOf(46)) != -1 && pos != text.length() - 1) {
            script = text.substring(0, pos);
            name = text.substring(pos + 1);
        }
        this._elScriptText = script;
        this._elStyleName = name;
        this._elStyle = name != null;
    }

    protected Object normalExecute(Context cx, Scriptable scope) {
        if (cx == null || scope == null) {
            throw new IllegalArgumentException();
        }
        if (this._rhinoScript == null) {
            this._rhinoScript = cx.compileString(this.getText(), this._sourceName, this._lineNumber + this._offsetLine, null);
        }
        return this._rhinoScript.exec(cx, scope);
    }

    protected Object getELStyleHost(Context cx, Scriptable scope) {
        if (cx == null || scope == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.isEmpty(this._elScriptText)) {
            return null;
        }
        if (this._elRhinoScript == null) {
            this._elRhinoScript = cx.compileString(this._elScriptText, this._sourceName, this._lineNumber + this._offsetLine, null);
        }
        return this._elRhinoScript.exec(cx, scope);
    }

    protected Object functionExecute(Context cx, Scriptable scope, Object host, Object[] args) {
        if (cx == null || scope == null || host == null || args == null) {
            throw new IllegalArgumentException();
        }
        if (host instanceof Scriptable) {
            Object func = ((Scriptable)host).get(this._elStyleName, scope);
            return ((Function)func).call(cx, scope, (Scriptable)host, args);
        }
        Class[] argClasses = this.getMethodArgClasses();
        return ObjectUtil.invoke(host, this._elStyleName, args, argClasses);
    }

    public Object execute(Object[] args) {
        Context cx = RhinoUtil.enter();
        Object ret = null;
        try {
            Object jsRet;
            Scriptable scope = RhinoUtil.getScope();
            if (this._elStyle && args != null) {
                Object host = this.getELStyleHost(cx, scope);
                jsRet = this.functionExecute(cx, scope, host, args);
            } else {
                jsRet = this.normalExecute(cx, scope);
            }
            ret = RhinoUtil.convertResult(cx, this.getExpectedClass(), jsRet);
        }
        catch (RhinoException e) {
            String message;
            int offsetLine;
            WrappedException we;
            Throwable wrapped;
            if (e instanceof WrappedException && (wrapped = (we = (WrappedException)((Object)e)).getWrappedException()) instanceof RenderingBrake) {
                RhinoUtil.removeWrappedException(we);
            }
            if (e instanceof JavaScriptException && ((JavaScriptException)e).getValue() instanceof IdScriptableObject) {
                offsetLine = -1;
                IdScriptableObject scriptable = (IdScriptableObject)((JavaScriptException)e).getValue();
                Object messageProperty = scriptable.get("message", (Scriptable)scriptable);
                message = messageProperty != Scriptable.NOT_FOUND ? messageProperty.toString() : scriptable.toString();
            } else {
                offsetLine = e.lineNumber() - this._lineNumber + 1;
                message = e.details() + " in script=\n" + this.getText();
            }
            throw new OffsetLineRhinoException(message, this._sourceName, e.lineNumber(), e.lineSource(), e.columnNumber(), offsetLine, e.getCause());
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    public boolean isReadOnly() {
        return !this._elStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignValue(Object value) {
        block13: {
            if (this.isReadOnly()) {
                throw new ReadOnlyScriptBlockException(this.getScriptText());
            }
            Context cx = RhinoUtil.enter();
            try {
                Scriptable scope = RhinoUtil.getScope();
                if (this._elStyle) {
                    Object host = this.getELStyleHost(cx, scope);
                    if (host == null) {
                        scope.put(this._elStyleName, scope, value);
                    } else if (host instanceof Scriptable) {
                        ((Scriptable)host).put(this._elStyleName, scope, value);
                    } else if (host instanceof AttributeScope) {
                        ((AttributeScope)host).setAttribute(this._elStyleName, value);
                    } else {
                        ObjectUtil.setProperty(host, this._elStyleName, value);
                    }
                    break block13;
                }
                throw new IllegalStateException();
            }
            catch (WrappedException e) {
                RhinoUtil.removeWrappedException(e);
            }
            finally {
                Context.exit();
            }
        }
    }
}

