/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.cycle.script;

import org.mozilla.javascript.Undefined;
import org.seasar.mayaa.cycle.ServiceCycle;
import org.seasar.mayaa.cycle.script.CompiledScript;
import org.seasar.mayaa.cycle.script.ScriptEnvironment;
import org.seasar.mayaa.engine.specification.NodeTreeWalker;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.script.LiteralScript;
import org.seasar.mayaa.impl.cycle.script.ScriptBlockIterator;
import org.seasar.mayaa.impl.cycle.script.UnbalancedBraceException;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.util.StringUtil;

public class ScriptUtil {
    private ScriptUtil() {
    }

    public static CompiledScript compile(String text, Class expectedClass) {
        CompiledScript compiled;
        if (expectedClass == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtil.hasValue(text)) {
            ScriptEnvironment environment = ProviderUtil.getScriptEnvironment();
            ServiceCycle cycle = CycleUtil.getServiceCycle();
            NodeTreeWalker node = cycle.getInjectedNode();
            compiled = environment.compile(text, node);
        } else {
            compiled = new LiteralScript("");
        }
        compiled.setExpectedClass(expectedClass);
        return compiled;
    }

    public static String getBlockSignedText(String text) {
        if (StringUtil.isEmpty(text)) {
            return text;
        }
        String blockSign = ProviderUtil.getScriptEnvironment().getBlockSign();
        return blockSign + "{" + text.trim() + "\n}";
    }

    public static void assertSingleScript(String text) {
        String blockSign = ProviderUtil.getScriptEnvironment().getBlockSign();
        ScriptBlockIterator iterator = new ScriptBlockIterator(text, blockSign, false);
        if (!iterator.hasNext()) {
            return;
        }
        iterator.next();
        if (iterator.hasNext()) {
            throw new UnbalancedBraceException(text, iterator.getOffset());
        }
    }

    public static boolean isEmpty(Object scriptResult) {
        return scriptResult == null || scriptResult instanceof Undefined;
    }
}

