/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl.builder.library.scanner;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.seasar.mayaa.builder.library.scanner.SourceScanner;
import org.seasar.mayaa.impl.IllegalParameterValueException;
import org.seasar.mayaa.impl.ParameterAwareImpl;
import org.seasar.mayaa.impl.builder.library.scanner.FolderSourceScanner;
import org.seasar.mayaa.impl.builder.library.scanner.JarSourceScanner;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.IteratorIterator;
import org.seasar.mayaa.source.SourceDescriptor;

public class MetaInfSourceScanner
extends ParameterAwareImpl
implements SourceScanner {
    private static final long serialVersionUID = -7285416169718204350L;
    private FolderSourceScanner _folderScanner = new FolderSourceScanner();
    private Set _ignores = new HashSet();
    private String _jarScanFolder;
    private Set _jarScanIgnores = new HashSet();
    private Set _jarScanExtensions = new HashSet();

    private void initJarScanOptions() {
        if (this._jarScanFolder == null) {
            this._jarScanFolder = "META-INF/";
        }
        if (this._jarScanIgnores.size() == 0) {
            this._jarScanIgnores.add("META-INF/MANIFEST.MF");
        }
        if (this._jarScanExtensions.size() == 0) {
            this._jarScanExtensions.add(".mld");
            this._jarScanExtensions.add(".tld");
        }
    }

    public Iterator scan() {
        this.initJarScanOptions();
        IteratorIterator itit = new IteratorIterator();
        Iterator it = this._folderScanner.scan();
        while (it.hasNext()) {
            JarSourceScanner scanner = new JarSourceScanner();
            scanner.setDescriptor((SourceDescriptor)it.next());
            scanner.setParameter("root", this._folderScanner.getFolder());
            scanner.setParameter("folder", this._jarScanFolder);
            Iterator itIgnore = this._jarScanIgnores.iterator();
            while (itIgnore.hasNext()) {
                scanner.setParameter("ignore", (String)itIgnore.next());
            }
            Iterator itExtension = this._jarScanExtensions.iterator();
            while (itExtension.hasNext()) {
                scanner.setParameter("extension", (String)itExtension.next());
            }
            itit.add(scanner);
        }
        return itit;
    }

    public void setParameter(String name, String value) {
        if ("ignore".equals(name)) {
            if (StringUtil.isEmpty(value)) {
                throw new IllegalParameterValueException(this.getClass(), name);
            }
            this._ignores.add(value);
        } else if (name.startsWith("jar.")) {
            if ("folder".equals(name = name.substring("jar.".length()))) {
                this._jarScanFolder = value;
            } else if ("ignore".equals(name)) {
                this._jarScanIgnores.add(value);
            } else if ("extension".equals(name)) {
                this._jarScanExtensions.add(value);
            }
        } else {
            this._folderScanner.setParameter(name, value);
            return;
        }
        super.setParameter(name, value);
    }
}

