/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.seasar.mayaa.ParameterAware;
import org.seasar.mayaa.impl.IllegalParameterValueException;
import org.seasar.mayaa.impl.util.StringUtil;
import org.seasar.mayaa.impl.util.collection.NullIterator;

public class ParameterAwareImpl
implements ParameterAware {
    private static final long serialVersionUID = 7520826050429074016L;
    private transient Map _parameters;
    private String _systemID = "";
    private int _lineNumber;
    private boolean _onTemplate;

    public void setParameter(String name, String value) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (value == null) {
            throw new IllegalParameterValueException(this.getClass(), name);
        }
        if (this._parameters == null) {
            this._parameters = new HashMap();
        }
        this._parameters.put(name, value);
    }

    public String getParameter(String name) {
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (this._parameters == null) {
            return null;
        }
        return (String)this._parameters.get(name);
    }

    public Iterator iterateParameterNames() {
        if (this._parameters == null) {
            return NullIterator.getInstance();
        }
        return this._parameters.keySet().iterator();
    }

    public void setSystemID(String systemID) {
        this._systemID = StringUtil.preparePath(systemID);
    }

    public String getSystemID() {
        return this._systemID;
    }

    public void setLineNumber(int lineNumber) {
        if (lineNumber < 0) {
            lineNumber = 0;
        }
        this._lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setOnTemplate(boolean onTemplate) {
        this._onTemplate = onTemplate;
    }

    public boolean isOnTemplate() {
        return this._onTemplate;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this._parameters);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Map map = (Map)in.readObject();
        if (map != null) {
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.setParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }
}

