/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa.impl;

import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.mayaa.engine.Engine;
import org.seasar.mayaa.engine.Page;
import org.seasar.mayaa.engine.Template;
import org.seasar.mayaa.engine.specification.Specification;
import org.seasar.mayaa.impl.cycle.CycleUtil;
import org.seasar.mayaa.impl.cycle.web.MockHttpServletRequest;
import org.seasar.mayaa.impl.cycle.web.MockHttpServletResponse;
import org.seasar.mayaa.impl.provider.ProviderUtil;
import org.seasar.mayaa.impl.source.SourceHolderFactory;
import org.seasar.mayaa.impl.util.ObjectUtil;
import org.seasar.mayaa.source.SourceHolder;

public class AutoPageBuilder
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$seasar$mayaa$impl$AutoPageBuilder == null ? (class$org$seasar$mayaa$impl$AutoPageBuilder = AutoPageBuilder.class$("org.seasar.mayaa.impl.AutoPageBuilder")) : class$org$seasar$mayaa$impl$AutoPageBuilder));
    public static final String OPTION_AUTO_BUILD = "autoBuild";
    private static final String OPTION_AUTO_BUILD_REPRAT = "autoBuild.repeat";
    private static final String OPTION_AUTO_BUILD_WAIT = "autoBuild.wait";
    private static final String OPTION_AUTO_BUILD_FILE_FILTERS = "autoBuild.fileNameFilters";
    private static final String OPTION_AUTO_BUILD_RENDER_MATE = "autoBuild.renderMate";
    private static final boolean REPEAT_DEFAULT = false;
    private static final int WAIT_DEFAULT = 60;
    private static final boolean RENDER_MATE_DEFAULT = false;
    public static final AutoPageBuilder INSTANCE = new AutoPageBuilder();
    private Thread _thread;
    private boolean _repeat;
    private int _wait;
    private boolean _renderMate;
    private String[] _fileFilters;
    private ServletContext _servletContext;
    private long _buildTimeSum;
    private long _renderTimeSum;
    static /* synthetic */ Class class$org$seasar$mayaa$impl$AutoPageBuilder;

    private AutoPageBuilder() {
    }

    public void init(ServletConfig servletConfig) {
        Engine engine = ProviderUtil.getEngine();
        boolean autoBuild = ObjectUtil.booleanValue(engine.getParameter(OPTION_AUTO_BUILD), false);
        if (autoBuild) {
            this._servletContext = servletConfig.getServletContext();
            this._repeat = ObjectUtil.booleanValue(engine.getParameter(OPTION_AUTO_BUILD_REPRAT), false);
            this._wait = ObjectUtil.numberValue(engine.getParameter(OPTION_AUTO_BUILD_WAIT), new Integer(60)).intValue() * 1000;
            this._renderMate = ObjectUtil.booleanValue(engine.getParameter(OPTION_AUTO_BUILD_RENDER_MATE), false);
            String filters = engine.getParameter(OPTION_AUTO_BUILD_FILE_FILTERS);
            this._fileFilters = filters != null ? filters.split(";") : new String[]{".html"};
            this._thread = new Thread((Runnable)this){
                {
                    this.setDaemon(true);
                    this.setName("mayaa.AutoPageBuilder");
                    this.setPriority(1);
                    this.start();
                }
            };
            LOG.info((Object)"mayaa.AutoPageBuilder start");
        }
    }

    public void destroy() {
        if (this._thread != null) {
            this._thread = null;
            LOG.info((Object)"mayaa.AutoPageBuilder end");
        }
    }

    protected void reportTime(Specification spec, long time) {
        LOG.info((Object)(spec.getSystemID() + " build time: " + time + " msec."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            Engine engine = ProviderUtil.getEngine();
            long engineBuildTime = this.diffMillis(0L);
            Engine engine2 = engine;
            synchronized (engine2) {
                engine.build();
            }
            this.reportTime(engine, this.diffMillis(engineBuildTime));
            while (currentThread == this._thread) {
                this._buildTimeSum = 0L;
                this._renderTimeSum = 0L;
                Iterator it = SourceHolderFactory.iterator();
                while (it.hasNext()) {
                    SourceHolder holder = (SourceHolder)it.next();
                    Iterator itSystemID = holder.iterator(this._fileFilters);
                    while (itSystemID.hasNext()) {
                        String systemID = (String)itSystemID.next();
                        try {
                            this.buildPage(systemID);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("page load failed: " + systemID), e);
                        }
                        Thread.sleep(100L);
                    }
                }
                LOG.info((Object)("page all build time: " + this._buildTimeSum + " msec."));
                if (this._renderMate) {
                    LOG.info((Object)("page all render time: " + this._renderTimeSum + " msec."));
                }
                if (this._repeat) {
                    Thread.sleep(this._wait);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected long diffMillis(long millis) {
        if (millis == 0L) {
            return System.currentTimeMillis();
        }
        return System.currentTimeMillis() - millis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPage(String systemID) {
        if (systemID.indexOf("/WEB-INF") >= 0) {
            return;
        }
        MockHttpServletRequest request = new MockHttpServletRequest(this._servletContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.setPathInfo(systemID);
        CycleUtil.initialize(request, response);
        try {
            String pageName = CycleUtil.getRequestScope().getPageName();
            Engine engine = ProviderUtil.getEngine();
            if (engine.isPageRequested()) {
                long pageBuildTime = this.diffMillis(0L);
                Page page = engine.getPage(pageName);
                this.reportTime(page, this.diffMillis(pageBuildTime));
                long templateBuildTime = this.diffMillis(0L);
                Template template = page.getTemplate(CycleUtil.getRequestScope().getRequestedSuffix(), CycleUtil.getRequestScope().getExtension());
                templateBuildTime = this.diffMillis(templateBuildTime);
                this._buildTimeSum += templateBuildTime;
                if (this._renderMate) {
                    long renderTime = this.diffMillis(0L);
                    engine.doService(null, true);
                    renderTime = this.diffMillis(renderTime);
                    if (response.getStatus() == 500) {
                        LOG.debug((Object)(systemID + " (render: ----" + " / build: " + templateBuildTime + " msec)"));
                    } else {
                        this._renderTimeSum += renderTime;
                        LOG.debug((Object)(systemID + " (render: " + renderTime + " / build: " + templateBuildTime + " msec)"));
                    }
                } else {
                    this.reportTime(template, templateBuildTime);
                }
            }
        }
        finally {
            CycleUtil.cycleFinalize();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

