/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mayaa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.seasar.mayaa.UnifiedFactory;
import org.seasar.mayaa.cycle.scope.ApplicationScope;
import org.seasar.mayaa.source.SourceDescriptor;

public abstract class FactoryFactory
implements Serializable {
    private static FactoryFactory _instance;
    private static Object _context;
    private static Map _factories;

    public static void setInstance(FactoryFactory instance) {
        if (instance == null) {
            throw new IllegalArgumentException();
        }
        _instance = instance;
    }

    public static void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        _context = context;
    }

    private static void check() {
        if (_instance == null || _context == null) {
            throw new IllegalStateException();
        }
    }

    public static boolean isInitialized() {
        return _instance != null && _context != null;
    }

    public static SourceDescriptor getBootstrapSource(String root, String systemID) {
        FactoryFactory.check();
        return _instance.getBootstrapSource(root, systemID, _context);
    }

    public static UnifiedFactory getFactory(Class interfaceClass) {
        FactoryFactory.check();
        UnifiedFactory factory = (UnifiedFactory)_factories.get(interfaceClass);
        if (factory == null) {
            factory = _instance.getFactory(interfaceClass, _context);
            if (factory == null) {
                return null;
            }
            _factories.put(interfaceClass, factory);
        }
        return factory;
    }

    public static ApplicationScope getApplicationScope() {
        FactoryFactory.check();
        return _instance.getApplicationScope(_context);
    }

    protected abstract UnifiedFactory getFactory(Class var1, Object var2);

    protected abstract SourceDescriptor getBootstrapSource(String var1, String var2, Object var3);

    protected abstract ApplicationScope getApplicationScope(Object var1);

    static {
        _factories = new HashMap();
    }
}

