# N2::Spam
# 2008/07/13 v0.1
# H.OHARA

# Spam prefs
package N2::Spam;
use strict;
use warnings;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '/_spam/pages', # string
        db => undef, # N2::Data
        rex => '^([^# ].*)\s*$', #'
        proc => undef,
        _prefs => [ ],
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

sub init {
    my $self = shift;
    my @prefs;
    if(!$self->{proc}) {
        $self->{proc} = sub {
            my ($a) = @_;
            if($a =~ /$self->{rex}/) {
                push(@prefs,$1);
            }
        };
    }
    my $proc = $self->{proc};
    my @lines = split(/\n/,$self->{db}->get($self->{page}));
    foreach my $a (@lines) { $proc->($a); }
    $self->{_prefs} = \@prefs;
}

sub get {
    my $self = shift;
    return $self->{_prefs};
}

sub set {
    my $self = shift;
    my ($ary) = @_;
    $self->{_prefs} = $ary;
}

sub add {
    my $self = shift;
    my ($data) = @_;
    my $prefs = $self->{_prefs};
    my $n = grep { $_ eq $data } @$prefs;
    if($n == 0) {
        push(@$prefs,$data);
        $self->{db}->set($self->{page},"$data\n",'',1,1);
    }
}

1;
