# N2::Plugin
# 2008/4/13 v0.1
# H.OHARA

# Plugin class
package N2::Plugin;
use strict;
use warnings;
use Ho::A;

# constructor
sub new {
    my $class = shift;
    my $self = {
        path => 'plugin', # string
        state => { },
        resouce => { },
        _inline_plugin => { },
        _command_plugin => { },
        @_
    };
    if($self->{path} !~ /\/$/) {
        $self->{path} = $self->{path}.'/';
    }
    Ho::A->make_dir($self->{path}, 0666);
    $self = bless $self, $class;
    $self->init();
    return $self;
}
# private methods
sub str_to_sub {
    my $self = shift;
    my ($funcname) = @_;
    my $fname = Ho::A->check_filename($funcname,'[\w:]+');
    return eval '\&'.$fname;
}

sub read_plugin {
    my $self = shift;
    my ($key,$extn,$type) = @_;
    my $pluginpath = $self->{path}.$key.$extn;
    eval { require $pluginpath };
    return $self->str_to_sub($key.'::plugin_'.$type.'_'.$key);
}

sub init {
    my $self = shift;
    my $plugindir = $self->{path};
    my @plugins_inline  = sort glob("$plugindir*.n2inline");
    my @plugins_command = sort glob("$plugindir*.n2command");
    @plugins_inline = 
        map {$_ =~ /\/(.+?)\.n2inline$/  ? $1 : '' } @plugins_inline;
    @plugins_command = 
        map {$_ =~ /\/(.+?)\.n2command$/ ? $1 : '' } @plugins_command;
    foreach my $p (@plugins_inline) {
        $self->{_inline_plugin}->{$p} = 1;
    }
    foreach my $p (@plugins_command) {
        $self->{_command_plugin}->{$p} = 1;
    }
}

# public methods
sub get_state {
    my $self = shift;
    my ($key) = @_;
    return $self->{state}->{$key};
}

sub set_state {
    my $self = shift;
    my ($key,$data) = @_;
    $self->{state}->{$key} = $data;
}

sub read_help {
    my $self = shift;
    my ($key,$extn) = @_;
    $key = Ho::A->check_filename($key,'\w+');
    my $pluginpath = $self->{path}.$key.$extn;
    my @help;
    open(FILE,$pluginpath) || die $!;
    while(<FILE>) {
        if(/^#(.*)/) {
            push(@help,$1);
        }
        else {
            last;
        }
    }
    close(FILE);
    return @help;
}

sub each_plugin {
    my $self = shift;
    my ($extn) = @_;
    my $plugindir = $self->{path};
    my @plugins  = sort glob("$plugindir*$extn");
    @plugins = 
        grep { $_ ne '' }
        map  { $_ =~ /\/(.+?)\Q$extn\E$/ ? $1 : '' } @plugins;
    return @plugins;
}

sub command_wrapper {
    my $self = shift;
    my $proc = shift;
    my $view = shift;
    my ($p,$opt,$prm,$page,$db,$q,$str,$d,$v,$ap,$lns,$rsl) = @_;
    my $args = {
        p => $p, opt => $opt, prm => $prm, page => $page,
        data => $db, view => $view, q => $q, str => $str,
        depth => $d, vdpth => $v, apre => $ap, lines => $lns,
        result => $rsl
    };
    $proc->($self,$args);
}

sub inline_wrapper {
    my $self = shift;
    my $proc = shift;
    my $view = shift;
    my ($oname,$name,$prm,$page,$db,$q,$vdpth,$isPost,$cl,$ti) = @_;
    my $args = {
        oname => $oname, name => $name, prm => $prm, page => $page,
        data => $db, view => $view, q => $q, vdpth => $vdpth,
        isPost => $isPost, class => $cl, title => $ti
    };
    $proc->($self,$args);
}

sub args {
    my $self = shift;
    my ($ary,$hash) = @_;
    my @arg;
    foreach my $key (@$ary) {
        push(@arg, $hash->{$key});
    }
    return @arg;
}

sub inline {
    my $self = shift;
    my ($key) = @_;
    my $proc = $self->{_inline_plugin}->{$key};
    if($proc) {
        if($proc == 1) {
            $proc = $self->read_plugin($key,'.n2inline','inline');
            $self->{_inline_plugin}->{$key} = $proc;
        }
        return sub{ $self->inline_wrapper($proc,@_); };
    }
    return $proc;
}

sub command {
    my $self = shift;
    my ($key) = @_;
    my $proc = $self->{_command_plugin}->{$key};
    if($proc) {
        if($proc == 1) {
            $proc = $self->read_plugin($key,'.n2command','command');
            $self->{_command_plugin}->{$key} = $proc;
        }
        return sub{ $self->command_wrapper($proc,@_); };
    }
    return $proc;
}

sub resource {
    my $self = shift;
    my ($type,$name,$db,$default) = @_;
    my $key = $type.'_'.$name;
    my $res = $self->{resouce}->{$key};
    if(!$db->exists_page("/_plugin/$type/$name")) {
        $db->set("/_plugin/$type/$name",$default);
    }
    if(!defined($res)) {
        $res = N2::Prefs->new(
            page => "/_plugin/$type/$name",
            db => $db
        );
        $self->{resouce}->{$key} = $res;
    }
    return $res;
}

1;
