# N2::PathPrefs
# 2008/07/13 v0.1
# H.OHARA

# class N2::PathPrefs
package N2::PathPrefs;
use strict;
use warnings;

# inherites from N2::Prefs
use N2::Prefs;
use base qw( N2::Prefs );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '', # string
        db => undef, # N2::Data
        rex => '^(\/.*)\s+=\s+([\w-]+)\s*$', #'
        proc => undef,
        _prefs => undef,
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

sub init {
    my $self = shift;
    my @prefs;
    my $i = 0;
    if(!$self->{proc}) {
        $self->{proc} = sub {
            my ($a) = @_;
            if($a =~ /$self->{rex}/) {
                my $dp = $1 eq '/' ? '/' : "$1/" ;
                my $len = length($dp);
                push(@prefs,[$1,$2,$dp,$len,$i]);
            }
            $i++;
        };
    }
    $self->SUPER::init();
    @prefs = sort { $b->[0] cmp $a->[0] } @prefs;
    $self->{_prefs} = \@prefs;
}

# public methods
sub get_pref {
    my $self = shift;
    my ($page) = @_;
    my $prefs = $self->{_prefs};
    foreach my $t (@$prefs) {
        my ($p) = @$t;
        if($page eq $p) {
            return $t;
        }
    }
    return ['', '', '', '', ''];
}

sub get {
    my $self = shift;
    my ($page) = @_;
    my $prefs = $self->{_prefs};
    foreach my $t (@$prefs) {
        my ($p,$n,$dp,$len) = @$t;
        if($page eq $p || substr($page,0,$len) eq $dp 
            || ($p eq '/_' && substr($page,0,2) eq '/_')) {
            return $n;
        }
    }
    return '';
}

sub set {
    my $self = shift;
    my ($key, $value) = @_;
    my @lines = split(/\n/,$self->{db}->get($self->{page}));
    my $md = $self->{db}->editdate($self->{page});
    my $len = @lines;
    my $oldvalues = $self->get_pref($key);
    my $i = $oldvalues->[4];
    if($value ne '') {
        if($i ne '') {
            $lines[$i] = $key.' = '.$value;
        }
        else {
            push(@lines, $key.' = '.$value);
        }
    }
    else {
        if($i ne '') {
            my $c = 0;
            @lines = grep { $c++ != $i } @lines;
        }
    }
    $self->{db}->set($self->{page},join("\n",@lines),$md,1);
    $self->init();
}

1;
