# N2::Group
# 2008/07/13 v0.1
# H.OHARA

# Group prefs class
package N2::Group;
use strict;
use warnings;

# inherites from N2::Prefs
use N2::Prefs;
use base qw( N2::Prefs );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '/_preferences/group', # string
        db => undef, # N2::Data
        rex => '^([^# ]\S*)\s*=\s*(.+)\s*$', #'
        proc => undef,
        _prefs => { },
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

sub init {
    my $self = shift;
    if(!$self->{proc}) {
        $self->{proc} = sub {
            my ($a) = @_;
            if($a =~ /$self->{rex}/) {
                my @mem = split(/\|/,$2);
                $self->{_prefs}->{$1} = \@mem
            }
        };
    }
    $self->SUPER::init();
}

1;
