# N2::Alias
# 2008/4/13 v0.1
# H.OHARA

# Alias class
package N2::Alias;
use strict;
use warnings;
use Ho::A;

# inherites from N2::Prefs
use N2::Prefs;
use base qw( N2::Prefs );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        page => '_alias', # string
        db => undef, # N2::Data
        rex => '^([^# ]\S*)\s*=\s*(.*)?\s*$', #'
        proc => undef,
        user => '',
        @_
    };
    $self = bless $self, $class;
    $self->init();
    return $self;
}

sub init {
    my $self = shift;
    $self->SUPER::init();
    my $db = $self->{db};
    my $pg = $self->{page};
    my $user = $self->{user};
    if($user eq '') { return; }
    my $proc = $self->{proc};
    my @lines = split(/\n/,$db->get($user.'/'.$pg));
    foreach my $a (@lines) { $proc->($a); }
}

# public methods
sub command {
    my $self = shift;
    my ($key) = @_;
    return $self->get($key);
}

1;
