# simple Html Object using CGI.pm
# 2008/4/6 v0.1
# H.OHARA

use CGI qw(:standard :no_xhtml);

# concrete class
package Ho::C;
use strict;
use warnings;

# inherites from Ho::A
use Ho::A;
use base qw( Ho::A );

# constructor
sub new {
    my $class = shift;
    my $self = {
        -html => new CGI,
        -lang => 'ja',
        -charset => 'UTF-8',
        -title => 'Untitled',
        -header => { },
        -body => undef,
        -bodyparam => [ ],
        -pubid => '-//W3C//DTD HTML 4.01 Transitional//EN',
        -sysid => 'http://www.w3.org/TR/html4/loose.dtd',
        -postmax => 1024 * 1024 * 50,
        -buffersize => 32 * 1024,
        -wday => ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],
        -cachereset => 1,
        _REQUEST => undef,
        _GET => undef,
        _POST => undef,
        _UPLOAD => undef,
        _UPLOAD_INFO => undef,
        _COOKIE => undef,
        @_
    };
    return bless $self, $class;
}

# private function
sub prepare_header {
    my $self = shift;
    my $lang = $self->{-lang};
    my $charset = $self->{-charset};
    my $title = $self->{-title};
    my $head = $self->{-header};
    my %header = (
           -lang => $lang,
           -encoding => $charset,
           -title => $title
       );
    my @meta = (
            CGI::meta({ 
                -http_equiv => 'Content-Type',
                -content => "text/html; charset=$charset"
            })
       );
    my @exjs;
    my @emjs;
    my %styl;
    my $key;
    my $value;
    my %header_table = (
        '-script_type'
            => sub{push(@meta,$self->http_equiv('Content-Script-Type',$value));},
        '-style_type'
            => sub{push(@meta,$self->http_equiv('Content-Style-Type',$value));},
        '-extrn_css'
            => sub{@meta = (@meta, map {$self->linkcss($_)} @$value);},
        '-keywords'
            => sub{push(@meta,CGI::meta({-name=>'keywords',-content=>$value}));},
        '-description'
            => sub{push(@meta,CGI::meta({-name=>'description',-content=>$value}));},
        '-generator'
            => sub{push(@meta,CGI::meta({-name=>'generator',-content=>$value}));},
        '-copyright'
            => sub{push(@meta,CGI::meta({-name=>'copyright',-content=>$value}));},
        '-favicon'
            => sub{push(@meta,CGI::Link({-rel=>'shortcut icon',-href=>$value}));},
        '-animefavicon'
            => sub{push(@meta,$self->rellink('icon',$value,'image/gif'));},
        '-rss'
            => sub{push(@meta,$self->linkrss($value));},
        '-extrn_javascript'
            => sub{@exjs = map { {-language=>'JAVASCRIPT',-src=>$_} } @$value;},
        '-embed_javascript'
            => sub{@emjs = map { {-language=>'JAVASCRIPT',-code=>$_} } @$value;},
        '-embed_css'
            => sub{%styl = ( -code => $value );},
        '-robots'
            => sub{push(@meta,CGI::meta({-name=>'ROBOTS',-content=>$value}));},
        '-googlebot'
            => sub{push(@meta,CGI::meta({-name=>'GOOGLEBOT',-content=>$value}));},
        '-meta'
            => sub{@meta = (@meta, map {CGI::meta($_)} @$value);}
    );
    while(($key,$value) = each(%$head)) {
        $header_table{$key}->();
    }
    $header{-head} = \@meta;
    $header{-script} = [@exjs,@emjs];
    $header{-style} = \%styl;
    if($self->{-sysid} ne '') {
        $header{-dtd} = $self->{-pubid}.'" "'.$self->{-sysid};
    }
    else {
        $header{-dtd} = $self->{-pubid};
    }
    return %header;
}

sub http_equiv {
    my $self = shift;
    my ($type,$content) = @_;
    return CGI::meta({-http_equiv => $type, -content => $content});
}

sub rellink {
    my $self = shift;
    my ($rel,$href,$type) = @_;
    return CGI::Link({-rel => $rel, -href => $href, -type => $type});
}

# print HTML
sub print {
    my $self = shift;
    my %param = @_;
    if($self->{-cachereset}) { $self->reset_param_cache(); }
    $self->set(%param);
    my %head = $self->prepare_header();
    my $body = $self->{-body};
    my $html = $self->{-html};
    my $bodyparam = $self->{-bodyparam};
    print $html->header(-charset => $self->{-charset});
    print $html->start_html(%head);
    print "\n";
    &$body(@$bodyparam);
    print "\n";
    print $html->end_html;
    print "\n";
    return $self;
}

sub param {
    my ($self,$key) = @_;
    my $code = sub{$self->{-html}->param();};
    return $self->param_cache($key,'_REQUEST',$code);
}

1;
