# simple Html Object B
# 2008/4/6 v0.1
# H.OHARA

# concrete class
package Ho::B;
use strict;
use warnings;

# inherites from Ho::A
use Ho::A;
use base qw( Ho::A );
our $VERSION = 0.1;

# constructor
sub new {
    my $class = shift;
    my $self = {
        -html => undef,
        -lang => 'ja',
        -charset => 'UTF-8',
        -title => 'Untitled',
        -header => { },
        -body => undef,
        -bodyparam => [ ],
        -pubid => '-//W3C//DTD HTML 4.01 Transitional//EN',
        -sysid => 'http://www.w3.org/TR/html4/loose.dtd',
        -postmax => 1024 * 1024 * 50,
        -buffersize => 32 * 1024,
        -wday => ['Sun','Mon','Tue','Wed','Thu','Fri','Sat'],
        -cachereset => 1,
        _REQUEST => undef,
        _GET => undef,
        _POST => undef,
        _UPLOAD => undef,
        _UPLOAD_INFO => undef,
        _COOKIE => undef,
        @_
    };
    return bless $self, $class;
}

# private function
sub prepare_header {
    my $self = shift;
    my $lang = $self->{-lang};
    my $charset = $self->{-charset};
    my $title = $self->{-title};
    my $head = $self->{-header};
    my @header;
    my $key;
    my $value;
    my %header_table = (
        '-script_type'
            => sub{push(@header,$self->http_equiv('Content-Script-Type',$value));},
        '-style_type'
            => sub{push(@header,$self->http_equiv('Content-Style-Type',$value));},
        '-extrn_css'
            => sub{@header = (@header, map {$self->linkcss($_)} @$value);},
        '-keywords'
            => sub{push(@header,$self->meta(name=>'keywords',content=>$value));},
        '-description'
            => sub{push(@header,$self->meta(name=>'description',content=>$value));},
        '-generator'
            => sub{push(@header,$self->meta(name=>'generator',content=>$value));},
        '-copyright'
            => sub{push(@header,$self->meta(name=>'copyright',content=>$value));},
        '-favicon'
            => sub{push(@header,$self->Link(rel=>'shortcut icon',href=>$value));},
        '-animefavicon'
            => sub{push(@header,$self->rellink('icon',$value,'image/gif'));},
        '-rss'
            => sub{push(@header,$self->linkrss($value));},
        '-extrn_javascript'
            => sub{push(@header, map {$self->extrn_javascript($_)} @$value);},
        '-embed_javascript'
            => sub{push(@header, map {$self->embed_javascript($_)} @$value);},
        '-embed_css'
            => sub{push(@header,$self->embed_css($value));},
        '-robots'
            => sub{push(@header,$self->meta(name => 'ROBOTS',content=>$value));},
        '-googlebot'
            => sub{push(@header,$self->meta(name => 'GOOGLEBOT',content=>$value));},
        '-meta'
            => sub{@header = (@header, map {$self->meta(%$_)} @$value);}
    );
    push(@header,$self->tag_start('head'));
    push(@header,
        $self->meta('http-equiv' => 'Content-Language', content => $lang)
    );
    push(@header,
        $self->meta(
            'http-equiv'=>'Content-Type',
            content =>"text/html; charset=$charset"
        )
    );
    while(($key,$value) = each(%$head)) {
        $header_table{$key}->();
    }
    push(@header,$self->title($title));
    push(@header,$self->tag_end('head'));
    return @header;
}

# print HTML
sub print {
    my $self = shift;
    my %param = @_;
    if($self->{-cachereset}) { $self->reset_param_cache(); }
    $self->set(%param);
    my $body = $self->{-body};
    my $bodyparam = $self->{-bodyparam};
    print $self->start_html;
    &$body(@$bodyparam);
    print "\n";
    print $self->end_html;
    return $self;
}

1;
