/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.comm.wce;

import gnu.javax.comm.wce.WCESerialPort;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortIdentifier;

public class WCECommDriver
implements CommDriver {
    private static final int MINIMUM_PORT = Integer.getInteger("gnu.javax.comm.wce.minimumPort", 1);
    private static final int MAXIMUM_PORT = Integer.getInteger("gnu.javax.comm.wce.maximumPort", 9);

    @Override
    public void initialize() {
        System.loadLibrary("javaxcomm");
        for (int i = MINIMUM_PORT; i <= MAXIMUM_PORT; ++i) {
            CommPortIdentifier.addPortName("COM" + i + ":", 1, this);
        }
    }

    @Override
    public CommPort getCommPort(String string, int n) {
        int n2 = this.getNativeHandle(string, n);
        if (n2 == 0) {
            return null;
        }
        if (n == 1) {
            return new WCESerialPort(string, n2);
        }
        throw new IllegalArgumentException("portType=" + n + " is not supported");
    }

    public native int getNativeHandle(String var1, int var2);
}

