#include <jni.h>

#include "gnu_javax_comm_wce_WCESerialPort.h"

// SerialPortEvent̒萔
#define SerialPortEvent_BI					10 
#define SerialPortEvent_CD					6 
#define SerialPortEvent_CTS					3 
#define SerialPortEvent_DATA_AVAILABLE		1 
#define SerialPortEvent_DSR					4 
#define SerialPortEvent_FE					9 
#define SerialPortEvent_OE					7 
#define SerialPortEvent_OUTPUT_BUFFER_EMPTY	2 
#define SerialPortEvent_PE					8 
#define SerialPortEvent_RI					5 


 /**
 * Cxgʒmp\bhID
 */
static jmethodID g_notifyEvent_id;

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    nativeClose
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_nativeClose(JNIEnv *env, jobject obj, jint handle) {
	CloseHandle((HANDLE) handle);
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeEventMask
 * Signature: (IIZ)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeEventMask
(JNIEnv *env, jobject obj, jint handle, jint type, jboolean enable) {
	DWORD dwEvtMask = 0;
	// ΉCxg}XNɕϊ
	switch (type) {
	case SerialPortEvent_BI:
		dwEvtMask = EV_BREAK;
		break;
	
	case SerialPortEvent_CD:
		dwEvtMask = EV_RLSD;
		break;

	case SerialPortEvent_CTS:
		dwEvtMask = EV_CTS;
		break;

	case SerialPortEvent_DATA_AVAILABLE:
		dwEvtMask = EV_RXCHAR;
		break;

	case SerialPortEvent_DSR:
		dwEvtMask = EV_DSR;
		break;

	case SerialPortEvent_OUTPUT_BUFFER_EMPTY:
		dwEvtMask = EV_TXEMPTY;
		break;

	case SerialPortEvent_RI:
		dwEvtMask = EV_RING;
		break;

	case SerialPortEvent_FE:
	case SerialPortEvent_OE:
	case SerialPortEvent_PE:
		// ̃tO͐ݒ肵ȂiɗLɂȂĂj
		dwEvtMask = 0;
		break;

	default:
		dwEvtMask = 0;
		break;
	}
	
	if (dwEvtMask) {
		// Jg}XN擾A}XNlݒ肵Ȃ
		DWORD dwNewMask = 0;
		if (GetCommMask((HANDLE) handle, &dwNewMask)) {
			if (enable) {
				// rbg}XNIɂ
				dwNewMask |= dwEvtMask;
			} else {
				// rbg}XNItɂ
				dwNewMask &= ~dwEvtMask;
			}
			SetCommMask((HANDLE) handle, dwNewMask);
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    nativeRead
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_nativeRead__I
(JNIEnv *env, jobject obj, jint handle) {
	char buffer[1];
	jint ret;
	DWORD dwBytesRead;

	if (! ReadFile((HANDLE) handle,
		     buffer,
			 sizeof(buffer),
			 &dwBytesRead,
			 NULL)) {
		jclass clazz = (*env)->FindClass(env, "java/io/IOException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
		return -1;
	}
	if (sizeof(buffer) != dwBytesRead) {
		// 炭^CAEg
		return -1;
	}
	ret = (jint) buffer[0];
	return ret;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    nativeRead
 * Signature: (I[BII)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_nativeRead__I_3BII
(JNIEnv *env, jobject obj, jint handle, jbyteArray b, jint off, jint len) {
	char* buffer;
	DWORD dwBytesRead = 0;
	jint arraylen;

	if (len <= 0) {
		return 0;
	}

	// obt@̒Ɏ܂Ă邩𒲂ׂ
	arraylen = (*env)->GetArrayLength(env, b);
	if (off + len > arraylen) {
		// IndexOutOfBoundsException throw
		jclass clazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
			return 0;
		}
	}

	// obt@bNAf[^ǂ݂
	buffer = (*env)->GetByteArrayElements(env, b, NULL);
	if (buffer) {
		if (! ReadFile((HANDLE) handle,
					   buffer + off,
					   len,
					   &dwBytesRead,
					   NULL)) {
			// G[ɂIOExceptionthrow
			jclass clazz = (*env)->FindClass(env, "java/io/IOException");
			if (clazz) {
				(*env)->ThrowNew(env, clazz, NULL);
			}
		}
	}
	(*env)->ReleaseByteArrayElements(env, b, buffer, 0);
	return dwBytesRead;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    availableBytes
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_availableBytes
(JNIEnv *env, jobject obj, jint handle) {
	COMSTAT stat = {0};
	DWORD errors = 0;
	if (ClearCommError((HANDLE) handle, &errors, &stat)) {
		// L[ɂ܂ĂāA܂ReadFile()œǂݏoĂȂoCg
		return stat.cbInQue;
	} else {
		return 0;
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    nativeWrite
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_nativeWrite__II
(JNIEnv *env, jobject obj, jint handle, jint b) {
	char buffer[1];
	DWORD dwBytesWritten;

	buffer[0] = (char) b;
	if (! WriteFile((HANDLE) handle,
					 buffer,
					 sizeof(buffer),
					 &dwBytesWritten,
					 NULL)) {
		jclass clazz = (*env)->FindClass(env, "java/io/IOException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    nativeWrite
 * Signature: (I[BII)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_nativeWrite__I_3BII
(JNIEnv *env, jobject obj, jint handle, jbyteArray b, jint off, jint len) {
	char* buffer;
	DWORD dwBytesWritten = 0;
	DWORD dwTotalBytesWritten = 0;
	jint arraylen;

	if (len <= 0) {
		return;
	}

	// obt@̒Ɏ܂Ă邩𒲂ׂ
	arraylen = (*env)->GetArrayLength(env, b);
	if (off + len > arraylen) {
		// IndexOutOfBoundsException throw
		jclass clazz = (*env)->FindClass(env, "java/lang/IndexOutOfBoundsException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
			return;
		}
	}

	// obt@bNAf[^
	buffer = (*env)->GetByteArrayElements(env, b, NULL);
	if (buffer) {
		// ׂẴoCgݏI܂Ń[v
		while (dwTotalBytesWritten < (DWORD) len) {
			if (! WriteFile((HANDLE) handle,
						   buffer + off,
						   len,
						   &dwBytesWritten,
						   NULL)) {
				jclass clazz = (*env)->FindClass(env, "java/io/IOException");
				if (clazz) {
					(*env)->ThrowNew(env, clazz, NULL);
				}
				// [v𔲂
				break;
			}
			// 񂾃oCg𑫂
			dwTotalBytesWritten += dwBytesWritten;
		}
	}
	(*env)->ReleaseByteArrayElements(env, b, buffer, 0);
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeBaudRate
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeBaudRate
(JNIEnv* env, jobject obj, jint handle) {
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	if (GetCommState((HANDLE) handle, &dcb)) {
		return dcb.BaudRate;
	} else {
		return 0;			// {[[g擾łȂ
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeDataBits
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeDataBits
(JNIEnv* env, jobject obj, jint handle) {
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	if (GetCommState((HANDLE) handle, &dcb)) {
		return dcb.ByteSize;	// 萔lƃrbg͓
	} else {
		return 0;				// rbgTCY擾łȂ
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeStopBits
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeStopBits
(JNIEnv* env, jobject obj, jint handle) {
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	if (GetCommState((HANDLE) handle, &dcb)) {
		switch (dcb.StopBits) {
		case ONESTOPBIT:
			// 1rbg
			return gnu_javax_comm_wce_WCESerialPort_STOPBITS_1;
		
		case ONE5STOPBITS:
			// 1.5rbg
			return gnu_javax_comm_wce_WCESerialPort_STOPBITS_1_5;

		case TWOSTOPBITS:
			// 2rbg
			return gnu_javax_comm_wce_WCESerialPort_STOPBITS_2;

		default:
			// s
			return -1;
		}
	}
	return -1;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeParity
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeParity
(JNIEnv* env, jobject obj, jint handle) {
	jint result = gnu_javax_comm_wce_WCESerialPort_PARITY_NONE;
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	if (GetCommState((HANDLE) handle, &dcb)) {
		if (dcb.fParity) {
			switch (dcb.Parity) {
			case EVENPARITY:
				result = gnu_javax_comm_wce_WCESerialPort_PARITY_EVEN;
				break;

			case MARKPARITY:
				result = gnu_javax_comm_wce_WCESerialPort_PARITY_MARK;
				break;

			case NOPARITY:
				result = gnu_javax_comm_wce_WCESerialPort_PARITY_NONE;
				break;

			case ODDPARITY:
				result = gnu_javax_comm_wce_WCESerialPort_PARITY_ODD;
				break;

			case SPACEPARITY:
				result = gnu_javax_comm_wce_WCESerialPort_PARITY_SPACE;
				break;
			}
		}
	}
	return result;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeSerialPortParams
 * Signature: (IIII)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeSerialPortParams
(JNIEnv* env, jobject obj, jint handle, jint baoudrate, jint dataBits, jint stopBits, jint parity) {
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	GetCommState((HANDLE) handle, &dcb);
	
	// {[[gƃf[^rbg͂̂܂ܐݒ肷
	dcb.BaudRate = baoudrate;
	dcb.ByteSize = (BYTE) dataBits;

	// Xgbvrbglϊ
	switch (stopBits) {
	case gnu_javax_comm_wce_WCESerialPort_STOPBITS_1:
		// 1rbg
		dcb.StopBits = ONESTOPBIT;
		break;

	case gnu_javax_comm_wce_WCESerialPort_STOPBITS_1_5:
		// 1.5rbg
		dcb.StopBits = ONE5STOPBITS;
		break;

	case gnu_javax_comm_wce_WCESerialPort_STOPBITS_2:
		// 2rbg
		dcb.StopBits = TWOSTOPBITS;
		break;
	
	}
	
	// peBlϊ
	switch (parity) {
	case gnu_javax_comm_wce_WCESerialPort_PARITY_EVEN:
		dcb.Parity = EVENPARITY;
		break;

	case gnu_javax_comm_wce_WCESerialPort_PARITY_MARK:
		dcb.Parity = MARKPARITY;
		break;

	case gnu_javax_comm_wce_WCESerialPort_PARITY_NONE:
		dcb.Parity = NOPARITY;
		break;

	case gnu_javax_comm_wce_WCESerialPort_PARITY_ODD:
		dcb.Parity = ODDPARITY;
		break;

	case gnu_javax_comm_wce_WCESerialPort_PARITY_SPACE:
		dcb.Parity = SPACEPARITY;
		break;
	}
	
	// VA|[g̏Ԃݒ肷
	if (! SetCommState((HANDLE) handle, &dcb)) {
		// G[ɂ UnsupportedCommOperationException throw
		jclass clazz = (*env)->FindClass(env, "javax/comm/UnsupportedCommOperationException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeDTR
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeDTR
(JNIEnv *env, jobject obj, jint handle, jboolean dtr) {
	EscapeCommFunction((HANDLE) handle,
						dtr ? SETDTR : CLRDTR);
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeRTS
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeRTS
(JNIEnv *env, jobject obj, jint handle, jboolean rts) {
	EscapeCommFunction((HANDLE) handle,
						rts ? SETRTS : CLRRTS);
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    isNativeCTS
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_comm_wce_WCESerialPort_isNativeCTS
(JNIEnv *env, jobject obj, jint handle) {
	DWORD dwModemStat = 0;
	GetCommModemStatus((HANDLE) handle, &dwModemStat);
	return (dwModemStat & MS_CTS_ON) == MS_CTS_ON;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    isNativeDSR
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_comm_wce_WCESerialPort_isNativeDSR
(JNIEnv *env, jobject obj, jint handle) {
	DWORD dwModemStat = 0;
	GetCommModemStatus((HANDLE) handle, &dwModemStat);
	return (dwModemStat & MS_DSR_ON) == MS_DSR_ON;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    isNativeRI
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_comm_wce_WCESerialPort_isNativeRI
(JNIEnv *env, jobject obj, jint handle) {
	DWORD dwModemStat = 0;
	GetCommModemStatus((HANDLE) handle, &dwModemStat);
	return (dwModemStat & MS_RING_ON) == MS_RING_ON;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    isNativeCD
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_comm_wce_WCESerialPort_isNativeCD
(JNIEnv *env, jobject obj, jint handle) {
	DWORD dwModemStat = 0;
	GetCommModemStatus((HANDLE) handle, &dwModemStat);
	return (dwModemStat & MS_RLSD_ON) == MS_RLSD_ON;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    waitAndNotifyNativeEvents
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_waitAndNotifyNativeEvents
(JNIEnv *env, jobject obj, jint handle) {
	DWORD dwEvtMask = 0;

	// O[oϐ
	if (! g_notifyEvent_id) {
		jclass clazz = (*env)->GetObjectClass(env, obj);
		if (! clazz) {
			return;
		}
		g_notifyEvent_id = (*env)->GetMethodID(env,
											   clazz,
											   "notifyEvent",
											   "(IZZ)V");
		if (! g_notifyEvent_id) {
			return;
		}
	}

	if (WaitCommEvent((HANDLE) handle, &dwEvtMask, NULL)) {
		// Cxg

		// ݂̏Ԃ擾
		// iCTS, DSR, RI, CD̂Ŏgpj
		DWORD dwModemStat = 0;
		GetCommModemStatus((HANDLE) handle, &dwModemStat);

		if ((dwEvtMask & EV_BREAK) == EV_BREAK) {
			(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_BI,	// Cxg^Cv
								   JNI_FALSE,			// oldValue
								   JNI_TRUE);			// newValue
		}
		if ((dwEvtMask & EV_CTS) == EV_CTS) {
			// CTS̏Ԃω
			jboolean newValue = (dwModemStat & MS_CTS_ON) ? JNI_TRUE : JNI_FALSE;
			(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_CTS,	// Cxg^Cv
								   ! newValue,			// oldValue
								   newValue);			// newValue
		}
		if ((dwEvtMask & EV_DSR) == EV_DSR) {
			// DSȐԂω
			jboolean newValue = (dwModemStat & MS_DSR_ON) ? JNI_TRUE : JNI_FALSE;
			(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_DSR,	// Cxg^Cv
								   ! newValue,			// oldValue
								   newValue);			// newValue
		}
		if ((dwEvtMask & EV_ERR) == EV_ERR) {
			// G[̓e肷邽߁AClearCommError()Ăяo
			// Xiɒʒmꂽ_ŁAۂɂ̓G[̓NAĂ
			DWORD errors = 0;
			ClearCommError((HANDLE) handle, &errors, NULL);
			if ((errors & CE_FRAME) == CE_FRAME) {
				// t[~OG[
				(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_FE,	// Cxg^Cv
								   JNI_FALSE,			// oldValue
								   JNI_TRUE);			// newValue
			}
			if ((errors & CE_OVERRUN) == CE_OVERRUN) {
				// I[o[G[
				(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_OE,	// Cxg^Cv
								   JNI_FALSE,			// oldValue
								   JNI_TRUE);			// newValue
			}
			if ((errors & CE_RXPARITY) == CE_RXPARITY) {
				// peBG[
				(*env)->CallVoidMethod(env,
								   obj,
								   g_notifyEvent_id,
								   SerialPortEvent_PE,	// Cxg^Cv
								   JNI_FALSE,			// oldValue
								   JNI_TRUE);			// newValue
			}
		}

		if ((dwEvtMask & EV_RING) == EV_RING) {
			// RIω
			jboolean newValue = (dwModemStat & MS_RING_ON) ? JNI_TRUE : JNI_FALSE;
			(*env)->CallVoidMethod(env,
							   obj,
							   g_notifyEvent_id,
							   SerialPortEvent_RI,	// Cxg^Cv
							   ! newValue,			// oldValue
							   newValue);			// newValue
		}

		if ((dwEvtMask & EV_RLSD) == EV_RLSD) {
			// RLSDω
			jboolean newValue = (dwModemStat & MS_RLSD_ON) ? JNI_TRUE : JNI_FALSE;
			(*env)->CallVoidMethod(env,
							   obj,
							   g_notifyEvent_id,
							   SerialPortEvent_CD,	// Cxg^Cv
							   ! newValue,			// oldValue
							   newValue);			// newValue
		}
			
		if ((dwEvtMask & EV_RXCHAR) == EV_RXCHAR) {
			(*env)->CallVoidMethod(env,
							   obj,
							   g_notifyEvent_id,
							   SerialPortEvent_DATA_AVAILABLE ,	// Cxg^Cv
							   JNI_FALSE,			// oldValue
							   JNI_TRUE);			// newValue
		}
			
		if ((dwEvtMask & EV_TXEMPTY) == EV_TXEMPTY) {
			(*env)->CallVoidMethod(env,
							   obj,
							   g_notifyEvent_id,
							   SerialPortEvent_OUTPUT_BUFFER_EMPTY,	// Cxg^Cv
							   JNI_FALSE,			// oldValue
							   JNI_TRUE);			// newValue
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeFlowControlMode
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeFlowControlMode
(JNIEnv *env, jobject obj, jint handle, jint flowcontrol) {
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	GetCommState((HANDLE) handle, &dcb);
	
	if (flowcontrol == gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_NONE) {
		// t[Ȃ
		dcb.fRtsControl		= RTS_CONTROL_ENABLE;		// RTS͏ɃIi=Ƀf[^M\j
		dcb.fOutxCtsFlow	= FALSE;					// CTS𖳎iɑM
		dcb.fOutX			= FALSE;					// XON/XOFF(Output)
		dcb.fInX			= FALSE;					// XON/XOFF(Input)
	}

	if (flowcontrol & gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_RTSCTS_IN) {
		dcb.fRtsControl		= RTS_CONTROL_HANDSHAKE;	// RTSnhVFCNs
	} else {
		dcb.fRtsControl		= RTS_CONTROL_ENABLE;		// RTS͏ɃIiɃf[^M\ԁj
	}
	
	if (flowcontrol & gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_RTSCTS_OUT) {
		dcb.fOutxCtsFlow	= TRUE;						// CTSđM邩߂
	} else {
		dcb.fOutxCtsFlow	= FALSE;					// CTS𖳎AɑM
	}

	if ((flowcontrol & gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_XONXOFF_IN)) {
		// XON/XOFFɂt[íj
		dcb.fInX = TRUE;								// XON/XOFF(Input)L
	} else {
		dcb.fInX = FALSE;
	}

	if ((flowcontrol & gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_XONXOFF_OUT)) {
		// XON/XOFFɂt[iój
		dcb.fOutX = TRUE;								// XON/XOFF(Output)L
	} else {
		dcb.fOutX = FALSE;
	}
	
	if (! SetCommState((HANDLE) handle, &dcb)) {
		// ݒɎsꍇAUnsupportedCommOperationExceptionthrow
		jclass clazz = (*env)->FindClass(env, "javax/comm/UnsupportedCommOperationException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
	}
}


/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeFlowControlMode
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeFlowControlMode
(JNIEnv *env, jobject obj, jint handle) {
	jint flowcontrol = gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_NONE;
	DCB dcb = {0};
	dcb.DCBlength = sizeof(DCB);
	
	if (GetCommState((HANDLE) handle, &dcb)) {
		if (! dcb.fRtsControl || dcb.fRtsControl == RTS_CONTROL_HANDSHAKE) {
			// RTSɂ̓t[L
			flowcontrol |= gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_RTSCTS_IN;
		}	
		if (dcb.fOutxCtsFlow) {
			// CTSɂo̓t[L
			flowcontrol |= gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_RTSCTS_OUT;
		}	

		if (dcb.fInX) {
			// XON/XOFF íj
			flowcontrol |= gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_XONXOFF_IN;
		}
		if (dcb.fOutX) {
			// XON/XOFF iój
			flowcontrol |= gnu_javax_comm_wce_WCESerialPort_FLOWCONTROL_XONXOFF_OUT;
		}
	}
	
	return flowcontrol;
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    sendNativeBreak
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_sendNativeBreak
(JNIEnv *env, jobject obj, jint handle, jint millis) {
	// w肳ꂽ~b|[gBreakԂɂ
	SetCommBreak((HANDLE) handle);
	Sleep((DWORD) millis);
	ClearCommBreak((HANDLE) handle);
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    enableNativeReceiveTimeout
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_enableNativeReceiveTimeout
(JNIEnv *env, jobject obj, jint handle, jint timeout) {
	COMMTIMEOUTS timeouts = {0};
	
	// M^CAEglύXĂ܂Ȃ悤ɁA݂̒l擾
	GetCommTimeouts((HANDLE) handle, &timeouts);

	// http://msdn.microsoft.com/library/default.asp?url=/library/en-us/wceseril/html/_wcesdk_win32_commtimeouts_str.asp
	// "Remarks"ɂݒs
	timeouts.ReadIntervalTimeout = MAXDWORD;
	timeouts.ReadTotalTimeoutMultiplier = MAXDWORD;
	timeouts.ReadTotalTimeoutConstant = timeout;

	if (! SetCommTimeouts((HANDLE) handle, &timeouts)) {
		// sꍇ UnsupportedCommOperationExceptionthrow
		jclass clazz = (*env)->FindClass(env, "javax/comm/UnsupportedCommOperationException");
		if (clazz) {
			(*env)->ThrowNew(env, clazz, NULL);
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    disableNativeReceiveTimeout
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_disableNativeReceiveTimeout
(JNIEnv *env, jobject obj, jint handle) {
	COMMTIMEOUTS timeouts = {0};
	
	// M^CAEglύXĂ܂Ȃ悤ɁA݂̒l擾
	if (GetCommTimeouts((HANDLE) handle, &timeouts)) {
		// M^CAEg𖳌ɂ
		timeouts.ReadIntervalTimeout = 0;
		timeouts.ReadTotalTimeoutMultiplier = 0;
		timeouts.ReadTotalTimeoutConstant = 0;

		if (! SetCommTimeouts((HANDLE) handle, &timeouts)) {
			// sꍇ UnsupportedCommOperationExceptionthrow
			jclass clazz = (*env)->FindClass(env, "javax/comm/UnsupportedCommOperationException");
			if (clazz) {
				(*env)->ThrowNew(env, clazz, NULL);
			}
		}
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeInputBufferSize
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeInputBufferSize
(JNIEnv *env, jobject obj, jint handle, jint size) {
	COMMPROP prop = {0};
	if (GetCommProperties((HANDLE) handle, &prop)) {
		SetupComm((HANDLE) handle, (DWORD) size, prop.dwCurrentTxQueue);
	}
}


/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeInputBufferSize
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeInputBufferSize
(JNIEnv *env, jobject obj, jint handle) {
	COMMPROP prop = {0};
	if (GetCommProperties((HANDLE) handle, &prop)) {
		return prop.dwCurrentRxQueue;	
	} else {
		return 0;
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    setNativeOutputBufferSize
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_gnu_javax_comm_wce_WCESerialPort_setNativeOutputBufferSize
(JNIEnv *env, jobject obj, jint handle, jint size) {
	COMMPROP prop = {0};
	if (GetCommProperties((HANDLE) handle, &prop)) {
		SetupComm((HANDLE) handle, prop.dwCurrentRxQueue, (DWORD) size);
	}
}


/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeOutputBufferSize
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeOutputBufferSize
(JNIEnv *env, jobject obj, jint handle) {
	COMMPROP prop = {0};
	if (GetCommProperties((HANDLE) handle, &prop)) {
		return prop.dwCurrentTxQueue;	
	} else {
		return 0;
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    isNativeReceiveTimeoutEnabled
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_gnu_javax_comm_wce_WCESerialPort_isNativeReceiveTimeoutEnabled
(JNIEnv *env, jobject obj, jint handle) {
	COMMTIMEOUTS timeouts = {0};
	if (GetCommTimeouts((HANDLE) handle, &timeouts)) {
		return (timeouts.ReadTotalTimeoutConstant != 0) ? JNI_TRUE : JNI_FALSE;
	} else {
		return JNI_FALSE;
	}
}

/*
 * Class:     gnu_javax_comm_wce_WCESerialPort
 * Method:    getNativeReceiveTimeout
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_gnu_javax_comm_wce_WCESerialPort_getNativeReceiveTimeout
(JNIEnv *env, jobject obj, jint handle) {
	COMMTIMEOUTS timeouts = {0};
	if (GetCommTimeouts((HANDLE) handle, &timeouts)) {
		return timeouts.ReadTotalTimeoutConstant;
	} else {
		return 0;
	}
}

