/* WCECommDriver.java --
   Copyright (C) 2005 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */

package gnu.javax.comm.wce;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.BitSet;
import java.util.TooManyListenersException;

import javax.comm.*;

/**
 * Windows CESerialPortNX
 */
public class WCESerialPort extends SerialPort {
	/**
	 * lCeBut@Cnh
	 */
	private final int handle;
	
	/**
	 * N[Yꂽ
	 */
	private volatile boolean closed;
	
	/**
	 * Xi
	 */
	private SerialPortEventListener listener;
	
	/**
	 * Cxgʒm}XN
	 */
	private BitSet eventMask = new BitSet();
	
	/**
	 * CxgʒmpXbh
	 */
	private Thread notifyThread;
	
	public WCESerialPort(String name, int handle) {
		this.name = name;
		this.handle = handle;
		
		// ʒmpXbh쐬
		this.notifyThread = new Thread(
			new Runnable() {
				public void run() {
					while (! closed) {
						// N[Y܂ŌJԂCxgҋ@
						waitAndNotifyNativeEvents(WCESerialPort.this.handle);
					}
				}
		});
		this.notifyThread.setDaemon(true);
		this.notifyThread.start();
	
	}
	
	/**
	 * |[gI[vԂł邩𒲂ׂ
	 * łclose()Ăꍇɂ IllegalStateException  throw 
	 */
	private void checkOpen() throws IllegalStateException {
		if (closed) {
			throw new IllegalStateException("Port closed");
		}
	}
	
	public InputStream getInputStream() throws IOException {
		checkOpen();
		return new WCESerialPortInputStream();
	}
	
	public OutputStream getOutputStream() throws IOException {
		checkOpen();
		return new WCESerialPortOutputStream();
	}
	
	public void close() {
		nativeClose(this.handle);
		this.closed = true;
		super.close();
	}
	
	/**
	 * lCeBunhN[Y
	 */
	private native void nativeClose(int handle);
	
	public void enableReceiveThreshold(int thresh)
                                     throws UnsupportedCommOperationException {
		checkOpen();
		// T|[gĂȂ
		throw new UnsupportedCommOperationException();
	}
                                     
	public void disableReceiveThreshold() {
		checkOpen();
		// Ȃ
	}
	
	
	public boolean isReceiveThresholdEnabled() {
		checkOpen();
		return false;
	}
	
	public int getReceiveThreshold() {
		checkOpen();
		return 0;
	}
	
	public void enableReceiveTimeout(int rcvTimeout)
                                   throws UnsupportedCommOperationException {
		checkOpen();
		enableNativeReceiveTimeout(this.handle, rcvTimeout);
	}

	/**
	 * M^CAEglݒ肷
	 */
	native void enableNativeReceiveTimeout(int handle, int rcvTimeout)
                                   throws UnsupportedCommOperationException;

	public void disableReceiveTimeout() {
		checkOpen();
		disableNativeReceiveTimeout(this.handle);
	}
	
	/**
	 * M^CAEg𖳌ɂ
	 */
	native void disableNativeReceiveTimeout(int handle);
	
	public boolean isReceiveTimeoutEnabled() {
		checkOpen();
		return isNativeReceiveTimeoutEnabled(this.handle);
	}
	
	/**
	 * M^CAEgLł邩Ԃ
	 */
	native boolean isNativeReceiveTimeoutEnabled(int handle);
	
	public int getReceiveTimeout() {
		checkOpen();
		return getNativeReceiveTimeout(this.handle);
	}
	
	native int getNativeReceiveTimeout(int handle);
	
	public void enableReceiveFraming(int framingByte)
                                   throws UnsupportedCommOperationException {
		checkOpen();
		throw new UnsupportedCommOperationException();
	}
	
    public void disableReceiveFraming() {
		checkOpen();
		// Ȃ
	}
    public boolean isReceiveFramingEnabled() {
		checkOpen();
		return false;
	}
	
    public int getReceiveFramingByte() {
		checkOpen();
		return 0;
	}
	
    public void setInputBufferSize(int size) {
		checkOpen();
		setNativeInputBufferSize(this.handle, size);
	}
	
	/**
	 * ̓obt@TCYݒ肷
	 */
	native void setNativeInputBufferSize(int handle, int size);

	public int getInputBufferSize() {
		checkOpen();
		return getNativeInputBufferSize(this.handle);
	}
	
	/**
	 * ̓obt@̃TCYԂ
	 */
	native int getNativeInputBufferSize(int handle);
	
    public void setOutputBufferSize(int size) {
		checkOpen();
		setNativeOutputBufferSize(this.handle, size);
	}
	
	/**
	 * o̓obt@TCYݒ肷
	 */
	native void setNativeOutputBufferSize(int handle, int size);
	
    public int getOutputBufferSize() {
		checkOpen();
		return getNativeOutputBufferSize(this.handle);
	}
	
	native int getNativeOutputBufferSize(int handle);
	
	public int getBaudRate() {
		checkOpen();
		return getNativeBaudRate(this.handle);
	}
	
	/**
	 * lCeBũ{[[g擾
	 */
	native int getNativeBaudRate(int handle);
	
	public int getDataBits() {
		checkOpen();
		return getNativeDataBits(this.handle);
	}
	
	/**
	 * f[^rbgԂ
	 */
	native int getNativeDataBits(int handle);
	
	public int getStopBits() {
		checkOpen();
		return getNativeStopBits(this.handle);
	}
	
	/**
	 * XgbvrbgԂB
	 */
	native int getNativeStopBits(int handle);
	
	public int getParity() {
		checkOpen();
		return getNativeParity(this.handle);
	}
	
	/**
	 * peBԂ
	 */
	native int getNativeParity(int handle);
	
	public void sendBreak(int millis) {
		checkOpen();
		sendNativeBreak(this.handle, millis);
	}
	
	/**
	 * u[N𑗐M
	 */
	native void sendNativeBreak(int handle, int millis);
	
	public void setFlowControlMode(int flowcontrol)
                                 throws UnsupportedCommOperationException {
		checkOpen();
		setNativeFlowControlMode(this.handle, flowcontrol);
	}
	
	/**
	 * t[䃂[hݒ肷
	 */
	native void setNativeFlowControlMode(int handle, int flowcontrol)
	                                 throws UnsupportedCommOperationException;

	
	public int getFlowControlMode() {
		checkOpen();
		return getNativeFlowControlMode(this.handle);
	}
	
	/**
	 * t[䃂[hԂ
	 */
	native int getNativeFlowControlMode(int handle);
	
	public void setSerialPortParams(int baudrate,
                                         int dataBits,
                                         int stopBits,
                                         int parity)
                                  throws UnsupportedCommOperationException {
		checkOpen();
		setNativeSerialPortParams(this.handle,
								  baudrate,
								  dataBits,
								  stopBits,
								  parity);
	}
    
    /**
     * VA|[g̃p[^ݒ肷
     */
    native void setNativeSerialPortParams(int handle,
    									  int baudrate,
                                          int dataBits,
                                          int stopBits,
                                          int parity)
                                  throws UnsupportedCommOperationException;
    
    public void setDTR(boolean dtr) {
		checkOpen();
		setNativeDTR(this.handle, dtr);
	}
	
	/**
	 * DTRݒ肷
	 */
	native void setNativeDTR(int handle, boolean dtr);
	
    public boolean isDTR() {
		checkOpen();
		// ǂĎH
		return false;
	}
	
    public void setRTS(boolean rts) {
		checkOpen();
		setNativeRTS(this.handle, rts);
	}
	
	/**
	 * RTSݒ肷
	 */
	native void setNativeRTS(int handle, boolean rts);
	
    public boolean isRTS() {
		checkOpen();
		// ǂĎH
		return false;
	}
    public boolean isCTS() {
		checkOpen();
		return isNativeCTS(this.handle);
	}
	
	native boolean isNativeCTS(int handle);
	
    public boolean isDSR() {
		checkOpen();
		return isNativeDSR(this.handle);
	}
	
	native boolean isNativeDSR(int handle);
	
    public boolean isRI() {
		checkOpen();
		return isNativeRI(this.handle);
	}
	
	/**
	 * RI̒lԂ
	 */
	native boolean isNativeRI(int handle);
	
    public boolean isCD() {
		checkOpen();
		return isNativeCD(this.handle);
	}
	
	/**
	 * CD̒lԂ
	 */
	native boolean isNativeCD(int handle);
	
    public void addEventListener(SerialPortEventListener lsnr)
                               throws TooManyListenersException {
		checkOpen();
		if (this.listener != null) {
			throw new TooManyListenersException();
		}
		this.listener = lsnr;
	}
    
    public  void removeEventListener() {
		// I[vĂ邩̃`FbN͂Ȃ
		this.listener = null;
	}
	
	/**
	 * ʒmtOݒ肷
	 */
	private void setEventMask(int type, boolean enable) {
		checkOpen();
		this.eventMask.set(type, enable);
		setNativeEventMask(this.handle, type, enable);
	}
	
	/**
	 * lCeBũCxgҋ@tOݒ肷
	 */
	native void setNativeEventMask(int handle, int type, boolean enable);
	
    public void notifyOnDataAvailable(boolean enable) {
		setEventMask(SerialPortEvent.DATA_AVAILABLE, enable);
	}

    public void notifyOnOutputEmpty(boolean enable) {
		setEventMask(SerialPortEvent.OUTPUT_BUFFER_EMPTY, enable);
	}

    public void notifyOnCTS(boolean enable) {
		setEventMask(SerialPortEvent.CTS, enable);
	}

    public void notifyOnDSR(boolean enable) {
		setEventMask(SerialPortEvent.DSR, enable);
	}

    public void notifyOnRingIndicator(boolean enable) {
		setEventMask(SerialPortEvent.RI, enable);
	}
	
    public void notifyOnCarrierDetect(boolean enable) {
		setEventMask(SerialPortEvent.CD, enable);
	}

    public void notifyOnOverrunError(boolean enable) {
		setEventMask(SerialPortEvent.OE, enable);
	}

    public void notifyOnParityError(boolean enable) {
		setEventMask(SerialPortEvent.PE, enable);
	}

    public void notifyOnFramingError(boolean enable) {
		setEventMask(SerialPortEvent.FE, enable);
	}

    public void notifyOnBreakInterrupt(boolean enable) {
		setEventMask(SerialPortEvent.BI, enable);
	}
	
	/**
	 * w肳ꂽnh1oCgǂݍ
	 */
	native int nativeRead(int handle) throws IOException;
	
	/**
	 * w肳ꂽnhf[^ǂݍ݁Aobt@Ɋi[
	 */
	native int nativeRead(int handle, byte[] buff, int off, int len) throws IOException;
	
	/**
	 * ubNɓǂݍ߂oCgԂB
	 */
	native int availableBytes(int handle) throws IOException ;
	
	/**
	 * w肳ꂽnh1oCg
	 */
	native void nativeWrite(int handle, int b) throws IOException;

	/**
	 * w肳ꂽnhɁAobt@̃f[^
	 */
	native void nativeWrite(int handle, byte[] buff, int off, int len) throws IOException;

	/**
	 * CxgXiɒʒm
	 */
	void notifyEvent(int eventType, boolean oldValue, boolean newValue) {
		if (this.listener != null) {
			if (this.eventMask.get(eventType)) {
				// tOLɂȂĂꍇ̂ݒʒm
				SerialPortEvent e = new SerialPortEvent(this,
														eventType,
														oldValue,
														newValue);
				this.listener.serialEvent(e);
			}
		}
	}
	
	/**
	 * lCeBuCxgҋ@AnotifyEventĂяo
	 */
	native void waitAndNotifyNativeEvents(int handle);
	
	/**
	 * ̓Xg[
	 */
	class WCESerialPortInputStream extends InputStream {
		public int read() throws IOException {
			return nativeRead(handle);
		}
		
		public int read(byte[] b, int off,int len) throws IOException {
			return nativeRead(handle, b, off, len);
		}
		
		public int available() throws IOException {
			return availableBytes(handle);
		}
	}
	
	/**
	 * o̓Xg[
	 */
	class WCESerialPortOutputStream extends OutputStream {
		public void write(int b) throws IOException {
			nativeWrite(handle, b);
		}
		
		public void write(byte[] b, int off, int len) throws IOException {
			nativeWrite(handle, b, off, len);
		}
	}
}
