<?php
/*----------------------------------------------------------------------------*/
/* 定数定義                                                                   */
/*----------------------------------------------------------------------------*/
/** DIRECTORY_SEPARATOR のエイリアス */
define('DS',			DIRECTORY_SEPARATOR);
/** PATH_SEPARATOR のエイリアス */
define('PS',			PATH_SEPARATOR);
/** コンテキストルートのパス */
define('CONTEXT_ROOT',	dirname(__FILE__) . DS);
/** プログラムルートのパス */
define('MY_ROOT',		str_replace(DS . 'context_root', '', CONTEXT_ROOT));
/** ソースファイルディレクトリのパス */
define('SRC_DIR',		MY_ROOT . 'src' . DS);
/** 実行ファイルディレクトリのパス */
define('BIN_DIR',		MY_ROOT . 'bin' . DS);
/** コンフィグファイルディレクトリのパス */
define('CONFIG_DIR',	MY_ROOT . 'config' . DS);
/** エンジンルートのパス */
define('CORE_ROOT',		str_replace(DS . 'my' . DS, DS . 'core' . DS, MY_ROOT));
/** ライブラリファイルディレクトリのパス */
define('LIB_DIR',		CORE_ROOT . 'lib' . DS);
/** 親クラスファイルディレクトリのパス */
define('CLASS_DIR',	CORE_ROOT . 'class' . DS);
/** Smartyファイルディレクトリのパス */
define('SMARTY_DIR',	CORE_ROOT . 'smarty' . DS);
/** エンジンセッティングファイルディレクトリのパス */
define('SETTING_DIR',	CORE_ROOT . 'setting' . DS);
/** ベースURL */
$BASE_URL = str_replace('/my/context_root', '', dirname($_SERVER['PHP_SELF']));
define('BASE_URL',		$BASE_URL);


/*----------------------------------------------------------------------------*/
/* インクルード                                                               */
/*----------------------------------------------------------------------------*/
// セッティングファイルをすべてインクルードする
$dir = @opendir(SETTING_DIR);
if ($dir !== false) {
	while ($file = readdir($dir)) {
		if (!is_dir($file)) {
			include_once(SETTING_DIR . $file);
		}
	}
}
@closedir($dir);

// コンフィグファイルをすべてインクルードする
$dir = @opendir(CONFIG_DIR);
if ($dir !== false) {
	while ($file = readdir($dir)) {
		if (!is_dir($file)) {
			include_once(CONFIG_DIR . $file);
		}
	}
}
@closedir($dir);


/*----------------------------------------------------------------------------*/
/* リクエスト                                                                 */
/*----------------------------------------------------------------------------*/
// ライブラリファイルをすべてリクエストする
$dir = @opendir(LIB_DIR);
if ($dir !== false) {
	while ($file = readdir($dir)) {
		if (!is_dir($file)) {
			require_once(LIB_DIR . $file);
		}
	}
}
@closedir($dir);

// クラスファイルをすべてリクエストする
$dir = @opendir(CLASS_DIR);
if ($dir !== false) {
	while ($file = readdir($dir)) {
		if (!is_dir($file)) {
			require_once(CLASS_DIR . $file);
		}
	}
}
@closedir($dir);

// モデルファイルをすべてリクエストする
$dir = @opendir(SRC_DIR . 'model' . DS);
if ($dir !== false) {
	while ($file = readdir($dir)) {
		if (!is_dir($file)) {
			require_once(SRC_DIR . 'model' . DS . $file);
		}
	}
}
@closedir($dir);


/*----------------------------------------------------------------------------*/
/* 処理の実行                                                                 */
/*----------------------------------------------------------------------------*/
// パスの取得
$path = isset($_GET['__URL__']) ? $_GET['__URL__'] : '';
$path = split('/', $path);

// 階層、コントローラ、アクションの定義
$division = $config['boot']['startup_division'];
$controller = $config['boot']['startup_controller'];
$action = $config['boot']['startup_action'];

// １個の場合
if (count($path) == 1) {
	if (strlen($path[0]) > 0) {
		$action = $path[0];
	}
}
// ２個の場合
if (count($path) == 2) {
	if (strlen($path[0]) > 0) {
		$controller = $path[0];
	}
	if (strlen($path[1]) > 0) {
		$action = $path[1];
	}
}
// ３個以上の場合
if (count($path) >= 3) {
	if (strlen($path[count($path) - 2]) > 0) {
		$controller = $path[count($path) - 2];
	}
	if (strlen($path[count($path) - 1]) > 0) {
		$action = $path[count($path) - 1];
	}
	unset($path[count($path) - 1]);
	unset($path[count($path) - 1]);
	$division = join(DS, $path) . DS;
}

// ロガーの作成
$logger = new MyLogger($config['log']);
// 開始ログの出力
$logger->info("コントローラ：{$controller}のアクション：{$action}が開始されました。");

// クラスとテンプレートのファイル場所を取得
$execDir = SRC_DIR . 'vc' . DS . $division . $controller;
$phpPath = $execDir . DS . 'c_' . $controller . '.php';
$tplFile = 'v_' . $action . '.tpl';

// クラスの生成と実行
require_once($phpPath);
$instance = new $controller($config);
if ($instance->init($config) !== false) {
	$instance->setTplDir($execDir);
	$instance->setTplFile($tplFile);
	if ($instance->$action() !== false) {
		// テンプレートログ
		$logger->info("テンプレートが適用されました。");
		$instance->show();
	}
}

// 終了ログの出力
$logger->info("コントローラ：{$controller}のアクション：{$action}が終了されました。");