<?php
/**
 * データベース接続のコンフィグ配列です。
 * 複数のデータベース接続を記述することができます。
 * 記述されているものにはすべて接続を試みるので注意が必要です。
 * 共通の「$_dbs」変数に配列で格納されます。
 * ただし、「default」としたものについては「$_db」でアクセス可能です。
 *
 * 各パラメータの説明
 *  dbhost：接続先のホスト名を指定します。
 *  dbport：接続先のポート番号を指定します。
 *  dbname：接続先のデータベース名を指定します。
 *  dbuser：ログインユーザを指定します。
 *  dbpass：ログインユーザのパスワードを指定します。(AES暗号化済み)
 *  encode：データベースのエンコードをMySQLの認識できる形で指定します。
 */
$config['db'] = array(
	'default'	=> array(
		'dbhost'	=> 'localhost',
		'dbport'	=> 3306,
		'dbname'	=> 'dbname',
		'dbuser'	=> 'dbuser',
		'dbpass'	=> 'dbpass',
		'encode'	=> 'utf8',
	),
//	'secondary'	=> array(
//		'dbhost'	=> 'database_host_name',
//		'dbport'	=> 3306,
//		'dbname'	=> 'database_name',
//		'dbuser'	=> 'database_user_name',
//		'dbpass'	=> 'database_user_password',
//		'encode'	=> 'mysql_encode_name',
//	),
);
?>