<?php
/**
 * セッション管理クラスです。
 */
class SessionManager
{
	/**
	 * コンストラクタです。セッションを開始します。
	 */
	public function __construct()
	{
		@session_start();
	}

	/**
	 * 指定したキーのセッション値を取得します。
	 * 存在しない場合にはnull値を返します。
	 * @param		(string)$key		キー
	 * @return		(string)			セッション値
	 */
	public function get($key)
	{
		$ret = null;
		if (!StringCommon::isNullOrEmpty($_SESSION[$key])) {
			$ret = Crypter::decrypt($_SESSION[$key]);
		}
		return $ret;
	}

	/**
	 * 指定したキーにセッション値を保存します。
	 * @param		(string)$key		キー
	 * @param		(string$value		セッション値
	 */
	public function set($key, $value)
	{
		$_SESSION[$key] = Crypter::encrypt($value);
	}

	/**
	 * 保存されているセッションを全てクリアします。
	 */
	public function allClear()
	{
		foreach ($_SESSION as $key => $value) {
			unset($_SESSION[$key]);
		}
	}
}