<?php
/**
 * 暗号化/復号化を行うための静的クラスです。
 */
class Crypter
{
	/**
	 * 指定した文字列をAESアルゴリズムで暗号化します。
	 * @param		(string)$str		対象文字列
	 * @return		(string)			暗号化文字列
	 */
	public static function encrypt($str)
	{
		// サイズとIVを取得する
		$size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($size, MCRYPT_RAND);

		// 暗号化する
		$encrypted = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, SECURITY_KEY, $str, MCRYPT_MODE_ECB, $iv);
		$hex = bin2hex($encrypted);

		// 値を返す
		return trim($hex);
	}

	/**
	 * 指定した文字列をAESアルゴリズムで復号化します。
	 * @param		(string)$hex		対象文字列
	 * @return		(string)			復号化文字列
	 */
	public static function decrypt($hex)
	{
		// サイズとIVを取得する
		$size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);
		$iv = mcrypt_create_iv($size, MCRYPT_RAND);

		// 復号化する
		$bin = @pack('H*', $hex);
		$str = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, SECURITY_KEY, $bin, MCRYPT_MODE_ECB, $iv);

		// 値を返す
		return trim($str);
	}

	/**
	 * ゼロパディングをPKCS5パディングに変更します。
	 * @param		(string)$str		対象文字列
	 * @param		(int)$size			ブロックサイズ
	 * @return		(string)			PKCS5パディング文字列
	 */
	private static function pkcs5_pad($str, $size)
	{
		$pad = $size - (strlen($str) % $size);
		return $str . str_repeat(chr($pad), $pad);
	}

	/**
	 * PKCS5パディングを解除します。
	 * @param		(string)$str		対象文字列
	 * @return		(string)			解除後文字列
	 */
	private static function pkcs5_unpad($str)
	{
		$pad = ord($str{strlen($str)-1});
		if ($pad > strlen($str)) return false;
		if (strspn($str, chr($pad), strlen($str) - $pad) != $pad) return false;
		return substr($str, 0, -1 * $pad);
	}
}