<?php
/**
 * GETやPOSTのパラメータをTPLエンコードからPHPエンコードに変換します。
 */
class ParamTransrator
{
	/** 環境的なコンフィグ */
	private $_envConf = null;

	/**
	 * コンフィグの内容をインスタンスに保存します。
	 * @param		(assoc)$envConf		環境的なコンフィグ配列
	 */
	public function __construct($envConf)
	{
		$this->_envConf = $envConf;
	}

	/**
	 * 変換処理を実行します。
	 * @param		(mixed)$param		GET/POSTパラメータ
	 * @return		(mixed)				変換後のGET/POSTパラメータ
	 */
	public function transrate($param)
	{
		$this->_transrate($param);
		return $param;
	}

	private function _transrate(&$param)
	{
		if (is_array($param))
		{
			foreach ($param as $key => $value) {
				$this->_transrate($param[$key]);
			}
		}
		else {
			$param = mb_convert_encoding($param, $this->_envConf['php_encode'], $this->_envConf['tpl_encode']);
		}
	}
}