<?php
class MySqlWrapper
{
	/** リンクID */
	private $_con;

	/** コンフィグ */
	private $_config = null;

	/** ロガー */
	private $_logger = null;

	/** 接続中かどうか */
	private $_isConnected = false;

	/** エラーメッセージ */
	private $_errorMessage = '';

	/**
	 * コンストラクタです。DBへの接続を試みます。
	 */
	public function __construct($config, $key)
	{
		$this->_config = $config;
		$this->_logger = new MyLogger($config['log']);
		$this->connect($this->_config['db'][$key]);
	}

	/**
	 * データベースへの接続を試みます。
	 * 明示的に実行しなくてもコンストラクタで実行されます。
	 * @param		(assoc)$dbConfig	データベースコンフィグ
	 * @return		(bool)				接続可否
	 */
	public function connect($dbConfig)
	{
		// DBへの接続
		$this->_con = @mysql_connect($dbConfig['dbhost'], $dbConfig['dbuser'], Crypter::decrypt($dbConfig['dbpass']));
		if ($this->_con === false) {
			$this->_logger->error('データベースへの接続に失敗しました。host:' . $dbConfig['dbhost'] . " user:" . $dbConfi['dbuser']);
			return false;
		}
		// DBの選択
		$this->_isConnected = @mysql_select_db($dbConfig['dbname'], $this->_con);
		if ($this->isConnected() === false) {
			$this->_logger->error("データベースの選択に失敗しました。scheme:" . $dbConfig['dbname']);
			return false;
		}
		// エンコードの選択
		$this->_isConnected = $this->execControlSql('SET NAMES ' . $dbConfig['encode']);
		if ($this->isConnected() === false) {
			$this->_logger->error("データベースエンコードの指定に失敗しました。encode:" . $dbConfig['encode'], $this->getErrorMessage());
			return false;
		}
		// トランザクションの有効化
		$this->_isConnected = $this->execControlSql('SET AUTOCOMMIT=0');
		if ($this->isConnected() === false) {
			$this->_logger->error("トランザクションの初期化に失敗しました。" . $this->getErrorMessage());
			return false;
		}
		// 現在の接続状態を返す
		return $this->isConnected();
	}

	/**
	 * データベースに接続されているかを取得します。
	 * @return		(bool)				接続可否
	 */
	public function isConnected()
	{
		return $this->_isConnected;
	}

	/**
	 * エラーメッセージを取得します。
	 * @return		(string)			エラーメッセージ
	 */
	public function getErrorMessage()
	{
		return $this->_errorMessage;
	}

	/**
	 * バインド変数付きのSQLにパラメータバインドします。
	 * @param		(string)$sql		バインド変数付きのSQL
	 * @param		(assoc)$param		バインドパラメータ
	 * @return		(string)			バインド後SQL
	 */
	private function prepareStatement($sql, $params)
	{
		// パラメータでループ
		foreach ($params as $key => $value) {
			// 暗号化
			if (strpos($key, 'encrypt_') === 0) {
				$value = Crypter::encrypt($value);
			}
			// バインド値をエスケープ
			$value = mb_convert_encoding($value, $this->_config['env']['db_encode'], $this->_config['env']['php_encode']);
			$value = mysql_real_escape_string($value, $this->_con);
			// 引用符
			$value = "'" . $value . "'";
			// キーに該当するバインド変数を変換
			$sql = str_replace(":{$key}", "{$value}", $sql);
		}
		// バインド後の値を返す
		return $sql;
	}

	/**
	 * 参照系のSQLを実行してその結果を連想配列の配列で返します。
	 * 何らかのエラーが発生した場合には<b>FALSE</b>を返します。
	 * $singleをtrueにした場合には先頭行を連想配列として返します。
	 * @param		(string)$sql		参照系SQL
	 * @param		(assoc)$params		パラメータ
	 * @param		(bool)$single		単一列を連想配列で取得
	 * @return		(array/assoc/bool)	結果配列
	 */
	public function execSelectSql($sql, $params = null, $single = false)
	{
		// 戻り値
		$ret = array();

		// パラメータのバインド
		if (is_array($params)) {
			$sql = $this->prepareStatement($sql, $params);
		}

		// SQLの実行
		$this->_logger->debug("参照系SQLを実行しました。" . PHP_EOL . $sql);
		$res = @mysql_query($sql, $this->_con);

		// 失敗
		if ($res === false) {
			// エラーメッセージを設定してfalseを返す
			$this->_errorMessage = mysql_error($this->_con);
			$this->_logger->error($this->getErrorMessage());
			return false;
		}
		// 成功
		else {
			// 単一結果を返す場合
			if ($single) {
				$ret = mysql_fetch_assoc($res);
				if ($ret !== false) {
					foreach ($ret as $key => $value)
					{
						if (strpos($key, 'decrypt_') === 0) {
							$kk = str_replace('decrypt_', '', $key);
							$ret[$kk] = Crypter::decrypt($value);
							unset($ret[$key]);
						}
					}
				}
			}
			// それ以外の場合
			else {
				// 結果のループ
				while ($row = mysql_fetch_assoc($res)) {
					foreach ($row as $key => $value) {
						if (strpos($key, 'decrypt_') === 0) {
							$kk = str_replace('decrypt_', '', $key);
							$row[$kk] = Crypter::decrypt($value);
							unset($row[$key]);
						}
					}
					$ret[] = $row;
				}
			}
			// 結果をクリア
			@mysql_free_result($res);
			// エラーメッセージをクリア
			$this->_errorMessage = '';
			// 結果を返す
			return $ret;
		}
	}

	/**
	 * 更新系のSQLを実行して影響件数を返します。
	 * 何らかのエラーが発生した場合には<b>FALSE</b>を返します。
	 * @param		(string)$sql		更新系SQL
	 * @param		(assoc)$params		パラメータ
	 * @return		(int/bool)			影響件数
	 */
	public function execUpdateSql($sql, $params = null)
	{
		// 戻り値
		$ret = 0;

		// パラメータのバインド
		if (is_array($params)) {
			$sql = $this->prepareStatement($sql, $params);
		}

		// SQLの実行
		$this->_logger->debug("更新系SQLを実行しました。" . PHP_EOL . $sql);
		$res = @mysql_query($sql);

		// 失敗
		if ($res === false) {
			// エラーメッセージを設定してfalseを返す
			$this->_errorMessage = mysql_error($this->_con);
			$this->_logger->error($this->getErrorMessage());
			return false;
		}
		// 成功
		else {
			// 件数の取得
			$ret = mysql_affected_rows($this->_con);
			// 結果をクリア
			@mysql_free_result($res);
			// エラーメッセージをクリア
			$this->_errorMessage = '';
			// 結果を返す
			return $ret;
		}
	}

	/**
	 * 制御系のSQLを実行ます。
	 * 何らかのエラーが発生した場合には<b>FALSE</b>を返します。
	 * @param		(string)$sql		制御系SQL
	 * @return		(bool)				実行成否
	 */
	public function execControlSql($sql)
	{
		// SQLの実行
		$this->_logger->debug("制御系SQLを実行しました。" . PHP_EOL . $sql);
		$res = @mysql_query($sql);

		// 失敗
		if ($res === false) {
			// エラーメッセージを設定してfalseを返す
			$this->_errorMessage = mysql_error($this->_con);
			$this->_logger->error($this->getErrorMessage());
			return false;
		}
		// 成功
		else {
			// 件数の取得
			$ret = mysql_affected_rows($this->_con);
			// 結果をクリア
			@mysql_free_result($res);
			// エラーメッセージをクリア
			$this->_errorMessage = '';
			// 結果を返す
			return true;
		}
	}

	/**
	 * トランザクションのコミットを実行します。
	 * @return		(bool)				実行成否
	 */
	public function commit()
	{
		return $this->execControlSql('commit');
	}

	/**
	 * トランザクションのロールバックを実行します。
	 * @return		(bool)				実行成否
	 */
	public function rollback()
	{
		return $this->execControlSql('rollback');
	}
}