<?php
class MyLogger
{
	/** ログコンフィグ */
	private $_logConfig = null;
	/** エラーログ出力フラグ */
	private $_outputErrorLog = false;
	/** インフォログ出力フラグ */
	private $_outputInfoLog = false;
	/** デバッグログ出力フラグ */
	private $_outputDebugLog = false;

	/**
	 * コンストラクタです。
	 * コンフィグをインスタンスに格納します。
	 * @param $logConfig
	 */
	public function __construct($logConfig)
	{
		// コンフィグを格納
		$this->_logConfig = $logConfig;
		// エラーログ出力フラグ
		if (substr($logConfig['log_level'], 0, 1) == "1") {
			$this->_outputErrorLog = true;
		}
		// インフォログ出力フラグ
		if (substr($logConfig['log_level'], 1, 1) == "1") {
			$this->_outputInfoLog = true;
		}
		// デバッグログ出力フラグ
		if (substr($logConfig['log_level'], 2, 1) == "1") {
			$this->_outputDebugLog = true;
		}
	}

	/**
	 * ログを出力します。
	 * @param		(int)$level			ログレベル
	 * @param		(string)$msg		メッセージ
	 */
	private function out($level, $msg)
	{
		// ファイルを開く
		$fp = @fopen($this->_logConfig['output_path'] . '.' . date('Ymd'), 'a');
		if ($fp !== false) {
			$out = $this->_logConfig['log_format'];
			$out = str_replace('[date]', date('Y/m/d H:i:s'), $out);
			$out = str_replace('[level]', $level, $out);
			$out = str_replace('[message]', $msg . PHP_EOL, $out);
			@fwrite($fp, $out);
			@fclose($fp);
		}
	}

	/**
	 * エラーレベルのログを出力します。
	 * @param		(string)$msg		メッセージ
	 */
	public function error($msg)
	{
		if ($this->_outputErrorLog) {
			$this->out('[ERROR]', $msg);
		}
	}

	/**
	 * インフォレベルのログを出力します。
	 * @param		(string)$msg		メッセージ
	 */
	public function info($msg)
	{
		if ($this->_outputInfoLog) {
			$this->out('[INFO]', $msg);
		}
	}

	/**
	 * デバッグレベルのログを出力します。
	 * @param		(string)$msg		メッセージ
	 */
	public function debug($msg)
	{
		if ($this->_outputDebugLog) {
			$this->out('[DEBUG]', $msg);
		}
	}
}