<?php
	require("../__common__/__define_mobile.php");
	require("__define.php");
	$login_id = mobile_login_check();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<?php
	mobile_common_head('myHome チャット');
?>
<script src="../js/jquery.tmpl.min.js"></script>
<style>
.custom-thumb {
	margin:10px;
}
.custom-opacity {
	opacity: 0.8;
}
.ui-li-has-thumb .ui-btn-inner {
	padding-left: 70px;
}
#chat_view_table {
	border-collapse: collapse;
	width: 100%;
	margin: 5px 0;
}
#chat_view_table td {
	vertical-align: top;
	border-style: solid;
	border-color: #c0c0c0;
	border-width: 1px 0 1px 0;
	background-color: #fafafa;
}
td.chat_view_image {
	width: 55px;
	padding: 5px 5px 5px 10px;
}
td.chat_view_handle {
	font-size: 90%;
	font-weight: bold;
	color: #404040;
	border-width: 1px 0 0 0 !important;
	padding: 5px 5px 2px 0;
}
td.chat_view_message {
	font-size: 84%;
	color: #404040;
	border-width: 0 0 1px 0 !important;
	padding: 2px 5px 5px 5px;
}
td.chat_view_time {
	font-size: 74%;
	text-align: right;
	width: 80px;
	color: #404040;
	border-width: 1px 0 0 0 !important;
	padding: 5px 5px 2px 5px;
}

</style>
</head>
<body>
<div data-role="page" data-url="<?= $_SERVER['REQUEST_URI'] ?>" id="timeline">
	<div data-role="header">
		<a href="../index" data-icon="home" rel="external">Home</a>
		<h1>チャット</h1>
		<a href="../index" data-icon="home" data-iconpos="notext" data-direction="reverse" class="ui-btn-right jqm-home">Home</a>
	</div>
	<div data-role="content">
		<ul data-role="listview" id="list" class="ui-li-has-thumb">
		</ul>
	</div>
	<div data-role="footer" data-position="fixed" class="custom-opacity" data-id="chatnew-menu">
		<div data-role="navbar">
			<ul>
				<li><a href="post.php" data-rel="dialog" data-theme="b" data-transition="pop" data-icon="plus" data-iconpos="top" rel="external">投稿</a></li>
				<li><a href="#" data-theme="b" data-icon="refresh" data-iconpos="top" id="chatnew-refresh">更新</a></li>
			</ul>
		</div>
	</div>
</div>
<script>
(function($){
	var URL = "read.php";
	function chatnew(callback) {
		$("#list").empty();
		$.ajax({
			type: "GET",
			url: "read.php",
			async: false,
			success: function(data){
				$('#list').html(data);
			}
		})
	}
	function chatnewByForm(callback) {
		chatnew( callback );
	}
	$("#chatnew-refresh").bind("click", function(){
		$("#list").empty();
		$.ajax({
			type: "GET",
			url: "read.php",
			async: false,
			success: function(data){
				$('#list').html(data);
			}
		})
	});
	chatnewByForm();
})(jQuery);
</script>
</body>
</html>
