<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	require("../db_tool/__define_csv-import.php");
	// 実運用定義ファイルでMeCabのインストールパスを"MECAB_EXE_PATH"で定義してください。
	// 例：	define("MECAB_EXE_PATH", "C:\Program Files\MeCab\bin\mecab.exe");
	if (!defined("MECAB_MEMORY_LIMIT_INI_SET")) {
		define("MECAB_MEMORY_LIMIT_INI_SET", "128M");			// CSV インポート メモリサイズ
	}
	if (!defined("MECAB_MAX_EXECUTION_TIME_INI_SET")) {
		define("MECAB_MAX_EXECUTION_TIME_INI_SET", "1800");		// CSV インポート 最大実行時間
	}
	ini_set("memory_limit", MECAB_MEMORY_LIMIT_INI_SET);			//メモリサイズ
	ini_set("max_execution_time", MECAB_MAX_EXECUTION_TIME_INI_SET);	//最大実行時間
	if (isset($_POST['download'])) {
		header('Content-Type: text/tab-separated-values');
		header('Content-Disposition: attachment; filename="mecab_yomi.csv"');
		echo myfile_ENCODE(form_str_filepath($_POST['csvdata']));
		exit;
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20120406">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/db_tools.css?20091018" type="text/css">
<title>MeCab：漢字読み変換 (CSVファイル一括)</title>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">MeCab：漢字読み変換 (CSVファイル一括)</span>
</p>
<?php
	if (!defined("MECAB_EXE_PATH") || MECAB_EXE_PATH == '') {
		echo '<br><br>MeCabのインストールパスが設定されていません。';
		exit;
	}
?>
<form method="POST" action="" enctype="multipart/form-data">
<p style="color: #9d974b">
※ デリミッタ(区切り文字)はカンマ(&nbsp;,&nbsp;)、文字列の囲みはダブルクォーテーション(")のみサポート。<br>
※ 文字コードは、Shift-JIS、UTF-8、EUCなど自動判別します。
</p>
<table>
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" name="filename" size=40 style="button-font-size:small">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
	</td>
</tr>
</table>
</form>
<?php
if ($_POST) {
	if (($csv_file = post_check('filename')) == True) {
		if (!($csv_file_name = csv_upload($csv_file))) {
			error_exit('csvファイルにデータがありません。');
		}
		if (($csv_file = post_check('filename')) == CSV_FILE_EXIST) {
			$import_cnt = mecab_get_yomi($csv_file_name);
		}
	}
}
?>
<br>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function csv_upload($csv_file) {
	if ($csv_file == CSV_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", CSV_IMPORT_FOLDER, CSV_FILE_NAME);
		$readFile = CSV_IMPORT_FOLDER.$attachFile;
	} else {
		$readFile = CSV_IMPORT_FOLDER.CSV_FILE_NAME;
	}
	if (list_table($readFile)) {
		return $readFile;
	} else {
		return false;
	}
}
function list_table($readFile) {
	$numRows = 0;
	if (!($contents = file_get_contents($readFile))) return false;
	file_put_contents($readFile, mb_convert_kana(mb_convert_encoding($contents, 'UTF-8', MB_CONVERT_ENCODING_AUTO),'a'));
		// UTF-8に変換： fgetcsvはShift-JISでは正常処理できない
		// 全角英数字を半角英数字に変換する： fgetcsvは全角英数字を正常処理できない
	$handle = fopen($readFile, 'r');
	while (($data = fgetcsv($handle)) !== FALSE) {
		$numCols = count($data);
		$numRows++;
	}
	fclose($handle);
	if ($numRows < 2 || $numCols < 1) return False;
	if ($numRows > 6) {
		$viewRows = 6;
	} else {
		$viewRows = $numRows;
	}
?>
<p>レコード件数：<span class="mp_rowcnt"><?= $numRows-1 ?></span>件
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: #808080">(先頭の<?= $viewRows-1 ?>件表示)</span></p>
<form method="POST" action="">
<table class="excel_table" cellspacing=1>
	<thead>
		<tr>
<?php
	$handle = fopen($readFile, 'r');
	if (($data = fgetcsv($handle)) !== FALSE) {
		for ($col = 0; $col < $numCols; $col++) {
?>
			<th>
			<label><input type="checkbox" name="C_<?= $col ?>" value="Y"<?php if ($_POST['C_'.$col] == 'Y') echo ' checked' ?>>
			<?= my_htmlspecialchars(mb_convert_encoding($data[$col],'UTF-8',MB_CONVERT_ENCODING_AUTO)) ?></label>
			</th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	}
	$row = 1;
	while (($data = fgetcsv($handle)) !== FALSE && $row < $viewRows) {
?>
		<tr>
<?php
		for ($col = 0; $col < $numCols; $col++) {
?>
			<td><?= my_htmlspecialchars(mb_convert_encoding($data[$col],'UTF-8',MB_CONVERT_ENCODING_AUTO)) ?></td>
<?php
		}
?>
		</tr>
<?php
		$row++;
	}
	fclose($handle);
?>
	</tbody>
</table>
<div style="margin: 10px 0 0 50px;">
※ 読み変換する列にチェックを入れてください。<br>
※ 処理時間はかなり遅いです。<br>
<input type="submit" name="get_yomi" value="漢字の読みを変換する">&nbsp;&nbsp;&nbsp;&nbsp;
<label><input type="checkbox" name="全角変換" value="YES" checked>半角カナを全角カナに変換する</label>
</div>
</form>
<?php
	return True;
}
function mecab_get_yomi($csv_file_name) {
?>
<table class="excel_table" cellspacing=1 style="margin: 8px 0;">
	<thead>
		<tr>
<?php
	$csvdata = '';
	$handle = fopen($csv_file_name, 'r');
	if (($data = fgetcsv($handle)) !== FALSE) {
		$numCols = count($data);
	}
	$col_chk = array();
	$col_chk_flg = false;
	for ($col = 0; $col < $numCols; $col++) {
		if ($csvdata <> '') {
			$csvdata .= ',';
		}
		$csvdata .= '"'.$data[$col].'"';
?>
			<th>
			<?= my_htmlspecialchars($data[$col]) ?>
			</th>
<?php
		if ($_POST['C_'.$col] == 'Y') {
			$col_chk[] = true;
			$csvdata .= ',"'.$data[$col].'_読み"';
			$col_chk_flg = true;
?>
			<th style="background-color:#23B9EF">
			<?= my_htmlspecialchars($data[$col].'_読み') ?>
			</th>
<?php
		} else {
			$col_chk[] = false;
		}
	}
	$csvdata .= "\n";
?>
		</tr>
	</thead>
<?php
	if (!$col_chk_flg) {
		echo '</table><br><br><span style="margin-left:50px;color:red;">読み変換する列にチェックがされていません。</span>';
		exit;
	}
?>
	<tbody>
<?php
	ob_implicit_flush();	// 自動フラッシュをオンにする。HTML出力をバッファリングしない
	$cnt = 0;
	while (($data = fgetcsv($handle)) !== FALSE) {
		if ($cnt < 5) {
			$html = '<tr>';
		}
		for ($col = 0; $col < $numCols; $col++) {
			if ($col <> 0) {
				$csvdata .= ',';
			}
			$csvdata .= '"'.$data[$col].'"';
			if ($cnt < 5) {
				$html .= '<td>'.my_htmlspecialchars($data[$col]).'</td>';
			}
			if ($col_chk[$col]) {
				if ($data[$col] <> '') {
					$cmd = 'echo ' . myfile_ENCODE($data[$col]) .' | "' . MECAB_EXE_PATH . '" -Oyomi';
					$ret = shell_exec($cmd);
					$yomi_data = myfile_DECODE(str_replace("\n",'',$ret));
				} else {
					$yomi_data = '';
				}
				$csvdata .= ',"'.$yomi_data.'"';
				if ($cnt < 5) {
					$html .= '<td>'.my_htmlspecialchars($yomi_data).'</td>';
				}
			}
		}
		if ($cnt < 5) {
			echo $html.'</tr>';
		} else {
			echo '+';
		}
		if ($cnt == 4) {
?>
			</tbody>
		</table>
		変換処理中です。
<?php
		}
		++$cnt;
		if (intval($cnt/100)*100 == $cnt) {
			echo '<br><span class="mp_rowcnt">'.$cnt.'</span>件終了。&nbsp;';
		}
		$csvdata .= "\n";
	}
	fclose($handle);
?>
<?php
	if ($cnt < 5) {
?>
		</tbody>
	</table>
<?php
	}
?>
	<br>変換終了しました。(<span class="mp_rowcnt"><?= $cnt ?></span>件)<br>
	<form method="POST" action="">
		<textarea name="csvdata" style="width:560px;" rows="5"><?= $csvdata ?></textarea><br>
		<input type="submit" name="download" value="CSVファイル・ダウンロード(Shift-JIS)">
	</form>
<?php
}
function post_check($filename) {
	if ($_POST['upload']) {
		if (strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.csv' or strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.txt') {
			return CSV_FILE_UPLOAD;
		} else {
			error_exit('拡張子が.CSVではありません。');
			return false;
		}
	} elseif ($_POST['get_yomi']) {
		if (file_exists(CSV_IMPORT_FOLDER.CSV_FILE_NAME)) {
			return CSV_FILE_EXIST;
		} else {
			return false;
		}
	}
}
?>
