<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("__define_excel-graph.php");
	my_session_start();
	require("../account/__logincheck.php");
	require("__include-common-excel-graph.php");

	if ($_COOKIE['excel_graph_width'].'' == '') {
		$_COOKIE['excel_graph_width'] = GRAPH_WIDTH;
	}
?>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER_COMMON ?>/common.css?201200406" type="text/css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools-excel-graph.css?20110622" type="text/css">
<title>Excel to グラフ by Bluff</title>
<!--
■ Spreadsheet_Excel_Reader
	http://sourceforge.net/projects/phpexcelreader/
		http://www.ilovex.co.jp/Division/SRD/archives/2007/08/phpexcel_2.html
		http://q.hatena.ne.jp/1207023049
■ グラフ作成ライブラリ: Bluff
	http://bluff.jcoglan.com/
		http://bizcaz.com/archives/2008/09/22-220643.php
■ IEでCanvasを利用するためのライブラリ:ExplorerCanvas
	http://excanvas.sourceforge.net/
		http://d.hatena.ne.jp/unageanu/20070921/1190377760
-->
<script type="text/javascript" src="scripts/Bluff/js-class.js"></script>
<script type="text/javascript" src="scripts/Bluff/bluff-min.js"></script>
<!--[if IE]><script type="text/javascript" src="scripts/excanvas/excanvas-compressed.js"></script><![endif]-->
<script language="javascript" src="scripts/cookie.js" type="text/javascript"></script>
<script type="text/javascript">
function graphBluff(g_type, g_width, g_theme) {
	// キャンバス要素からコンテキストを取得
	var canvas = document.getElementById('graph_canvas');		// キャンバス要素
	var ctx = canvas.getContext('2d');				// 引数を'2d'として、2次元描画用のコンテキストを得る

	// グラフ種類
	// var g = new Bluff.Line('graph_canvas', 350);
	// var g = new Bluff.Bar('graph_canvas', 350);
	// ----- オブジェクト名に変数を使う方法 -----
	var graphObj = eval('Bluff.' + g_type);
	var g = new graphObj('graph_canvas', eval(g_width));		// canvas ID, 横幅

	// ビルトイン・テーマ選択(オプション)
	// g.theme_keynote();
	// g.theme_37signals();
	// g.theme_rails_keynote();
	// g.theme_pastel();
	// g.theme_odeo();
	// g.theme_greyscale();
	// ----- プロパティに変数を使う方法 -----
	g[g_theme]();

	// 読込むテーブルIDセット(必須)
	g.data_from_table('data_table');				// table ID

	// デザイン(オプション)
	g.set_theme({
		marker_color: '#95949a',				/* 横のラインの色 */
		font_color: '#330033'					/* フォントの色 */
	});

	// 最後に描画(必須)
	g.draw();
}
function onLoad() {
	g_type = loadCookie("excel_graph_type");
	g_width = loadCookie("excel_graph_width");
	g_theme = loadCookie("excel_graph_theme");
	if (g_type == "") {g_type = "Bar"};
	if (g_width == "") {g_width = <?= GRAPH_WIDTH ?>};
	if (g_theme == "") {g_theme = "theme_pastel"};
	saveCookie("excel_graph_type", g_type);
	saveCookie("excel_graph_width", g_width);
	saveCookie("excel_graph_theme", g_theme);
	graphBluff(g_type, g_width, g_theme);
}
function graphType(g_type) {
	saveCookie("excel_graph_type", g_type);
	graphBluff(g_type, loadCookie("excel_graph_width"), loadCookie("excel_graph_theme"));
}
function graphWidth(g_width) {
	saveCookie("excel_graph_width", g_width);
	graphBluff(loadCookie("excel_graph_type"), g_width, loadCookie("excel_graph_theme"));
}
function graphTheme(g_theme) {
	saveCookie("excel_graph_theme", g_theme);
	graphBluff(loadCookie("excel_graph_type"), loadCookie("excel_graph_width"), g_theme);
}
</script>
</head>
<?php	if (($excel_file = post_check('filename')) == True) { ?>
<body onload="onLoad()">
<?php	} else { ?>
<body>
<?php	} ?>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>" enctype="multipart/form-data">
<table id="form_table">
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" size=40 name="filename" style="button-font-size:small">
		<span id="current_title" style="margin-left:16px">by Bluff</span>
		<a href="excel-graph-html5.php" style="margin-left:16px">by HTML5</a>
		<a href="excel-graph-google.php" style="margin-left:16px">by Google</a>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
		<input type="submit" name="clear" value="クリア">
		<input type="submit" name="redraw" value="再描画">
	</td>
</tr>
<tr>
	<td align=right>グラフ横幅：</td>
	<td>
		<select name="zoomsize" onChange="graphWidth(this.options[this.selectedIndex].value);">
		<?php 	for ($val=300; $val<=800; $val+=50) { ?>
			<option value="<?= $val ?>"<?= $val==$_COOKIE['excel_graph_width'] ? ' selected' : '' ?>><?= $val ?></option>
		<?php	} ?>
		</select>
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="button" value="縦棒" onClick="graphType('Bar')">
		<input type="button" value="縦棒（積）" onClick="graphType('StackedBar')">
		<input type="button" value="横棒" onClick="graphType('SideBar')">
		<input type="button" value="横棒（積）" onClick="graphType('SideStackedBar')">
		<input type="button" value="　線　" onClick="graphType('Line')">
		<input type="button" value="線（塗り）" onClick="graphType('Area')">
		<input type="button" value="線（塗り）（積）" onClick="graphType('StackedArea')">
		<input type="button" value="円（1列目）" onClick="graphType('Pie')">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="button" value="pastel" onClick="graphTheme('theme_pastel')">
		<input type="button" value="keynote" onClick="graphTheme('theme_keynote')">
		<input type="button" value="37signals" onClick="graphTheme('theme_37signals')">
		<input type="button" value="rails_keynote" onClick="graphTheme('theme_rails_keynote')">
		<input type="button" value="odeo" onClick="graphTheme('theme_odeo')">
		<input type="button" value="greyscale" onClick="graphTheme('theme_greyscale')">
	</td>
</tr>
</table>
</form>
<?php
	if ($excel_file) {
		post_done_proc($excel_file);
	}
?>
<div id="footer">
<a href="http://bluff.jcoglan.com/" target="_blank" style="color:#b0b0ff;">Powered by Bluff</a><br />
<a href="http://sourceforge.net/projects/phpexcelreader" target="_blank" style="color:#b0b0ff;">Powered by Spreadsheet_Excel_Reader</a><br />
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function post_done_proc($excel_file) {
	if ($excel_file == EXCEL_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", ATTACH_FILE_FOLDER, EXCEL_FILE_NAME);
		$readFile = ATTACH_FILE_FOLDER.$attachFile;
	} else {
		$readFile = ATTACH_FILE_FOLDER.EXCEL_FILE_NAME;
	}
	require 'phpExcelReader/Excel/Reader.php';
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($readFile);

	if (!list_table($excel, $dMatrix, $xNums, $yNums, $xNames, $yNames, False)) {
		return;
	}
?>
	<br>
	<div class="canvas"><canvas id="graph_canvas"></canvas></div>
<?php
}
?>
