<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	require("../__common__/include-common-html.php");
	require("../account/__logincheck.php");
	if (!defined("HTML_TEXT_MULTI_TAG_MAX_NUMBER")) {
		define('HTML_TEXT_MULTI_TAG_MAX_NUMBER', 5);
	}
	if (!defined("HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBER")) {
		define('HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBER', 1);
		// ★ 実運用定義で、HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBERを2以上にする場合、
		// ★ 実運用定義ファイルに、以下の関数定義が必要。
		// function set_option_name()
		// function option_tag_set_2(),function option_tag_set_3()...
	}
	if (!function_exists('set_option_name')) {
		function set_option_name() {
			// ★ HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBER 数分 submitボタンのname,value文字を定義
			$option_name = array();
			$option_name[] = 'ゴガクル・タグ設定';	//	(1)
			// $option_name[] = '';			//	(2)
			return $option_name;
		}
	}
	$option_name = set_option_name();
	if (!function_exists('option_tag_set_1')) {
		// ★ これを変更する場合、実運用定義ファイルで、以下の関数を定義。
		function option_tag_set_1() {
			$_SESSION['html_text_url'] = $_POST['url'];
			$_SESSION['html_text_separator'] = $_POST['separator'];
			$_SESSION['html_text_addstr'] = $_POST['addstr'];
			$_SESSION['html_text_quote'] = $_POST['quote'];
			$top_tag = array();
			$top_tag[] = '<table width="580"';
			$top_tag[] = '</table>';
			$tags = array();
			$tags[] = array('<span lang="en" class="font-en">', '</span>');
			$tags[] = array('<dd class="jp">', '</dd>');
			tag_set($top_tag, $tags);
		}
	}
	if ($_POST) {
		if (isset($_POST['download'])) {
			file_download(form_str_filepath($_POST['title']), form_str_filepath($_POST['text']));
			exit;
		}
		$opt_called = false;
		for ($ix=1; $ix<=HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBER; $ix++) {
			if (isset($_POST[$option_name[$ix-1]])) {
				$opt_func = 'option_tag_set_'.$ix;
				$opt_func();
				$opt_called = true;
			}
		}
		if (!$opt_called) {
			if (isset($_POST['reset'])) {
				$_SESSION['html_text_separator'] = $_POST['separator'];
				$_SESSION['html_text_quote'] = $_POST['quote'];
				tag_reset();
				session_2_cookie();
			} else {
				$_SESSION['html_text_url'] = $_POST['url'];
				$_SESSION['html_text_separator'] = $_POST['separator'];
				$_SESSION['html_text_addstr'] = $_POST['addstr'];
				$_SESSION['html_text_quote'] = $_POST['quote'];
				$_SESSION['html_tag_top1'] = form_str_adjust($_POST['html_tag_top1']);
				$_SESSION['html_tag_top2'] = form_str_adjust($_POST['html_tag_top2']);
				for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
					for ($iy=1; $iy<=2; $iy++) {
						$_SESSION['html_tag_'.$ix.'_'.$iy] = form_str_adjust($_POST['html_tag_'.$ix.'_'.$iy]);
					}
				}
				session_2_cookie();
			}
		}
	} else {
		$_SESSION['html_text_url'] = $_COOKIE['html_text_url'];
		$_SESSION['html_text_separator'] = $_COOKIE['html_text_separator'];
		$_SESSION['html_text_addstr'] = $_COOKIE['html_text_addstr'];
		$_SESSION['html_text_quote'] = $_COOKIE['html_text_quote'];
		$_SESSION['html_tag_top1'] = form_str_filepath($_COOKIE['html_tag_top1']);
		$_SESSION['html_tag_top2'] = form_str_filepath($_COOKIE['html_tag_top2']);
		for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
			for ($iy=1; $iy<=2; $iy++) {
				$_SESSION['html_tag_'.$ix.'_'.$iy] = form_str_filepath($_COOKIE['html_tag_'.$ix.'_'.$iy]);
			}
		}
	}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
<title>HTML テキスト抽出 複数一括</title>
<style type="text/css">
body {
	background-color: #ffffff;
	margin: 10px;
	padding: 0px;
}
#title{
	font-size: 120%;
	font-weight: bold;
}
</style>
<script language="JavaScript">
function textareaBigSmall(obj, bigSmall, min) {
	if (bigSmall == "大") {
		document.getElementById(obj).rows = document.getElementById(obj).rows + 10;
	} else {
		if (document.getElementById(obj).rows > min) {
			document.getElementById(obj).rows = document.getElementById(obj).rows - 10;
		}
	}
}
</script>
</head>
<body>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">HTML テキスト抽出 複数一括 (タグ指定)</span>
</p>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
	URL：<br>
	<div class="block_left">
	<textarea id="url" name="url" style="width:560px;" rows="8"><?= $_SESSION['html_text_url'] ?></textarea><br>
	</div>
	<div class="block_left">
		<input type="button" value="小" OnClick="textareaBigSmall('url','小', 5)"><br>
		<input type="button" value="大" OnClick="textareaBigSmall('url','大', 5)">
	</div>
	<div style="clear: both; color:#8b4513; margin-left:5px;">
	抽出親タグ：<input class="text" type="text" name="html_tag_top1" size=40 value="<?= my_htmlspecialchars($_SESSION['html_tag_top1']) ?>">～
	<input class="text" type="text" name="html_tag_top2" size=10 value="<?= my_htmlspecialchars($_SESSION['html_tag_top2']) ?>">
	例： &lt;table id="foo"～&lt;/table&gt;<br>
	<?php	for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) { ?>
	抽出タグ(<?= $ix ?>)：<input class="text" type="text" name="html_tag_<?= $ix ?>_1" size=40 value="<?= my_htmlspecialchars($_SESSION['html_tag_'.$ix.'_1']) ?>">～
	<input class="text" type="text" name="html_tag_<?= $ix ?>_2" size=10 value="<?= my_htmlspecialchars($_SESSION['html_tag_'.$ix.'_2']) ?>">
	例： &lt;td class="foo"～&lt;/td&gt;<br>
	<?php	} ?>
	データ・セパレータ：<input class="text" type="text" name="separator" size=5 value="<?= $_SESSION['html_text_separator'] ?>">
	テーブル行先頭挿入：<input class="text" type="text" name="addstr" size=16 value="<?= $_SESSION['html_text_addstr'] ?>">
	<label><input type="checkbox" name="quote" value="Y"<? if ($_SESSION['html_text_quote'] == 'Y' ) echo ' checked' ?>>文字列を"で囲む</label><br>
	<input type="submit" name="gethtml" value="テキスト抽出">
	<input type="submit" name="reset" value="リセット">
<?php	for ($ix=1; $ix<=HTML_TEXT_MULTI_OPTION_SET_FUNCTION_NUMBER; $ix++) { ?>
	<input type="submit" name="<?= $option_name[$ix-1] ?>" value="<?= $option_name[$ix-1] ?>">
<?php	} ?>
	</div>
<?php
	if (isset($_POST['gethtml']) and $_POST['url'] <> '') {
		if (left($_POST['url'],7) <> 'http://') {
			error_exit('http://以外は取得できません。');
		}
		if (HTTP_PROXY_HOST.'' <> '') {
			$proxy = array(
				'http' => array(
					'proxy' => 'tcp://'.HTTP_PROXY_HOST.':'.HTTP_PROXY_PORT,
					'request_fulluri' => true,
				),
			);
			$proxy_context = stream_context_create($proxy);
		} else {
			$proxy_context = NULL;
		}
		$urlary = explode("\n", str_replace(' ','',$_POST['url']));
		$html = '';
		$title = '';
		if ($_SESSION['html_tag_top1'] <> '') {
			$table1 = $_SESSION['html_tag_top1'];
		} else {
			$table1 = '<table';
		}
		if ($_SESSION['html_tag_top2'] <> '') {
			$table2 = $_SESSION['html_tag_top2'];
		} else {
			$table2 = '</table>';
		}
		for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
			if ($_SESSION['html_tag_'.$ix.'_1'] <> '' && $_SESSION['html_tag_'.$ix.'_2'] <> '') {
			}
		}
		$tag1 = array();
		$tag2 = array();
		$tag_cnt = 0;
		for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
			if ($_SESSION['html_tag_'.$ix.'_1'] <> '' and $_SESSION['html_tag_'.$ix.'_2'] <> '') {
				$tag1[] = $_SESSION['html_tag_'.$ix.'_1'];
				$tag2[] = $_SESSION['html_tag_'.$ix.'_2'];
				++$tag_cnt;
			}
		}
		foreach ($urlary as $url_1) {
			if ($url_1 <> '') {
				$html_1 = get_html(trim($url_1), $proxy_context);
				if ($html_1) {
					if ($title == '') {
						$title = get_intag($html_1,'<title>','</title>',$pos=0);
					}
					$pos = 0;
					while (($elem = get_intag_span($html_1, $table1, $table2, $pos)) <> '') {
						$pp = 0;
						$intag = '';
						for ($ix=0; $ix<$tag_cnt; $ix++) {
							if (left($tag1[$ix],1) == '<') {
								$func = 'get_intag_span';
							} else {
								$func = 'get_intag';
							}
							if ($intag <> '') {
								$intag .= $_SESSION['html_text_separator'];
							}
							if ($_SESSION['html_text_quote'] == 'Y') {
								$intag .= '"';
							}
							if (($data = $func($elem, $tag1[$ix], $tag2[$ix], $pp)) <> '') {
							$intag .= $data;
							}
							if ($_SESSION['html_text_quote'] == 'Y') {
								$intag .= '"';
							}
						}
						if ($_SESSION['html_text_addstr'] <> '') {
							$html .= $_SESSION['html_text_addstr'].$_SESSION['html_text_separator'];
						}
						$html .= $intag.'<br>';
					}
				}
			}
		}
		if ($html) {
			view_textarea($title, my_strip_tags($html), $url);
		} else {
			error_exit('取得できませんでした。');
		}
	} elseif (isset($_POST['sendmail']) and $_POST['text'] <> '') {
		$_SESSION['html_text_url'] = $_POST['url'];
		$_SESSION['html_text_separator'] = $_POST['separator'];
		$_SESSION['html_text_addstr'] = $_POST['addstr'];
		$_SESSION['html_text_quote'] = $_POST['quote'];
		$title = form_str_filepath(mb_convert_kana($_POST['title'], 'KV', 'UTF-8'));
		$text = form_str_filepath(mb_convert_kana($_POST['text'], 'KV', 'UTF-8'));
		view_textarea($title, $text, $url);
		post_sendmail($title, $text);
	}
?>
</form>
<div id="footer" style="margin: 10px 0 0 0;">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function view_textarea($title, $text, $url='') {
	$line = substr_count($text, chr(10));
?>
	件名/CSVファイル名：<input class="text" type="text" name="title" value="<?= my_htmlspecialchars($title) ?>" size="70">
	抽出：<span style="color:red;font-weight:bold;"><?= $line ?></span> 件<br>
	<div class="block_left">
		<textarea id="text" name="text" style="width:560px;" rows="10"><?= $text ?></textarea>
	</div>
	<div class="block_left">
		<input type="button" value="小" OnClick="textareaBigSmall('text','小', 15)"><br>
		<input type="button" value="大" OnClick="textareaBigSmall('text','大', 15)">
	</div>
	<a name="end"></a>
	<div style="clear: both; ">
	<p>
		<input type="submit" name="sendmail" value="メール送信">
		<input type="submit" name="download" value="CSVファイル・ダウンロード(Shift-JIS)">
	</p>
	</div>
<?php
}
function my_strip_tags($str) {
	if ($_SESSION['html_text_addstr'] <> '') {
		$str = str_ireplace('<tr', '__addstr__<tr', $str);
	}
	$str = str_ireplace('<br>', '--(br)--', $str);
	$str = str_ireplace('</td>', ' ', $str);
	$str = str_ireplace('</th>', ' ', $str);
	$str = str_ireplace('</li>', '--(br)--', $str);
	$str = str_ireplace('</p>', '--(br)--', $str);
	$str = str_ireplace('</div>', '--(br)--', $str);
	$str = str_ireplace('</tr>', '--(br)--', $str);
	$str = preg_replace('@<script[^>]*?>.*?</script>@si', '', $str);	// javascriptを削除
	$str = preg_replace('@<style[^>]*?>.*?</style>@si', '', $str);		// styleを削除
	$str = preg_replace("/\s\s+/", ' ', $str);				// 連続したスペースをスペースに
	$str = str_ireplace("\n", '', $str);					// 改行を除去
	$str = strip_tags($str);
	$search = array ('@&(quot|#34);@i',
			 '@&(amp|#38);@i',
			 '@&(lt|#60);@i',
			 '@&(gt|#62);@i',
			 '@&(nbsp|#160);@i',
			 '@&(iexcl|#161);@i',
			 '@&(cent|#162);@i',
			 '@&(pound|#163);@i',
			 '@&(copy|#169);@i');
	$replace = array ('"',
			  '&',
			  '<',
			  '>',
			  ' ',
			  chr(161),
			  chr(162),
			  chr(163),
			  chr(169));
	$str = preg_replace($search, $replace, $str);
	$str = preg_replace('/\s\s+/', ' ', $str);
	$str = str_ireplace('--(br)--', "\n", $str);
	$str = str_ireplace("\n ", chr(10), $str);
	$str = str_ireplace(" \n", chr(10), $str);
	$str = preg_replace("/\n\n+/", chr(10), $str);				// 連続した改行を1個に
	$str = str_replace('__addstr__ ', '__addstr__', $str);
	$str = str_replace(', ', ',', $str);
	if ($_SESSION['html_text_addstr'] <> '') {
		$str = str_replace('__addstr__', $_SESSION['html_text_addstr'], $str);
	}
	$str = str_replace(",\n", "\n", $str);
	return $str;
}
function post_sendmail($subject, $body) {
	$con = my_mysql_connect(_DB_ACCOUNT_SCHEMA);
	$sql = "SELECT * FROM m_account WHERE id_account = '" . $_SESSION['login_id'] . "' and c_delete = 0";
	$rs_account = my_mysql_query($sql);
	$row = mysql_num_rows($rs_account);
	if ($row == 0) {
		error_exit('アカウントがみつかりません。');
	}
	$rec_account = mysql_fetch_array($rs_account);
	if (($to = $rec_account['c_email_calendar']) == '') {
		error_exit('電子メールアドレスが登録されていません。');
	}
	$con = mysql_close($con);
	$header_from = _SENDMAIL_EMAIL_NAME . ' <'._SENDMAIL_EMAIL_ADDR.'>';
	$ret = my_send_mail(_SENDMAIL_EMAIL_ADDR, $header_from, $to, $subject, $body, _SENDMAIL_HOST, _SENDMAIL_PORT, _SENDMAIL_AUTH_USE, _SENDMAIL_EMAIL_USER, _SENDMAIL_EMAIL_PASS);
	if ($ret) {
		echo '<p class="noramal_msg">メール送信しました。</p>';
	} else {
		error_exit('<p>メール送信でエラーが発生しました。</p>');
	}
}
function file_download($subject, $body) {
	header('Content-Type: text/tab-separated-values');
	header('Content-Disposition: attachment; filename="'.urlencode($subject) .'.csv"');
	echo myfile_ENCODE($body);
}
function get_html($url, $proxy_context) {
	$html = @file_get_contents($url, false, $proxy_context);
	if ($html) {
		return mb_convert_encoding($html, 'UTF-8', MB_CONVERT_ENCODING_AUTO);
	} else {
		return '';
	}
}
function tag_set($top_tag, $tags) {
	$_SESSION['html_tag_top1'] = $top_tag[0];
	$_SESSION['html_tag_top2'] = $top_tag[1];
	$ix = 0;
	foreach ($tags as $tag) {
		$ix++;
		$_SESSION['html_tag_'.$ix.'_1'] = $tag[0];
		$_SESSION['html_tag_'.$ix.'_2'] = $tag[1];
	}
}
function tag_reset() {
	$_SESSION['html_text_url'] = '';
	$_SESSION['html_text_addstr'] = '';
	$_SESSION['html_tag_top1'] = '';
	$_SESSION['html_tag_top2'] = '';
	for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
		$_SESSION['html_tag_'.$ix.'_1'] = '';
		$_SESSION['html_tag_'.$ix.'_2'] = '';
	}
}
function session_2_cookie() {
	setcookie("html_text_url", $_SESSION['html_text_url'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie("html_text_separator", $_SESSION['html_text_separator'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie("html_text_addstr", $_SESSION['html_text_addstr'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie("html_text_quote", $_SESSION['html_text_quote'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie('html_tag_top1', $_SESSION['html_tag_top1'], time() + LOGIN_COOKIE_EXPIRE, "/");
	setcookie('html_tag_top2', $_SESSION['html_tag_top2'], time() + LOGIN_COOKIE_EXPIRE, "/");
	for ($ix=1; $ix<=HTML_TEXT_MULTI_TAG_MAX_NUMBER; $ix++) {
		setcookie('html_tag_'.$ix.'_1', $_SESSION['html_tag_'.$ix.'_1'], time() + LOGIN_COOKIE_EXPIRE, "/");
		setcookie('html_tag_'.$ix.'_2', $_SESSION['html_tag_'.$ix.'_2'], time() + LOGIN_COOKIE_EXPIRE, "/");
	}
}
?>
