<?php
function calendar_month($year, $month, $current_id, $category, $keystring, $class='calendar_tbl', $calendar_mode='') {
	if ($calendar_mode == '') {
		 $calendar_mode = $_SESSION['calendar_mode'];
	}
	$time = mktime(0, 0, 0, $month, 1, $year);	// 1日
	$last_day = date("t", $time);
	$day = 1 - date("w", $time);			// 先頭日  date("w",$time):曜日取得(0...6)
	echo "<table class='".$class."'>";
	echo "<caption>";
	if ($class == "calendar_tbl_mini") {
		if (CALENDAR_DIARY_MODE == 'diary') {
			$month_php = 'month.php';
		} else {
			$month_php = '../calendar/month.php';
		}
		echo "<span class='calendar_caption_ym_mini'><p><a href='".$month_php."?y=".$year."&m=".$month;
		echo "&uid=".$current_id."'>";
		echo $year."年".$month."月"."</a></p></span>";
	} else {
		echo "<span class='calendar_caption_ym'>".$year."年".$month."月"."</span>";
	}
	if ($class == "calendar_tbl") {
		$prev_year_m = $month;
		$prev_year_y = $year - 1;
		$next_year_m = $month;
		$next_year_y = $year + 1;
		if ($month == 1) {
			$prev_month_m = 12;
			$prev_month_y = $year - 1;
			$next_month_m = $month + 1;
			$next_month_y = $year;
		} elseif ($month == 12) {
			$prev_month_m = $month - 1;
			$prev_month_y = $year;
			$next_month_m = 1;
			$next_month_y = $year + 1;
		} else {
			$prev_month_m = $month - 1;
			$prev_month_y = $year;
			$next_month_m = $month + 1;
			$next_month_y = $year;
		}
?>
<span id="calendar_ymd_change">
<ul>
<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= date('Y') ?>&m=<?= date('n') ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">今月</a></li>
<li><a class="calendar_move_year" href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $prev_year_y ?>&m=<?= $prev_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">&lt;&lt;前年</a></li>
<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $prev_month_y ?>&m=<?= $prev_month_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">←前月</a></li>
<li><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $next_month_y ?>&m=<?= $next_month_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">→次月</a></li>
<li><a class="calendar_move_year" href="<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?= $next_year_y ?>&m=<?= $next_year_m ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>">&gt;&gt;次年</a></li>
</ul>
</span>
<span id="calendar_ymd_select">
	<script language="JavaScript">
	<!--
	function SelectionYear(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?y=" + escape(sel.options[i].value) + "&m=<?= $month ?>&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>";
			}
		}
	}
	function SelectionMonth(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?y=<?=$year ?>&m=" + escape(sel.options[i].value) + "&cat=<?= $category ?>&key=<?= urlencode($keystring) ?>";
			}
		}
	}
	//-->
	</script>
	<select name="ChangeYear" onChange="SelectionYear(this.form, this)">
	<?php
		$endYY = date("Y") + 10;
		for ($yy = _CALENDAR_SELECT_FIRST_YEAR; $yy <= $endYY; $yy++) {
	?>
	<option value="<?= $yy ?>"<?= $yy == $year ? ' selected' : '' ?>><?= $yy ?>
	<?php
		}
	?>
	</select>年
	<select name="ChangeMonth" onChange="SelectionMonth(this.form, this)">
	<?php
		$endYY = date("Y") + 10;
		for ($mm = 1; $mm <= 12; $mm++) {
	?>
	<option value="<?= $mm ?>"<?= $mm == $month ? ' selected' : '' ?>><?= $mm ?>
	<?php
		}
	?>
	</select>月
</span>
<?php
	echo "<br /><br style='font-size: 10px;' />";
	}
	echo "</caption>";
	echo "<tr class='calendar_head'>";
	for ($x=0; $x<=6; $x++) {
		if ($x == 0) {
			$day_class = "head_sunday";
		} elseif ($x == 6) {
			$day_class = "head_saturday";
		} else {
			$day_class = "head_weekday";
		}
		echo "<th class='".$day_class."'>".mb_substr("日月火水木金土", $x, 1)."</th>";
	}
	echo "</tr>";
	$sch_days = schedule_check_month($year, $month, $current_id, $category, $keystring);
	for ($y=0; $y<=6; $y++) {
		if ($class == "calendar_tbl_mini") {
			echo "<tr class='calendar_body_mini'>";
		} else {
			echo "<tr class='calendar_body'>";
		}
		for ($x=0; $x<=6; $x++) {
			if ($x == 0) {
				$day_class = "day_sunday";
			} elseif ($x == 6) {
				$day_class = "day_saturday";
			} else {
				$day_class = "day_weekday";
			}
			day_view($year, $month, $day, $day_class, $current_id, $class, $category, $keystring, $sch_days, False, $calendar_mode);
			$day++;
		}
		echo "</tr>";
		if ($day > $last_day) {
			break;
		}
	}
	echo "</table>";
	return;
}
function calendar_week($year, $month, $day, $account_id, $handle, $keystring) {
	$time = mktime(0, 0, 0, $month, $day, $year);
	$day = $day - date("w", $time);			// 先頭日  date("w",$time):曜日取得(0...6)
	echo "<tr>";
	echo "<td class='calendar_tbl_week_handle'>".$handle."</td>";
	if (check_permit_id($_SESSION['login_id'], $account_id) == "") {
		echo "<td colspan=7>アクセス権なし</td>";
		echo "</tr>";
		return;
	}
	$sch_days = schedule_check_month($year, $month, $account_id, '', $keystring);
	for ($x=0; $x<=6; $x++) {
		if ($x == 0) {
			$day_class = "day_sunday";
		} elseif ($x == 6) {
			$day_class = "day_saturday";
		} else {
			$day_class = "day_weekday";
		}
		day_view($year, $month, $day, $day_class, $account_id, $class, '', $keystring, $sch_days, "week", "schedule");
		$day++;
	}
	echo "</tr>";
	return;
}
function calendar_week_header() {
	echo "<tr>";
	echo "<th class='calendar_tbl_week_handle'><br></th>";
	for ($x=0; $x<=6; $x++) {
		if ($x == 0) {
			$day_class = "head_sunday";
		} elseif ($x == 6) {
			$day_class = "head_saturday";
		} else {
			$day_class = "head_weekday";
		}
		echo "<th class='".$day_class."'>".mb_substr("日月火水木金土", $x, 1)."</th>";
	}
	echo "</tr>";
}
function day_view($year, $month, $day, $day_class, $current_id, $class, $category, $keystring, $sch_days, $week_mode=False, $calendar_mode='') {
	$holiday = holiday_check($year, $month, $day);
	if ($holiday) {
		$day_class = "day_holiday";
	}
	if (date("Y-m-d", mktime(0, 0, 0, $month, $day, $year)) == date("Y-m-d")) {
		if ($class == "calendar_tbl_mini") {
			$day_class .= " day_today_mini";
		} else {
			$day_class .= " day_today";
		}
	}
	if ($class == "calendar_tbl_mini") {
		$view_day = date('j', mktime(0, 0, 0, $month, $day, $year));
		if ($day == $view_day) {
			if ($calendar_mode == 'album') {
				if (($photo_path = photo_album_check($year, $month, $day, $current_id)) <> '') {
					if ($day_class <> "day_today" && $day_class <> "day_today_mini") {
						$day_class = $day_class." day_schedule_on";
					}
				}
				echo "<td class='".$day_class."'>";
				echo "<a href='../photo/?uid=".$current_id."&path=".urlencode($photo_path)."'>".$view_day."</a>";
				echo "</td>";
			} else {
				//if (schedule_check_OLD($year, $month, $day, $current_id, $category, $keystring) <> 0) {
				if ($sch_days[$day]) {
					if ($day_class <> "day_today" && $day_class <> "day_today_mini") {
						$day_class = $day_class." day_schedule_on";
					}
				}
				$view_day = date('j', mktime(0, 0, 0, $month, $day, $year));
				$view_month = date('n', mktime(0, 0, 0, $month, $day, $year));
				$view_year = date('Y', mktime(0, 0, 0, $month, $day, $year));
				if ($_SESSION['calendar_weather_mode'] == 'wh' and (right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php' or right($_SERVER['SCRIPT_NAME'],17) == 'calendar/year.php')) {
					$bg_class = weather_ratio_class($_SESSION['calendar_ken'], $month, $day);
				} elseif ($_SESSION['calendar_weather_mode'] == 'tmp' and (right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php' or right($_SERVER['SCRIPT_NAME'],17) == 'calendar/year.php')) {
					$bg_class = weather_temp_class($_SESSION['calendar_ken'], $month, $day);
				} else {
					$bg_class ='';
				}
				echo "<td class='".$day_class.' '.$bg_class."'>";
				if (CALENDAR_DIARY_MODE == 'diary') {
					if ($sch_days[$day]) {
						echo "<a href='view.php?year=".$year."&month=".$month."&day=".$day."&ret=".$_SERVER['SCRIPT_NAME']."'>".$view_day."</a>";
					} else {
						echo "<a href='input.php?uid=".$current_id."&y=".$year."&m=".$month."&d=".$day."&ret=".$_SERVER['SCRIPT_NAME']."'>".$view_day."</a>";
					}
				} elseif (($_SESSION['calendar_weather_mode'] == 'wh' or $_SESSION['calendar_weather_mode'] == 'tmp') and (right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php' or right($_SERVER['SCRIPT_NAME'],17) == 'calendar/year.php')) {
					echo "<a href='../calendar/weather-map.php?wh=".$_SESSION['calendar_weather_mode']."&m=".$view_month."&d=".$view_day."'>".$view_day."</a>";
				} else {
					echo "<a href='../calendar/list.php?uid=".$current_id."&selY=".$view_year."&selM=".$view_month."&selD=".$view_day."&sort=date_a'>".$view_day."</a>";
				}
				echo "</td>";
			}
		} else {
			if (($_SESSION['calendar_weather_mode'] == 'wh' or $_SESSION['calendar_weather_mode'] == 'tmp') and strstr($_SERVER['SCRIPT_NAME'], 'calendar')) {
				echo "<td><br>";
			} else {
				echo "<td class='".$day_class."'><br>";
			}
			echo "</td>";
		}
	} else {
		$view_day = date('j', mktime(0, 0, 0, $month, $day, $year));
		$view_month = date('n', mktime(0, 0, 0, $month, $day, $year));
		$view_year = date('Y', mktime(0, 0, 0, $month, $day, $year));
		if ($day == $view_day || $week_mode) {
			$view_day_class = 'calendar_day';
			$view_holiday_name = 'holiday_name';
		} else {
			$view_day_class = 'calendar_day_other_month';
			$view_holiday_name = 'other_month_holiday_name';
			if ($day_class == 'day_weekday') {
				$day_class = 'day_other_month';
			}
		}
		echo "<td class='".$day_class."'>";
		if (CALENDAR_DIARY_MODE == 'diary') {
			echo "<p><a href='input.php?uid=".$current_id."&y=".$view_year."&m=".$view_month."&d=".$view_day."&ret=month.php' class='".$view_day_class."'>".$view_day."</a>";
		} else {
			echo "<p><a href='../calendar/input.php?uid=".$current_id."&y=".$view_year."&m=".$view_month."&d=".$view_day."' class='".$view_day_class."'>".$view_day."</a>";
?>
&nbsp;<a href='javascript:popup_schedule("<?= $current_id ?>", "<?= $view_year ?>", "<?= $view_month ?>", "<?= $view_day ?>")' class='popup_sch_link'>↑</a>
<?php
		}
		echo "<span class='".$view_holiday_name."'>".$holiday."</span>";
		if ($_SESSION['calendar_weather_mode'] == 'wh' and right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php') {
			echo "</p>";
			weather_ratio_print($_SESSION['calendar_ken'], $view_month, $view_day);
			echo "<p>";
		} elseif ($_SESSION['calendar_weather_mode'] == 'tmp' and right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php') {
			echo "</p>";
			weather_temp_print($_SESSION['calendar_ken'], $view_month, $view_day);
			echo "<p>";
		}
		if (($photo_path = photo_album_check($year, $month, $day, $current_id)) <> '') {
			echo "<span class='popup'><a href='../photo/?path=".urlencode($photo_path)."'>";
			if ($calendar_mode == 'album') {
				$imgfile = get_album_photo_imgfile($photo_path);
					//$imgsrc = '../scripts/php/img-size-change.php?img='.urlencode($imgfile).
					//			'&size='.ALBUM_PHOTO_SIZE_POP;
				$imgsrc = '../photo/img-view.php?img='.urlencode($imgfile);
				echo "<img src='".$imgsrc."' width=".ALBUM_PHOTO_SIZE_POP." class='pop_up bicubic' border=0>";
				echo "<img src='".$imgsrc."' width=".ALBUM_PHOTO_SIZE." class='bicubic' border=0>";
			} else {
				echo "<img src='../images/photo.gif' class='bicubic' border=0></a>";
			}
		}
		echo "</p>";
		if (CALENDAR_DIARY_MODE == 'diary') {
			diary_print($view_year, $view_month, $view_day, $current_id, $category, $keystring);
		} elseif ($_SESSION['schedule_detail'] == 'on') {
			schedule_print($view_year, $view_month, $view_day, $current_id, $category, $keystring, True, True);
		} else {
			schedule_print($view_year, $view_month, $view_day, $current_id, $category, $keystring);
		}
		echo "</td>";
	}
}
function diary_print($year, $month, $day, $current_id, $category, $keystring, $input_mode=True) {
	$datestr = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
	$sql = "select * from v_schedule where c_date = '".$datestr."' and c_delete = 0";
	if ($current_id != $_SESSION['login_id']) {
		$sql .= " and c_privacy = 0";
	}
	$sql .= " and id_account = '".$current_id."'";
	if ($category <> "") {
		$sql .= " and id_category = '".$category."'";
	}
	if ($keystring <> "") {
		$select_item = array();
		$select_item[] = "c_subject";
		if (CALENDAR_DIARY_MODE == 'diary') {
			$select_item[] = "c_memo";
		} else {
			$select_item[] = "c_memo_strip_tags";
		}
		if (count($select_item) > 0) {
			$sql .= ' and ( '.query_and_or($select_item, $keystring).' )';
		}
	}
	$rs = my_mysql_query_debug_print($sql);
	while ($rec = mysql_fetch_array($rs)) {
		$p_class = '';
		echo '<p class="'.$p_class.'">';
		if ($rec['c_time1']."" <> "" || $rec['c_time2']."" <> "") {
			echo '<span class="calendar_time">';
			echo sch_time_format($rec['c_time1'], $rec['c_time2'])."&nbsp;";
			echo '</span>';
		}
			$schedule_class = "schedule_input";
		if ($input_mode) {
			echo "<a href='view.php?id=".$rec['id_schedule']."&ret=month.php' class='" . $schedule_class ."'>";
		} else {
			echo "<span class='" . $schedule_class ."'>";
		}
		echo my_htmlspecialchars($rec['c_subject']);
		if ($input_mode) {
			echo "</a>";
		} else {
			echo "</span>";
		}
	}
}
function schedule_print($year, $month, $day, $current_id, $category, $keystring, $input_mode=True, $memo_mode=False, $img_dir_rep='', $img_dir='') {
	$datestr = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
	$sql = "select * from v_schedule where c_date = '".$datestr."' and c_delete = 0";
	if ($current_id != $_SESSION['login_id']) {
		$sql .= " and c_privacy = 0";
	}
	$sql .= " and id_account = '".$current_id."'";
	if ($category <> "") {
		$sql .= " and id_category = '".$category."'";
	}
	if ($keystring <> "") {
		$select_item = array();
		$select_item[] = "c_subject";
		if (CALENDAR_DIARY_MODE == 'diary') {
			$select_item[] = "c_memo";
		} else {
			$select_item[] = "c_memo_strip_tags";
		}
		if (count($select_item) > 0) {
			$sql .= ' and ( '.query_and_or($select_item, $keystring).' )';
		}
	}
	$sql .= " order by c_time1";
	$rs = my_mysql_query_debug_print($sql);
	while ($rec = mysql_fetch_array($rs)) {
		if ($rec['c_privacy'] == 444) {
			$p_class = 'calendar_privacy';
		} else {
			$p_class = '';
		}
		echo '<p class="'.$p_class.'">';
		if ($rec['c_time1']."" <> "" || $rec['c_time2']."" <> "") {
			echo '<span class="calendar_time">';
			echo sch_time_format($rec['c_time1'], $rec['c_time2'])."&nbsp;";
			echo '</span>';
		}
		if ($rec['c_iconImage'] <> "") {
			echo "<img src='".IMAGES_FOLDER."/".$rec['c_iconImage']."' class='bicubic' />";
		}
		if ($rec['c_categoryDisplayColor'] <> "") {
			$schedule_class = "color_".$rec['c_categoryDisplayColor'];
		} else {
			if ($rec['c_subject'] == '') {
				$schedule_class = "schedule_input_no_subject";
			} else {
				$schedule_class = "schedule_input";
			}
		}
		if ($input_mode) {
			if (CALENDAR_DIARY_MODE == 'diary') {
				echo "<a href='view.php?id=".$rec['id_schedule']."&ret=month.php' class='" . $schedule_class ."'>";
			} else {
				echo "<a href='../calendar/input.php?uid=".$current_id."&id=".$rec['id_schedule']."' class='" . $schedule_class ."'>";
			}
		} else {
			if ($rec['c_categoryDisplayColor'] <> '') {
				echo "<span style='color: ".$rec['c_categoryDisplayColor']."'>";
			} else {
				echo "<span class='" . $schedule_class ."'>";
			}
		}
		if ($rec['c_subject'] == '') {
			echo NO_SUBJECT_INPUT_MARK;
		} else {
			echo my_htmlspecialchars($rec['c_subject']);
		}
		if ($input_mode) {
			echo "</a>";
		} else {
			echo "</span>";
		}
		if ($rec['c_map'] == 1) {
			echo '&nbsp;<a href="http://maps.google.co.jp/maps?q='.urlencode($rec['c_subject']).'" target="_blank" class="map_href">→地図</a>&nbsp;<a href="http://maps.google.co.jp/maps?ie=UTF8&f=d&ttype=dep&dirflg=r&saddr='.urlencode($_SESSION['login_friends_home_address_'.$current_id]).'&daddr='.urlencode($rec['c_subject']).'" target="_blank" class="route_href">→経路</a>';
		}
		$filename1 = $rec['c_attachFile1'];
		$filename2 = $rec['c_attachFile2'];
		$filename3 = $rec['c_attachFile3'];
		if ($memo_mode || $rec['c_subject'] == '') {
			if ($rec['c_subject'] <> '') {
				?></p><?php
				if ($rec['c_privacy'] == 444) {
					$p_class = 'calendar_privacy';
				} else {
					$p_class = '';
				}
				if (!$input_mode) {
					$next_para_l = '<p class="memo_in_input '.$p_class.'">';
				} else {
					$next_para_l = '<p class="'.$p_class.'">';
				}
				$next_para_r = '</p>';
			} else {
				$next_para_l = '';
				$next_para_r = '';
			}
			?>
			<?php if (TEXTAREA_HTML_USE == "YES") { ?>
				<?php
					$memo = my_schedule_decorate($rec['c_memo'], $current_id);
					if ($img_dir_rep <> '') {
						$memo = str_ireplace($img_dir.'/', $img_dir_rep.'/', $memo);
					}
				?>
				<?= $next_para_l ?><?= ins_br_strip_script($memo) ?><?= $next_para_r ?>
			<?php } else { ?>
				<?= $next_para_l ?><?= ins_br(my_htmlspecialchars(icon_to_imgsrc($rec['c_memo']))) ?><?= $next_para_r ?>
			<?php } ?>
			<?php
				if ($filename1 <> "" || $filename2 <> "" || $filename3 <> "") {
			?>
					<?= $next_para_l ?>
			<?php
					attach_file_view($rec['id_account'], $filename1, "<br>", 100, True, $memo_mode);
					attach_file_view($rec['id_account'], $filename2, "<br>", 100, True, $memo_mode);
					attach_file_view($rec['id_account'], $filename3, "<br>", 100, True, $memo_mode);
			?>
					<?= $next_para_r ?>
			<?php
				}
		} else {
			if ($filename1 <> "" || $filename2 <> "" || $filename3 <> "") {
				attach_file_view($rec['id_account'], $filename1, "", 0, False, $memo_mode);
				attach_file_view($rec['id_account'], $filename2, "", 0, False, $memo_mode);
				attach_file_view($rec['id_account'], $filename3, "", 0, False, $memo_mode);
			}
			?>
			</p>
<?php
		}
	}
}
function photo_album_check($year, $month, $day, $current_id) {
	$album_calendar_folder = $_SESSION['login_friends_album_calendar_folder_'.$current_id];
	$path_SJIS = myfile_ENCODE($album_calendar_folder.'/'.$year);
	if ($dir = is_dir($path_SJIS)) {
		$datestr = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
		$path_SJIS = myfile_ENCODE($album_calendar_folder.'/'.$year.'/'.$datestr);
		foreach (glob($path_SJIS."*") as $filename) {
			if (is_dir($filename)) {
				return myfile_DECODE($filename);
			}
		}
	}
	return '';
}
function get_album_photo_imgfile($photo_path) {
	$path_SJIS = myfile_ENCODE($photo_path);
	if (is_dir($path_SJIS)) {
		$dir = opendir($path_SJIS);
		while (($file = readdir($dir)) !== false) {
			if ($file != "." && $file != "..") {
				if (!is_dir($path_SJIS."/".$file)) {
					return myfile_DECODE($path_SJIS ."/".$file);
				}
			}
		}
	}
	return '';
}
function schedule_check_month($year, $month, $current_id, $category, $keystring) {
	$from = date("Y-m-d", mktime(0, 0, 0, $month, 1, $year));
	$to = date("Y-m-d", mktime(0, 0, 0, $month+1, 1, $year));
	$sql = "select distinct day(c_date) as s_data from m_schedule";
	$sql .= " where c_date >= '".$from."' and c_date < '".$to."' and c_delete = 0";
	if ($current_id != $_SESSION['login_id']) {
		$sql .= " and c_privacy = 0";
	}
	$sql .= " and id_account = '".$current_id."'";
	if ($category <> "") {
		$sql .= " and id_category = '".$category."'";
	}
	if ($keystring <> "") {
		$select_item = array();
		$select_item[] = "c_subject";
		if (CALENDAR_DIARY_MODE == 'diary') {
			$select_item[] = "c_memo";
		} else {
			$select_item[] = "c_memo_strip_tags";
		}
		if (count($select_item) > 0) {
			$sql .= ' and ( '.query_and_or($select_item, $keystring).' )';
		}
	}
	$sch_days = array();
	$rs = my_mysql_query_debug_print($sql);
	while ($rec = mysql_fetch_array($rs)) {
		$sch_days[$rec['s_data']] = True;
	}
	return $sch_days;
}
function schedule_check_OLD($year, $month, $day, $current_id, $category, $keystring) {
	$datestr = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
	$sql = "select * from m_schedule where c_date = '".$datestr."' and c_delete = 0";
	if ($current_id != $_SESSION['login_id']) {
		$sql .= " and c_privacy = 0";
	}
	$sql .= " and id_account = '".$current_id."'";
	if ($category <> "") {
		$sql .= " and id_category = '".$category."'";
	}
	if ($keystring <> "") {
		$select_item = array();
		$select_item[] = "c_subject";
		if (CALENDAR_DIARY_MODE == 'diary') {
			$select_item[] = "c_memo";
		} else {
			$select_item[] = "c_memo_strip_tags";
		}
		if (count($select_item) > 0) {
			$sql .= ' and ( '.query_and_or($select_item, $keystring).' )';
		}
	}
	$rs = my_mysql_query_debug_print($sql);
	return (mysql_num_rows($rs));
}
function holiday_check($year, $month, $day) {
	$datestr = date("Y-m-d", mktime(0, 0, 0, $month, $day, $year));
	$sql = "select * from m_holiday where c_holidaydate = '".$datestr."'";
	$rs = my_mysql_query($sql);
	if ($rec = mysql_fetch_array($rs)) {
		return my_htmlspecialchars($rec['c_holidayname']);
	} else {
		return False;
	}
	return False;
}
function filter_category_select($category, $account_id, $http_arg) {
?>
	<script language="JavaScript">
	<!--
	function SelectionCategory(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?<?= query_from_http_arg_pool($http_arg, "cat") ?>&cat=" + escape(sel.options[i].value);
			}
		}
	}
	//-->
	</script>
	カテゴリ：<select name="Category" class="<? if ($category.'' <> '') echo 'mp_list_filter_true'; ?>" onChange="SelectionCategory(this.form, this)">
	<option value="__reset__" class="mp_list_filter_false">すべて
<?php
		$sqlsel = "select * from m_category where c_delete = 0";
		if ($account_id <> "ALL") {
			$sqlsel .= " and id_account = '".$account_id."'";
		}
		$sqlsel = $sqlsel . " order by c_categoryDisplayOrder";
		$rs_sel = my_mysql_query($sqlsel);
		while ($rec_sel=mysql_fetch_array($rs_sel)) {
?>
	<option value="<?= $rec_sel['id_category'] ?>"<?= $rec_sel['id_category'] == $category ? ' selected class="mp_list_filter_true"' : ' class="mp_list_filter_false"' ?>><?= $rec_sel['c_categoryName'] ?>
<?php
		}
?>
	</select>
	<script language="JavaScript">
	<!--
	function categoryReset() {
		window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?<?= query_from_http_arg_pool($http_arg, 'cat') ?>";
	}
	//-->
	</script>
	<input type="button" name="カテゴリリセット" value="リセット" onClick="categoryReset()">
<?php
}
function filter_key_select($keystring, $http_arg) {
	mp_list_filter_key_select($keystring, $http_arg);
}
function filter_mode_change($Detail=False) {
?>
	<script language="JavaScript">
	function SelectionOption(opt, form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&" + opt + "=" + escape(sel.options[i].value);
			}
		}
	}
	function CheckboxOnOff(opt, onOff) {
		if (onOff == 'on') {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&" + opt + "=off";
		} else {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&" + opt + "=on";
		}
	}
	</script>
	<select name="Mode" onChange="SelectionOption('mode', this.form, this)">
	<option value="sch"><?= CALENDAR_FILTER_TITLE ?>
	<option value="album"<?= $_SESSION['calendar_mode'] == 'album' ? ' selected' : '' ?>>アルバム
	</select>
	<?php
		if ($Detail) {
			if (CALENDAR_DIARY_MODE <> 'diary') {
				filter_detail_onoff();
			}
		}
	if (($_SESSION['calendar_mode'] <> 'album' or right($_SERVER['SCRIPT_NAME'],18) == 'calendar/month.php') and CALENDAR_DIARY_MODE <> 'diary'){
		filter_weather();
		filter_kenmei();
	}
}
function filter_weather() {
?>
	<script language="JavaScript">
	function SelectionWeatherOption(opt, form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&" + opt + "=" + escape(sel.options[i].value);
			}
		}
	}
	function CheckboxWeatherOnOff(opt, onOff) {
		if (onOff == '' || onOff == 'off') {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&wh=" + opt;
		} else if (opt == 'tmp' && onOff == 'wh') {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&wh=tmp";
		} else if (opt == 'wh' && onOff == 'tmp') {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&wh=wh";
		} else {
			window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&wh=off";
		}
	}
	</script>
	<label><input type="checkbox" onClick="CheckboxWeatherOnOff('wh','<?= $_SESSION['calendar_weather_mode'] ?>')"<?= $_SESSION['calendar_weather_mode'] == 'wh' ? ' checked' : '' ?>>天気出現率</label>
	<label><input type="checkbox" onClick="CheckboxWeatherOnOff('tmp','<?= $_SESSION['calendar_weather_mode'] ?>')"<?= $_SESSION['calendar_weather_mode'] == 'tmp' ? ' checked' : '' ?>></label>
	<select onChange="SelectionWeatherOption('tm', this.form, this)" style="margin-left:-3px">
		<option value="Max"<?= $_SESSION['calendar_temp_mode'] == 'Max' ? ' selected' : '' ?>>最高気温</option>
		<option value="Ave"<?= $_SESSION['calendar_temp_mode'] == 'Ave' ? ' selected' : '' ?>>平均気温</option>
		<option value="Min"<?= $_SESSION['calendar_temp_mode'] == 'Min' ? ' selected' : '' ?>>最低気温</option>
	</select>
<?php
}
function filter_kenmei() {
	$sqlsel = 'SELECT * FROM r_kenmei';
	$rs_sel = my_mysql_query($sqlsel);
	$optgroup = '';
?>
	<script language="JavaScript">
	function SelectionKenmei(form, sel) {
		for (i = 0; i < sel.options.length; i++) {
			if (sel.options[i].selected == true) {
				window.location.href = "<?= $_SERVER['SCRIPT_NAME'] ?>?cat=<?= $_GET['cat'] ?>&ken=" + escape(sel.options[i].value);
			}
		}
	}
	</script>
	<?php if (!strstr($_SERVER['SCRIPT_NAME'], "weather-graph")) { ?>
	<script language="JavaScript">
	jQuery(function(){
		jquery_cs_function = 'SelectionKenmeiCS';
		jquery_cs_arg = 'ken';
			jquery_cs_style = 'margin-left:-100px';
			<?php if (strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) { ?>
				jquery_cs_style = 'margin-left:-500px';
			<?php } else { ?>
				jquery_cs_style = 'margin-left:-400px';
			<?php } ?>
		$('#jquery_cs_ken select').cs();
	});
	function SelectionKenmeiCS(key, data) {
		window.location.href = "?"+key+"="+data+"&cat=<?= $_GET['cat'] ?>";
	}
	</script>
	<?php } ?>
<span id="jquery_cs_ken">
	都道府県：<select onChange="SelectionKenmei(this.form, this)">
<?php
	while ($rec_sel=mysql_fetch_array($rs_sel)) {
		if ($optgroup <> $rec_sel['c_area']) {
			if ($optgroup <> '') {
?>
	</optgroup>
<?php
			}
?>
	<optgroup label="<?= $rec_sel['c_area'] ?>">
<?php
		}
?>
	<option value="<?= $rec_sel['c_kenid'] ?>"<?= $rec_sel['c_kenid'] == $_SESSION['calendar_ken'] ? ' selected' : '' ?>><?= my_htmlspecialchars($rec_sel['c_kenmei']) ?></option>
<?php
		$optgroup = $rec_sel['c_area'];
	}
?>
		</optgroup>
	</select>
</span>
<?php
}
function filter_detail_onoff() {
?>
	<label><input type="checkbox" name="" value="on" onClick="CheckboxOnOff('dt','<?= $_SESSION['schedule_detail'] ?>')"<?= $_SESSION['schedule_detail'] == 'on' ? ' checked' : '' ?>>詳細</label>
<?php
}
function icon_to_imgsrc($str) {
	return str_replace('<icon ', '<img src='.IMAGES_FOLDER.'/', $str);
}
function my_schedule_decorate($str, $current_id) {
	if ($_SESSION['login_friends_home_address_'.$current_id].'' <> '') {
		$saddr = urlencode($_SESSION['login_friends_home_address_'.$current_id]);
		$str = preg_replace('/<m>(.*?)<\/m>/e', "'$1' . '&nbsp;<a href=\"http://maps.google.co.jp/maps?q=' . urlencode('$1') . '\" \" target=\"_blank\" class=\"map_href\">→地図</a>&nbsp;<a href=\"http://maps.google.co.jp/maps?ie=UTF8&f=d&ttype=dep&dirflg=r&saddr='.'$saddr'.'&daddr=' . urlencode('$1') . '\"\" target=\"_blank\" class=\"route_href\">→経路</a>&nbsp;'", $str);
	} else {
		$str = preg_replace('/<m>(.*?)<\/m>/e', "'$1' . '&nbsp;<a href=\"http://maps.google.co.jp/maps?q=' . urlencode('$1') . '\" \" target=\"_blank\" class=\"map_href\">→地図</a>&nbsp;'", $str);
	}
	return icon_to_imgsrc($str);
}
function my_schedule_decorate_preview($str) {
	$str = preg_replace('/<m>(.*?)<\/m>/e', "'<span style=\"color: #008000\">['.'$1'.']</span>'", $str);
	return icon_to_imgsrc($str);
}
