<?php
	require("../__common__/__define_common.php");
	require("../__common__/include-common-all.php");
	my_session_start();
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (FILE_MANAGER_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	if ($_GET['path'].'' == '') {
		exit;
	}
	$open_path = my_GET('path');
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<meta name="description" content="ファイルマネージャー,ファイルアップロード">
<title>ファイルマネージャー（ファイル・アップロード）</title>
<link rel="stylesheet" href="blueimp/js/bootstrap.min.css">
<link rel="stylesheet" href="blueimp/js/bootstrap-image-gallery.min.css">
<link rel="stylesheet" href="blueimp/jquery.fileupload-ui.css">
<style type="text/css">
.page-header {
    background-color: #f5f5f5;
    padding: 80px 20px 10px;
    margin: 0 -20px 20px;
    border: 1px solid #DDD;
    -webkit-border-radius: 0 0 6px 6px;
       -moz-border-radius: 0 0 6px 6px;
            border-radius: 0 0 6px 6px;
}
</style>
<!--[if lt IE 7]>
<style type="text/css">
.topbar {
    position: absolute;
}
.topbar ul, .topbar .container {
    padding-top: 10px;
}
.topbar li {
    display: inline;
    margin-right: 10px;
}
.topbar a:hover {
    color: #fff;
}
.span16 {
    display: inline;
    float: left;
    margin-left: 20px;
}
input {
    display: inline;
    width: auto;
}
/* The following is required for Modals to work on IE6 */
.modal {
    position: absolute;
    top: 50%;
    filter: none;
}
#gallery-modal.fullscreen {
    overflow: hidden;
}
</style>
<![endif]-->
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110622" type="text/css">
<style type="text/css" >
#folder_path {
	background-color: #B0E0E6;
	padding: 3px;
}
</style>
</head>
<body>
<p id="tool_title_area">
<a href="../tools/" class="return_index" style="font-size:20px;">■</a>
<span id="tool_title">ファイルマネージャー（ファイル・アップロード）</span>
<a href="file-manager.php?path=<?= urlencode($open_path) ?>" class="a_cancel_back">戻る</a>
</p>
<div id="swfupload-control">
	<p>アップロード先フォルダ：<span id="folder_path"><?= my_htmlspecialchars($open_path) ?></span></p>
	<p>複数ファイルを選択して一括アップロードが出来ます。デスクトップからファイルをドラッグ&ドロップできます。</p>
	<p style="color:red;">※ 同一ファイル名がある場合、上書きします。</p>
</div>
<div class="container">
    <form id="fileupload" action="file-upload-drag-do.php?path=<?= urlencode($open_path) ?>" method="POST" enctype="multipart/form-data">
        <div class="row">
            <div class="span16 fileupload-buttonbar">
                <div class="progressbar fileupload-progressbar"><div style="width:0%;"></div></div>
                <span class="btn success fileinput-button">
                    <span>Add files...</span>
                    <input type="file" name="files[]" multiple>
                </span>
                <button type="submit" class="btn primary start">Start upload</button>
                <button type="reset" class="btn info cancel">Cancel upload</button>
<!--
                <button type="button" class="btn danger delete">Delete selected</button>
                <input type="checkbox" class="toggle">
-->
            </div>
        </div>
        <br>
        <div class="row">
            <div class="span16">
                <table class="zebra-striped"><tbody class="files"></tbody></table>
            </div>
        </div>
    </form>
</div>
<!-- gallery-loader is the loading animation container -->
<div id="gallery-loader"></div>
<!-- gallery-modal is the modal dialog used for the image gallery -->
<div id="gallery-modal" class="modal hide fade">
    <div class="modal-header">
        <a href="#" class="close">&times;</a>
        <h3 class="title"></h3>
    </div>
    <div class="modal-body"></div>
    <div class="modal-footer">
        <a class="btn primary next">Next</a>
        <a class="btn info prev">Previous</a>
        <a class="btn success download" target="_blank">Download</a>
    </div>
</div>
<script>
var fileUploadErrors = {
    maxFileSize: 'File is too big',
    minFileSize: 'File is too small',
    acceptFileTypes: 'Filetype not allowed',
    maxNumberOfFiles: 'Max number of files exceeded',
    uploadedBytes: 'Uploaded bytes exceed file size',
    emptyResult: 'Empty file upload result'
};
</script>
<script id="template-upload" type="text/html">
{% for (var i=0, files=o.files, l=files.length, file=files[0]; i<l; file=files[++i]) { %}
    <tr class="template-upload fade">
        <td class="preview"><span class="fade"></span></td>
        <td class="name">{%=file.name%}</td>
        <td class="size">{%=o.formatFileSize(file.size)%}</td>
        {% if (file.error) { %}
            <td class="error" colspan="2"><span class="label important">Error</span> {%=fileUploadErrors[file.error] || file.error%}</td>
        {% } else if (o.files.valid && !i) { %}
            <td class="progress"><div class="progressbar"><div style="width:0%;"></div></div></td>
            <td class="start">{% if (!o.options.autoUpload) { %}<button class="btn primary">Start</button>{% } %}</td>
        {% } else { %}
            <td colspan="2"></td>
        {% } %}
        <td class="cancel">{% if (!i) { %}<button class="btn info">Cancel</button>{% } %}</td>
    </tr>
{% } %}
</script>
<script id="template-download" type="text/html">
{% for (var i=0, files=o.files, l=files.length, file=files[0]; i<l; file=files[++i]) { %}
    <tr class="template-download fade">
        {% if (file.error) { %}
            <td></td>
            <td class="name">{%=file.name%}</td>
            <td class="size">{%=o.formatFileSize(file.size)%}</td>
            <td class="error" colspan="2"><span class="label important">Error</span> {%=fileUploadErrors[file.error] || file.error%}</td>
        {% } else { %}
            <td class="preview">{% if (file.thumbnail_url) { %}
                <a href="{%=file.url%}" title="{%=file.name%}" rel="gallery"><img src="{%=file.thumbnail_url%}"></a>
            {% } %}</td>
            <td class="name">
                <a href="{%=file.url%}" title="{%=file.name%}" rel="{%=file.thumbnail_url&&'gallery'%}">{%=file.name%}</a>
            </td>
            <td class="size">{%=o.formatFileSize(file.size)%}</td>
            <td colspan="2"></td>
        {% } %}
<!--
        <td class="delete">
            <button class="btn danger" data-type="{%=file.delete_type%}" data-url="{%=file.delete_url%}">Delete</button>
            <input type="checkbox" name="delete" value="1">
        </td>
-->
    </tr>
{% } %}
</script>
<script src="blueimp/js/jquery.min.js"></script>
<script src="blueimp/vendor/jquery.ui.widget.js"></script>
<script src="blueimp/js/tmpl.min.js"></script>
<script src="blueimp/js/load-image.min.js"></script>
<!-- Bootstrap Modal and Image Gallery are not required, but included for the demo -->
<script src="blueimp/js/bootstrap-modal.min.js"></script>
<script src="blueimp/js/bootstrap-image-gallery.min.js"></script>
<script src="blueimp/jquery.iframe-transport.js"></script>
<script src="blueimp/jquery.fileupload.js"></script>
<script src="blueimp/jquery.fileupload-ui.js"></script>
<script src="blueimp/application.js"></script>
<!-- The XDomainRequest Transport is included for cross-domain file deletion for IE >= 8 -->
<script src="blueimp/jquery.xdr-transport.js"></script>
<!-- postMessage Transport support can be added with the following plugin -->
<!--script src="blueimp/jquery.postmessage-transport.js"></script-->
<div>
<p style="margin:10px 0;"><a href="file-manager.php?path=<?= urlencode($open_path) ?>">ファイルマネージャに戻る</a></p>
</div>
</body>
</html>