<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("../tools/__include-common-code-file.php");
	if (!defined("LIST_URL_DEFAULT_FOLDER_index")) {
		define("LIST_URL_DEFAULT_FOLDER_index", "C:/Users/Public/Favorites");
	}
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	html_header(HTML_TITLE, "_add_header-list-url.php");
	page_header();
	contents_header();
	main_proc();
	page_footer();
	html_footer();
	exit();
function main_proc() {
	if ($_POST['path'].'' <> '') {
		$open_path = form_str_filepath($_POST['path']);
	} elseif ($_GET['path'].'' <> '') {
		$open_path = my_GET('path');
	} elseif ($_SESSION['index_list_url_path'] <> '') {
		$open_path = $_SESSION['index_list_url_path'];
	} else {
		$open_path = LIST_URL_DEFAULT_FOLDER_index;
	}
	$open_path = str_replace(DIRECTORY_SEPARATOR, "/", right_slash_strip($open_path));
	$_SESSION['index_list_url_path'] = $open_path;
	if (isset($_POST['search_key']) && $_POST['search_key'].'' <> '') {
		$_SESSION['index_list_url_search_key'] = $_POST['search_key'];
	} elseif ($_GET['key'].'' <> '') {
		$_SESSION['index_list_url_search_key'] = $_GET['key'];
	}
	if (isset($_POST['search_reset'])) {
		$_SESSION['index_list_url_search_key'] = '';
	}
	if ($_GET['sort'].'' <> '') {
		$_SESSION['index_list_url_sort'] = $_GET['sort'];
	}
	if ($_GET['order'].'' <> '') {
		$_SESSION['index_list_url_sort_order'] = $_GET['order'];
	}
	$file_mode = folder_check($open_path, $path_SJIS, $error_msg);
?>
<div id="header">
	<form name="form0" action="<?= $_SERVER['SCRIPT_NAME'] ?>?type=<?= $_GET['type'] ?>" method="post">
		<input type="button" name="" value="↑" onClick="location.href='<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode(up_folder_path($open_path)) ?>'">
		<input class="text" type="text" id="path" name="path" value="<?= my_htmlspecialchars($open_path) ?>" size=100>
		<input type="submit" name="path_change" value="変更"><br>
		<p id="file_name_box">フォルダ：<span><?= up_folder_direct('?path=', $open_path) ?></span></p>
		タイトル/フォルダ名：<input class="text<?= $_SESSION['index_list_url_search_key'] <> '' ? ' list_filter_true' : '' ?>" type="text" name="search_key" value="<?= my_htmlspecialchars($_SESSION['index_list_url_search_key']) ?>" size=30>
		<input type="submit" name="search" value="検索">
		<input type="submit" name="search_reset" value="リセット">
<script language="JavaScript">
function CheckboxThumbnail(onOff) {
	if (onOff == 'on') {
		$.cookie("index_list_url_thumb","",{ expires: 365 });
	} else {
		$.cookie("index_list_url_thumb","on",{ expires: 365 });
	}
	window.location.href = "?";
}
function ListCaptureOnOff(chk){
	if (chk.checked == true) {
		$.cookie("index_list_url_capture","none",{ expires: 365 });
	} else {
		$.cookie("index_list_url_capture","",{ expires: 365 });
	}
	window.location.href = "?";
}
</script>
<?php
?>
	<input type="checkbox" value="on" onClick="CheckboxThumbnail('<?= $_COOKIE['index_list_url_thumb'] ?>')"<?= $_COOKIE['index_list_url_thumb'] == 'on' ? ' checked' : '' ?>>サムネイル
<?php if ($_COOKIE['index_list_url_thumb'] <> 'on') { ?>
	<input type="checkbox" onClick="ListCaptureOnOff(this)"<?= $_COOKIE['index_list_url_capture'] == 'none' ? ' checked' : '' ?>>キャプチャ非表示
<?php	} ?>
	</form>
</div>
<div id="body">
<div id="filemanager_body">
<?php
	if ($file_mode == 'Folder') {
		view_folder($open_path, $path_SJIS, $_SESSION['index_list_url_search_key']);
	} else {
		echo '<p class="error_msg">'.$error_msg.'</p>';
	}
?>
</div>
</div>
<?php
}
function view_folder($open_path, $path_SJIS, $search_key) {
	$prt_dir = array();
	$prt_file = array();
	if ($dir = opendir($path_SJIS)) {
		$files = scandir($path_SJIS);
		natcasesort($files);
		$order = 0;
		error_reporting(0);	// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
		foreach ($files as $file) {
			if ($file != "." && $file != "..") {
				$filepath_SJIS = $path_SJIS.'/'.$file;
				if (is_dir($filepath_SJIS)) {
					$prt_dir[] = $file;
				} else {
					if (is_ext_filename_str($file, 'url')) {
						if (($stat = stat($filepath_SJIS)) <> False) {
							$prt_file[] = array($file, $type, $stat['size'], $stat['mtime']);
							$prt_file_name[] = $file;
							$prt_file_size[] = $stat['mtime'];
							
						} else {
							// 文字「≫」(Shift-JIS:0x81E2) : stat()でエラーになる
							$prt_file[] = array($file, $type, 0, 0);
							$prt_file_name[] = $file;
							$prt_file_size[] = 0;
						}
						// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
						$prt_order[] = ++$order;
					}
				}
			}
		}
		error_reporting(E_ALL ^ E_NOTICE);
		closedir($dir);
	}
	print_dir($open_path, $prt_dir, $search_key);
	print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order);
}
function print_dir($open_path, $prt_dir, $search_key) {
?>
	<div id="print_dir">
	<ul class="file_list">
<?php
	foreach ($prt_dir as $dir) {
		$file_UTF = myfile_DECODE($dir);
		$path_UTF = $open_path.'/'.myfile_DECODE($dir);
		if ($search_key == '' or ($search_key <> '' and stristr(basename($path_UTF), $search_key)) ) {
?>
		<li class="file_folder"><a href="<?= $_SERVER['SCRIPT_NAME'] ?>?path=<?= urlencode($path_UTF) ?>&key=<?= urlencode($search_key) ?>"><?= $file_UTF ?></a>
		<input type="button" class="copy_button" value="Ｃ" onClick="location.href='folder-copy.php?path=<?= urlencode($path_UTF) ?>'">
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_folder('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_folder('<?= escape_squote($path_UTF) ?>')">
		</li>
<?php
		}
	}
?>
	</ul>
	</div>
<?php
}
function print_file($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size, $prt_order) {
	if (!$prt_file_name) return;
?>
	<div id="print_file">
<?php
	if ($_SESSION['index_list_url_sort'] == 'date') {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			array_multisort($prt_file_size, SORT_DESC, $prt_file);
		} else {
			array_multisort($prt_file_size, SORT_ASC, $prt_file);
		}
	} else {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			// array_multisort()で日本語の順番が乱れる対策としてnatcasesort()の順番を使う
			array_multisort($prt_order, SORT_DESC, $prt_file);
		}
	}
	if ($_COOKIE['index_list_url_thumb'] == 'on') {
		url_thumb($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size);
	} else {
		url_list($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size);
	}
?>
	</div>
<?php
}
function url_thumb($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size) {
?>
	<ul id="index_thumbnail">
<?php
		foreach ($prt_file as $file) {
			$file_UTF = myfile_DECODE($file[0]);
			$path_UTF = $open_path.'/'.$file_UTF;
			$path_SJIS = myfile_ENCODE($path_UTF);
			if ($search_key == '' or ($search_key <> '' and stristr($file_UTF, $search_key)) ) {
				$url = '';
				$fp = @fopen($path_SJIS, 'r');
				while ($line=@fgets($fp, 4096)) {
					if (left($line,4) == 'URL=') {
						$url = mb_substr($line,4);
					}
				}
				$file_UTF = basename($file_UTF, '.url');
				$path_UTF = $open_path.'/'.$file_UTF;
?>
			<li>
			<p class="index_thumbnail_title"><a href="<?= $url ?>" target="_blank"><?= my_htmlspecialchars(mb_strimwidth($file_UTF, 0, 21, "..")) ?></a></p>
			<a href="<?= $url ?>" target="_blank"><img src="http://img.simpleapi.net/small/<?= $url ?>"></a>
			</li>
<?php
			}
		}
?>
	</ul>
<?php
}
function url_list($open_path, $prt_file, $search_key, $prt_file_name, $prt_file_size) {
	$href = $_SERVER['SCRIPT_NAME'] . '?path=' .urlencode($open_path);
	if ($_SESSION['index_list_url_sort'] == 'date') {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			$date_ch_order = '&order=asc';
			$date_om = '<span class="order_mark">▼</span>';
		} else {
			$date_ch_order = '&order=desc';
			$date_om = '<span class="order_mark">▲</span>';
		}
	} else {
		if ($_SESSION['index_list_url_sort_order'] == 'desc') {
			$name_ch_order = '&order=asc';
			$name_om = '<span class="order_mark">▼</span>';
		} else {
			$name_ch_order = '&order=desc';
			$name_om = '<span class="order_mark">▲</span>';
		}
	}
?>
	<table>
	<tr><a name="file" /></a>
<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
	<th><br></th>
<?php	} ?>
	<th class="file_list"><a href="<?= $href ?>&sort=name<?= $name_ch_order ?>#file">タイトル</a><?= $name_om ?></th>
	<th class="file_time"><a href="<?= $href ?>&sort=date<?= $date_ch_order ?>#file">更新日時</a><?= $date_om ?></th>
	</tr>
<?php
	foreach ($prt_file as $file) {
		$file_UTF = myfile_DECODE($file[0]);
		$path_UTF = $open_path.'/'.$file_UTF;
		$path_SJIS = myfile_ENCODE($path_UTF);
		if ($search_key == '' or ($search_key <> '' and stristr($file_UTF, $search_key)) ) {
			$url = '';
			$fp = @fopen($path_SJIS, 'r');
			while ($line=@fgets($fp, 4096)) {
				if (left($line,4) == 'URL=') {
					$url = mb_substr($line,4);
				}
			}
			$file_UTF = basename($file_UTF, '.url');
			$path_UTF = $open_path.'/'.$file_UTF;
?>
		<tr>
<?php	if ($_COOKIE['index_list_url_capture'] <> 'none') { ?>
		<td class="index_list_capture">
		<a href="<?= $url ?>" target="_blank"><img src="http://img.simpleapi.net/small/<?= $url ?>"></a>
		</td>
<?php	} ?>
		<td class="file_list" nowrap>
			<span class="file_url">
<?php			if ($url <> '') {	?>
				<a href="<?= $url ?>" target="_blank"><?= left_short($file_UTF, 40) ?></a>
<?php			} else {	?>
				<span style="color:red;font-weight:bold;">エラー：</span><?= $file_UTF ?>
<?php			}	?>
			</span>
		<input type="button" class="copy_button" value="Ｒ" onClick="rename_file('<?= escape_squote($path_UTF) ?>', '<?= escape_squote($file_UTF) ?>')">
		<input type="button" class="copy_button" value="Ｄ" onClick="delete_file('<?= escape_squote($path_UTF) ?>')">
			<p class="index_list_url"><?= left_short($url, 70) ?></p>
		</td>
		<td class="file_time"><?= date("Y/m/d H:i", $file[3]) ?></td></tr>
<?php
		}
	}
?>
	</table>
<?php
}
function folder_check($open_path, &$path_SJIS, &$error_msg) {
	$path_SJIS = myfile_ENCODE($open_path);
	if (file_exists($path_SJIS)) {
		if (is_dir($path_SJIS)) {
			return 'Folder';
		} else {
			$error_msg =  'ファイル『 '.$open_path.' 』は表示できません。';
			return 'File';
		}
	} else {
		$error_msg =  'フォルダまたはファイル『 '.$open_path.' 』が、みつかりません。';
		return 'Error';
	}
}
?>
