<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (DB_TOOL_ID_PASSWORD_USE == 'YES') {
		require("../id-manager/__include-im-login.php");
		require("../id-manager/im-logincheck.php");
	}
	require("__define_excel-import.php");
	ini_set("memory_limit", MEMORY_LIMIT_INI_SET);			//メモリサイズ
	ini_set("max_execution_time", MAX_EXECUTION_TIME_INI_SET);	//最大実行時間
?>
<!DOCTYPE html>
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<title>MySQL管理ツール：Excelインポート</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20110515" type="text/css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/db_tools.css?20091018" type="text/css">
</head>
<body>
<?php
	if (($dbname = $_GET['db']) == '') {
		error_exit('データベース名なし');
	}
	if (($tblname = $_GET['tb']) == '') {
		error_exit('テーブル名なし');
	}
	$con = @mysql_connect(_DB_SERVER, _DB_SCHEMA_USERNAME, _DB_SCHEMA_PASSWORD);
	if ($con == False) {
		error_exit('データベース接続エラー');
	}
	mysql_query('set names utf8', $con);
	if (!mysql_select_db($dbname)) {
		error_exit('データベース選択エラー');
	}
	if (!mysql_query('desc '.$tblname)) {
		error_exit ($tblname.'：テーブル選択エラー');
	}
	$con = mysql_close($con);
?>
<p><?php
	page_header_return_index();
?>
<span id="tool_title">MySQL管理ツール：Excelインポート</span>
<a class="a_cancel_back" href='mysql-database.php'>データベース一覧に戻る</a>
<a class="a_cancel_back" href='mysql-database.php?db=<?= $dbname ?>'>テーブル一覧に戻る</a>
<a class="a_cancel_back" href='mysql-table-list.php?db=<?= $dbname ?>&tb=<?= $tblname?>'>データ表示に戻る</a>
</p>
<p class="subtitle">データベース：<span class="db_name"><?= $dbname ?></span>&nbsp;&nbsp;
テーブル：<span class="tbl_name"><?= $tblname ?></span>
</p>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $dbname ?>&tb=<?= $tblname ?>" enctype="multipart/form-data">
<p style="color: #9d974b">
※ 拡張子.xlsのみ対応しています。<br>
※ 日付型は正常に取り込めません。文字型にしてください。
</p>
<table>
<tr>
	<td align=right>ファイル：</td>
	<td>
		<input type="file" name="filename" size=40 style="button-font-size:small">
	</td>
</tr>
<tr>
	<td><br></td>
	<td>
		<input type="submit" name="upload" value="アップロード">
	</td>
</tr>
</table>
</form>
<?php
if ($_POST) {
	if (($excel_file = post_check('filename')) == True) {
		if (!($excel_file_name = excel_upload($excel_file))) {
			error_exit('Excelシートにデータがありません。');
		}
		if (!$_POST['import']) {
?>
<form name="form0" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>?db=<?= $dbname ?>&tb=<?= $tblname ?>">
<div style="margin: 10px 0 0 50px;"><input type="submit" name="import" value="このデータをインポートする"></div>
</form>
<?php
		}
		if (($excel_file = post_check('filename')) == EXCEL_FILE_EXIST) {
			$import_cnt = database_import($excel_file_name, $dbname, $tblname);
?>
	<br>インポート件数：<span class="mp_rowcnt"><?= $import_cnt ?></span>件<br><br>
	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='mysql-table-list.php?db=<?= $dbname ?>&tb=<?= $tblname?>' target="_blank">テーブル データ表示</a>
<?php
		}
	}
}
?>
<br>
<div id="footer">
<a href="http://ok2nd.web.fc2.com/" target="_blank" style="color:#b0b0ff;">Powered by ok.2nd</a>
</div>
</body>
</html>
<?php
function excel_upload($excel_file) {
	if ($excel_file == EXCEL_FILE_UPLOAD) {
		$attachFile = file_upload_to_name("filename", EXCEL_IMPORT_FOLDER, EXCEL_FILE_NAME);
		$readFile = EXCEL_IMPORT_FOLDER.$attachFile;
	} else {
		$readFile = EXCEL_IMPORT_FOLDER.EXCEL_FILE_NAME;
	}
	require 'phpExcelReader/Excel/Reader.php';
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($readFile);
	if (list_table($excel)) {
		return $readFile;
	} else {
		return false;
	}
}
function list_table($excel) {
	$numRows = $excel->sheets[0]["numRows"];
	$numCols = $excel->sheets[0]["numCols"];
	if ($numRows < 2 || $numCols < 1) return False;
	if ($numRows > 6) {
		$viewRows = 6;
	} else {
		$viewRows = $numRows;
	}
?>
<p>レコード件数：<span class="mp_rowcnt"><?= $numRows-1 ?></span>件
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color: #808080">(先頭の<?= $viewRows-1 ?>件表示)</span></p>
<table class="excel_table" cellspacing=1>
	<thead>
		<tr>
<?php
		for ($col = 1; $col <= $numCols; $col++) {
?>
			<th><?= my_htmlspecialchars($excel->sheets[0]["cells"][1][$col]) ?></th>
<?php
		}
?>
		</tr>
	</thead>
	<tbody>
<?php
	for ($row = 2; $row <= $viewRows; $row++) {
?>
		<tr>
<?php
		for ($col = 1; $col <= $numCols; $col++) {
			if ($excel->sheets[0]["cellsInfo"][$row][$col]['type'] == "date") {
				//	$data = date("Y/m/d", $excel->sheets[0]["cells"][$row][$col]);		// NG
				//	$unix_time = ($excel->sheets[0]["cells"][$row][$col] - 25569) * 86400;	// NG
				//	$data = date("Y/m/d", $unix_time);					// NG
				$data = '<font color=red>日付型は正常に取り込めません。文字型にしてください。</font>';
			} else {
				$data = my_htmlspecialchars($excel->sheets[0]["cells"][$row][$col]);
			}
?>
			<td><?= $data ?></td>
<?php
		}
?>
		</tr>
<?php
	}
?>
	</tbody>
</table>
<?php
	return True;
}
function database_import($excel_file_name, $dbname, $tblname) {
	$excel = new Spreadsheet_Excel_Reader();
	$excel->setUTFEncoder('mb');
	$excel->setOutputEncoding('UTF-8');
	$excel->read($excel_file_name);
	return table_import($excel, $dbname, $tblname);
}
function table_import($excel, $dbname, $tblname) {
	$numRows = $excel->sheets[0]["numRows"];
	$numCols = $excel->sheets[0]["numCols"];
	if ($numRows < 2 || $numCols < 1) return False;
	$con = @mysql_connect(_DB_SERVER, _DB_SCHEMA_USERNAME, _DB_SCHEMA_PASSWORD);
	if ($con == False) {
		error_exit('データベース接続エラー');
	}
	mysql_query('set names utf8', $con);
	if (!mysql_select_db($dbname)) {
		error_exit('データベース選択エラー');
	}
	$colname = '';
	for ($col = 1; $col <= $numCols; $col++) {
		if ($colname <> '') $colname .= ',';
		$colname .= str_for_mysql($excel->sheets[0]["cells"][1][$col]);
	}
	$cnt = 0;
	for ($row = 2; $row <= $numRows; $row++) {
		$coldata = '';
		for ($col = 1; $col <= $numCols; $col++) {
			if ($coldata <> '') $coldata .= ',';
			$coldata .= '"'. str_for_mysql($excel->sheets[0]["cells"][$row][$col]) . '"';
		}
		$sql = "insert into " . $tblname;
		$sql .= " (" . $colname . ")";
		$sql .= " values (" . $coldata .")";
		++$cnt;
		if (!mysql_query($sql)) {
			error_msg(mysql_error());
			error_exit($cnt.'件目のレコードのインポートでエラーが発生しました。');
		}
	}
	$con = mysql_close($con);
	return $cnt;
}
function post_check($filename) {
	if ($_POST['upload']) {
		if (strtolower(strrchr($_FILES[$filename]['name'], '.')) == '.xls') {
			return EXCEL_FILE_UPLOAD;
		} else {
			error_exit('Excelファイルではありません。');
			return false;
		}
	} elseif ($_POST['import']) {
		if (file_exists(EXCEL_IMPORT_FOLDER.EXCEL_FILE_NAME)) {
			return EXCEL_FILE_EXIST;
		} else {
			return false;
		}
	}
}
?>
