<?php
	require("__include-common.php");
	require("../account/__logincheck.php");
	require("../tools/__include-file-cipher.php");
	if ($_SESSION['システム管理者'] <> "YES") {
		exit;
	}
	if (!defined("BACKUP_MYDB_DIR")) {
		define("BACKUP_MYDB_DIR", "/_myhome_backup");
	}
	if (defined("BACKUP_MYDB_DIR_REAL")) {
		$backup_path_real = str_replace(DIRECTORY_SEPARATOR, "/", BACKUP_MYDB_DIR_REAL);
	} else {
		$backup_path_real = $_SERVER['DOCUMENT_ROOT'].BACKUP_MYDB_DIR;
	}
	if (!defined("BACKUP_TEMP_DIR")) {
		define("BACKUP_TEMP_DIR", "temp");
		define("BACKUP_ZIP_FOLDER_NAME", "_myhome_backup");
		define("BACKUP_ZIP_COMMON_MY", "__define_common_my.zip");
		define("BACKUP_ZIP_MYDB_A", "_mydb_backup_a.zip");
		define("BACKUP_ZIP_MYDB_B", "_mydb_backup_b.zip");
	}
	if (!defined("BACKUP_MYDB_CIPHER_MODE")) {
		define("BACKUP_MYDB_CIPHER_MODE", "3");
	}
	define("_MY_DEFINE_COMMON_FILENAME", substr(_MY_DEFINE_COMMON,strrpos(_MY_DEFINE_COMMON,'/')+1));
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html lang="ja">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Script-Type" content="text/javascript">
<meta name="author" content="ok.2nd">
<title>実運用環境バックアップ</title>
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/tools_common.css?20091105" type="text/css">
<link rel="stylesheet" href="<?= _STYLE_SHEET_FOLDER ?>/db_tools.css?20091018" type="text/css">
</head>
<body>
<a href="../tools/" class="return_index">■</a>
<span id="tool_title">実運用環境バックアップ</span>
<form method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
<div style="margin: 10px; ">
<?php
	if (!defined("BACKUP_MYDB_DIR_REAL")) {
		echo '<p style="margin: 15px 0 15px 15px; color:red;">※ 定義ファイルで「<font color=black><b>BACKUP_MYDB_DIR_REAL</b></font>」を有効にしてください。<br>※ バックアップ先ディレクトリが、/xampp/htdocの下の場合、バックアップファイルがWeb経由でダウンロードできてしまいます。</p>';
	}
?>
<p style="margin: 5px 0 5px 0; ">
バックアップ先ディレクトリ： <a href="../tools/file-manager.php?path=<?= $backup_path_real ?>" target="_blank"><?= $backup_path_real ?></a><br>
&nbsp;&nbsp;&nbsp;&nbsp;(↑ディレクトリが無い場合は、作成します。)<br>
実運用定義ファイル： <font color=red><?= _MY_DEFINE_COMMON_FILENAME ?></font> ===&gt; <font color=blue><?= $backup_path_real ?>/<?= BACKUP_ZIP_COMMON_MY ?></font><br>
実運用データベース： <font color=red><?= _DB_SCHEMA_zid_mgr_b ?>以外</font> ===&gt; <font color=blue><?= $backup_path_real ?>/<?= BACKUP_ZIP_MYDB_A ?></font><br>
実運用データベース： <font color=red><?= _DB_SCHEMA_zid_mgr_b ?></font> ===&gt; <font color=blue><?= $backup_path_real ?>/<?= BACKUP_ZIP_MYDB_B ?></font><br>
</p>
<p style="margin: 10px 0 5px 0; color: green; ">
実運用定義ファイルで、「FILE_MANAGER_CIPHER_SEED」が定義されている場合、MySQLデータベースバックアップの暗号化ファイル(拡張子：.encode<?= BACKUP_MYDB_CIPHER_MODE ?>)も作成します。
</p>
<p style="margin: 10px 0 5px 0; ">
<input type="submit" name="backup" value="バックアップ実行"<?php if (isset($_POST['backup'])) echo ' disabled'; ?>>
</p>
</form>
<?php
	if (isset($_POST['backup'])) {
		ob_implicit_flush();	//自動フラッシュをオン(出力をバッファリングしない)
		echo '<p style="margin: 10px 0 10px 0; ">バックアップ処理中 ..........</p>';
		echo '<p style="margin: 10px 0 10px 0; color:red; ">';
		echo '---------------------------------------------------------------------------------------<br>';
		echo 'バックアップ処理中にMyHome Portalの他のページを開かないでください。<br>';
		echo '他のページを開くとハングアップします。<br>';
		echo 'ハングアップした場合は、XAMPPコントロールパネルでApacheを一旦停止し再起動してください。<br>';
		echo '---------------------------------------------------------------------------------------<br>';
		echo '</p>';
		if (backup_mydb_proc($backup_path_real)) {
			echo '<p style="margin: 10px 0 10px 0; ">バックアップ終了</p>';
			if (defined("FILE_MANAGER_CIPHER_SEED") and FILE_MANAGER_CIPHER_SEED <> '') {
				if (($ret = file_cipher($backup_path_real.'/'.BACKUP_ZIP_COMMON_MY, FILE_MANAGER_CIPHER_SEED, BACKUP_MYDB_CIPHER_MODE)) <> '')
					error_msg($ret);
				if (($ret = file_cipher($backup_path_real.'/'.BACKUP_ZIP_MYDB_A, FILE_MANAGER_CIPHER_SEED, BACKUP_MYDB_CIPHER_MODE)) <> '')
					error_msg($ret);
				if (($ret = file_cipher($backup_path_real.'/'.BACKUP_ZIP_MYDB_B, FILE_MANAGER_CIPHER_SEED, BACKUP_MYDB_CIPHER_MODE)) <> '')
					error_msg($ret);
				echo '<p style="margin: 10px 0 10px 0; ">ファイル暗号化終了</p>';
			}
			echo '<p style="margin: 10px 0 10px 0; ">--- ＜終了＞ ---</p>';
?>
			<p style="margin: 10px 0 10px 0; ">
			<a href="../tools/file-manager.php?path=<?= $backup_path_real ?>" target="_blank">バックアップ先ディレクトリ(<?= $backup_path_real ?>)を確認する</a>
			</p>
			<p style="margin: 10px 0 10px 0; ">
			<a href="<?= $_SERVER['SCRIPT_NAME'] ?>">バックアップをやり直す</a>
			</p>
<?php
		}
	}
?>
</div>
</body>
</html>
<?php
function backup_mydb_proc($targetDir) {
//	$targetDir = BACKUP_MYDB_DIR;
	$temp_dir = $targetDir.'/'.BACKUP_TEMP_DIR;

	$dbnames = array();
	$dbnames2 = array();
	$dbnames_bk_files = array();
	$dbnames2_bk_files = array();

	$dbnames[] = _DB_SCHEMA_account;
	$dbnames[] = _DB_SCHEMA_index;
	$dbnames[] = _DB_SCHEMA_calendar;
	$dbnames[] = _DB_SCHEMA_memo;
	$dbnames[] = _DB_SCHEMA_bbs;
	$dbnames[] = _DB_SCHEMA_rss;
	$dbnames[] = _DB_SCHEMA_chat;
	$dbnames[] = _DB_SCHEMA_study;
	$dbnames[] = _DB_SCHEMA_abook;
	$dbnames[] = _DB_SCHEMA_diary;
	$dbnames[] = _DB_SCHEMA_sticky;
	$dbnames[] = _DB_SCHEMA_kakeibo;
	$dbnames[] = _DB_SCHEMA_guide;
	$dbnames[] = _DB_SCHEMA_zid_mgr_a;
	$dbnames2[] = _DB_SCHEMA_zid_mgr_b;

	if (($dir = @opendir($targetDir)) === False) {
		mkdir($targetDir);
	}
	if (($dir = @opendir($temp_dir)) === False) {
		mkdir($temp_dir);
	}
	foreach ($dbnames as $dbname) {
		$dbnames_bk_files[] = mysql_dump($dbname, $temp_dir, '.bk.txt');
	}
	foreach ($dbnames2 as $dbname) {
		$dbnames2_bk_files[] = mysql_dump($dbname, $temp_dir, '.bk.txt');
	}
	my_create_zip_file_multi($temp_dir, $dbnames_bk_files, BACKUP_ZIP_MYDB_A, $targetDir);
	my_create_zip_file_multi($temp_dir, $dbnames2_bk_files, BACKUP_ZIP_MYDB_B, $targetDir);
	if (file_exists(_MY_DEFINE_COMMON)) {
		copy(_MY_DEFINE_COMMON, $temp_dir.'/'._MY_DEFINE_COMMON_FILENAME);
	} elseif (file_exists(_MY_DEFINE_COMMON_SAVE)) {
		copy(_MY_DEFINE_COMMON_SAVE, $temp_dir.'/'._MY_DEFINE_COMMON_FILENAME);
	} else {
		return False;
	}
	my_create_zip_file($temp_dir, _MY_DEFINE_COMMON_FILENAME, BACKUP_ZIP_COMMON_MY, $targetDir);
	return True;
}
function mysql_dump($dbname, $dir, $ext) {
	$backup_mydb_file = $dbname.$ext;
	$command = 'mysqldump -u '._DB_SCHEMA_USERNAME.' -p'._DB_SCHEMA_PASSWORD.' '.$dbname.' > "'.$dir.'/'.$backup_mydb_file.'"';
	exec($command);
	return $backup_mydb_file;
}
function my_create_zip_file($sourceDir, $filename, $zipName, $targetDir) {
	include_once("CreateZipFile/CreateZipFile.inc.php");
	$createZipFile = new CreateZipFile;
	$filePath = $sourceDir.'/'.$filename;
	$fileContents = file_get_contents($filePath);
	$createZipFile->addFile($fileContents, BACKUP_ZIP_FOLDER_NAME.'/'.$filename);
	$targetPath = $targetDir.'/'.$zipName;
	$fp = fopen($targetPath, "wb");
	$out = fwrite($fp, $createZipFile->getZippedfile());
	fclose($fp);
}
function my_create_zip_file_multi($sourceDir, $filenames, $zipName, $targetDir) {
	include_once("CreateZipFile/CreateZipFile.inc.php");
	$createZipFile = new CreateZipFile;
	foreach ($filenames as $filename) {
		$filePath = $sourceDir.'/'.$filename;
		$fileContents = file_get_contents($filePath);
		$createZipFile->addFile($fileContents, BACKUP_ZIP_FOLDER_NAME.'/'.$filename);
	}
	$targetPath = $targetDir.'/'.$zipName;
	$fp = fopen($targetPath, "wb");
	$out = fwrite($fp, $createZipFile->getZippedfile());
	fclose($fp);
}
?>
