<?php
	require("../__common__/__define_common.php");
	if (!defined("GOOGLE_API_KEY")) {
		define("GOOGLE_API_KEY", "ABQIAAAA1XbMiDxx_BTCY2_FkPh06RRaGTYH6UMl8mADNa0YKuWNNa8VNxQEerTAUcfkyrr6OwBovxn7TDAH5Q");
	}
	if (!defined("GOOGLE_MAPS_EARTH_ADDRESS")) {
		define("GOOGLE_MAPS_EARTH_ADDRESS", "東京タワー");
	}
	if (!defined("GOOGLE_MAPS_EARTH_ZOOM")) {
		define("GOOGLE_MAPS_EARTH_ZOOM", 15);
	}
	if (!defined("MAPS_FIX_HEIGHT")) {
		define("MAPS_FIX_HEIGHT", 24);
	}
	if ($_GET['addr'] <> '') {
		$addr = $_GET['addr'];
	} elseif ($_POST['address'] <> '') {
		$addr = $_POST['address'];
	} elseif ($_COOKIE['google_maps_address'] <> '') {
		$addr = $_COOKIE['google_maps_address'];
	} else {
		$addr = GOOGLE_MAPS_EARTH_ADDRESS;
	}
	setcookie('google_maps_address', $addr, time() + LOGIN_COOKIE_EXPIRE, "/");
	if ($_GET['zoom'] <> '') {
		$zoom = $_GET['zoom'];
	} else {
		$zoom = GOOGLE_MAPS_EARTH_ZOOM;
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Language" content="ja">
<meta http-equiv="Content-Style-Type" content="text/css">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
<meta name="author" content="ok.2nd">
<title>Google Maps & Earth</title>
<script src="http://www.google.com/jsapi?key=<?= GOOGLE_API_KEY ?>"></script>
<script type="text/javascript" src="../scripts/jquery.js"></script>
<script type="text/javascript" src="../scripts/jquery.cookie.js"></script>
<script language="javascript" src="../scripts/encodeURL.js" type="text/javascript"></script>
<script type="text/javascript">
var map;
var ge;
var geocoder = null;
google.load("maps", "2.x");
function setHeightPercent(elementID, fixHeight) {
	// マップの高さ設定
	if (document.all) {	// IE
		fixHeight += 50;
	}
	mapsWinHeight = 100 - Math.ceil( fixHeight * 100 / screen.availHeight );
	document.getElementById(elementID).style.height = mapsWinHeight + "%";
}
function init() {
	setHeightPercent('map3d', <?= MAPS_FIX_HEIGHT ?>);
	map = new GMap2(document.getElementById('map3d'));
	var mapui = map.getDefaultUI();
	mapui.maptypes.physical = true;
	map.setUI(mapui);
	map.addMapType(G_SATELLITE_3D_MAP);
	GEvent.addListener(map, 'maptypechanged', function() {
		if (ge) return;
		map.getEarthInstance(function(pluginInstance) {
			ge = pluginInstance;
			//doStuffWithEarth();
		});
	});
	geocoder = new GClientGeocoder();
	showAddress('<?= $addr ?>');
}
function doStuffWithEarth() {
	//document.getElementById('installed-plugin-version').innerHTML = ge.getPluginVersion().toString();
}
function showAddress(address) {
	$.cookie('google_maps_address',address,{ expires: 365 });
	if (geocoder) {
		geocoder.getLatLng(
			address,
			function(point) {
				if (!point) {
					alert(address + " が見つかりません");
				} else {
					map.setCenter(point, <?= $zoom ?>);
					showMarker(point, address);
				}
			}
		);
	}
}
function showMarker(point, address) {
	map.addOverlay(createMarker(point, address));
}
function createMarker(point, addr) {
	var marker = new GMarker(point);
	GEvent.addListener(marker, "click", function() {
		html = addr + '<br><br>';
		html += '緯度：' + point.lat() + '<br>';
		html += '経度：' + point.lng() + '<br><br>';
		html += '<a href="http://maps.google.com/maps?q=' + encodeURL(addr);
		html += '" target="_blank">Googleマップ ≪' + addr + '≫</a>';
		map.openInfoWindowHtml(point, html);
	});
	return marker;
}
function addressClear() {
	document.getElementById("address").value = '';
}
var streetview = '';
var svOverlay;
function StreetViewOnOff() {
	if (streetview == '') {
		StreetViewOn();
	} else {
		StreetViewOff();
	}
}
function StreetViewOn() {
	$("#panorama").css("display","");
	map.getDragObject().setDraggableCursor("default");
	var myPano = new GStreetviewPanorama(document.getElementById("panorama"));
	//	GEvent.addListener(myPano, "error", handleNoFlash);
	svOverlay = new GStreetviewOverlay();
	map.addOverlay(svOverlay);
	GEvent.addListener(map, "click", function(overlay,latlng) {
		myPano.setLocationAndPOV(latlng);
	});
	streetview = 'on';
}
function StreetViewOff() {
	map.removeOverlay(svOverlay);
	$("#panorama").css("display","none");
	map.getDragObject().setDraggableCursor("pointer");
	streetview = '';
	$("#cb_sv").attr("checked", false);
}
function handleNoFlash(errorCode) {
	if (errorCode == FLASH_UNAVAILABLE) {
		alert("Error: Flash doesn't appear to be supported by your browser");
		return;
	}
}
</script>
<style type="text/css">
/* * {margin: 0px; padding: 0px; } */
/*	↓ input 除く */
body, div, img, dl, dt, dd, ul, ol, li, h1, h2, h3, h4, h5, h6, pre, form, fieldset, textarea, p, blockquote, th, td, caption {
	margin: 0; 
	padding: 0;
}
input {
	margin: 0;
	padding: 0 3px;
	*padding: 0;
}
input[type="submit"] {
	background-color: #e0e0e0;
}
input[type="reset"] {
	background-color: #e0e0e0;
}
input[type="button"] {
	background-color: #e0e0e0;
}
button {
	background-color: #e0e0e0;
}
textarea,input,button {
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	line-height: 1.3;
	*line-height: 1.0;
	font-size: 100%;
}
select {
	font-family: "ＭＳ Ｐゴシック",arial,helvetica,clean,sans-serif;
	line-height: 1.3;
	*line-height: 1.0;
	font-size: 100%;
}
textarea {
	padding: 2px;
	_padding: 0px;
	/padding: 0px;
}
html {
	width: 100%;
	height: 100%;
	overflow: hidden;
}
body {
	margin: 0;
	width: 100%;
	height: 100%;
	font-size: 84%;
}
#form {
	margin: 5px 0 0 5px;
}
#map3d {
	width: 100%;
}
#panorama {
	position: absolute; bottom: 15px; right: 6px; width: 50%; height: 50%;
	border: 1px solid #666; padding: 0px; line-height: 1.4; overflow: hidden;
	background: #ffffff;
}
input.text {
	margin: 0px;
	padding: 1px 0 1px 0;
}
a { color: blue; }
</style>
</head>
<body onload="init()" onunload="GUnload()">
<form id="form" method="POST" action="<?= $_SERVER['SCRIPT_NAME'] ?>">
	<input id="address" class="text" type="text" size="40" name="address" value="<?= $addr ?>">
	<button onclick="showAddress(form.address.value); return false">地図を検索</button>
	<button onclick="addressClear(); return false" style="margin-left:2px;">クリア</button>
	<input id="cb_sv" type="checkbox" value="on" onclick="StreetViewOnOff()">ストリートビュー
	<a href="http://maps.google.co.jp/" target="_blank" style="margin-left:16px;">Google マップ</a>
	<a href="http://code.google.com/intl/ja/apis/earth/" target="_blank" style="margin-left:8px;">Google Earth API</a>
</form>
<div id="map3d"></div>
<div id="panorama" style="display:none;">
地図上の道路をクリックしてください。
<a href="javascript:StreetViewOff()">閉じる</a></div></div>
<!--
<div>Installed Plugin Version: <span id="installed-plugin-version" style="font-weight: bold;">Loading...</span></div>
-->
</body>
</html>
