<?php
function rss_view($rec, $table_width=194, $cntmax=100, $pop_width=0) {
	if ($rec['c_rss_url'].'' == '') return;
	$rss = fetch_rss($rec['c_rss_url']);
?>
	<table class="rss_article" style="width: <?= $table_width ?>px; border-color: <?= $rec['c_displayColor'] ?>; background-color: <?= $rec['c_displayColor'] ?>;">
	<tr><th class="rss_article_title">
		<a href="<?= $rec['c_home_url'] ?>" target="_blank"><?= $rec['c_title'] ?></a>
		<?php if ($pop_width <> 0) { ?>
		&nbsp;<a href='javascript:popup_rss("<?= $rec['id_rss'] ?>", <?= $pop_width+36 ?>)' class='popup_rss_link'>↑</a>
		<?php } ?>
	</th></tr>
	<tr><td class="rss_article_body" style="border-color: <?= $rec['c_displayColor'] ?>;">
	<?php if ($rss) { ?>
	<ul class="rss_article_item">
	<?
		$cnt = 0;
		foreach ($rss->items as $item) {
	?>
			<li><a href="<?= $item['link'] ?>" target="_blank"><?= $item['title'] ?></a>
			<span class="rss_article_time">(<?= rss_pubdate($item) ?>)</span>
			</li>
	<?php
			if (++$cnt >= $cntmax) break;
		}
	?>
	</ul>
	<?php }  else { ?>
		<span class='error_msg'>RSS取得エラー</span>
	<?php } ?>
	</td></tr>
	</table>
<?php
}
?>
<?php
function rss_pubdate($item) {
	if ($item['published'].'' <> '') {		// Atom 1.0
		return date("y/m/d H:i:s", strtotime((string)$item['published']));
	} elseif ($item['pubdate'].'' <> '') {		// RSS 2.0
		return date("y/m/d H:i:s", strtotime((string)$item['pubdate']));
	} elseif ($item['dc']['date'].'' <> '') {	// RSS 1.0
		return date("y/m/d H:i:s", strtotime(str_replace('T',' ',(string)$item['dc']['date'])));
	} elseif ($item['issued'].'' <> '') {		// ?????
		return date("y/m/d H:i:s", strtotime((string)$item['issued']));
	} else {
		return '';
	}
}
?>
