<?
/*
	This is PHP file that generates CAPTCHA image for the How to Create CAPTCHA Protection using PHP and AJAX Tutorial

	You may use this code in your own projects as long as this
	copyright is left in place.  All code is provided AS-IS.
	This code is distributed in the hope that it will be useful,
 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	For the rest of the code visit http://www.WebCheatSheet.com

	Copyright 2006 WebCheatSheet.com

*/
//Start the session so we can store what the security code actually is
session_start();

//Send a generated image to the browser
create_image();
exit();

function create_image()
{
	//Let's generate a totally random string using md5
	$md5_hash = md5(rand(0,999));
	//We don't need a 32 character long string so we trim it down to 5
	$security_code = substr($md5_hash, 15, 5);

	//Set the session to store the security code
	$_SESSION["security_code"] = $security_code;

	//Set the image width and height
	$width = 100;
	$height = 25;

	//Create the image resource
	$image = ImageCreate($width, $height);

	//We are making three colors, white, black and gray
	$white = ImageColorAllocate($image, 255, 255, 255);
	$black = ImageColorAllocate($image, 0, 0, 0);
	$grey = ImageColorAllocate($image, 204, 204, 204);
	$blue = ImageColorAllocate($image, 0, 0, 160);
	$red = ImageColorAllocate($image, 160, 0, 0);
	$green = ImageColorAllocate($image, 40, 120, 40);
	$olivedrab = ImageColorAllocate($image, 107, 142, 35);
	$orange = ImageColorAllocate($image, 255, 128, 0);
	$pink = ImageColorAllocate($image, 255, 64, 255);
	$violet = ImageColorAllocate($image, 128, 40, 200);
	$lightseagreen = ImageColorAllocate($image, 32, 178, 170);

	//Make the background black
	$rand = mt_rand(0, 7);
	if ($rand == 1) {
		ImageFill($image, 0, 0, $blue);
	} elseif ($rand == 2) {
		ImageFill($image, 0, 0, $red);
	} elseif ($rand == 3) {
		ImageFill($image, 0, 0, $green);
	} elseif ($rand == 4) {
		ImageFill($image, 0, 0, $olivedrab);
	} elseif ($rand == 5) {
		ImageFill($image, 0, 0, $orange);
	} elseif ($rand == 6) {
		ImageFill($image, 0, 0, $pink);
	} elseif ($rand == 7) {
		ImageFill($image, 0, 0, $violet);
	} else {
		ImageFill($image, 0, 0, $black);
	}
	//Add randomly generated string in white to the image
	ImageString($image, 5, 30, 3, $security_code, $white);

	//Throw in some lines to make it a little bit harder for any bots to break
	ImageRectangle($image,0,0,$width-1,$height-1,$grey);
	$rand = mt_rand(0, 9);
		//	imageline($image, x,y, --- x,y, $grey);
	if ($rand == 0) {
		imageline($image, 0, $height/2-5, $width, $height/2, $grey);
		imageline($image, 0, $height/2, $width, $height/2+10, $grey);
		imageline($image, $width/2+20, 0, $width/2+10, $height, $grey);
		imageline($image, 0, 0, $width/2+10, $height, $grey);
		imageline($image, 20, 0, $width/2+30, $height, $grey);
	} elseif ($rand == 1) {
		imageline($image, 0, 0, $width, $height, $grey);
		imageline($image, 0, $height, $width, 0, $grey);
		imageline($image, 0, $height/2, $width, $height/2+5, $grey);
		imageline($image, $width/2-10, 0, $width/2-20, $height, $grey);
		imageline($image, $width/2+30, 0, $width/2+10, $height, $grey);
	} elseif ($rand == 2) {
		imageline($image, 0, $height/2-6, $width, $height/2+6, $grey);
		imageline($image, $width/2+10, 0, $width/2+15, $height, $grey);
		imageline($image, $width/2+20, 0, $width/2+25, $height, $grey);
		imageline($image, 0, $height, $width/2+10, 0, $grey);
		imageline($image, 20, $height, $width/2+30, 0, $grey);
	} elseif ($rand == 3) {
		imageline($image, 0, $height/2+6, $width, $height/2-10, $grey);
		imageline($image, $width/2+10, 0, $width/2+10, $height, $grey);
		imageline($image, $width/2-15, 0, $width/2-20, $height, $grey);
		imageline($image, 10, 0, $width/2+20, $height, $grey);
		imageline($image, 30, 0, $width/2+40, $height, $grey);
	} elseif ($rand == 4) {
		imageline($image, 0, $height/2+6, $width, $height/2-10, $grey);
		imageline($image, $width/2+10, 0, $width/2+20, $height, $grey);
		imageline($image, $width/2-20, 0, $width/2-5, $height, $grey);
		imageline($image, 10, $height, $width/2+20, 0, $grey);
		imageline($image, 30, $height, $width/2+40, 0, $grey);
	} elseif ($rand == 5) {
		imageline($image, 0, $height/2-5, $width, $height/2, $grey);
		imageline($image, 0, $height/2, $width, $height/2+20, $grey);
		imageline($image, $width/2+30, 0, $width/2+5, $height, $grey);
		imageline($image, 0, 0, $width/2-5, $height, $grey);
		imageline($image, 20, 0, $width/2+20, $height, $grey);
	} elseif ($rand == 6) {
		imageline($image, 0, 0, $width, $height, $grey);
		imageline($image, 0, $height, $width, 0, $grey);
		imageline($image, 0, $height/2, $width, $height/2+5, $grey);
		imageline($image, $width/2-10, 0, $width/20, $height, $grey);
		imageline($image, $width/2+30, 0, $width/2+10, $height, $grey);
	} elseif ($rand == 7) {
		imageline($image, 0, $height/2, $width, $height/2+6, $grey);
		imageline($image, $width/2+10, 0, $width/2+5, $height, $grey);
		imageline($image, $width/2+20, 0, $width/2-5, $height, $grey);
		imageline($image, 0, $height, $width/2+15, 0, $grey);
		imageline($image, 20, $height, $width/2+30, 0, $grey);
	} elseif ($rand == 8) {
		imageline($image, 0, $height/2+3, $width, $height/2-10, $grey);
		imageline($image, $width/2+5, 0, $width/2, $height, $grey);
		imageline($image, $width/2-15, 0, $width/2+10, $height, $grey);
		imageline($image, 10, 0, $width/2+10, $height, $grey);
		imageline($image, 30, 0, $width/2+30, $height, $grey);
	} else {
		imageline($image, 0, $height/2+6, $width, $height/2-5, $grey);
		imageline($image, $width/2+5, 0, $width/2+20, $height, $grey);
		imageline($image, $width/2-15, 0, $width/2-5, $height, $grey);
		imageline($image, 10, $height, $width/2+10, 0, $grey);
		imageline($image, 30, $height, $width/2+25, 0, $grey);
	}
	//Tell the browser what kind of file is come in
	header("Content-Type: image/jpeg");

	//Output the newly created image in jpeg format
	ImageJpeg($image);
	
	//Free up resources
	ImageDestroy($image);
}
?>