<?
/*
***********************************************************************
	MyHome Portal (マイホーム ポータル)
***********************************************************************
	Version		2.33
	Copyright	2008,2009 ok.2nd <m.ok.2nd@gmail.com>
	HomePage	http://ok2nd.web.fc2.com/
			中級プログラマの自宅でPHP
	Blog		http://ok2nd.blog87.fc2.com/
			中級プログラマの自宅でPHP ブログ
***********************************************************************
【ライセンス】
	・オープンソースとします。
	・GPLライセンスに準拠します。
		* 商用/非商用に関わらず、自由に利用可。
		* 商用/非商用に関わらず、自由に修正可。
		* 商用/非商用に関わらず、自由に再配布可。
		* ただし、商用利用では、使用している各ライブラリのライセンスにご注意ください。
		* ただし、このReadMe-original.txtおよびCopyrightは消さないでください。
		* 感想、バグ報告、改善や機能追加のアイデアなどをEmailでお知らせいただけるとうれしいです。

【免責事項】
	・このシステムを利用することによって、何らかの不具合や不利益が生じても開発者は一切の責任を負いません。

【開発環境】
	・XAMPP 1.6.6a (Windows)
		* Apache 2.2.8
		* MySQL 5.0.51a
		* PHP 5.2.5

【クライアント側動作確認】
	* 一部機能はブラウザによっては動作しません。
	・Internet Explorer 6
	・Internet Explorer 7
	・Firefox on Windows
	・Google Chrome (on Windows)
	・Safari 4 (on Windows)

【コンセプト】
	・自宅でポータルとして使えるシステム。(家庭内グループウェア)
	・データはインターネット上ではなく、ローカルPCまたはローカルサーバに保管。
	・初級、中級プログラマにも理解可能なシステム。
	・PHP、SQL、JavaScriptの知識だけで理解可能なシステム。
	・PHPの良さを生かしたHTMLインラインコーディング。(なるべくprint文を使わない。)
	・ブラックボックスの少ないシステム。
	・オブジェクト指向プログラミングを使わない。手続き型(関数型)プログラミングを採用。
	・MVCを使わない。
	・フレームワークに頼らないシステム。
	・テキストエディタ以外の開発ツールを必要としない。

【対象者】
	・自分または家族専用のWebポータルサイトが作りたい。
	・Webポータルサイトをインターネット上ではなく、ローカルPCまたは自宅サーバーで立ち上げたい。
	・日常的に良く使う機能が、個々のアプリケーションを起動せずに、ブラウザの中で出来たらうれしい。
	・スケジュールその他自分の個人情報をインターネット上に置きたくない。
	・パスワードなどのID情報をインターネット上に置きたくない。
	・Webプログラム開発初心者。
	・プログラミングを仕事でなく、趣味でやりたい。
		・オブジェクト指向が苦手。
		・MVCは面倒。
		・システム全体を把握したい。(ブラックボックスは少ない方が良い。)
		・フレームワークを使いたくない。(PHP、SQL、JavaScriptだけで開発したい。)

【特徴・補足】
	・自宅で家族で使えるシステムを目指して作りました。家庭内LANでの利用を想定しています。
	・少人数の会社のイントラでの利用も可能かもしれません。
	  セキュリティは万全ではないので、スケジュール共有など機能を限定して利用願います。
	・ユーザー登録など、インターネット上での利用を想定した機能も付けています。
	  セキュリティは万全ではないので、インターネット上での利用は、お勧めしません。
	・簡単なユーザー管理機能もあります。
	・認証機能もあります。
	・ユーザー単位で他のユーザーに対して参照・書込の権限設定ができます。
	・レコード単位での非公開の設定もできます。
	・ただし、システム管理者はデータベースを直接見ることで全ての情報を参照ができてしまいますので、悪用しないように。
	・ID管理では、二重の認証が必要なしくみにしています。
	・ID管理では、パスワードを独自の方式で暗号化しています。ID情報は、２つのテーブルに分割して保存します。
		暗号化のキーと２つのテーブルを別々にバックアップすれば、ID情報の復元はしづらい(?)と思います。
	・簡単なログ機能も付けています。
	・簡単なシステム管理者機能も付けています。
	・コンテンツを追加しやすい構造にしています。
	・ページ分割有りの一覧形式のページを簡単に作れる共有ライブラリを用意しています。一覧形式での編集もできます。
		/_myhome/__common__/include-common-mp-list.php
	  各コンテンツのlist.php、category.phpを参考にしてください。
	・一覧形式の表示部分のみを、独自のphpソースに置き換えられます。($mp_list_arg['template_view'])

【システム概要】
●INDEX
	・良く使うホームページを登録して、自分のポータルとして使えます。
	・当月の前後3か月分のカレンダーも表示します。スケジュール有の日付は色が変わります。
	・検索もできます。
	・ブログパーツを貼り付けることもできます。
●カレンダ
	・スケジューラです。
	・月間、年間(2年分)、週(全員)、一覧形式での表示が出来ます。
	・一覧形式では、今年、今月、今週などの範囲選択もできます。
	・検索もできます。
	・添付ファイルも付けられます。
	・アルバムとの連携もできます。「My設定」で「アルバムフォルダ」を指定してください。
		サンプル「/_myhome/z_photo_sample」と同じ形式のフォルダ階層になっていれば、
		カレンダの「アルバム」表示で該当の日付のフォルダがあれば、写真表示します。
			/2008/
			/2008/2008-09-16-xxx/
			/2008/2008-09-23-yyy/
	・カレンダーカテゴリで色を名前で指定すると、月、週表示のスケジュール表示色にも適用されます。
●掲示板
	・MyHome Portal全ユーザー共通の掲示板です。
	・投稿の検索やフィルタリングができます。
	・投稿の修正、削除、復活ができます。
	・スレッド単位でページ送りで投稿を閲覧できます。
	・WYSIWYGでHTMLタグが使えます。
	・ファイルや写真、動画の添付もできます。
	・FLV動画はプレビュー表示できます。
	・お絵かきもできます。

●RSSリーダー
	・ユーザーが任意に登録したRSS記事一覧ができます。
●メモ
	・メモ帳です。
	・添付ファイルも付けられます。
	・検索もできます。
●アルバム
	・サーバーのローカルディスクの任意のフォルダの写真を表示できます。表示できるディレクトリの制限もできます。
	  ディレクトリ制限をしない場合は、サーバ上の全てのディレクトリやイメージデータを表示できてしまいますので、
	  セキュリティ上のリスクを十分ご理解の上、利用願います。
	・2種類のサムネイル表示とスライドショータイプの表示ができます。
	・動画のサムネイル表示もできます。
	・画像の拡大、縮小が出来ます。
●チャット
	・MyHome Portalユーザー全員参加型のチャット(Chat)です。
	・MyHome Portalトップページに最新の投稿を表示することもできます。
	・チャット入力ページでは、表示件数や投稿の経過時間を指定できます。
●ID管理
	・パスワードなどのID情報を管理します。
	・ID管理では、専用のパスワード入力が必要です。
	・ID管理では、パスワードを独自の方式で暗号化しています。
	・暗号化のアルゴリズムの信頼性は保証できません。利用者の自己責任でご利用ください。
	  IDやパスワードを復元できなかった場合の責任は持ちかねますので、ご了承願います。
	・ID情報は、２つのテーブルに分割して保存します。
	・暗号化のキーと２つのテーブルを別々にバックアップすれば、ID情報の復元はしづらい(?)と思います。
	・運用開始前に、「/_myhome/__common__/__define_common.php」の
	  define("_DB_ANGOUKA_KEY",)を必ず修正の上、利用開始してください。
	・運用開始後、「/_myhome/__common__/__define_common.php」の
	  define("_DB_ANGOUKA_KEY",)を修正するとパスワードが復元できなくなります。
●利用ガイド
	・管理者は、利用ガイドを編集できます。
●ユーザー一覧
	・ユーザー登録されているメンバの一覧を表示します。管理者モードと一般ユーザーでは表示項目が違います。
	・管理者は、一覧形式でユーザー情報の修正ができます。
●My設定
	・自分のアカウント情報を修正できます。
	・パスワードの修正ができます。
	・公開先メンバや、参照メンバの設定が出来ます。
●ユーザー登録
	・ユーザーの新規登録が出来ます。
	・アカウント名やハンドル名が利用可能かどうかを、簡易Ajaxでチェックできます。
	・簡易Ajaxでは、XMLもJSONも使っていません。単にテキストを返しているだけです。
	・登録確認画面ではキャプチャ認証をします。(インターネットでの利用を想定)
●パスワード忘れ
	・パスワードを忘れた場合、本人宛に電子メールで通知します。
●おまけツール
	・(簡易)預貯金管理
	・HTML テキスト抽出&メール送信
	・HTML URL抽出&ファイルダウンロード
	・Excel to グラフ by Bluff
	・Excel to グラフ by HTML5
	・翻訳 by Google AJAX Language API
	・ホームページのモノトーン表示
	・ホームページの拡大縮小表示
	・テキスト縦書き表示
	・PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー
	・MySQL管理ツール(データベース/テーブル/データ一覧/Excelインポート)
	・HTML テーブル CSSスタイル シミュレーション
	・HTML カラーチャート

【携帯端末スケジュール表示機能】
	別ユニット(_mobile)して、携帯電話(mobile端末)からのカレンダースケジュール表示機能。
	実用に耐えるかどうかは保障できません。あくまで、携帯端末向けWebサイトのトライアルとして作成。

【インストール概略】（Windowsの場合）
	★★★ 「中級プログラマの自宅でPHP」の「インストール」に詳細に記述しています。
	http://ok2nd.web.fc2.com/install.html

	1.Apache、PHP、MySQLが使える環境にします。XAMPPがお勧めです。
	2.圧縮ファイルを展開したディレクトリ一式を、Apacheのhtdocsの下に入れます。
		例：
		D:\xampp\htdocs\_myhome (myHome Portal 本体)
		D:\xampp\htdocs\_mobile (モバイル携帯端末用スケジュール表示)
	3.サンプルのデータベースを作成します。
	  「db_restore.txt.php」の「リストア、ビュー作成、ユーザーアカウント作成」の手順をDOSプロンプトから実行します。
		http://localhost/_myhome/setup-sample.phpで自動セットアップも可能です。
		★ rootのパスワード等、環境に合わせて変更してください。
		★ 「ユーザーアカウント作成」では、PHPからデータベースへアクセスするユーザーを登録します。
	4.「/_myhome/__common__/__define_common.php」を環境に合わせて修正します。
		★ 実運用する場合は、「__define_common.php」の代わりの定義ファイルを別に作成し、
		define("_MY_DEFINE_COMMON")で指定してください。
		★ 定義ファイルサンプルとして、_myhome/__define_common_my_sample.phpを参考にしてください。
		★ PHPファイルは全て、文字コードがUTF-8(UTF-8N)になっていますので、ご注意ください。
	5.サンプルデータのMyHome Portal管理者ユーザーのアカウントは「tarou」、パスワードは「demo」です。

【実運用ディレクトリ構成例】
	★ サンプルデータで動作確認後は、実運用環境を以下のように/_myhome/_とは別のディレクトリ構成にすることをお勧めします。
	/htdocs/_myhome					(myHome Portal 本体)
	/htdocs/_blog-parts				(トップページ全ユーザー共通のブログパーツフォルダ)
	/htdocs/_mobile					(モバイル携帯端末用スケジュール表示)
	/htdocs/_attach/calendar			(カレンダー添付ファイル格納場所)
	/htdocs/_attach/memo				(メモ添付ファイル格納場所)
	/htdocs/_attach/bbs				(掲示板添付ファイル格納場所)
	/htdocs/_myhome_myset/_my_calendar_images	(カレンダーアイコンフォルダ、/calendar/imagesをコピー)
	/htdocs/_myhome_myset/__define_common_my.php	(__define_common_my_sample.phpをコピーして名前変更)
	★ ↑ このファイル名が存在するかどうかで実運用環境かサンプル環境かを判断します。
	/htdocs/__define_weather_city_my.php		(livedoor天気ガジェット：都市定義ファイル、/index/からコピーして修正)

【初期アカウント登録方法】
	サンプルデータを利用して一括修正する方法が簡単です。
	1.サンプルデータの管理者アカウント「tarou」でログインします。
	2.右上メニュー「ユーザ一覧」を開き、「一括修正/追加/削除」を開きます。
	3.サンプルデータのアカウント、ハンドル、パスワードを利用環境のユーザに合わせて修正します。
	  権限に「admin」と入れるとシステム管理者になります。

【サンプルデータ削除方法】
	サンプルデータを削除する方法です。
	＜カレンダからサンプルのスケジュールデータを削除＞
	mysql -u myhome -ppass123
	use _db_calendar;
	truncate table m_schedule;
	exit;

【使用スクリプト/ライブラリ】
	・scripts/encodeURL：URLエンコード
		IE他クロスブラウザで正しく動作するURLエンコード。
		http://www.favorite-labo.org/archives/211.html

	・scripts/URLencode：URLエンコード
		PHPでデコードできるURLエンコード。
		http://postcard.blog.ocn.ne.jp/itazura/2004/12/javascript_url_.html

	・scripts/ecl.js：Escape Codec Library
		トップページのGoo郵便番号検索、Yahoo電話帳検索で、EUC-JPコードでのescapeエンコードに使用。
		http://nurucom-archives.hp.infoseek.co.jp/digital/escape-codec-library.html

	・scripts/create_image.php：Create CAPTCHA Protection
		ユーザー登録画面のCAPTCHA認証画像の生成に使用。
		http://www.webcheatsheet.com/PHP/create_captcha_protection.php

	・scripts/calendar.js：「ホームページの素」の日付入力補助
		カレンダースケジュール入力画面の日付のポップアップ入力で使用。
		http://www.kanaya440.com/

	・scripts/YahhoCal.js：YUI Calendar(Yahoo! UI Library: Calendar)の日本語化&ポップアップ対応JavaScript
		カレンダースケジュール入力画面の日付のポップアップ入力で使用。
		日付のポップアップ入力を定義ファイル(__define_common.php)でYUIを指定した場合に使用。
		http://0-oo.net/sbox/javascript/yahho-calendar
		http://developer.yahoo.com/yui/calendar/

	・scripts/jquery.js
		アルバムの画像のマウスクリックによる拡大・縮小で使用。
		ツールの「HTML テーブル CSSスタイル シミュレーション」(サンプル)で使用。
		チャット、ToDoのAjaxで使用。
		http://jquery.com/

	・scripts/livedoor天気Webサービス
		トップページに3日分の天気表示で使用。
		http://weather.livedoor.com/weather_hacks/webservice.html

	・scripts/prototype.js
		livedoor天気Webサービス利用のAjaxで使用。
		http://www.prototypejs.org/

	・scripts/getRange_in_textarea.js
		カレンダースケジュール本文へのタグ&アイコン挿入機能に使用。
		http://archiva.jp/web/javascript/getRange_in_textarea.html

	・scripts/not_use/textarea.js
		textarea入力支援スクリプト。(現在、未使用)
		http://painter.homeip.net/~raelian/tag/enclose.html

	・scripts/openwysiwyg/ 一式
		掲示板のWYSIWYGエディタとして使用
		http://www.openwebware.com/

	・scripts/yui/ 一式：Yahoo! UI Library(YUI)
		掲示板のWYSIWYGエディタとして使用
		http://developer.yahoo.com/yui/editor/

	・scripts/JWPlayer/ 一式 (JW FLV Player/JW WMV Player)
		掲示板、メモのFLV, WMV動画プレビューに使用。
		http://www.longtailvideo.com/

	・rss/magpierss/ 一式
		RSSパーサーとして使用。
		http://magpierss.sourceforge.net/

	・scripts/nifty/ 一式
		RSSのカテゴリ・ナビの角丸タグに使用。
		http://www.html.it/articoli/nifty/index.html

	・scripts/inputdraw/ 一式
		掲示板のお絵かきに使用。
		http://www.mainada.net/inputdraw

	・tools/scripts/dp.SyntaxHighlighter/ 一式
		ツールの「PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー」で使用。
		http://winofsql.jp/sh/html/syntax_highlighter.htm

	・tools/scripts/editarea/ 一式
		ツールの「PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー」で使用。
		http://www.cdolivet.net/editarea/

	・tools/scripts/Bluff/ 一式
		ツールの「Excel to グラフ by Bluff」で使用。
		http://bluff.jcoglan.com/

	・tools/scripts/html5jp/ 一式
		ツールの「Excel to グラフ by HTML5」で使用。
		http://www.html5.jp/library/index.html

	・tools/scripts/excanvas/ 一式
		ツールの「Excel to グラフ」で使用。
		Internet ExplorerをCanvasに対応させる。
		http://sourceforge.net/projects/excanvas/

	・tools/phpExcelReader/ 一式
		ツールの「Excel to グラフ」のExcelシートの取り込みに使っています。
		http://sourceforge.net/projects/phpexcelreader

	・db_tool/CreateZipFile/ 一式
		ツールの「実運用環境バックアップ」でZIPファイル生成に使っています。
		http://olederer.users.phpclasses.org/browse/package/2322.html

	・pdf/fpdf 一式
		PDF作成用ライブラリFPDF関連。
		http://www.fpdf.org/
		    ・FPDF
		    ・MBFPDF
		    ・Rotations

		http://www.setasign.de/products/pdf-php-solutions/fpdi/
		    ・FPDI
		    ・FPDF_TPL

	・pdf/fpdf/pdf-inc.php
		PDF葉書宛名書きライブラリ。
		http://wp.rapidexp.com/2009/01/fpdf/

	・tools/refresh_web/ 一式
		ツール「Photoshop-like JavaScript Color Picker」
		http://johndyer.name/post/2007/09/PhotoShop-like-JavaScript-Color-Picker.aspx

	・scripts/pixastic/ 一式
		「アルバム」の画像エフェクトに使っています。
		http://www.pixastic.com/lib/

	・scripts/jquery.cs.js
		「住所録」の都道府県選択のプルダウンに使っています。
		http://www.jextend.com/sample/cs.html

	・scripts/snapfit/ 一式
		「アルバム」のジグソーパズル生成に使っています。
		http://www.netzgesta.de/snapfit/

	・scripts/HAWHAW：汎用的な携帯用アプリの開発ツールキット
		携帯電話(mobile端末)からのカレンダースケジュール表示機能に使用。
		http://www.d-meister.co.jp/HAWHAW/

【使用アイコン】
	・1キロバイトの素材屋さん
	http://www.fuchu.or.jp/~tenshi/1kb/sozai/

	・フリー素材Fairy Tail (リストマークアイコン)
	http://fairy-tail.com/graphics/icon/list/index.html

	・famfamfam.com
	http://www.famfamfam.com/

	・205 16x16 cms ect icons pngs by ~zman3
	http://zman3.deviantart.com/art/205-16x16-cms-ect-icons-pngs-85612498

【使用データ】
	・フォトサンプル：写真素材 足成【フリーフォト、無料写真素材サイト】
	http://www.ashinari.com/

【修正履歴】

	★★★修正履歴は、以下のWebページでも確認できます。
		http://ok2nd.web.fc2.com/download.html

【修正履歴：Ver.2.33】
	・システムをWindows以外のOS上に載せやすいように、ファイルシステムの文字コードを定義ファイルで変更できるようにしました。
		define("_SYSTEM_FILE_ENCODING", "SJIS-win");
	・アルバムで、動画を時間分割して、サムネイル表示できる機能を追加しました。分割数やサイズも選択できます。
	・修正モジュール
		・__common__/__define_common.php, include-common-all.php
		・calendar/_my_calendar.php
		・photo/多数
		・tools/多数
		・setup-sample.php, __define_common_my_sample.php

【修正履歴：Ver.2.32】
	・住所録の「電子メール宛名」機能で、mailto:の複数メールアドレスの結合文字として、Outlook用の";"を定義ファイルで設定できるようにしました。
		define("MAILTO_CONCATENATE_CHR", ",");
	・掲示板、メモ、アルバムでWMVをFLV同様にプレビューできるようにしました。
	  WMVプレビューには、JW WMV Playerを使用。
		http://www.longtailvideo.com/players/jw-wmv-player/
	・FLVプレビュー用のJW FLV Playerをバージョン4.6にしました。
	・アルバム、ツールの(簡易)ファイルマネージャー等でファイル名にシングルクォート(')が含まれている場合の不具合を修正。
	・カレンダーで、平均気温の他に、最高気温、最低気温の表示もできるようにしました。
	・気温の色分け区分を増やしました。
	・修正モジュール
		・__common__/__define_common.php, include-common-html.php, include-common-all.php
		・abook/do-proc.php
		・bbs/view.php, __define.php, player.swf, yt.swf
		・memo/list-my-template.php, __define.php, player.swf, yt.swf
		・calendar/__define.php, __include-weather.php, _my_calendar.php
		・calendar/month.php, year.php, weather-map.php
		・photo/__define.php, index.php, slide.php, img-view.php
		・photo/video-jpeg.php, video-view.php, jigsaw.php
		・tools/多数
		・scripts/JWPlayer/swfobject.js
		・style/original/weather.css, map-japan-weather.css
		・__define_common_my_sample.php
	・追加モジュール
		・bbs/wmvplayer.xaml
		・memo/wmvplayer.xaml
		・photo/wmvplayer.xaml
		・scripts/JWPlayer/wmvplayer.js, silverlight.js

【修正履歴：Ver.2.31】
	・カレンダーの年間カレンダーを1024×768のディスプレイで全体が表示できるように微調整。
	・カレンダーに全国の都道府県別平均気温表示機能を追加。
	  天気出現率と同じく、月間、年間カレンダーでの表示の他、日本地図での日付別の平均気温表示もできます。
	・修正モジュール
		・calendar/__define.php, _my_calendar.php,__include-weather.php
		・calendar/year.php, month.php, weather-map.php
		・style/original/calendar.css, weather.css, map-japan-weather.css
		・__define_common_my_sample.php

【修正履歴：Ver.2.30】
	・カレンダーの天気出現率地図を、1024×768のディスプレイで地図全体が表示できるように微調整。
	・修正モジュール
		・calendar/weather-map.php
		・style/original/map-japan-weather.css

【修正履歴：Ver.2.29】
	・サンプルDBセットアップ「setup-sample.php」の修正。
	  mysqli_multi_query()では、長いSQL文を実行するとエラーになるようなので、exec()を使用する方法に変更。
	・ツールに「HTML テキスト抽出 複数一括」を追加。
	  複数のURLから一括してテキスト抽出します。
	  テーブルデータ出力時のセパレータ（区切り文字）を指定できます。
	  デフォルトはスペースです。カンマ(,)にすることで、CSVとしての利用が容易になります。
	  テーブルデータ出力時に、行単位に先頭に文字を付加することもできます。CSV利用時に、共通のキーを付加したい場合に使えます。
	  テーブルのみに限定して抽出もできます。（ただし、階層構造には未対応です。）
	  テーブルサイズを指定サイズ以上のものに限定することもできます。
	・カレンダーに、天気出現率機能追加。
	  カレンダーで、天気出現率を表示します。天気出現率とは、過去30年間の大気現象や日降水量、日平均雲量から割り出したものです。
	  月間、年間カレンダーで、各日の都道府県別の天気出現率を基にした出現率の高い天気を表示します。主に都道府県庁所在地の天気出現率を基にしています。
	  北海道は主な支庁の都市を表示します。佐渡、伊豆大島、輪島の天気出現率も表示します。
	  日付別の天気出現率の日本地図表示もできます。指定日の日本全体の天気の傾向が読み取れます。
	  天気出現率は、「みんなの知識【ちょっと便利帳】」のものを使わせていただきました。
			http://www.benricho.org/weather_ratio/
	  天気アイコンは、「素材のプチッチ」のものを使わせていただきました。
			http://putiya.com/4risuto2.html
	・既に前のバージョンで実運用の場合は、以下の手順で、テーブル「m_weather」と「r_kenmei」を追加してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」、インストールドライブを「D:」として説明します。
	  【サンプルDBの場合】
		1.コマンド・プロンプトで次を実行します。
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_calendar < _db_calendar_add_m_weather.txt
		2.次に、「MySQL管理ツール」で、「実運用サンプル/天気出現率.csv」を、「_db_calendar」のテーブル「m_weather」にインポートしてください。
		3.同じく、「実運用サンプル/都道府県_for_カレンダー.csv」を、「_db_calendar」のテーブル「r_kenmei」にインポートしてください。
		4.コマンド・プロンプトで次を実行します。
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_calendar < create_view_db_calendar.txt
	  【実運用DBの場合】
		1.コマンド・プロンプトで次を実行します。
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_calendar < _db_calendar_add_m_weather.txt
		2.次に、「MySQL管理ツール」で、「実運用サンプル/天気出現率.csv」を、「_mydb_calendar」のテーブル「m_weather」にインポートしてください。
		3.同じく、「実運用サンプル/都道府県_for_カレンダー.csv」を、「_mydb_calendar」のテーブル「r_kenmei」にインポートしてください。
		4.コマンド・プロンプトで次を実行します。
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_calendar < create_view_mydb_calendar.txt
	・修正モジュール
		・__common__/include-common-all.php
		・abook/map-japan.php
		・calendar/多数
		・db_tool/csv-import.php, mysql-table-list.php
		・tools/index.php, html-text-mail.php, colorpicker.php
		・tools/refresh_web/colorpicker/ColorPicker.js
		・setup-sample.php
		・style/original/calendar.css, map-japan.css
		・z_db_backup/create_view_db_calendar.txt, create_view_mydb_calendar.txt, _db_calendar.bk.txt
	・追加モジュール
		・calendar/weather-map.php, __html-my-header-weather-map.php, __include-weather.php
		・tools/html-text-multi.php
		・style/original/weather.css
		・icon/weather/天気アイコン
		・z_db_backup/_db_calendar_add_m_weather.txt
		・実運用サンプル/天気出現率.csv, 都道府県_for_カレンダー.csv

【修正履歴：Ver.2.28】
	・テキストをHTML表示する時に、スペース(" ")を、"&nbsp;"に置き換えていたのを止めました。英文表示で自動改行がされなくなるため。
	・「メモ」に翻訳機能追加。メモ本文を各国語に翻訳できます。一覧表示全体または個々のメモを翻訳できます。文単位で翻訳します。
	  原文の言語は自動判別しますので、日本語から英語や各国語、または英語など各国語から日本語への翻訳ができます。
	  OSとブラウザの環境によっては、中国語や韓国語などは、正しい文字が表示されず文字化けする可能性があります。
	  翻訳には、Google AJAX Language APIを使用しています。
		＜Google AJAX Language API＞
		http://code.google.com/intl/ja/apis/ajaxlanguage/documentation/
	・修正モジュール
		・__common__/include-common-all.php, include-common-html.php
		・memo/list.php, list-my-template.php
		・style/original/memo.css
	・追加モジュール
		・memo/translate-google.php, __html-my-header-translate.php

【修正履歴：Ver.2.27】
	・月間カレンダーの右に表示される年間カレンダーにマウスを載せるとカレンダーが消えてしまう不具合を修正。(CSSのfloat:left;を除去)
	・ツール「(簡易) 預貯金管理」の名義フィルタに削除したデータの名義が残ってしまう不具合があったのを修正。
	  ビュー「v_keiyakusha」の定義に不備があったため。
	・既に前のバージョンで実運用の場合は、以下の手順で、_db_kakeiboまたは_mydb_kakeiboのビューを再定義してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」」、インストールドライブを「D:」として説明します。
		【サンプルDBの場合】
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_kakeibo < create_view_db_kakeibo.txt
		【実運用DBの場合】
			D:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_kakeibo < create_view_mydb_kakeibo.txt
	・修正モジュール
		・style/original/calendar.css
		・z_db_backup/create_view_db_kakeibo.txt, create_view_mydb_kakeibo.txt, _db_kakeibo.bk.

【修正履歴：Ver.2.26】
	・ページ全体のbodyの横幅の定義をCSSファイルでなく、実運用定義ファイルで指定できるように変更。
	  実運用定義ファイルのPAGE_BODY_STYLEで定義してください。max-widthを外せば100%指定になります。
		define("PAGE_BODY_STYLE", "max-width: 980px;");
	・修正モジュール
		・__common__/__define_common.php, include-common-html.php
		・abook/map-japan.php
		・calendar/maps-alone.php
		・style/original/common.css, rss.css, calendar.css
		・__define_common_my_sample.phpp

【修正履歴：Ver.2.25】
	・CSSで、
		* {margin: 0px; padding: 0px; }
	  とすると、Google Chromeだけtextareaの左端のカーソルが見えなくなってしまう問題の対策をしました。
	  以下をCSSに追加しました。ただし、Firefox、Safariのtextareaの左端に隙間ができます。
		textarea {
			padding: 2px;
			_padding: 0px;
			/padding: 0px;
		}
	・入力画面のレイアウトの微調整。
	・textareaの横幅がブラウザによって違ってしまう問題の回避策として、colsをやめてwidthにしました。
	・修正モジュール
		・account/edit-myprofile.php, newaccount.php
		・calendar/input.php
		・chat/index.php
		・guide/input.php
		・id-manager/input.php
		・memo/input.php
		・tools/html-text-mail.php
		・style/original/common.css, tools_common.css, chat.css

【修正履歴：Ver.2.24】
	・住所録の都道府県フィルタで都道府県を選択した時に、分類がリセットされてしまう問題を修正。
	・修正モジュール
		・__common__/include-common-mp-list.php

【修正履歴：Ver.2.23】
	・住所録で、日本地図で都道府県を選択すると、分類の選択がリセットされてしまう問題を修正。
	・RSSの配置を横4個固定でなく、ウインドウサイズに合わせて可変にしました。
	・RSSの画面表示で出力をバッファリングしないように「ob_implicit_flush();」を追加しました。
	・一覧形式のページのCSSの微調整。
	・ツールの「実運用環境バックアップ」で住所録DBのバックアップが漏れていたのを修正。
	・修正モジュール
		・abook/_contents-header.php, map-japan.php
		・abook/list-my-template.php, list-my-template-sekaiisan.php
		・rss/index.php, __define.php
		・db_tool/backup-mydb.php
		・style/original/mp-list.css, rss.css, abook.css

【修正履歴：Ver.2.22】
	・サンプルデータDBの住所録の百名山データを太郎から共通に変更しました。
	・住所録のサンプルデータとして世界遺産を追加しました。
	  分類フィルタで、世界遺産を選択すると世界遺産専用の一覧形式に変わります。国別、UNESCOのRef番号順に並び替えもできます。
	  世界遺産名をクリックすると、UNESCOの解説ページが開きます。「→日本語」をクリックすると、UNESCOの解説ページをGoogleで翻訳表示します。
	  「マップ」で、世界遺産をGoogleマップでマーカー表示することもできます。Google Earthモード表示もできます。
	  Googleマップのマーカーから、UNESCOの解説ページに飛ぶこともできます。
	・「実運用サンプル」フォルダに「世界遺産.csv」を追加しています。
	・世界遺産のデータは、以下のページのものを使わせていただきました。
		＜google maps による世界遺産めぐり：世界遺産の緯度と経度＞
		http://www.geocities.jp/heritages001/heritages.html
	・世界遺産データを実運用データベースに登録した場合、世界遺産のカテゴリid_category番号を実運用定義ファイルで設定してください。
		define("SEKAI_ISAN_CATEGORY_ID", 4);
	・既に前のバージョンで実運用の場合は、以下の手順で、テーブル「m_abook」の列の桁数を大きくしてください。
	  コマンドプロンプトから以下を実行してください。MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	  世界遺産データをアップロードする前に実行してください。
		【サンプルDBの場合】
			mysql -u root -pkanri789
			use _db_abook;
			alter table m_abook modify c_name1 varchar(255) NOT NULL;
			alter table m_abook modify c_name2 varchar(255) NOT NULL;
			alter table m_abook modify c_yomi1 varchar(255) NOT NULL;
			alter table m_abook modify c_yomi2 varchar(255) NOT NULL;
			alter table m_abook modify c_renmei varchar(255) NOT NULL;
			alter table m_abook modify c_memo varchar(500) NOT NULL;
			exit;
		【実運用DBの場合】
			mysql -u root -pkanri789
			use _mydb_abook;
			alter table m_abook modify c_name1 varchar(255) NOT NULL;
			alter table m_abook modify c_name2 varchar(255) NOT NULL;
			alter table m_abook modify c_yomi1 varchar(255) NOT NULL;
			alter table m_abook modify c_yomi2 varchar(255) NOT NULL;
			alter table m_abook modify c_renmei varchar(255) NOT NULL;
			alter table m_abook modify c_memo varchar(500) NOT NULL;
			exit;
	・修正モジュール
		・abook/多数
		・style/original/abook.css
		・__define_common_my_sample.php
		・実運用サンプル/日本百名山.csv
	・追加モジュール
		・実運用サンプル/世界遺産.csv

【修正履歴：Ver.2.21】
	・住所録の住所欄を緯度、経度で入力した場合、マップ機能で1地点あたりのスリープが不要なのに、スリープするようになっていた問題を修正。
	・マップ機能で、地点数が多いとエラーになりやすいので、1地点あたりの取得タイム設定値「GETLATLNG_SLEEP_TIMEののデフォルト値を0.2秒に変更しました。
		define("GETLATLNG_SLEEP_TIME", 200000); // 0.2秒
	・修正モジュール
		・abook/maps-abook.php
		・calendar/maps-include.php
		・tools/google-maps-earth-marker.php
		・__define_common_my_sample.php

【修正履歴：Ver.2.20】
	・住所録のマップ機能で、マーカーに氏名、住所、メモを表示するようにしました。
	・住所録のマップ機能で、住所欄に緯度、経度情報を入力した場合も表示できるようにしました。
	・住所録サンプルデータの日本百名山のデータを差し替えました。日本百名山の住所欄に緯度、経度情報を住所欄に入れています。
	  これで、かなり正確な位置にマーカー表示できるようになりました。実運用アップロード用ファイル「日本百名山.csv」も差し替えました。
	・日本百名山の緯度、経度情報は、以下のページのものを使わせていただきました。
		＜日本百名山一覧/深田順 NASA World Wind＞
		http://www.occn.zaq.ne.jp/sohta/100list_N.htm
	・修正モジュール
		・abook/do-proc.php
		・実運用サンプル/日本百名山.csv
	・追加モジュール
		・abook/maps-abook.php, __html-my-header-maps-abook.php

【修正履歴：Ver.2.19】
	・MySQL管理ツールのCSVインポート、Excelインポートで、サイズの大きなファイルをインポートした場合にエラーとならないように、
	  メモリサイズ、実行時間の拡張を追加。
		ini_set("memory_limit", MEMORY_LIMIT_INI_SET);
		ini_set("max_execution_time", MAX_EXECUTION_TIME_INI_SET);
	・実運用定義ファイルでメモリサイズ、実行時間の変更もできます。
		define("MEMORY_LIMIT_INI_SET", "128M");
		define("MAX_EXECUTION_TIME_INI_SET", "240");
	・INDEXの一覧表示でホームページのサムネイル表示が出来るようにしました。
	・住所録に、項目「都道府県」を追加。
	・住所録一覧に、「都道府県」フィルタを追加。
	・住所録一覧の表示順に、「都道府県順」を追加。
	・住所録に、「都道府県名セット」を追加。郵便番号から判断して都道府県名をセットします。
	・住所録に、日本地図を追加。都道府県をクリックすると、該当の都道府県の住所録一覧が表示されます。
	・住所録一覧で、都道府県選択のプルダウンでは、以下のサイトのCustom Select「jquery.cs.js」を利用しています。
	  ただ、「jquery.cs.js」では、selectタグをbuttonに変更しているためにonChangeが使えないので、
	  一部カスタマイズした「jquery.cs.ok2nd.js」を使っています。強引にonClickを追加しています。
		＜Custom Select - JQueryでselectタグのプルダウンをカスタマイズする＞
		http://www.jextend.com/sample/cs.html
	・住所録DBに、都道府県テーブル「r_kenmei」を追加。
	・住所録DBに、郵便番号の頭2桁と都道府県の対応テーブル「r_zip100」を追加。都道府県名セットで使用。
	・既に前のバージョンで実運用中の場合は、以下の手順で、テーブル「m_abook」に列「c_kenid」の追加と、
	  テーブル「r_kenmei」「r_zip100」の追加をしてください。MySQL管理者ユーザーrootのパスワードを「kanri789」、
	  インストールドライブを「D:」として説明します。
	【サンプルDBの場合】
		mysql -u root -pkanri789
		use _db_abook;
		ALTER TABLE m_abook ADD c_kenid varchar(10) NOT NULL AFTER c_zip2;
		exit;
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_abook < _db_abook_add_r_kenmei.txt
		mysql -u root -pkanri789 _db_abook < _db_abook_add_r_zip100.txt
		mysql -u root -pkanri789 _db_abook < create_view_db_abook.txt
	【実運用DBの場合】
		mysql -u root -pkanri789
		use _mydb_abook;
		ALTER TABLE m_abook ADD c_kenid varchar(10) NOT NULL AFTER c_zip2;
		exit;
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_abook < _db_abook_add_r_kenmei.txt
		mysql -u root -pkanri789 _mydb_abook < _db_abook_add_r_zip100.txt
		mysql -u root -pkanri789 _mydb_abook < create_view_mydb_abook.txt
	・住所録のサンプルデータに、「日本百名山」を追加。
	「マップ」機能で、ツールの「Google Maps & Earth」で日本百名山のマーカー付きの地図が表示できます。
	  ただし、日本百名山の多くは山の名前でGoogle Mapsでマーカー表示されますが、一部の山は同名の中国等の山が表示されてしまいます。
	・実運用データベースへの追加用として、「実運用サンプル」フォルダに「日本百名山.csv」を追加しています。
	  MySQL管理ツールのCSVアップロードで、実運用データベースへ追加できます。CSVアップロードする場合は、事前に分類を追加した上で、
	  id_accountとid_categoryのデータ部分を置き換えてご利用ください。テーブル「m_abook」にアップロードしてください。
	・修正モジュール
		・__common__/include-common-mp-list.php, include-common-all.php
		・index/list-my-template.php
		・abook/__html-my-header.php, _contents-header.php, list.php
		・abook/list-my-add-filter.php, list-my-template.php, edit-caption.php
		・db_tool/__define.php, csv-import.php, excel-import.php
		・style/index.css, abook.css, mp-list.css
		・z_db_backup/create_view_db_abook.txt, create_view_mydb_abook.txt
		・__define_common_my_sample.php
	・追加モジュール
		・abook/set-todofuken-by-zip.php, map-japan.php, __html-my-header-map-japan.php
		・scripts/jquery.cs.js, jquery.cs.ok2nd.js
		・style/map-japan.css
		・実運用サンプル/日本百名山.csv

【修正履歴：Ver.2.18】
	・アルバムで画像エフェクトをかけた場合、現在のエフェクト状態をボタンの下にテキスト表示するようにしました。
	・saturationのボタン1回あたりのエフェクト度を少し下げました。
	・アルバムの全画面スライドショーで、キーボード操作を可能にしました。
		・[ESC]：全画面モード終了
		・[→], [Page Down], [Enter], [Space]：次画像
		・[←], [Page Up]：前画像
		・[Tab]：10画像スキップ(リピートは無効)
		・[半角/全角]：10画像前へスキップ(リピートは無効)
		・[Home]：先頭画像へスキップ
		・[End]：最後画像へスキップ
		・[A]：自動モード On/Off
		・[R]：リピート On/Off
		・[W]：壁紙モード On/Off
	・修正モジュール
		・photo/index.php, slide.php

【修正履歴：Ver.2.17】
	・INDEXトップページでカテゴリ表示順が同じものが複数ある場合、１つのカテゴリのリンクが分かれて表示されてしまう不具合を修正。
	  sort orderの指定ミスでした。
	・ログインし直した時に、HTMLを含まないページ(chat/read-min.phpなど)に遷移してしまうことがある不具合を修正。
	・修正モジュール
		・index/top.php
		・account/__logincheck.php
		・chat/read.php, read-min.php, write.php ・todo/read.php, read-min.php, write.php, update.php, delete.php, priority_updown.php

【修正履歴：Ver.2.16】
	・MySQL管理ツールに、CSVファイルからデータベースへのアップロード機能を追加。
	  デリミッタ(区切り文字)はカンマ( , )、文字列の囲みはダブルクォーテーション(")のみサポート。
	  文字コードは、Shift-JIS、UTF-8、EUCなど自動判別します。
	・MySQL管理ツールのExcelシートアップロードにエラー処理の不備があったので修正。
	・アルバムのスライドショーに、画像エフェクト機能を追加。
	  画像エフェクトには、JavaScriptライブラリ「Pixastic」を使用しています。
	  http://www.pixastic.com/lib/
	  エフェクトの種類は、sepia、posterize、saturation、sharpen、blur、contrast、lighten、glow、red、green、blue、desaturate、solarizeです。
	  desaturate、solarize以外は、ボタンを複数回押すとエフェクトの効果が上がっていきます。
	  複数のエフェクトを組み合わせることができます。
	  エフェクトを組み合わせると、処理に時間がかかります。多くのエフェクトを組み合わせると、ブラウザがハングアップします。
	  エフェクトは、スライドショーで次の画像にも反映されます。
	  全画面スライドショーにも、反映されます。壁紙タイプの場合は、反映されません。
	  IEでは、この機能は使えません。
	・修正モジュール
		・db_tool/mysql-database.php, mysql-table-list.php, excel-import.php
		・photo/index.php, slide.php
		・__define_common_my_sample.php
	・追加モジュール
		・db_tool/csv-import.php, __define_csv-import.php

【修正履歴：Ver.2.15】
	・アルバムやファイルマネージャーで、ネットワークドライブが使えない問題の解決策はみつかっていませんが、
	  UNC表記(例：\\HostName\Folder)であれば可能なことが判明。
	  しかし、アルバムやファイルマネージャーでUNC表記を使った時にフォルダ移動すると//が/になってしまう不具合があったので修正。
	  UNC表記を使う場合、サーバ名だけではダメで、必ずディレクトリの最上位階層も含めて指定する必要があります。
	・ユーザーによるアカウント登録ページで、CAPTCHA(認証用絵文字コード)を使用しない設定を可能に。定義ファイルで設定してください。
	・アルバムの全画面スライドショーに壁紙タイプを追加。画像をタイル形式で並べて表示します。
	・修正モジュール
		・__common__/include-common-all.php, __define_common.php
		・tools/file-manager.php, code-file-view.php, html-get-url-img.php, index.php
		・db_tool/backup-mydb.php
		・photo/index.php, slide.php
		・account/newaccount-confirm.php, __define.php, __include-login.php
		・setup-sample.php, __define_common_my_sample.php

【修正履歴：Ver.2.14】
	・カレンダーのスケジュール入力画面において、textareaへの文字の色付などのタグ挿入で、
	  ChromeとSafariでは文字列を右から左に選択した場合、正しい位置にタグ挿入できなかったのを修正。
	・textareaの文字列選択によるタグ挿入のJavaScriptを、textarea.jsから、getRange_in_textarea.jsに変更。
		getRange_in_textarea.jsは、Archiva.jpの以下のものを使わせていただきました。
		http://archiva.jp/web/javascript/getRange_in_textarea.html
	・チャットでURLを入力した場合、Aタグ挿入しリンク表示するようにしました。タグテキストは短く表示します。
	・ツールに「縦計だけの表計算」を追加。縦計だけのシンプルな表計算シートです。
	  各セルには、()付きの数式の入力もできます。数式の計算はJavaScriptのeval()を使っていますので、JavaScriptの数学関数(Math)も使えます。
	  数字以外は、JavaScriptとして評価して実行しますので、ご注意ください。例えば、「alert(Date());」なども実行できます。
	・修正モジュール
		・calendar/input.php
		・chat/read.php, read-min.php
		・__common__/include-common-all.php, include-common-html.php
	・追加モジュール
		・tools/calc.php
		・scripts/getRange_in_textarea.js

【修正履歴：Ver.2.13】
	・住所録のPDF葉書宛名書きの印刷フォントをゴシック体/明朝体から選択ができるようにしました。
	  住所録定義ファイル__define_abook_pdf_my.phpで設定してください。
	・住所録でローマ数字(ⅠⅡⅢⅣⅤ)を表示するために、PEAR/Numbers/Roman.phpを使っていたのを使わない方法に変更。
	  なおかつ、環境依存文字のローマ数字自体を使わずに、I、II、III、IV、Vで代用。
	・ⅠⅡⅢⅣⅤのチェックボックスを、見出しを定義しているもののみ表示するように変更。
	  見出しの定義は、「チェック項目見出し編集」で行ってください。
	・MyHome Portal全体のアンカータグのリンク文字色を青色から変更。
	・(簡易) 預貯金管理のkakeibo/list.phpのテーブル指定が、v_keiyakuShaになっていたのを、v_keiyakushaに修正。Linux環境で動作可能にするため。
	・ツールに「Photoshop-like JavaScript Color Picker」追加。
		Powered by http://johndyer.name/post/2007/09/PhotoShop-like-JavaScript-Color-Picker.aspx
	・修正モジュール
		・abook/以下一式
		・kakeibo/list.php
		・style/original/common.css, tools_common.css, abook.css
		・__common__/include-common-all.php
		・__define_abook_pdf_my_sample.php
	・追加モジュール
		・tools/colorpicker.php
		・tools/refresh_web/以下一式

【修正履歴：Ver.2.12】
	・新コンテンツ「住所録」を追加。選択した名簿の電子メール宛名一覧作成、Google Maps & Earthマップ作成、PDF葉書宛名書き等ができます。
	・My設定のアカウント情報に、〒番号、住所2を追加しました。
	・既に前のバージョンで実運用中の場合は、「住所録」を追加するために、以下の手順により環境設定してください。
	【サンプルモード】
	  まず、サンプルモード用データベース「_db_abook」を登録します。
	  コマンドプロンプトから以下を実行してください。以下、MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	  また、インストールディレクトリをDドライブとして説明します。
		mysql -u root -pkanri789
		create database _db_abook;
		exit;

		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_abook < _db_abook.bk.txt
		mysql -u root -pkanri789 _db_abook < create_view_db_abook.txt

		mysql -u root -pkanri789
		GRANT SELECT,INSERT,UPDATE,DELETE ON _db_abook.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit;
	【実運用モード】
	・実運用定義ファイル__define_common_my.phpに、実運用データベースの定義を追加してください。
	  __define_common_my_sample.phpを参考にしてください。
		define("_DB_SCHEMA_abook", _mydb_abook);
	・コンテンツ定義ファイル__define_contents_my.phpに、コンテンツの追加をしてください。
	  __define_contents_my_sample.phpを参考にしてください。
		$navi_item[] = array("href"=>"abook/", "query"=>"", "name"=>"住所録");
	・データベース「_db_abook」をコピーして、実運用データベース「_mydb_abook」を作成します。
	  MySQLを一旦停止します。XAMPPコントロールパネルを使って停止してください。
		mkdir D:\xampp\mysql\data\_mydb_abook
		copy D:\xampp\mysql\data\_db_abook\* D:\xampp\mysql\data\_mydb_abook
	  MySQLを再起動します。XAMPPコントロールパネルで「開始」を押してください。コマンドプロンプトから以下を実行してください。
		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_abook < create_view_mydb_abook.txt

		mysql -u root -pkanri789
		GRANT SELECT,INSERT,UPDATE,DELETE ON _mydb_abook.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit;
	  サンプルデータベースからコピーされた住所録をクリアします。
		mysql -u root -pkanri789
		use _mydb_abook;
		truncate table m_abook;
		truncate table m_category;
		truncate table m_check_caption;
		exit;
	・既に前のバージョンで実運用中の場合は、MySQLデータベース_db_account、_mydb_accountのテーブル「m_account」に、
	  列「c_home_address2」を追加してください。 コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	【サンプルモードDB】
		mysql -u root -pkanri789
		use _db_account;
		ALTER TABLE m_account ADD c_home_address2 varchar(200) NOT NULL;
		ALTER TABLE m_account ADD c_zip1 varchar(10) NOT NULL;
		ALTER TABLE m_account ADD c_zip2 varchar(10) NOT NULL;
		exit;
		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_account < create_view_db_account.txt
	【実運用DB】
		mysql -u root -pkanri789
		use _mydb_account;
		ALTER TABLE m_account ADD c_home_address2 varchar(200) NOT NULL;
		ALTER TABLE m_account ADD c_zip1 varchar(10) NOT NULL;
		ALTER TABLE m_account ADD c_zip2 varchar(10) NOT NULL;
		exit;
		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_account < create_view_mydb_account.txt
	・既に前のバージョンで実運用中の場合は、実運用定義ファイル__define_common_my.phpに以下を追加してください。
	 	define("ATTACH_FILE_FOLDER_abook", "../../_attach/abook/");
	・PDF作成には、FPDFを利用しています。
		http://www.fpdf.org/
		    ・FPDF
		    ・MBFPDF
		    ・Rotations
		http://www.setasign.de/products/pdf-php-solutions/fpdi/
		    ・FPDI
		    ・FPDF_TPL
	・PDF葉書宛名書きでは、以下のRapid Expressで公開されているpdf.inc.phpを利用させてもらっています。
	  文字列の長さに合わせてフォントサイズの調整もしてくれる優れものです。
		Rapid Express：PDF作成ライブラリ(FPDF+FPDI+MBFPDF+Rotations)
		http://wp.rapidexp.com/2009/01/fpdf/
	・IE以外のChrome、Safariなどのブラウザで、INDEXトップが「リンク先を新しいウインドウで開く」設定になっている場合、
	  先頭の(Google)検索ボタンで開いたウインドウを閉じてしまうと、2回目以降、ウインドウが開かない不具合を修正。
	  (formタグのtarget指定では、同様の不具合が発生する模様)
	・カレンダーの今日が休みの場合、日付の色が赤色にならなかったのを修正。
	・修正モジュール
		・account/list-user.php, myprofile.php, edit-myprofile.php
		・index/__define_index_search.php
		・__define_index_search_my_google.php, __define_index_search_my_yahoo.php
		・calendar/_my_calendar.php
		・style/original/calendar.css
		・__common__/include-common-mp-list.php
	・追加モジュール
		・abook/以下一式
		・pdf/以下一式 (FPDF関係ライブラリを含む)
		・style/original/abook.css
		・__define_abook_pdf_my_sample.php

【修正履歴：Ver.2.11】
	・INDEX、メモ、学習、(簡易) 預貯金管理 、ユーザ一覧に、「一括修正/追加/削除」とは別に、
	  一覧形式の追加専用「一括追加」を追加しました。
	・修正モジュール
		・index/list.php
		・memo/list.php
		・study/list.php
		・kakeibo/list.php
		・account/list-user.php
		・__common__/include-common-mp-list.php

【修正履歴：Ver.2.10】
	・カレンダー入力画面に、URL挿入ボタン「Ｌ」を追加しました。
	・修正モジュール
		・calendar/input.php

【修正履歴：Ver.2.09】
	・ツール「(簡易) 預貯金管理」の「預貯金一覧」に検索フィルタ「解約状態」を追加。
	・修正モジュール
		・kakeibo/list.php
	・追加モジュール
		・kakeibo/list-my-add-filter.php

【修正履歴：Ver.2.08】
	・トップINDEXの「●」ボタンの検索を、「Google Maps & Earth」から「Google Maps & Earth (複数地点/マーカー付)」に変更。
	・トップINDEXの検索で、複数キーワードの区切りスペースの全角から半角への変換が1つのみしか対処していなかった点を修正。
	・カレンダーの「マップ」およびツールの「Google Maps & Earth(...)」のマップの高さサイズをディスプレイのサイズを判断して
	  多少調整するようにしました。
	・修正モジュール
		・index/__define_index_search.php
		・calendar/maps.php, maps-alone.php
		・calendar/maps-include.php, __html-my-header-maps.php, __html-my-header-maps-alone.php
		・tools/google-maps-earth.php, google-maps-earth-marker.php, google-maps-earth-marker-uncertain.php
		・__define_index_search_my_google, __define_index_search_my_yahoo.php

【修正履歴：Ver.2.07】
	・カレンダーの「マップ」と、ツールの「Google Maps & Earth(複数地点/マーカー付)」のロジック修正。
	・表示地点が多い場合、全ての地点が表示されない点を改善。(取得できない地点は、タイミングによって不定です。)
	  サーバー側でURL引数によるMaps APIジオコーダを使って緯度経度を取得する方式に変更。
	  ただ、この方式にしても、取得地点が多いとタイミングによって取得できない場合あり。
	  1地点取得毎に0.1秒程度時間遅延すると取得できる頻度が上がるため、ロジックに時間遅延を入れています。
	  よって地点が多いと地図が表示されるまで時間がかかります。緯度経度情報が取得できなかった地名をウインドウの下にNot foundとして表示します。
		＜参考：サーバー側のスクリプトを直接使用して、Maps APIジオコーダにアクセス＞
		http://q.hatena.ne.jp/1194229236
		http://code.google.com/intl/ja/apis/maps/documentation/services.html#Geocoding_Direct
		＜参考：イベントリスナでクロージャを使用＞
		http://blog.hansode.org/archives/51763965.html
		http://code.google.com/intl/ja/apis/maps/documentation/mapplets/events.html#Event_Closures
	・ロジック修正前の「Google Maps & Earth(複数地点/マーカー付)」を不確実版として残しています。
	  地点数が多い場合、すべてを表示できない可能性が高いです。
	・修正モジュール
		・calendar/maps-include.php, __html-my-header-maps.php, __html-my-header-maps-alone.php
		・tools/google-maps-earth-marker.php
		・__common__/include-common-all.php
	・追加モジュール
		・tools/google-maps-earth-marker-uncertain.php

【修正履歴：Ver.2.06】
	・カレンダーの一覧、マップの検索フィルタの不具合を修正。
	・修正モジュール
		・calendar/list-my-add-filter.php, _contents-header.php, maps-include.php

【修正履歴：Ver.2.05】
	・カレンダーの「マップ」とツールの「Google Maps & Earth(複数地点/マーカー付)」のロジック修正。
	  マーカー表示地点が多いと地図を表示できなくなる不具合を修正。
	・カレンダーに「マップ(別窓)」を追加。マップの全画面タイプです。別ウインドウで開きます。
	・修正モジュール
		・calendar/maps.php, __html-my-header-maps.php, _contents-header.php
		・tools/google-maps-earth-marker.php
		・__common__/include-common-html.php, include-common-all.php
	・追加モジュール
		・calendar/maps-alone.php, maps-include.php, __html-my-header-maps-alone.php

【修正履歴：Ver.2.04】
	・カレンダーにGoogle Maps APIを使ったマップ機能を追加しました。
	  カレンダーに登録されている場所をGoogleマップでマーカー表示します。
	  件名に地図チェックが付いているスケジュールが対象です。
	  検索条件にあった地点全てを表示します。去年旅行で行ったところの一覧地図といった感じで使えます。
	  同じ場所が複数ある場合、マーカーは１つにまとめます。
	  マーカーをクリックすると、スケジュールの日付とスケジュール内容を表示します。
	  Google Earth 表示もできます。
	・カレンダーの一覧表示の週間指定で、月を跨った場合、ただしく検索されない不具合を修正しました。
	・定義ファイルの定義名の英語の綴りが間違っていたのを、修正しました。
		define("SCHEDULE_VIEW_FRAME_COLOR_index", "#228b22");	// スケジュール表示 枠カラー
		define("SCHEDULE_VIEW_DAY_index", 3);			// スケジュール表示 日数
	・ツールに「Google Maps & Earth (複数地点/マーカー付) 」を追加しました。 Google Maps & Earthのマーカー付きのタイプです。
	  複数地点をスペースで区切って入力できます。
	・修正モジュール
		・calendar/_contents-header.php, list-my-add-filter.php, list-my-template.php
		・__common__/include-common-all.php, include-common-html.php
		・tools/google-maps-earth.php
		・__define_common_my_sample.php
	・追加モジュール
		・calendar/maps.php, __html-my-header-maps.php ・tools/google-maps-earth-marker.php, index.php

【修正履歴：Ver.2.03】
	・カレンダーの件名でも、Googleマップの地図検索と経路検索と連携ができるようにしました。
	  スケジュール入力画面の件名欄右のチェックボックス「地図」にチェックを入れると、
	  カレンダー月間表示に「→地図」「→経路」のリンクが表示され、クリックするとGoogleマップで検索します。
	・既に2.02以前のバージョンで実運用中の場合は、MySQLデータベース_db_calendar、_mydb_calendarのテーブル「m_schedule」に、
	  列「c_map」を追加してください。 コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
		【サンプルモードDB】
			mysql -u root -pkanri789
			use _db_calendar;
			ALTER TABLE m_schedule ADD c_map int unsigned NOT NULL;
			exit;
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_calendar < create_view_db_calendar.txt
		【実運用DB】
			mysql -u root -pkanri789
			use _mydb_calendar;
			ALTER TABLE m_schedule ADD c_map int unsigned NOT NULL;
			exit;
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_calendar < create_view_mydb_calendar.txt
	・アルバムの全画面表示で、写真のページ数を表示するようにしました。
	・ツールの「ファイル暗号化/復号化＋ファイルマネージャー」を、「(簡易)ファイルマネージャー(暗号化/復号化付き)」に名称変更。
	・ツール「ファイルマネージャー」に、unZIP機能追加。(unZipは、元のタイムスタンプは保存されません。)
	・ツール「ファイルマネージャー」に、フォルダコピー、リネーム、削除機能追加。
	・ツール「ファイルマネージャー」に、ファイルダウンロード機能追加。ファイル名クリックでダウンロードします。
	・修正モジュール
		・calendar/input.php, _my_calendar.php
		・z_db_backup/create_view_db_calendar.txt, create_view_mydb_calendar.txt
		・photo/slide.php
		・tools/index.php, code-file-view.php
		・tools/file-manager.php
		・tools/file-rename.php, file-copy.php, file-delete.php, file-cipher.php
		・__common__/include-common-all.php
	・追加モジュール
		・tools/folder-copy.php, folder-delete.php, folder-rename.php
		・tools/file-unzip.php, file-download.php

【修正履歴：Ver.2.02】
	・アルバムに全画面表示タイプのスライドショーを追加。
	  F11キーと組み合わせると、パソコン画面一杯でスライドショーができます。
	  左右の＜＞キーで前後の画像に移動できます。
	  画面下の×クリックで通常のスライド画面に戻ります。
	  オートプレイやオートプレイの繰り返しもできます。
	「Google Maps & Earth」のcssに「overflow: hidden;」を追加。
	・修正モジュール
		・photo/index.php
		・tools/google-maps-earth.php
	・追加モジュール
		・photo/slide.php

【修正履歴：Ver.2.01】
	・ツールに「Google Maps & Earth」を追加。
	  Google Maps API とGoogle Earth APIを組み合わせたツールです。
	  検索した地図を、Google Earth APIを使って3D立体表示にできます。
	  3D地図を表示するためには、Google Earth プラグインをインストールする必要があります。
		http://code.google.com/intl/ja/apis/earth/
	  url引数に、場所とズーム倍率を指定できるようにもしています。
		http://localhost/_myhome/tools/google-maps-earth.php?addr=%e6%9d%b1%e4%ba%ac%e3%82%bf%e3%83%af%e3%83%bc&zoom=18
	・Google MAPS APIキーは、http://code.google.com/apis/ajax/playground/のサンプルのものを記述しています。
	  このツールをインターネット上で使う場合は、Google MAPS APIキーを取得して、そのキーを使用願います。
	・INDEXトップページに、このGoogle Maps & Earth検索用ボタン●を追加。
	・修正モジュール
		・index/__define_index_search.php
		・tools/index.php
		・__define_common_my_sample.php
	・追加モジュール
		・tools/google-maps-earth.php

【修正履歴：Ver.2.00】
	・Ver.1.00リリースから約1年ということで、Ver.2.00としました。
	・メインコンテンツとして「学習」を追加。任意の問題集を登録して、自学習に使えます。
	  英会話の英文と日本文を登録するなどして、ご利用ください。ユーザー各自の理解度を記録できます。
	  Ajaxにより、マウスクリックだけでデータベースに記録できます。質問や解答をそれぞれ隠すこともできます。
	  質問や解答の上にマウスを重ねると、それぞれ解答と質問がツールチップ表示されます。表示順序をランダムにすることもできます。
	・問題集のサンプルデータとして、以下の2つを使わせていただきました。
		＜できるといいな英会話(Excel版)＞
			http://www.vector.co.jp/soft/win95/edu/se143894.html
		＜「実践例蓄積型」の英会話集＞
			http://www5f.biglobe.ne.jp/~newseastory/
	・問題集を、MySQL管理ツールを使って、Excelシートから一括アップロードすることもできます。
	・既にMyHome Portalをご利用の方は、「学習」を追加するために、以下の手順により環境設定してください。
	【サンプルモード】
	・まず、サンプルモード用データベース「_db_study」を登録します。
	・コマンドプロンプトから以下を実行してください。以下、MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。また、インストールディレクトリをDドライブとして説明します。
		mysql -u root -pkanri789
		create database _db_study;
		exit;

		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_study < _db_study.bk.txt
		mysql -u root -pkanri789 _db_study < create_view_db_study.txt

		mysql -u root -pkanri789
		GRANT SELECT,INSERT,UPDATE,DELETE ON _db_study.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit;
	【実運用モード】
	・実運用定義ファイル__define_common_my.phpに、実運用データベースの定義を追加してください。
		__define_common_my_sample.phpを参考にしてください。
		define("_DB_SCHEMA_study", _mydb_study);
	・コンテンツ定義ファイル__define_contents_my.phpに、コンテンツの追加をしてください。
		__define_contents_my_sample.phpを参考にしてください。
		$navi_item[] = array("href"=>"study/", "query"=>"", "name"=>"学習");
	・データベース「_db_study」をコピーして、実運用データベース「_mydb_study」を作成します。
	・MySQLを一旦停止します。XAMPPコントロールパネルを使って停止してください。
		mkdir D:\xampp\mysql\data\_mydb_study
		copy D:\xampp\mysql\data\_db_study\* D:\xampp\mysql\data\_mydb_study
	・MySQLを再起動します。XAMPPコントロールパネルで「開始」を押してください。コマンドプロンプトから以下を実行してください。
		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_study < create_view_mydb_study.txt

		mysql -u root -pkanri789
		GRANT SELECT,INSERT,UPDATE,DELETE ON _mydb_study.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit;
	・サンプルデータベースからコピーされたMyチェックデータをクリアします。
		mysql -u root -pkanri789
		use _mydb_study;
		truncate table m_mycheck;
		exit;
	・サンプルデータベースからコピーされたサンプル問題集一式も削除する場合、次を実行してください。
		mysql -u root -pkanri789
		use _mydb_study;
		truncate table m_study;
		truncate m_category;
		truncate m_category2;
		exit;
	・z_db_backup以下のファイルが、ブラウザからダウンロードできないように、.htaccessを追加。
	・デザインの微調整。
	・修正モジュール
		・__common__/__define_contents.php, include-common-mp-list.php
		・_style/original/common.css
		・___define_common_my_sample.php, __define_contents_my_sample.php
		・_setup-sample.php
		・_db_backup.txt.php, db_restore.txt.php
		・db_tool/backup-mydb.php
	・追加モジュール
		・study/以下一式
		・scripts/jquery.cookie.js
		・_style/original/study.css
		・_z_db_backup/_db_study.bk.txt, create_view_db_study.txt, create_view_mydb_study.txt
		・z_db_backup/.htaccess

【修正履歴：Ver.1.71】
	・ツール「実運用環境バックアップ」のバックアップ先ディレクトリ指定を、Windows物理パス指定ができるように変更。
	  Ver.1.70以前の/xampp/htdoc以下のパス指定では、バックアップファイルがWeb経由でダウンロードできてしまい、セキュリティ上問題です。
	  「実運用環境バックアップ」を使う場合、実運用定義ファイルに追加した定数「BACKUP_MYDB_DIR_REAL」のコメントアウトを外して、
	  /xampp/htdocsの下以外のディレクトリを指定してください。
		//define("BACKUP_MYDB_DIR_REAL", "D:/_myhome_backup");	//←優先(物理パス)
	  Ver.1.70以前で作成されたディレクトリ「/xampp/htdoc/_myhome_backup」は安全のため、必ず削除してください。
	・修正モジュール
		・db_tool/backup-mydb.php
		・__define_common_my_sample.php

【修正履歴：Ver.1.70】
	・「ファイル暗号化/復号化」「実運用環境バックアップ」の暗号化方式の変更。関数Crypt_Blowfishを使った方式にしました。
	  前のバージョンで暗号化したファイルと区別するために、ファイル拡張子を.encode3にしました。
	・Crypt_Blowfishでの暗号化では、ファイルサイズが大きいとエラー(Out of memory)になるため、ファイルサイズの制限を設定をしました。
	  定義ファイルで約50MBに設定しています。
	・「ファイル暗号化/復号化」では、チェックボックスで「XORで暗号化」を選択することもできます。
	  ただし、暗号化キーコードが推測されるリスクがあります。
	・「実運用環境バックアップ」では、実運用定義ファイルで暗化方式を選択できます。
	・「PHP/JavaScriptソースコード表示&編集」「ファイル暗号化/復号化」のファイルマネージャー部分にファイル削除機能追加。
	  ゴミ箱に入るわけではなく、実際に削除されますので、ご注意ください。
	・一部のツールのCSSを一部統一。
	・修正モジュール
		・tools/file-manager.php, file-cipher.php, __include-file-cipher.php
		・tools/code-file-view.php
		・tools/html-text-mail.php, html-get-url-img.php
		・db_tool/backup-mydb.php, mysql-database.php, mysql-table-list.php, excel-import.php
		・style/original/db_tools.css
		・__define_common_my_sample.php
	・追加モジュール
		・tools/file-delete.php
		・style/original/tools_common.css
	・ファイル名変更モジュール
		・tools/file-copy.php, file-rename.php

【修正履歴：Ver.1.69】
	・ツール「ファイル暗号化」で、暗号化ファイル内に暗号化キーコードがそのまま見えてしまう場合がある問題の対策。
	  （小手先の対策ですが）
	・ツール「ファイル暗号化」で、ファイルサイズが大きいとエラーになってしまう問題の対策。
	  ファイルサイズに関係なく処理できるようにしました。ただし、処理時間がかなりかかります。
	・修正モジュール
		・tools/file-manager.php, __include-file-cipher.php

【修正履歴：Ver.1.68】
	・「ファイル暗号化＋ファイルマネージャー」ツールを追加。ファイルの暗号化と復号化ができます。
	  実運用定義ファイルで暗号化キー「FILE_MANAGER_CIPHER_SEED」を設定しておく必要があります。
	  利用開始後、「FILE_MANAGER_CIPHER_SEED」を変更すると、それ以前に暗号化したファイルは復元できなくなります。
	・ツール「実運用環境バックアップ」にファイル暗号化機能追加。
	  バックアップ実行ボタンを2度押しすると、ハングアップするので、ボタン2度押し禁止設定。
	・定義ファイルのバックアップ先ディレクトリを相対パスから絶対パスに変更しましたので、ご注意ください。
		define("BACKUP_MYDB_DIR", "/_myhome_backup");
	・IEでウインドウの横幅を狭くすると、ページ右上メニューが縦長になってしまう問題を修正。
	  (リストでの対策が分からなかったのでテーブルに変更して対処。common.cssも修正。)
	・ID管理のID/パスワードの暗号化強化。実運用定義ファイルで「_DB_ANGOUKA_KEY_EOR」を設定すると暗号化を2重に行います。
	  _DB_ANGOUKA_KEY_EORの文字列と排他的論理和での暗号化を行います。
	・ID管理でID/パスワード入力欄に長い日本語文字列を入力する場合は、ID管理用データベース「_db_zid_mgr_b」「_mydb_zid_mgr_b」の
	  テーブル「m_pass2」のカラム「c_val1」～「c_val6」の桁数を大きくしてください。全角で50文字程度入力する場合は、varchar(700)程度にしてください。
	  コマンドプロンプトから以下を実行してください。MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
		mysql -u root -pkanri789
		use _mydb_zid_mgr_b;
		alter table m_pass2 modify c_val1 varchar(700) NOT NULL;
		alter table m_pass2 modify c_val2 varchar(700) NOT NULL;
		alter table m_pass2 modify c_val3 varchar(700) NOT NULL;
		alter table m_pass2 modify c_val4 varchar(700) NOT NULL;
		alter table m_pass2 modify c_val5 varchar(700) NOT NULL;
		alter table m_pass2 modify c_val6 varchar(700) NOT NULL;
		exit;
	・定義ファイルの動画定義定数「IS_VIDEO_EXT」にAVCHDの拡張子「m2ts」を追加。
	・修正モジュール
		・__common__/__define_common.php, include-common-html.php
		・tools/file-copy.php, file-rename.php
		・db_tool/backup-mydb.php
		・style/original/common.css
		・__define_common_my_sample.php
	・追加モジュール
		・tools/file-manager.php, file-cipher.php, __include-file-cipher.php

【修正履歴：Ver.1.67】
	・ツールにシステム管理者用ツール「実運用環境バックアップ」を追加。
	  実運用定義ファイル「__define_common_my.php」と実運用データベースのバックアップをします。
	  MySQLデータベースをmysqldumpでバックアップします。
	  実運用定義ファイル「__define_common_my.php」と、MySQLデータベースバックアップファイルを、ZIPファイルに圧縮します。
	・スタイルシートのうち、common.cssを別ディレクトリから参照できるように、定義ファイルを変更。
	  common.cssを別ディレクトリにコピーし、カスタマイズしてご利用ください。
	  実運用定義ファイルの以下の部分を修正してください。(以下は修正例)
		 define("_STYLE_SHEET_FOLDER_COMMON", "../../_myhome_myset");
	・トップページ検索ボタンの百度をFresheye(コトバノウチュウ)に変更。
	・トップページ用サンプルブログパーツを、NHK NewsからGoogle Newsに再変更。
	・RSSサンプルデータベース_db_rssも、NHK NewsからGoogle Newsに再変更。
	・修正モジュール
		・__common__/__define_common.php
		・tools/index.php
		・blog-parts/rss-google-news.inc
		・__define_common_my_sample.php
		・common.cssを参照しているすべてのモジュール
		・index/__define_index_search.php
		・__define_index_search_my_google.php
		・__define_index_search_my_yahoo.php
	・追加モジュール
		・db_tool/backup-mydb.php
		・db_tool/CreateZipFile/一式

【修正履歴：Ver.1.66】
	・トップページ検索ボタンが、下のインデックス部分が4列未満でも改行しないように変更。
	・トップページ検索キーの全角スペースを半角スペースに置き換えるようにしました。
	・トップページ用サンプルブログパーツを、Google Newsの代わりにNHK Newsに変更。
	・RSSサンプルデータベース_db_rssも、Google NewsからNHK Newsに変更。
	・修正モジュール
		・__common__/__define_common.php
		・index/__define_index_search.php
		・__define_common_my_sample.php, __define_index_search_my_google.php, __define_index_search_my_yahoo.php
		・z_db_backup/_db_rss.bk.txt
	・追加モジュール
		・blog-parts/rss-nhk-news.inc
	・削除モジュール
		・blog-parts/rss-google-news.inc

【修正履歴：Ver.1.65】
	・トップページに、次の検索ボタンを追加。
	  Naver、Bing、ブログ(Google)、天気(tenki.jp)、料理(Cookpad)、料理(キッコーマン)、
	  価格.com、楽天、Amazon、Yahooオークション、YouTube、Twitter
	・トップページ検索ボタン部分を別モジュール化し、ユーザーがカスタマイズできるようにしました。
	  不要なボタンを外したり、順番を入れかえたりできます。
	  HTMLとJavaScriptが少し分かる人なら、ボタンの追加など自由な編集が可能です。
	  カスタマイズ用の検索ボタンモジュールとして、Yahoo検索ボタンを先頭にしたタイプも用意しました。
	  カスタマイズする場合、__define_index_search_my_google.php, __define_index_search_my_yahoo.phpの２つのファイルを、
	  実運用環境ディレクトリ(/htdocs/_myhome_myset/)にコピーして編集してください。
	  実運用定義ファイルの以下の部分を変更してください。
	  _DEFINE_INDEX_SEARCH_MYで検索ボタンモジュールを指定してください。
	  __define_index_search_my_yahoo.phpを使う場合は、SEARCH_FORM_INPUT_TEXT_NAME_indexを"p"にしてください。
		// ★ index トップページ 検索ボタン定義ファイル
		define("_DEFINE_INDEX_SEARCH_MY", "");
		// define("_DEFINE_INDEX_SEARCH_MY", "../../_myhome_myset/__define_index_search_my_google.php");
		// define("_DEFINE_INDEX_SEARCH_MY", "../../_myhome_myset/__define_index_search_my_yahoo.php");
		// ★ index トップページ 検索フォーム優先サイト NAME属性
		define("SEARCH_FORM_INPUT_TEXT_NAME_index", "q");	// (Googleの場合)
		//define("SEARCH_FORM_INPUT_TEXT_NAME_index", "p");	// (Yahooの場合)
	・修正モジュール
		・index/top.php, __define.php
		・__common__/__define_common.php
		・__define_common_my_sample.php
	・追加モジュール
		・index/__define_index_search.php
		・__define_index_search_my_google.php
		・__define_index_search_my_yahoo.php

【修正履歴：Ver.1.64】
	・不具合修正です。Ver.1.63で、PHP5.3.0以降非推奨の関数split()をexplode()に置き換えましたが、
	  正規表現を使っている箇所ではpreg_split()に置き換えました。
	  しかし、split()とpreg_split()の正規表現の違いをチェックしていなかったため、
	  ID管理のスペースとハイフンによるセパレート機能が働かなくなっていました。この不具合を修正。
	・修正モジュール
		・id-manager/list-my-template.php
		・id-manager/view-idpass.php

【修正履歴：Ver.1.63】
	・ツール「HTML URL抽出&ファイルダウンロード 」を追加。ホームページのHTMLからAタグのURLを抽出します。
	  AタグやIMGタグの画像や動画等のファイルをダウンロードすることもできます。
	  ダウンロードファイルの保存先は、サーバーローカルディスクの任意のディレクトリを指定できます。
	・関数split()が、PHP5.3.0以降非推奨となったため、explode()に置き換えました。
	・修正モジュール
		・tools/index.php
		・__common__/__define_common.php
		・__define_common_my_sample
		・関数split()を使っていた全てのモジュール
	・追加モジュール
		・tools/html-get-url-img.php

【修正履歴：Ver.1.62】
	・ツール「HTMLテキスト抽出&メール送信」のテキスト抽出ロジックを修正。
	・ツール「HTMLテキスト抽出&メール送信」にリセットボタンを追加。
	・修正モジュール
		・tools/html-text-mail.php

【修正履歴：Ver.1.61】
	・ツールに「HTMLテキスト抽出&メール送信」を追加しました。
	  ホームページのURLを入れてボタンを押すと、HTMLからテキストのみを抽出します。
	  抽出したテキストから編集で必要な部分のみを抜き出してメール送信できます。
	  メール送信先は、My設定でスケジュール送信先として登録してある電子メールアドレスです。
	・企業内イントラなどプロキシ経由の環境では、定義ファイルでプロキシサーバの設定をしてください。
		define("HTTP_PROXY_HOST", "");	// HTTP プロキシサーバ アドレス
		define("HTTP_PROXY_PORT", "");	// HTTP プロキシサーバ ポート
	・ID管理で、値に半角スペースが含まれている場合も、-によるセパレータ表示をするようにしました。
	・ID管理で、W↑をクリックすると、ID&パスワードの小ウインドウと該当ホームページのウインドウ2つを同時に開くようにしました。
	  ID&パスワードのコピー&ペーストがし易くなります。
	・修正モジュール
		・__common__/__define_common.php
		・id-manager/list-my-template.php, __define.php, input.php
		・tools/index.php
		・style/original/id-manager.css
		・__define_common_my_sample
	・追加モジュール
		・id-manager/view-idpass.php
		・tools/html-text-mail.php

【修正履歴：Ver.1.60】
	・ToDoおよびスケジュールを携帯電話等のメールアドレス宛に送信できるようにしました。
	  ユーザー各自が事前にMy設定で「スケジュール送信先」メールアドレスを登録しておく必要があります。
	・My設定で登録するメールアドレスを「パスワード忘れ用」と「スケジュール送信先」に分けました。
	  スケジュール送信先は携帯メール等を想定しています。
	・定義ファイルの電子メール関係の定数名を変更しました。
	・電子メール送信を、mb_send_mail()から、PEAR::Mailに変更しました。SMTP認証も使えるようにしました。
	  通常のプロバイダのメールアカウントでメール送信機能が使えます。
	  定義ファイルで送信者として使うEmailアカウントのユーザー名、パスワードを設定してください。
	・「パスワード忘れ」およびカレンダーの「メール送信」は、定義ファイルでそれぞれメール送信機能を使う設定にしないと表示されません。
	・ID管理で値に「-」が含まれている場合、-で区切ったボックス表示と-抜きのボックス表示をするようにしました。
	  クレジットカードのナンバを想定しています。サイトにより、4桁単位で入力するシステムと16桁一括で入力するシステムがあるのに対応するため。
	・ツールの預貯金管理で、小計もできるようにしました。並び替えのキーに合わせて小計を表示します。
	  並び替えキーを契約日と満期日にした場合は、それぞれ年単位で小計します。
	・実運用モードの掲示板の投稿者フィルタにテストモードのユーザーが表示されてしまう不具合を修正。
	・月間カレンダーで非公開スケジュールの背景をグレー表示するようにしました。
	・MySQLデータベース_db_accountのテーブル「m_account」に、列「c_email_calendar」を追加しました。
	  既に運用中のデータベースに列を追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	【サンプルモードDB】
		mysql -u root -pkanri789
		use _db_account;
		ALTER TABLE m_account ADD c_email_calendar VARCHAR(255) NOT NULL;
		exit
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_account < create_view_db_account.txt
	【実運用DB】
		 mysql -u root -pkanri789
		use _mydb_account;
		ALTER TABLE m_account ADD c_email_calendar VARCHAR(255) NOT NULL;
		exit
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_account < create_view_mydb_account.txt
	・修正モジュール
		・__common__/__define_common.php, include-common-all.php
		・account/__define.php, edit-myprofile.php, forgot-pass.php, myprofile.php, login.php, logout.php
		・calendar/send-mail.php, _contents-header.php, _my_calendar.php
		・bss/list-my-add-filter.php
		・id-manager/list-my-template.php
		・kakeibo/list.php, list-my-template.php
		・style/original/common.css, id-manager.css
		・__define_common_my_sample
	・追加モジュール
		・calendar/send-mail.php

【修正履歴：Ver.1.59】
	・ToDo管理機能を追加しました。シンプルかつユニークなToDo機能です。優先順位の変更ができます。文字に色を付けられます。
	  Ajaxを利用して簡便な操作ができます。
	・MySQLデータベース_db_calendar/_mydb_calendarに、テーブル「m_todo」を追加しました。
	・既に運用中のシステムに、テーブルを追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	【サンプルモードDB】
		mysql -u root -pkanri789
		use _db_calendar;
		CREATE TABLE `m_todo` (
		  `id_todo` int(10) unsigned NOT NULL auto_increment,
		  `id_account` int(10) unsigned NOT NULL,
		  `c_todo` varchar(250) NOT NULL,
		  `c_color` varchar(50) NOT NULL,
		  `c_priority` int(10) signed NOT NULL default '0',
		  `c_registtime` datetime NOT NULL,
		  `c_updatetime` datetime NOT NULL,
		  `c_delete` int(10) unsigned NOT NULL default '0',
		  PRIMARY KEY  (`id_todo`)
		) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
		exit;
	【実運用モードDB】
		mysql -u root -pkanri789
		use _mydb_calendar;
		CREATE TABLE `m_todo` (
		  `id_todo` int(10) unsigned NOT NULL auto_increment,
		  `id_account` int(10) unsigned NOT NULL,
		  `c_todo` varchar(250) NOT NULL,
		  `c_color` varchar(50) NOT NULL,
		  `c_priority` int(10) signed NOT NULL default '0',
		  `c_registtime` datetime NOT NULL,
		  `c_updatetime` datetime NOT NULL,
		  `c_delete` int(10) unsigned NOT NULL default '0',
		  PRIMARY KEY  (`id_todo`)
		) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;
		exit;
	・チャットのAjaxでキャッシュが使われないようにしました。
	  IEの「インターネット一時ファイル」の設定が「自動的に確認する」になっている場合、キャッシュが使われてしまう問題の対策です。
	・チャットで入力欄が空白でもメッセージが追加されてしまう問題を修正。
	・INDEXトップページの掲示板表示では、１週間を過ぎたものは表示しないように変更。
	・各コンテンツの一覧画面の検索フィルタを選択した場合、IE以外でも背景色が変わるようにしました。
	・修正モジュール
		・__common__/__define_common.php, include-common-mp-list.phpp
		・bbs/list-my-add-filter.php
		・calendar/__define.php, _my_calendar.php, list-my-add-filter.php, month.php
		・bbs/list.php
		・index/__define.php, __html-my-header.php, top.php
		・styles/original/calendar.css, index.css, mp-list.css
		・__define_common_my_sample.php
	・追加モジュール
		・todo/一式
		・styles/original/todo.css
		・styles/original/icon/リストマークアイコン数種

【修正履歴：Ver.1.58】
	・ツールに「(簡易)預貯金管理」を追加。
	・「(簡易)預貯金管理」のデータベース「_db_kakeibo」を追加しました。
	・既に運用中のシステムに、データベースを追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	【サンプルモードDB】
		mysql -u root -pkanri789
		create database _db_kakeibo;
		exit;
		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_kakeibo < _db_kakeibo.bk.txt
		mysql -u root -pkanri789 _db_kakeibo < create_view_db_kakeibo.txt
		mysql -u root -pkanri789
		GRANT SELECT,INSERT,UPDATE,DELETE ON _db_kakeibo.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit;
	【実運用モードDB】
		MySQLを一旦停止します。XAMPPコントロールパネルを使って停止してください。
		サンプルデータベースを名前を変えてコピーすることで、実運用DB「_mydb_kakeibo」を作成します。
			mkdir D:\xampp\mysql\data\_mydb_kakeibo
			copy D:\xampp\mysql\data\_db_kakeibo\* D:\xampp\mysql\data\_mydb_kakeibo
		MySQLを再起動します。XAMPPコントロールパネルで「開始」を押してください。コマンドプロンプトから以下を実行してください。
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_kakeibo < create_view_mydb_kakeibo.txt
			mysql -u root -pkanri789
			GRANT SELECT,INSERT,UPDATE,DELETE ON _mydb_kakeibo.* TO myhome@localhost;
			FLUSH PRIVILEGES;
			exit;
		サンプルデータベースからコピーされたサンプルデータを削除します。
			mysql -u root -pkanri789
			use _mydb_kakeibo;
			truncate table m_chokin;
			truncate table m_category;
			exit;
	・カレンダーの年間表示の内部ロジック変更。スケジュール有無チェックのSQLクエリ発行を、
	  日単位から月1回に変更。年間スケジュール表示の高速化のため。これに合わせて、データベーステーブル「m_schedule」にインデックスを付与。
	  ただし、この修正による高速化は、スケジュール件数が数万件(?)程度以上にならないと効果は現れてきません。
	・既に運用中のシステムに、インデックスを付与する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
		【サンプルモードDB】
			mysql -u root -pkanri789
			use _db_calendar;
			ALTER TABLE m_schedule ADD INDEX (c_date);
			exit;
		【実運用モードDB】
			mysql -u root -pkanri789
			use _mydb_calendar;
			ALTER TABLE m_schedule ADD INDEX (c_date);
			exit;include-common-mp-list.phpの修正。
	・項目フィルタを複数可能にするなど、内部関数の引数変更を含む大幅修正。基本機能に大きな変更はありません。
	・「MyHome Portal サンプルDB自動セットアップ(setup-sample.php)」
	  「PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー(tools/__define_code-file.php)」で、
	  デフォルトディレクトリを$_SERVER['DOCUMENT_ROOT']を使うように変更。
	・MySQL管理ツールのソース修正。機能に変更はありません。
	・チャットのソース修正。機能に変更はありません。
	・修正モジュール
		・__common__/__define_common.php, include-common-mp-list.php, include-common-html.php
		・account/edit-friends.php, edit-public.php
		・calendar/list.php
		・bbs/list.php
		・tools/index.php
		・tools/__define_code-file.php ・styles/original/kakeibo.css
		・db_tool/一式
		・chat/一式
		・setup-sample.php
	・追加モジュール
		・kakeibo/一式
		・z_db_backup/_db_kakeibo.bk.txt, create_view_db_kakeibo.txt, create_view_mydb_kakeibo.txt
	・移動モジュール
		・db_tool/common.css→styles/original/common.css

【修正履歴：Ver.1.57】
	・ツールの「MySQL データベース/テーブル一覧」を、「MySQL管理ツール」と名称変更し、
	  「テーブルデータ一覧表示」「Excelインポート」機能を追加しました。
	・「テーブルデータ一覧表示」はページング機能付きです。列目クリックによる並び替えもできます。
	・「Excelインポート」では、Excelシートをアップロードして任意のデータベーステーブルにインポートできます。
	・修正モジュール
		・tools/index.php
		・__define_common_my_sample.php
	・追加モジュール
		・db_tool/一式
	・追加ディレクトリ
		・_attach/excel-imports/

【修正履歴：Ver.1.56】
	・掲示板に「お絵かき」機能を追加しました。お絵かきした絵をそのまま投稿できます。投稿後、修正もできます。
	・「お絵かき」の実現には、InputDrawを使用しています。
		http://www.mainada.net/inputdraw
	・MySQLデータベース_db_accountのテーブル「m_bbs」に、列「c_draw」を追加しました。
	  既に運用中のデータベースに列を追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
	【サンプルモードDB】
		mysql -u root -pkanri789
		use _db_bbs;
		ALTER TABLE m_bbs ADD c_draw longtext NOT NULL;
		exit
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _db_bbs < create_view_db_bbs.txt
	【実運用DB】 mysql -u root -pkanri789
		use _mydb_bbs;
		ALTER TABLE m_bbs ADD c_draw longtext NOT NULL;
		exit
		D:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pkanri789 _mydb_bbs < create_view_mydb_bbs.txt
	・修正モジュール
		・bbs/input.php, view.php, __define.php
		・__common__/__define_common.php
		・__define_common_my_sample.php
	・追加モジュール
		・scripts/inputdraw/一式

【修正履歴：Ver.1.55】
	・「チャット」を追加しました。MyHome Portalユーザー全員参加型のチャット(Chat)です。
	・INDEXトップページに最新(30分以内)の投稿3件分を表示されます。
	  Ajax利用していますので、Webページを開いたままでも、新しい投稿があれば、更新されます。
	  「チャット」をクリックすると、チャット入力ページを別ウインドウで表示します。
	・チャット入力ページでは、表示件数や投稿の経過時間を指定できます。
	・修正モジュール
		・__common__/__define_common.php
		・index/__define.php, top.php
		・style/original/index.css
		・__define_common_my_sample.php, db_backup.txt.php, setup-sample.php, db_restore.txt.php
	・追加モジュール
		・chat/一式
		・style/original/chat.css

【修正履歴：Ver.1.54】
	・アルバムで、FLV動画をプレビューできるようにしました。
	  ただし、ファイル名やパス名に日本語が含まれている場合は、プレビューできません。
	  ffmpegがインストールされていて、定義ファイルで以下が"YES"になっている必要があります。（インストール Ⅵ 参照）
		define("photo_VIDEO_FFMPEG", "YES");
		define("photo_VIDEO_PREVIEW", "YES");
	・アルバムのスライド表示で、画像の下にファイル名を表示するようにしました。
	・掲示板、メモ、アルバムのFLV動画プレビュー開始画面に、映像の最初の静止画を合わせて表示するようにしました。
	  ffmpegがインストールされていて、定義ファイルで以下が"YES"になっている必要があります。（インストール Ⅵ 参照）
		define("photo_VIDEO_FFMPEG", "YES");
	・修正モジュール
		・__common__/include-common-html.php, __define_common.php
		・photo/__define.php, index.php
		・scripts/JWPlayer/movie_preview.js
		・style/original/photo.css
		・__define_common_my_sample.php
	・追加モジュール
		・photo/player.swf, yt.swf

【修正履歴：Ver.1.53】
	・INDEXトップページの検索ボタンにGoogleブック検索を追加。
	・カレンダースケジュール入力で件名なしも許可するように仕様変更。件名なしの場合、
	  スケジュール修正画面を開くためのリンクを☆印で表示。件名なしの場合、詳細表示モードでなくても、詳細(本文)表示します。
	・My設定で「カレンダーで件名を使わずにスケジュール本文のみ使う」設定ができるようにしました。
	  この設定をすると入力画面に件名欄が表示されません。
	・カレンダーの週間(全員)表示で、Google経路検索の起点をそれぞれのユーザーが登録した住所を使うように修正。
	・MySQLデータベース_db_accountのテーブル「m_account」に、列「c_cal_sbj_use」を追加しました。
	  既に運用中のデータベースに列を追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
		【サンプルモードDB】
			mysql -u root -pkanri789
			use _db_account;
			ALTER TABLE m_account ADD c_cal_sbj_use VARCHAR(10) NOT NULL;
			exit
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_account < create_view_db_account.txt
		【実運用DB】
			mysql -u root -pkanri789
			use _mydb_account;
			ALTER TABLE m_account ADD c_cal_sbj_use VARCHAR(10) NOT NULL;
			exit
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_account < create_view_mydb_account.txt
	・修正モジュール
		・__common__/__define_common.php, include-common-mp-list.php
		・calendar/__define.php, input.php, _my_calendar.php, list.php, list-my-template.php
		・account/myprofile.php, edit-myprofile.php, __include-login.php
		・index/__define.php, top.php
		・__define_common_my_sample.php

【修正履歴：Ver.1.52】
	・カレンダーにGoogle地図、Google経路検索を連携できるようにしました。
	  カレンダーの本文入力で、駅名や住所を「地」ボタンで囲む(タグ<m></m>で囲まれます。)と、
	  スケジュール詳細表示で「→地図」が表示されます。これをクリックすると、Google地図が別ウインドウで開きます。
	  My設定で「住所 (経路起点)」を登録しておくと「→経路」も表示されます。これをクリックすると、Googleルートマップが別ウインドウで開きます。
	・My設定で住所（経路起点）を登録しておくと、INDEX(トップページ)の「経路(Google)」検索ボタンで、
	  目的地のみを入れて起点からのGoogleルート検索ができるようにしました。
	・INDEX(トップページ)の設定が「リンク先を新しいウインドウで開く」になっている場合、
	  検索ボタンを押した場合も新しいウインドウが開くように仕様変更。
	・【不具合情報】Google ChromeやSafariでは、カレンダー本文入力の「B」「I」「地」等のボタンによるタグ挿入で、
	  文字列をマウスで右から左に囲んだ場合、正しい位置にタグが挿入されません。
	・サンプルDB自動セットアップツール「setup-sample.php」を追加しました。
	・MySQLデータベース_db_accountのテーブル「m_account」に、列「c_home_address」を追加しました。
	  既に運用中のデータベースに列を追加する場合は、コマンドプロンプトから以下を実行してください。
	  MySQL管理者ユーザーrootのパスワードを「kanri789」として説明します。
		【サンプルモードDB】
			mysql -u root -pkanri789
			use _db_account;
			ALTER TABLE m_account ADD c_home_address VARCHAR(200) NOT NULL;
			exit
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _db_account < create_view_db_account.txt
		【実運用DB】
			mysql -u root -pkanri789
			use _mydb_account;
			ALTER TABLE m_account ADD c_home_address VARCHAR(200) NOT NULL;
			exit
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pkanri789 _mydb_account < create_view_mydb_account.txt
	・修正モジュール
		・account/myprofile.php, edit-myprofile.php, __include-login.php
		・index/top.php
		・calendar/input.php, _my_calendar.php, list-my-template.php
		・style/original/index.css, calendar.css
	・追加モジュール
		・setup-sample.php

【修正履歴：Ver.1.51】
	・「カレンダー」の入力画面およびポップアップウインドウの予定済みスケジュール表示のデザイン修正。
	・「カレンダー」の入力画面の時間入力欄の位置変更。
	・修正モジュール
		・calendar/input.php, _my_calendar.php, popup-schedule.php
		・style/original/calendar.css

【修正履歴：Ver.1.50】
	・「アルバム」のサムネイル表示、スライドショー表示の画像表示サイズを、横幅(width)一定でなく高さ(height)一定に仕様変更しました。
	・「アルバム」のスライドショー表示に、おまけ機能として、画像のジグソーパズル化ツールを追加しました。
	  任意の画像をジグソーパズルに出来ます。Snapfitを使っています。
	  IEでは正常動作しません。不要な場合は、定義ファイルで機能を除くこともできます。
		参考：http://phpspot.org/blog/archives/2009/03/javascriptsnapf.html
		Powered by http://www.netzgesta.de/snapfit/
	・IE7でiframeのheight="100%"ではフレームの縦が縮んでしまう対策としてheight="1000px"に変更。
	   外部コンテンツ組み込みサンプル(実運用サンプル/youtube/index.php)、ホームページのモノトーン表示、ホームページの拡大縮小表示をそれぞれ修正。
		<iframe src="" width="100%" height="100%"></iframe>
		↓↓↓
		<iframe src="" width="100%" height="1000px"></iframe>
	・修正モジュール
		・__common__/__define_common.php
		・photo/index.php, __define.php
		・tools/monotone.php, zoom.php, zoom-page.php
		・実運用サンプル/youtube/index.php
		・__define_common_my_sample.php
	・追加モジュール
		・photo/jigsaw.php ・scripts/snapfit/一式

【修正履歴：Ver.1.49】
	・IE7でサムネイル等の画質が汚いのを高画質化しました。以下のページを参考にしました。IE6では効果が無いようです。
		http://phpspot.org/blog/archives/2009/03/css_81.html
		http://devthought.com/tumble/2009/03/tip-high-quality-css-thumbnails-in-ie7/
	・「My設定 」の「公開先メンバ修正」「My参照メンバ修正」を、一覧からの選択式に変更。
	・フォーム入力・修正ページを開いた状態で、別ウインドウで別ユーザーで再ログインすると、
	   誤ったユーザーアカウントでデータ登録・更新される可能性がある問題を修正。
	   (POST前のログインID、カレントIDを<input type="hidden">で渡し、POST後のセッション変数のログインID、カレントIDと
	  一致しているかチェックするようにしました。)
	・ユーザー自身によるユーザー登録(newaccount.php)ができない設定を、定義ファイルで設定できるようにしました。
	・PHPソースのprintをechoに変更。
	・主な修正モジュール
		・__common__/__define_common.php, include-common-all.php, include-common-mp-list.php
		・account/edit-friends.php, edit-public.php
		・フォーム入力・修正関連モジュール全て
		・画像表示関連モジュール全て
	・追加モジュール
		・account/list-my-template-edit-friends.php, list-my-template-edit-public.php

【修正履歴：Ver.1.48】
	・メインコンテンツとして「RSSリーダー」を追加しました。タイル形式で記事を5件ずつ一覧表示します。
	  ↑クリックでポップアップウィンドウで全件表示します。
	  RSSパーサーは、MagpieRSSを使用。
		http://magpierss.sourceforge.net/
	  RSSのカテゴリ・ナビは、Nifty Cornersを使って角丸タグにしました。
		http://www.html.it/articoli/nifty/index.html
	・トップページのブローグパーツ表示機能でRSS記事表示を設定できます。
	  サンプルファイルblog-parts/rss-google-news.inc, rss-ameba-news.incを入れています。
	・トップページの一覧形式のレイアウトを変更。
	・ログイン画面や入力画面で、テキストボックスに入力フォーカスを設定。
	・メイン・ナビメニューの「INDEX」選択で、常にタイル型トップページを表示するように仕様変更。
	・ユーザー切り替えをコンテンツ毎の他に、全コンテンツ一括切り替えもできるようにしました。
	===========================================
	≪サンプルデータベース作成≫
	  Ver.1.47以前で既にテスト環境を構築済みの場合は、以下の手順でRSSリーダーのサンプルデータベースを追加してください。
	  コマンドプロンプトで以下を実行してください。
		mysql -u root -pパスワード
		create database _db_rss;
		exit

		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pパスワード _db_rss < _db_rss.bk.txt
		mysql -u root -pパスワード _db_rss < create_view_db_rss.txt

		mysql -u root -pパスワード
		GRANT SELECT,INSERT,UPDATE,DELETE ON _db_rss.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit
	===========================================
	≪実運用環境設定≫
	  Ver.1.47以前で既に実運用環境を構築済みの場合は、以下の手順でRSSリーダーの実運用環境を追加してください。
	＊実運用データベース作成
		・MySQLを一旦停止します。XAMPPコントロールパネルを使って停止してください。
		・サンプルデータベースを名前を変えてコピーすることで実運用DBを作成します。
		  データベース名を「_db_rss」をコピーして「_mydb_rss」とします。
		  コマンドプロンプトで以下を実行してください。
			mkdir D:\xampp\mysql\data\_mydb_rss
			copy D:\xampp\mysql\data\_db_rss\* D:\xampp\mysql\data\_mydb_rss
		・MySQLを開始
		・データベースのビューを作成します。コマンドプロンプトで以下を実行してください。
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pパスワード _mydb_rss < create_view_mydb_rss.txt
		・ユーザーアカウントのアクセス権を設定します。サンプルデータと同じユーザー名の例です。
		  コマンドプロンプトで以下を実行してください。
			mysql -u root -pパスワード
			GRANT SELECT,INSERT,UPDATE,DELETE ON _mydb_rss.* TO myhome@localhost;
			FLUSH PRIVILEGES;
			exit
	＊定義ファイル D:\xampp\htdocs\_myhome_myset\__define_contents_my.phpに、以下を追加。
		$navi_item[] = array("href"=>"rss/", "query"=>"arg=session", "name"=>"ＲＳＳ");
	＊定義ファイル D:\xampp\htdocs\_myhome_myset\__define_common_my.phpに、以下を追加。
		define("_DB_SCHEMA_rss", "_mydb_rss");
	===========================================
	≪RSSリーダー用プロキシ設定≫
	  企業内イントラなど、プロキシ経由の環境では、定義ファイルで、RSSリーダー用のプロキシサーバの設定をしてください。
		define("MAGPIE_PROXY_HOST", "xxx");	// RSSリーダー用 プロキシサーバ アドレス
		define("MAGPIE_PROXY_PORT", "xxx");	// RSSリーダー用 プロキシサーバ ポート
	===========================================
	・主な修正モジュール
		・__common__/include-common-all.php, include-common-html.php, include-common-mp-list.php
		・__common__/__define_common.php, __define_contents.php
		・account/change-account.php, login.php
		・__define_common_my_sample.php, __define_contents_my_sample.php
		・index/list.php
		・style/original/common.css
	・追加モジュール
		・rss/ 一式
		・rss/magpiers/ 一式
		・scripts/nifty/ 一式
		・blog-parts/rss-google-news.inc, rss-ameba-news.inc
		・index/list-my-template.php
		・style/original/rss.css
	・修正ファイル
		・db_backup.txt.php, db_restore.txt.php
	・追加ファイル
		・z_db_backup/_db_rss.bk.txt, create_view_db_rss.txt, create_view_mydb_rss.txt

【修正履歴：Ver.1.47】
	・トップページに掲示板の最新の投稿を数件分表示できるようにしました。
	・トップページ、カレンダー、ID管理等のページデザインの微調整。
	  Chrome、Safariでも、デザインの差異がなるべく出ないようにしました。
	・掲示板のスレッド一覧を、デフォルトでは削除済みは表示しない仕様に変更。フィルタ「削除済み投稿を表示」で表示可能に。
	・掲示板のWYSIWYGエディタ「openWYSIWYG」をGoogle Chromeでも動作するようにしました。Safari 4でも動作します。
	  ネットで以下のページが見つかったので、これを参考にscripts/openwysiwyg/scripts/wysiwyg-ja.jsを修正。
		＜Support for Google Chrome＞
		http://www.openwebware.com/forum/viewtopic.php?f=4&t=2138
	・カレンダー、掲示板、メモの添付ファイル格納フォルダをユーザーID毎に分ける方式に変更。
	  __common__/include-common-html.php内のattach_file_view()の仕様変更。引数の先頭に$user_idを追加。
	  この仕様変更に伴い、登録済みの添付ファイル移動ツール(tools/upload-file-move-147.php)を追加。
		Ver.1.46以前で運用開始済みの場合は、以下を、サンプルデータモード、実運用モードそれぞれで実行してください。
		http://localhost/_myhome/tools/upload-file-move-147.php
	・ツールの「MySQL データベース/テーブル一覧」(tools/mysql-database.php)用に、
	  ビューのスキーマ表示の権限があるMySQLユーザーを定義できるようにしました。
		/htdocs/_myhome_myset/__define_mysql_admin.phpで定義。(サンプルとして__define_mysql_admin_sample.phpを用意)
	・修正モジュール
		・__common__/include-common-html.php, include-common-all.php
		・index/top.php, __define.php
		・calendar/year.php, input.php, _my_calendar.php, list-my-template.php
		・memo/input.php, list-my-template.php
		・bbs/input.php, view.php, list.php, list-my-add-filter.php
		・id-manager/list-my-template.php
		・guide/input.php, list-my-template.php
		・tools/mysql-database.php
		・style/original/index.css, calendar.css, id-manager.css
		・scripts/openwysiwyg/scripts/wysiwyg-ja.js
	・追加モジュール
		・tools/upload_file_move.php
		・__define_mysql_admin_sample.php(_myhome_myset/__define_mysql_admin.phpサンプル)

【修正履歴：Ver.1.46】
	・掲示板とメモで、動画(FLV)ファイルをアップロードした場合、プレビュー表示するようにしました。
	  プレビュー表示には、JW FLV Playerを使用。
		http://www.longtailvideo.com/
	  動画(FLV)のファイル名が日本語の場合、プレビューされません。
	・掲示板で、YUI:Rich Text Editorを使った時に、一部スタイルが崩れる問題を解消。
		(yui/build/fonts/fonts-min.cssを指定していたのが原因)
	・修正モジュール
		・__common__/include-common-mp-list.php, __define_common.php, __define_contents.php
		・__define_common_my_sample.php, __define_contents_my_sample.php
		・bbs/view.php, __define.php, _add_input_header_YUI.php
		・memo/list-my-template.php, __define.php
	・追加モジュール
		・bbs/player.swf, yt.swf (phpと同じパスにないと動作しないよう(?)のでここに置きました。)
		・memo/player.swf, yt.swf (phpと同じパスにないと動作しないよう(?)のでここに置きました。)
		・scripts/JWPlayer/swfobject.js
		・scripts/JWPlayer/movie_preview.js

【修正履歴：Ver.1.45】
	・メインコンテンツとして「掲示板」を追加しました。MyHome Portal全ユーザー共通の掲示板機能です。
	  ファイルや写真の添付もできます。投稿の修正、削除、および復活ができます。
	  投稿の検索ができます。スレッド単位でページ送りしながら投稿を閲覧できます。
	  カテゴリはシステム管理者のみが追加、修正できます。
	  投稿表示の角丸ボックスは、Snazzy Bordersを使いました。
	  http://f32.aaa.livedoor.jp/~azusa/index.php?t=css&p=kadomaru
	  http://www.cssplay.co.uk/boxes/snazzy.html
	  投稿はWYSIWYGでHTMLタグも使えます。WYSIWYGエディタはopenWYSIWYGとYahoo! UI Library(YUI):Rich Text Editorのいずれかを使えます。
	  (定義ファイルで設定します。)
	  openWYSIWYGは、Google Chromeでは使えません。(→Ver.1.47で解決)
	  MyHome Portalでは、いずれのエディタも入力時と入力結果が必ずしも一致しません。一部、動作も不安定です。
	  MyHome PortalのCSSとの相性の問題かもしれません。
	  文字に色を付けたり、文字サイズを変える程度の利用に留めた方が無難です。
	  http://www.openwebware.com/
	  http://developer.yahoo.com/yui/editor/
	===========================================
	≪サンプルデータベース作成≫
	Ver.1.44以前で既にテスト環境を構築済みの場合は、以下の手順で掲示板のサンプルデータベースを追加してください。
	コマンドプロンプトで以下を実行してください。
		mysql -u root -pパスワード
		create database _db_bbs;
		exit

		d:
		cd "D:\xampp\htdocs\_myhome\z_db_backup"
		mysql -u root -pパスワード _db_bbs < _db_bbs.bk.txt
		mysql -u root -pパスワード _db_bbs < create_view_db_bbs.txt

		mysql -u root -pパスワード
		GRANT SELECT,INSERT,UPDATE,DELETE ON _db_bbs.* TO myhome@localhost;
		FLUSH PRIVILEGES;
		exit
	===========================================
	≪実運用環境追加≫
	Ver.1.44以前で既に実運用環境を構築済みの場合は、以下の手順で掲示板機能の実運用環境を追加してください。
	＊実運用データベース作成
		・MySQLを一旦停止します。XAMPPコントロールパネルを使って停止してください。
		・サンプルデータベースを名前を変えてコピーすることで実運用DBを作成します。
			データベース名を「_db_bbs」をコピーして「_mydb_bbs」とします。
			コマンドプロンプトで以下を実行してください。
			mkdir D:\xampp\mysql\data\_mydb_bbs
			copy D:\xampp\mysql\data\_db_bbs\* D:\xampp\mysql\data\_mydb_bbs
		・MySQLを開始
		・データベースのビューを作成します。コマンドプロンプトで以下を実行してください。
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u root -pパスワード _mydb_bbs < create_view_mydb_bbs.txt
		・ユーザーアカウントのアクセス権を設定します。サンプルデータと同じユーザー名の例です。
			コマンドプロンプトで以下を実行してください。
			mysql -u root -pパスワード
			GRANT SELECT,INSERT,UPDATE,DELETE ON _mydb_bbs.* TO myhome@localhost;
			FLUSH PRIVILEGES;
			exit
	＊サンプルデータの削除
		・コマンドプロンプトで以下を実行してください。
			mysql -u root -pパスワード
			use _mydb_bbs;
			delete from m_bbs;
			exit
	＊定義ファイル D:\xampp\htdocs\_myhome_myset\__define_contents_my.php
		以下を追加。
		$navi_item[] = array("href"=>"bbs/", "query"=>"arg=session", "name"=>"掲示板");
	＊定義ファイル D:\xampp\htdocs\_myhome_myset\__define_common_my.php
		以下を追加。
		define("_DB_SCHEMA_bbs", "_mydb_bbs");
		define("ATTACH_FILE_FOLDER_bbs", "../../_attach/bbs/");
	＊添付ファイル用ディレクトリ作成
		D:\xampp\htdocs\_attach\bbs
	===========================================
	・修正モジュール
		・__common__/include-common-mp-list.php, __define_common.php, __define_contents.php
		・__define_common_my_sample.php, __define_contents_my_sample.php
		・style/original/common.css
	・追加モジュール
		・bbs/一式
		・scripts/openwysiwyg一式, scripts/yui一式
		・style/original/bbs.css, Snazzy.css
	・修正ファイル
		・db_backup.txt.php, db_restore.txt.php
	・追加ファイル
		・z_db_backup/_db_bbs.bk.txt, create_view_db_bbs.txt, create_view_mydb_bbs.txt
	・追加フォルダ
		・_attach/bbs/

【修正履歴：Ver.1.44】
	・「ツール」に「Excel to グラフ by Bluff 」を追加しました。
	  ExcelシートをアップロードしてBluffを使ってグラフ作成をします。
		http://bluff.jcoglan.com/
	  ボタンでグラフ種類やスタイルを変更できます。
	  アップロードしたExcelシートはMyHomePortalユーザー毎に保存されます。
	  Excelシートの取り込みには、Spreadsheet_Excel_Readerを使っています。
		http://sourceforge.net/projects/phpexcelreader
	  「実運用サンプル/Excel_to_グラフ_サンプル」フォルダにサンプルのExcelを入れています。
	・「ツール」に「Excel to グラフ by HTML5 」を追加しました。
	  ExcelシートをアップロードしてHTML5を使ってグラフ作成をします。
		http://www.html5.jp/library/index.html
	  ボタンでグラフ種類やスタイルを変更できます。
	  アップロードしたExcelシートはMyHomePortalユーザー毎に保存されます。
	  Excelシートの取り込みには、Spreadsheet_Excel_Readerを使っています。
	  「実運用サンプル/Excel_to_グラフ_サンプル」フォルダにサンプルのExcelを入れています。
	・「ツール」の「PHP/JavaScriptソースコード編集」のテキストエリアの行数を拡げました。また、定義ファイルで変更可能にしました。
	・tools/tategaki.phpのmb_convert_encodingの「SJIS」を「SJIS-win」に変更。
	・_mobileのmb_convert_encodingの「SJIS」を「SJIS-win」に変更。
	・修正モジュール
		・tools/code-file-edit.php, index.php
		・__common__/include-common-all.php, __define_common.php
		・__define_common_my_sample.php
		・/_mobile/__common__/include-common-mobile.php
	・追加モジュール
		・tools/excel-graph-bluff.php, excel-graph-html5.php
		・tools/__define_excel-graph.php, __include-common-excel-graph.php
		・tools/phpExcelReader一式
		・tools/scripts/Bluff一式
		・tools/scripts/html5jp一式
		・tools/scripts/excanvas一式
	・実運用サンプル/Excel_to_グラフ_サンプル/sample1.xls, sample2.xls
	・追加フォルダ
		・_attach/excel-graph

【修正履歴：Ver.1.43】
	・「ツール」にシステム管理者用機能として「PHP/JavaScript ソースコード表示&編集＋ファイルマネージャー」を追加しました。
	・ソースコード整形表示(シンタックスハイライト)ツール「Syntaxhig Hlighter」と、ソースコードエディタ「Edit Area」と、
	  オリジナルのシンプルなファイルマネージャー機能を足して、一つのツールとしてまとめてみました。
	・最低限のテストは行っていますが、なんらかの要因により、ファイルが破損するリスクもありますので、自己責任においてお使いください。
	・サーバーのローカルディスクの任意のフォルダのHTML/PHP/JavaScript/CSS/TXTのソースファイルを整形表示＆編集ができます。
	・ソースファイルの文字コードはUTF-8およびShift-JISをサポートしています。
	  Shift-JISはmb_convert_encodingでUTF-8に変換して表示します。
	・MyHome Portalシステム管理者でログインしている場合のみ使えるようにしています。
	・【ファイルマネージャー】
		・ファイルマネージャーでは、下位フォルダおよびソースファイル(拡張子：html、htm、php、inc、js、css、txt、sql、xml)の
		  一覧を表示します。
		・フォルダ名のクリックや「↑」ボタンでフォルダの移動ができます。
		・ソースファイル内の文字検索もできます。該当のファイル名を赤色で表示します。
		・ファイル名または、ファイル更新日付で昇順/降順のソートができます。
		・ソースファイル名をクリックするとソースコード整形表示画面になります。
		  IE6ではサイズの大きいファイルのコード表示で実行速度の警告が出ます。
		・「編集」でソースコード編集画面になります。
		・「Ｃ」ボタンでファイルのコピーができます。コピーされるファイル名は元のファイル名＋"-COPY(n)"＋拡張子です。
		・「Ｒ」ボタンでファイルのリネームができます。
	・【Syntaxhig Hlighterによるソースコード整形表示】
		・整形表示形式をボタンで変えることができます。
		・「コード編集」ボタンを押すとソースコード編集画面になります。
	・【Edit Areaによるソースコード】
		・行番号表示やシンタックスハイライト表示してくれます。
		・表示形式をプルダウンで変えることができます。
		・日本語にも対応しています。
		・全画面表示や、ソース内の文字列検索や文字列置換ができます。
		・タブコードも挿入できます。複数行選択でのタブ挿入もできます。
		・「{」などを選択すると対応する「}」をハイライトしてくれます。
		・「保存」ボタンを押すとファイルに書き込みます。ファイルマネージャーまたはソースコード整形表示に戻ります。
	・「ツール」の前のバージョンの「PHP/JavaScript 整形表示」は削除しました。
	・「アルバム」のフォルダ移動で不具合があったので修正しました。
	・mb_convert_encodingで、「SJIS」では文字化けが発生するようなので、すべてのモジュールで「SJIS-win」に変更しました。
	・修正モジュール
		・tools/index.php
		・__common__/include-common-all.php, __define_common.php
		・photo/index.php ・__define_common_my_sample.php ・mb_convert_encodingを使っている全てのモジュール
	・追加モジュール
		・tools/code-file-view.php, code-file-edit.php, file-copy.php, file-rename.php
		・tools/__define_code-file.php, __include-common-code-file.php
		・tools/scripts/editarea/(一式)

【修正履歴：Ver.1.42】
	・アルバムのスライド表示にオートプレイ機能を追加しました。オートプレイの時間間隔も指定できます。
	  繰り返しの指定もできます。オートプレイの時は、メイン画像の下のサムネイルは表示しません。
	  オートプレイ機能ではAjax/JavaScriptは使っていません。シンプルに<meta http-equiv="refresh">を使っています。
	・アルバムのスライド表示で画像サイズを変更できるようにしました。
	・修正モジュール
		・photo/index.php, __define.php
		・__common__/include-common-html.php, __define_common.php
		・__define_common_my_sample.php

【修正履歴：Ver.1.41】
	・アルバムの動画サムネイル表示で、サムネイル画像を生成する動画開始時間(秒)を指定できるようにしました。
	・修正モジュール
		・photo/index.php, video-jpeg.php

【修正履歴：Ver.1.40】
	・アルバムで動画のサムネイル表示ができるようにしました。
	・対象の動画は、静止画と同様にサーバのローカルディスクの任意のフォルダが対象です。
	  システム管理者以外は静止画と同様にディレクトリを限定できます。
	・ffmpegがインストールされている必要があります。
	  ffmpegは、「お気に入りの動画を携帯で見よう(http://blog.k-tai-douga.com/)」から
	  、Windows用バイナリをダウンロードしてインストールするのが手っ取り早いです。
	・Windowsのシステム環境変数Pathにffmpegのインストールディレクトリを追加してください。(例:「;C:\Program Files\ffmpeg」)
	  環境変数追加後に、Apacheを再起動する必要があります。(Windowsを再起動する必要があるかも)
	・サムネイルをダブルクリックまたはクリックで動画再生または動画ダウンロードできます。
	  ただし、動画の種類によって、エラーになるなど、動画再生が出来ない場合もあります。とくにIEが再生できない場合が多いようです。
	・定義ファイルに以下の行を追加しました。
	  以前のバージョンで既に実運用環境設定されている方は、定義ファイルに以下の行を追加してください。
		define("photo_VIDEO_FFMPEG", "");	// 動画をサムネイル表示する場合:"YES"
		define("IS_VIDEO_EXT", "avi,flv,mpg,mov,swf,wmv");
		define("IS_VIDEO_MIME","video/x-msvideo,video/x-flv,video/mpeg,video/quicktime,application/x-shockwave-flash,video/x-ms-wmv");
		define("IS_IMG_EXT", "jpeg,jpg,gif,png");
	  動画をサムネイル表示する場合は、photo_VIDEO_FFMPEGを"YES"にしてください。
	  サンプルの定義ファイル「__define_common_my_sample.php」では、photo_VIDEO_FFMPEGは""（オフ）になっています。
	  サムネイル表示対象の動画種類はIS_VIDEO_EXTで拡張子を指定します。
	  デフォルトでは「avi,flv,mpg,mov,swf,wmv」を定義しています。
	  拡張子を追加する場合は、IS_VIDEO_MIMEに、IS_VIDEO_EXTと同じ順番でMIMEを定義してください。
	・動画のサムネイルにはオレンジ色のボーダーを付けて静止画と区別できるようにしました。
	・サムネイルのimgタグにalt属性およびtitle属性でファイル名を表示するようにしました。
	・修正モジュール
		・__common__/__define_common.php, include-common-all.php
		・photo/index.php, __define.php, __html-my-header.php, img-view.php
		・style/original/photo.css
		・__define_common_my_sample.php
	・追加モジュール
		・photo/video-jpeg.php, video-view.php

【修正履歴：Ver.1.39】
	・INDEXトップページのユーザー毎のHTML(ブログパーツ)登録機能で、HTMLに<br>タグが入ってしまう問題を修正。
	  このHTMLパーツ登録機能を使って、オリジナルの乗換案内をサンプルDBに追加。
		＜乗換案内HTMLパーツ＞
		<form name="norikae_form" target="_self" style="border:1px solid #808080;background-color:#F0E68C;margin:5px;padding:3px;">
		乗車：<input type="text" name="SF" size="12"><br>
		下車：<input type="text" name="ST" size="12"><br>
		<input type="button" value="乗換(駅探)" onClick="Norikae_Ekitan()"><br>
		<input type="button" value="乗換(Google)" onClick="Norikae_Google()"><br>
		</form>
		<script language="JavaScript">
		<!--
		function Norikae_Google() {
		url = "http://maps.google.co.jp/maps?ie=UTF8&f=d&ttype=dep&dirflg=r";
		url = url + "&saddr=" + encodeURL(document.norikae_form.SF.value);
		url = url + "&daddr=" + encodeURL(document.norikae_form.ST.value);
		top.location.href = url;
		}
		function Norikae_Ekitan() {
		url = "http://search.ekitan.com/norikae/Norikae2Servlet?AN=0&FN=0&ETYPE=0&CHAR=UTF8&submit=%8C%9F%8D%F5";
		url = url + "&SF=" + encodeURL(document.norikae_form.SF.value);
		url = url + "&ST=" + encodeURL(document.norikae_form.ST.value);
		top.location.href = url;
		}
		-->
		</script>
	・アルバムのサムネイルBタイプに、ボタンによる画像一括拡大縮小機能を追加。
	・include-common-all.phpの一部関数の無駄な処理を修正。
	・修正モジュール
		・index/top.php
		・photo/index.php
		・__common__/include-common-all.php, include-common-mp-list.php
		・z_db_backup/_db_index.bk.txt (INDEXのデータベース:乗換案内HTMLパーツ追加)

【修正履歴：Ver.1.38】
	・アルバムのサムネイル表示で画像のダブルクリックで原画像を別ウインドウで表示するようにしました。
	・アルバムのサムネイル表示に「Bタイプ」を追加しました。正方形のフレームに縦横混在の画像を納める形式のサムネイルです。
	  フレーム内の画像のセンタリングについては、CSS-EBLOG(http://css-eblog.com/csstechnique/img-center.html)を参考にしました。
	  画像のシングルクリックで原画像を別ウインドウで表示します。
	・アルバムのスライド表示に、10枚単位のスキップ機能を追加しました。
	  Ver.1.36、1.37のカレンダーのアルバム連携表示のロールオーバーの不具合を修正しました。
	  原因はHTML内に余分の</p>タグがあったためでした。CSSのIEハックなどは不要でした。
	・修正モジュール
		・calendar/_my_calendar.php
		・photo/index.php, __html-my-header.php
		・style/original/calendar.css, photo.css
	・追加モジュール
		・style/original/center.css, center_ie.css

【修正履歴：Ver.1.37】
	・Ver.1.36のカレンダーのアルバム連携表示のロールオーバーによる画像拡大CSSの修正で、
	  ロールオーバー時にカレンダー日付枠が拡大画像サイズに従って拡がってしまう問題を修正。
	  ただし、修正はIEのみ有効で、Firefox、Google Chromeは未対応。(Ver.1.38で修正しました。)
	・修正モジュール
		・style/original/calendar.css

【修正履歴：Ver.1.36】
	・Ver.1.24でアルバムの画像データ表示をscripts/php/img-size-change.phpを使わない方法に変更したが、
	  カレンダーのアルバム連携表示ではそのままになっていたのを、同様の方法に修正。
	・カレンダーのアルバム連携表示のロールオーバーによる画像拡大(CSSによる)がIE以外で動作しなかったのを
	  Firefox、Google Chromeでも動作するように修正。(不具合がありましたが、Ver.1.38で修正しました。)
	・修正モジュール
		・calendar/_my_calendar.php
		・style/original/calendar.css

【修正履歴：Ver.1.35】
	・実運用設定で、アルバムの表示ディレクトリを制限できるようにしました。実運用定義ファイル_define_common_my.phpで設定します。
	  これを指定すると、指定ディレクトリおよびその下以外には移動できなくなります。
	  システム管理者のみ、この制限をはずすこともできます。
	  実運用定義ファイルサンプル__define_common_my_sample.phpを参考にしてください。
		define("photo_LIMITED_IMAGES_FOLDER", "D:/デジカメ写真");
		define("photo_LIMITED_ADMIN_NOLIMIT", "YES");
	・これを指定するとカレンダー連携のアルバムフォルダは、このディレクトリからの相対アドレス指定となります。
	・修正モジュール
		・photo/index.php, img-view.php
		・account/__include-login.php, myprofile.php, edit-myprofile.php
		・__define_common_my_sample.php

【修正履歴：Ver.1.34】
	・実運用設定で、コンテンツ定義ファイル__define_contents.phpを別ファイル指定できるようにしました。
	  別定義ファイルでメインコンテンツの使用/不使用を設定できます。
	・コンテンツ定義ファイルサンプル__define_contents_my_sample.phpを用意しました。
	・_myhomeディレクトリの外に、コンテンツフォルダを置いても良いようにinclude-common-html.php、__logincheck.phpを修正。
	・カレンダースケジュール入力画面のアイコン一覧表示で、拡張子.zzzのダミーファイルがあると改行するようにしました。
	・拡張子.zzzのダミーファイルを含めたカレンダーイメージファイルサンプルを「実運用サンプル」フォルダにいれました。
	・カレンダーでアイコン読み取り関数をreaddirからscandirに変更。
	・__define_common_my_sample.phpのイメージファイルフォルダ名指定がcalnedarになっていたのをcalendarに変更。
	・カレンダーの時間表示で分が00の時も表示するように仕様変更。
	・account/__include-account-check.phpにあった未使用関数sql_and_or、sql_and_or_col2を__common__/include-common-all.phpに移動。
	・修正モジュール
		・__common__/__define_common.php
		・__common__/__define_contents.php
		・__common__/include-common-html.php
		・__common__/include-common-all.php
		・account/__logincheck.php, __include-account-check.php
		・calendar/_my_calendar.php, input.php
		・style/original/common.css
	・追加モジュール
		・__define_contents_my_sample.php
		・実運用サンプル/youtube一式
		・実運用サンプル/_my_calendar_images一式

【修正履歴：Ver.1.33】
	・MyHomePortalコンテンツの定義ファイル(__define_contents.php)を独自に設定できるようにしました。
	  MyHomePortalコンテンツの一部を使わない(例:アルバムを使わない)設定とか、
	  独自コンテンツをコンテンツメニューに追加するなどが出来ます。
	・アルバムを、ブラウザのウインドウを複数開いて別々のフォトディレクトリを表示できるように修正。
	・修正モジュール
		・__common__/__define_common.php, include-common-html.php
		・__define_common_my_sample.php
		・photo/index.php, __define.php

【修正履歴：Ver.1.32】
	・利用ガイドを少し修正しました。
	・z_db_backupフォルダ内に、実運用データベースのビュー作成スクリプトファイルを追加。
	・プログラムモジュールの変更はありません。

【修正履歴：Ver.1.31】
	・アルバムの内部ロジックを修正。ディレクトリのファイル一覧をSESSION変数に保存し、同一パスの間は、
	  ディスクスキャンをしないようにしました。
	・アルバムで、スライドショー表示もできるようにしました。
	・修正モジュール
		・photo/index.php, __define.php
		・style/original/photo.css
		・__common__/__define_common.php
		・__define_common_my_sample.php

【修正履歴：Ver.1.30】
	・トップページ検索キー入力テキストボックスでEnterキーでGoogle検索できるようにしました。
	  JavaScriptでonKeypressを使って実現しようとしましたが、うまく動作しないのでFORMのPOSTで実現しました。
	  自宅用 HTML版 Webポータル「MyIndex」も同じように修正しました。
	・アルバムをぺージングできるように修正。
	・ReadMe-original.txt.phpの【実運用ディレクトリ構成例】の間違いを修正。
		/htdocs/__define_common_my.php → /htdocs/_myhome_myset/__define_common_my.php
	・修正モジュール
		・index/top.php
		・photo/index.php
		・style/original/photo.css
		・__common__/__define_common.php

【修正履歴：Ver.1.29】
	・カレンダースケジュール入力画面の日付のポップアップ入力を、YUI Calendarの代わりに、
	  「ホームページの素」(http://www.kanaya440.com/)の日付入力補助(calendar.js)を使用するように変更。
	  calendar.jsは、祝日をJavaScriptロジックで表示。
	  MyHome Portal定義ファイル(__define_common.php)で、YUI Calendarの選択も可能。
	  calendar.jsはオリジナルを一部修正しています。
		・文字コードをUTF-8に変更。
		・日付入力欄のSELECTプルダウンに対応。(ちょっと強引に修正しています。)
		・ポップアップカレンダーのCSSを修正(font:→font-size:)。CSSを別ファイル化。
	・修正モジュール
		・__common__/__define_common.php
		・calendar/__define.php, input.php, _add_input_header.php
	・追加モジュール
		・calendar/_add_input_header_YUI.php
		・scripts/calendar.js, setValue.js
		・scripts/style/calendar.js.css, calendar.js-Firefox.css

【修正履歴：Ver.1.28】
	・MySQLサンプルデータベース作成スクリプト「db_backup_restore.txt.php」の変更。
	  データベース作成ユーザーをrootアカウントに変更し、PHP実行用のユーザーアカウント作成スクリプトを追加。
	  PHP実行用のユーザーアカウントのデータベースアクセス権限を、SELECT,INSERT,UPDATE,DELETEのみとしました。
	  restoreとbackupのサンプルスクリプトファイルを分割。
	・追加ファイル
		・db_restore.txt.php, db_backup.txt.php
	・削除ファイル
		・db_backup_restore.txt.php

【修正履歴：Ver.1.27】
	・トップページ(index/top.php)の不具合修正。
	  Ver.1.26で、ホームページ登録なしのカテゴリ抽出に不具合があることがわかり、修正したつもりが間違った修正をしていました。
	  改めて修正しました。
	・修正モジュール
		・index/top.php

【修正履歴：Ver.1.26】
	・トップページ右側に任意のブログパーツを貼れるようにしました。最大で縦2列で8個まで貼れます。
	  全ユーザー共通でトップページに表示されます。サンプルではYahoo天気予報と時計を貼っています。
	  ただ、たくさん貼り付けるとページ表示やページ遷移が遅くなります。
	  【ブログパーツの設定方法：サンプルデータの例】
		ブログパーツHTML(Script)を、/_myhome/blog-parts/フォルダの下にテキストファイルで置いてください。
		HTML(Script)ファイルの文字コードはUTF-8にしてください。
		HTML(Script)ファイル名を、定義ファイル/_myhome/__common__/__define_common.phpで指定します。
		(定義ファイルサンプルを参考にしてください。)
	・トップページ右上に表示していたlivedoor(Ajax)天気予報はサンプルのデフォルトでは表示しないようにしました。
	・トップページのホームページインデックス枠内に、ユーザー毎に任意のブログパーツを貼れるようにしました。
		ホームページの登録画面で、HTML(ブログパーツ)を登録してください。
		ブログパーツ以外の任意のHTMLを入れることも可能です。
		ブログパーツによっては、正しく表示されない可能性があります。
	 	サンプルデータベースではユーザー「共通」に4個、ユーザー「花子」に1個登録しています。
	・MySQLデータベース_db_indexのテーブル「m_homepage」に、列「c_html」を追加しました。
		既存のデータベースに列を追加する場合は、コマンドプロンプトから以下を実行してください。
		実運用のデータベース名を変えている場合は、注意してください。
	 	「create_view_db_index.txt」の中のデータベース名も変える必要があります。
		-----------------------------------------
			mysql -u myhome -ppass123
			use _db_index;
			ALTER TABLE m_homepage ADD c_html LONGTEXT NOT NULL;
			exit
			d:
			cd "D:\xampp\htdocs\_myhome\z_db_backup"
			mysql -u myhome -ppass123 _db_index < create_view_db_index.txt
		-----------------------------------------
	・トップページに「Googleマップルート・乗換案内」検索ボタンを追加。
	・修正モジュール
		・__common__/__define_common.php, include-common-mp-list.php
		・index/top.php, list.php, __define.php, __html-my-header.php
		・style/original/index.css
		・z_db_backup/create_view_db_index.txt, _db_index.bk.txt
	・追加モジュール
		・blog-partsフォルダと、ブログパーツサンプルファイル
	・データベース変更
		・データベース「_db_index」：テーブル「m_homepage」に、列「c_html」を追加。

【修正履歴：Ver.1.25】
	・トップページのインターネット検索ボタンに「Yahoo!百科事典」を追加。
	・カレンダースケジュール入力画面の日付のポップアップ入力で使用しているYUIのJavaScriptとCSSを、
	  Yahooサイトでなくサーバーローカルからロードする方式に変更。
	・修正モジュール
		・photo/index.php
		・calendar/_add_input_header.php
		・scripts/YahhoCal.js
	・追加モジュール
		・scripts/yui 以下一式 (YUI Library: version 2.6.0から一部を抜粋)

【修正履歴：Ver.1.24】
	・アルバムで、画像データをimagecopyresampled()でリサイズしていたが、非常に時間がかかるのでリサイズ処理を行わない方法に変更。
	・修正モジュール
		・photo/index.php
	・追加モジュール
		・photo/img-view.php

【修正履歴：Ver.1.23】
	・「ツール」に「HTML テーブル CSSスタイル シミュレーション」を追加。
	  使いそうなテーブルレイアウト複数パターンのbackground-colorやborder-widthなどを一括変更して
	  レイアウトイメージを確認できます。
	  JavaScript＋jQueryを使っています。
	・修正モジュール
		・tools/index.php
		・scripts/jquery.js (photo/scriptsから移動。バージョンを1.2.6に。)
		・photo/index.php (jquery.jsのディレクトリ移動に伴う修正。)
	・追加モジュール
		・tools/table-layout.php

【修正履歴：Ver.1.22】
	・入力フォームの件名未入力チェックをJavaScriptで行い警告ダイアログを表示するようにしました。
	  (修正コンテンツ：カレンダー、メモ、ID管理、利用ガイド)
	・修正モジュール
		・calendar/input.php
		・memo/input.php
		・id-manager/input.php
		・guide/input.php

【修正履歴：Ver.1.21】
	・一覧形式ページでurl引数にdebug=yを付けるとSQL文を表示するようにしているが、そのSQLを少しだけ整形して表示するようにした。
	・合わせて、このデバッグ用SQL表示のロジック変更をした。
	  (修正前)
		include-common-mp-list.php内の、mp_list_sql_add_create、mp_list_sql_createで、$_SESSION['debug'] == "y"の時に
		error_msgでSQLを表示していた。
	  (修正後)
		error_msgの代わりに、整形表示用sql_printを作成。
		include-common-all.php内に、my_mysql_query_debug_printという関数を新たに作成し、
		mp_list_view、mp_list_editで、my_mysql_queryの代わりにこれをコールするようにした。
		定義ファイルの_DEBUG_ERROR_MSGが"YES"の時のみ、この機能が有効なように仕様変更。
		function my_mysql_query_debug_print($sql, $err_msg="", $con_link=NULL, $html=False) {
			if (_DEBUG_ERROR_MSG == "YES" and $_SESSION['debug'] == "y") {
				sql_print ($sql);
			}
			return my_mysql_query($sql, $err_msg, $con_link, $html);
		}
	・デバッグモードをOFFにする場合は、url引数にdebug=nを付けてください。
	・修正モジュール
		・__common__/include-common-all.php, include-common-mp-list.php
		・index/top.php(debugプリント機能を削除)

【修正履歴：Ver.1.20】
	・「ID管理」表示ページのID、パスワード表示欄のレイアウトを少しだけ修正。
	  項目名と値表示ボックスの上下位置がアンバランスだったのを補正。
	  Google Chromeでは改行されて2段表示になってしまっていた問題を解消。
	・修正モジュール
		・id-manager/list-my-template.php
		・style/original/id-manager.css

【修正履歴：Ver.1.19】
	・携帯電話(mobile端末)からのカレンダースケジュール表示機能を作成しました。
	  本人のスケジュール表示機能だけです。本文のHTML、アイコンは省いています。
	  カテゴリアイコンと色は件名に反映させています。png画像の場合、正しく表示されない可能性があります。
	  開発には、携帯用アプリの開発ツールキットHAWHAWを利用しています。
	  http://www.d-meister.co.jp/HAWHAW/
	  テストはiモードHTMLシミュレータIIでのみ行っています。実機でのテストは行っていません。
	  http://www.nttdocomo.co.jp/service/imode/make/content/download/index.html
	  実用に耐えるかどうかは保障できません。 あくまで、携帯端末向けWebサイトのトライアルとして作成しました。
	  認証は、ログイン画面を表示する方式とurlで直接アカウントとパスワードを指定する方式をサポートしています。
	  http://localhost/_mobile/calendar/
	  http://localhost/_mobile/calendar/?ac=tarou&pw=demo
	・携帯端末の場合、Cookieが使えないなどセッションまわりがPCブラウザと違うので、そのための工夫をしていますが、
	  試行錯誤しましたので、間違いや余分のものがある可能性があります。
	  PHPソース内でのセッション開始では、以下のようにしています。
	        ini_set('session.use_trans_sid', '1');
	        session_start();
	        session_regenerate_id(true);
	  .htaccessファイルを作成して以下のように記述しました。
	        php_flag session.use_trans_sid On
	  header("Location: ../")でページ遷移する場合、携帯端末ではセッションが引き継がれないことがあるので、
	  下記のようにしてセッションIDを指定しています。
	        header("Location: ../?".SID);
	  以下のサイトを参考にしました。
	  	http://www.phppro.jp/qa/1356
	・_myhomeと並列のディレクトリ_mobileとして作成しました。
	  ただし、_myhomeの定義ファイルや共有ライブラリに依存する構成にしています。
	・修正モジュール
		・__common__/include-common-all.php(関数追加)
	・追加モジュール
		・/_mobile/index.php, .htaccess
		・/_mobile/__common__/__define_mobile.php, include-common-mobile.php
		・/_mobile/login/index.php
		・/_mobile/calendar/index.php, __define.php
		・/_mobile/lib/hawhaw.inc, hawxy.php

【修正履歴：Ver.1.18】
	・システム管理者「ログアウト/管理」に、「MyHome Portal ログイン履歴表示」を追加。
	・修正モジュール
		・__common__/__define_common.php
		・__define_common_my_sample.php
		・account/logout.php, __define.php
		・style/original/account.css
	・追加モジュール
		・account/list-loginlog.php

【修正履歴：Ver.1.17】
	・「ツール」にシステム管理者用ツールとして「MySQL データベース/テーブル一覧」を追加しました。
	  データベースのテーブル/ビューのフィールド名、データタイプなどの一覧を表示します。
	  ビューの場合、スキーマも合わせて表示します。少し見やすく整形しています。
	  単独でも動作できるように、MyHome Portalの共有ライブラリに依存しない形で作成しました。
	・カレンダー、メモ入力画面がブラウザの文字サイズを大きくした時に崩れる問題を解消。
	  (textareaと大小ボタンをdivで並べていたのをtableに変更。)
	・Ver.1.14でスタイル調整のため、inputタグにclass指定したのが原因で、
	  検索キー有の時のbackground-colorが有効にならなくなっていた不具合を修正。
	・利用ガイドを、最新バージョンに合わせて少しだけ修正しました。
	・修正モジュール
		・tools/index.php
		・__common__/include-common-mp-list.php
		・calendar/input.php, _my_calendar.php, __html-my-header.php
		・memo/input.php
		・style/original/calendar.css, mp-list.css
		・z_db_backup/_db_guide.bk.txt
	・追加モジュール
		・tools/mysql-database.php, mysql-database-simple.php

【修正履歴：Ver.1.16】
	・カレンダースケジュール入力画面のアイコン挿入ボタンで挿入されるタグを「<img src=」ではなく、
	  ダミーの「<icon」に変更し、ファイルのソースパスを省略。HTML表示時に「<img src=」に戻して表示。
	  スケジュール入力欄(textarea)内をすっきりさせるためと、運用開始後にアイコンフォルダを移動(変更)しても
	  支障が出ないようにするため。
	  ※ 既にMyHome Portalを運用開始済みの場合は、入力済みのスケジュールを以下の方法で変更することをお勧めします。
	     実行前には、データベースのバックアップをとってください。
	     MySQLのユーザー名、パスワードは環境に合わせて変更してください。
		■ サンプルデータベースの例 (Windowsの場合、DOSプロンプトから実行。)
		mysql -u myhome -ppass123
		use _db_calendar;
		update m_schedule set c_memo=REPLACE(c_memo,"<img src=images/","<icon ");
		exit
		■ 実運用データベースの例 (Windowsの場合、DOSプロンプトから実行。)
		    define("IMAGES_FOLDER_calendar", "../../_myhome_myset/_my_calendar_images")で、
		    データベース名が_mydb_calendarの場合の例。
		    注：置換前の<img srcのパスは、defineで定義しているパスの最後に必ず/をつけてください。
		mysql -u myhome -ppass123
		use _mydb_calendar;
		update m_schedule set c_memo=REPLACE(c_memo,"<img src=../../_myhome_myset/_my_calendar_images/","<icon ");
		exit
	・修正モジュール
		・calendar/input.php, list.php, list-my-template.php, _my_calendar.php

【修正履歴：Ver.1.15】
	・カレンダースケジュール入力画面で、アイコン挿入およびカラータグ挿入時にHTMLプレビューを自動更新するようにしました。
	・カレンダースケジュール修正画面で、HTMLプレビューを合わせて表示するようにしました。
	・修正モジュール
		・calendar/input.php

【修正履歴：Ver.1.14】
	・textarea内の文字サイズ、種類をページ内全体と同じになるようにCSS(スタイルシート)の見直しをしました。
	・IE6、Firefox、Google Chromeの各ブラウザでFORM入力画面がなるべく同じになるようにしました。
	・上記CSSの変更に合わせて、FORM画面のtextareaのcolsなどを調整。
	・CSSの更新時にブラウザにキャッシュが残っているとスタイルが更新されない問題の対策。
	  以下のようにすることで、キャッシュを使わないようになります。
	  <link rel="stylesheet" href="xxx.css" type="text/css">
		↓↓↓
	  <link rel="stylesheet" href="xxx.css?20081017" type="text/css">
	・ユーザー登録画面でAjaxを使ったアカウント名、ハンドル名チェックのエラーメッセージがFirefoxでは表示されなかった問題を解消。
	  document.all.xxxxxxは、IE独自の仕様のため、document.getElementById('xxxxxx')に変更。
	・修正モジュール
		・style/common.css
		・account/_add_newaccount_header.php
		・FORM入力関係全て

【修正履歴：Ver.1.13】
	・カレンダースケジュール入力画面に、スケジュール本文へのカラータグ挿入ボタン追加。
	  スケジュール本文の色を付けたい文字列を選択して、カラーボタンを押してください。
	  ボールド、イタリック、ストライクアウトボタンも付けました。
	  カラータグメニューの色は、calendar/__define_color_tag.phpで指定できます。
	・カレンダースケジュール入力画面に、スケジュール本文のHTMLプレビュー確認機能追加。
	  スケジュール入力画面右の●ボタンを押してください。
	・上記機能およびスケジュール本文へのアイコン挿入機能を、Firefox、Google Chromeでも動作するようにしました。
	  (Powered by http://painter.homeip.net/~raelian/tag/enclose.html)
	・カレンダーの「一括修正/追加/削除」画面の列見出しを変更。(表題=>件名、メモ=>スケジュール本文)
	・実運用定義ファイル__define_common_my.phpサンプル追加。
	・修正モジュール
		・calendar/input.php, __define.php, list.php
		・__common__/__define_common.php
	・追加モジュール
		・calendar/__define_color_tag.php
		・scripts/textarea.js
		・__define_common_my_sample.php

【修正履歴：Ver.1.12】
	・「ツール」にシステム管理者用機能として「PHP/JavaScriptソースコード整形表示」を追加。
		・Powerd by http://code.google.com/p/syntaxhighlighter/
		・ツールメニューにはシステム管理者のみ表示するようにしていますが、
		  syntax-highlight.php本体には、アクセス制限機能は付けていませんのでご注意ください。
		・dp.SyntaxHighlighterを使ってソースコード全体を整形表示します。
		・php、js、css、html、htm、txt、sqlの拡張子に合わせて整形表示します。ボタンで整形タイプを変更できます。
		・ファイルマネージャー的な機能も付けましたので、フォルダを移動して任意のソースを表示できます。
		・IE6では、ステップ数の多いソースを表示しようとすると、「このページのスクリプトが、
		  Internet Explorerの実行速度を遅くしています。...」という警告が出ます。実際に遅いです。
		  Google Chromeでは高速に表示されます。
		・syntax-highlight.php＋JavaScriptのみで動作できるように、cssやphp共通関数を取り込んでいます。
	・上記ツールに検索機能を付加した「PHP/JavaScript整形表示＋検索付」も作ってみました。
		・winofsqlによる改造版SyntaxHighlighterを使用。
		  Powered by http://winofsql.jp/sh/html/syntax_highlighter.htm
		・検索文字列をハイライト表示します。ただ、整形タイプ指定によってハイライト表示されない場合もあります。
		・フォルダ内ファイル名一覧でも、ファイル内のテキスト検索を行い、該当ファイル名をハイライト表示します。
	・コンテンツカテゴリの「ツール」と「ＩＤ管理」の位置を交換。
	・修正モジュール
		・__common__/__define_contents.php, __define_common.php
		・style/original/tools.css
	・追加モジュール
		・tools/syntax-highlight.php, syntax-highlight-search.php, __define.php
		・tools/scripts/dp.SyntaxHighlighter
		・tools/icon/* (フォルダ名をimagesから変更)

【修正履歴：Ver.1.11】
	・「ツール」に「ホームページのモノトーン表示」を追加。(url引数指定版とform指定版を用意)
	・「ツール」に「ホームページの拡大縮小表示」を追加。(url引数指定版とform指定版を用意)
	・「ツール」に「テキスト縦書き表示」を追加。
		(注：サーバーローカルのテキストファイル全てを表示可能です。ツールメニューにはシステム管理者のみ
		表示するようにしていますが、tategaki.phpにはアクセス制限機能は付けていませんので、ご注意ください。)
	・「ReadMe-original.txt」と「db_backup_restore.txt」が不用意にブラウザから見えてしまわないように拡張子phpを付けました。
	・カレンダーのサンプルデータの月を10月に変更。
	・修正モジュール
		・tools/index.php, __html-my-header.php
		・関数「up_folder_path,right_slash_strip」を
		  photo/__include-common.phpから、__common__/include-common-all.phpに移動
	・追加モジュール
		・tools/monotone.php, monotone-page.php, zoom.php, zoom-page.php, tategaki.php

【修正履歴：Ver.1.10】
	・コンテンツカテゴリとして「ツール」を追加。
	・「ツール」に「翻訳 by Google AJAX Language API」を追加。
		※ 日⇔英翻訳では、翻訳後、元の言語に再翻訳して翻訳の精度を確かめられるようにしました。
		※ 直接翻訳ができない場合は、英語経由で翻訳できるようにしました。
	・「ツール」に「HTMLカラーチャート」をリンク。
	・修正モジュール
		・_common__/__define_contents.php
		・style/original/common.css
	・追加モジュール
		・tools/index.php, ajaxlang.php, __html-my-header.php
		・style/original/tools.css

【修正履歴：Ver.1.09】
	・カレンダーの月間表示に、詳細表示のチェックボックスを追加。スケジュール本文全てを表示します。
	・カレンダー入力画面でカテゴリが多いとページが横に広がってしまう問題点を修正。
	・修正モジュール
		・calendar/_my_calendar.php, month.php, input.php
		・style/original/calendar.css

【修正履歴：Ver.1.08】
	・INDEXトップページに、livedoor天気Webサービスによる天気を表示できるようにしました。
		※ IEの標準のセキュリティレベルで、自宅のPCからAjaxでインターネット上のWebサービスにアクセスすると
		「このページは、制御範囲外の情報にアクセスしています。セキュリティ上の問題がある可能性があります。」
		という警告が出てしまいます。FirefoxやGoogle Chromeでは、警告は出ませんが、天気予報が表示できません。
		そこで、PHPのfile_get_contentsで、ネット上のホームページファイルを取得できることを利用して、
		直接Ajaxでインターネットにアクセスせず、サーバーサイドのphp(get_weather_livedoor.php)で、
		file_get_contentsでXMLを取得し、クライアントに返す方法を取っています。
		これで、IEの警告画面が出なくなり、FirefoxとGoogle Chromeでも天気予報を表示できるようになりました。
	・INDEXトップページのデザインを微調整。
	・スケジュール入力画面のアイコン挿入ボタンのデザインを変更。アイコンをそのままボタンにしました。
	・修正モジュール
		・_common__/__define_common.php
		・index/top.php, __define.php
		・calendar/input.php
		・style/original/index.css, calendar.css
		・scripts/prototype.jsをnot_useから格上げ(livedoor天気WebサービスAjaxで使用)
	・追加モジュール
		・index/__include-weather.php, __define_weather_city.php, get_weather_livedoor.php

【修正履歴：Ver.1.07】
	・INDEXトップページに、カレンダースケジュールを数日分(defineで指定)表示できるようにしました。
	・INDEXトップページのカレンダースケジュールから、直接スケジュール画面に入れます。
	・INDEXトップページの月カレンダーの表示月数をdefineで指定できるようにしました。
	・スケジュール入力画面のアイコン挿入ボタンの配置を変更。縦12個単位で横に広がるようにしました。
	・修正モジュール
		・_common__/__define_common.php, include-common-all.php
		・index/top.php, __define.php
		・calendar/input.php, _my_calendar.php
		・style/original/index.css, calendar.css

【修正履歴：Ver.1.06】
	・カレンダーのスケジュール本文にhtmlタグを使えるようにしました。
		(define("TEXTAREA_HTML_USE", "YES")の場合)
	  ※注：<scriptだけは機能しないようにしていますが、それ以外は全て機能してしまいます。
		この機能はセキュリティ上、問題があります。
		家族など信頼できるユーザーだけで利用する以外は、
		define("TEXTAREA_HTML_USE", "NO")にして、このタグ機能を無効にすることをお勧めします。
	・スケジュール入力画面に、アイコン挿入ボタンを追加しました。(define("TEXTAREA_HTML_USE", "YES")の場合)
	  (ただし、FirefoxやGoogle Chromeでは、textareaのカーソル位置に関係なく最後に挿入されてしまいます。)
	・Firefoxで、スケジュール入力画面が正常に表示されない不具合を解消。
	・修正モジュール
		・_common__/__define_common.php, include-common-all.php
		・calendar/__define.php, input.php, _my_calendar.php, _add_input_header.php, list-my-template.php
		・style/original/calendar.css

【修正履歴：Ver.1.05】
	・calendar/images：
	カレンダー用アイコン追加。「1キロバイトの素材屋さん」に
	新幹線と飛行機のアイコンを作ってもらいました。他も含めて6個のアイコンを追加しました。
	http://www.fuchu.or.jp/~tenshi/1kb/sozai/blog.html

【修正履歴：Ver.1.04】
	・style/original/common.css：
	CSSに以下を追加。FirefoxやGoogle Chromeではレイアウトが崩れてしまう件の対策。
	(サブヘッダーのメニューやユーザー切り替えの部分)
	by ブログコメントANさん（ANさん、ありがとうございます。）
		#page_contents に　width: 100%;　を追加。
		#contents_header:after {
			content: ".";
			display: block;
			height: 0px;
			clear: both;
			visibility: hidden;
		}

【修正履歴：Ver.1.03】
	・style/original/common.css：
	CSSに以下を追加。FirefoxやGoogle Chromeではレイアウトが崩れてしまう件の対策。
	by ブログコメントANさん
		#page_header:after {
			content:".";
			display: block;
			height: 0px;
			clear: both;
			visibility: hidden;
		}
		#page_navi {
			float:left;
		}
【修正履歴：Ver.1.02】
	・acount/logout.php：
	  実運用モード/サンプルモード切替判断で、
	  define定数を参照せずに直接ファイルパスを記述していた問題を修正。
	・__common__/__define_common.php：
	  define("_MY_DEFINE_COMMON".定義ファイルパスを都合により修正。

【修正履歴：Ver.1.01】
	・calendar/_my_calendar.php：
	  カレンダーの月間表示で当月以外の日付のスケジュール表示と入力ができるようにした。
*/
?>
